package jp.grain.sprout.ui;

import jp.grain.spike.Element;
import jp.grain.spike.Node;

/**
 * InlinevfO[sO邽߂̗vfłB
 * ̗vf̂̓O[sÔ߂̋@\񋟂܂B
 * ̂߁A`ȂǂɂĂ͐eInlineBlockɈϏ܂B
 * @author nakajo
 *
 */
public class InlineGroup extends Inline {

	public static final String NAME = "inline-group";
	
	protected int applyedIndex;
	protected Inline _lastApplyed;
	
	public InlineGroup() {
		super(InlineGroup.NAME);
	}

	public InlineGroup(String name) {
		super(name);
	}

	public boolean fitWithIn(Row row) {
		System.out.println(getClass().getName()+"@"+hashCode()+": fitWithIn(Row) child="+getChildCount()+" applyedIndex="+applyedIndex);
		Inline inline = null;
		for(int i=applyedIndex; i<getChildCount();) {
			inline = (Inline)getChildElement(i);
            if (inline == null) {
            	i++;
            	continue;
            }
            _lastApplyed = inline; //sKvׂ邽
            
			if(!inline.fitWithIn(row)) {
				applyedIndex = i;
				return false;
			} else if(inline.isLineBreak()) {
				applyedIndex = i+1;
				return !isContinue();
			}
            if (!inline.isContinue()) ++i;
		}
		
		//Ō܂ŏÎchildCount=applyedIndexɂ
		this.applyedIndex = getChildCount();
		return true;
	}

	public void initChildren(Form form) {
        for (int i = 0; i < getChildCount(); ++i) {
        	Box inline = (Box)getChildElement(i);
            if (inline == null) continue;
            inline.init(form);
        }
	}

	protected void applySelf(Form form) {
        _width = _preferedWidth;
        _height = 0;
        if (_width < 0) {
            if (getParent() != null) {
                _width = ((Box)getParent()).getBoxWidth();
            } else {
                _width = 0;
            }
        }
        this.applyedIndex = 0;
	}

	protected void applyChildren(Form form) {
        for (int i = 0; i < getChildCount(); ++i) {
        	Box inline = (Box)getChildElement(i);
            if (inline == null) continue;
            inline.apply(form);
        }
	}

	public void draw(DrawContext dc) {
        drawCommonStyle(dc);
	}

	public boolean isContinue() {
		return this.applyedIndex < getChildCount();
	}

	public boolean isLineBreak() {
		//]͎̂̎qSrowapplyꂽゾB
		//Ȃ̂Ŏ̉s邩HƈԍŌɏqɉs邩H
		if(super.isLineBreak()) return true;
		return this._lastApplyed != null && this._lastApplyed.isLineBreak();
	}

	public void preProcess(Node parent) {
        if (parent instanceof InlineBlock) {
            ((InlineBlock)parent).addChildInline(this);
        } else if (parent instanceof InlineGroup) {
            ((InlineGroup)parent).addChild(this);
        }
	}
	
	/**
	 * inline-group̎qvfƂĎw肳ꂽR|[lg
	 * ݂邩ǂԂ܂B
	 * qvfinline-group̏ꍇ͍ċAIɌ܂B
	 */
	public boolean contains(Node node) {
		for(int i=0; i<getChildCount(); i++) {
			Element child = getChildElement(i);
			if(child instanceof InlineGroup) {
				if(((InlineGroup)child).contains(node)) return true;
			} else {
				if(child.equals(node)) return true;
			}
		}
		
		return false;
	}
}
