package jp.sf.grizzly.pipeline.valve;

import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.storage.StreamStorage;

public interface ValveContext
{
    /**
     * <p>Cause the <code>invoke()</code> method of the next Valve
     * that is part of the Pipeline currently being processed (if any)
     * to be executed, passing on the specified request and response
     * objects plus this <code>ValveContext</code> instance.
     * Exceptions thrown by a subsequently executed Valve will be
     * passed on to our caller.</p>
     *
     * <p>If there are no more Valves to be executed, execution of
     * this method will result in a no op.</p>
     *
     * @param data The run-time information, including the servlet
     * request and response we are processing.
     *
     * @exception IOException Thrown by a subsequent Valve.
     * @exception SummitException Thrown by a subsequent Valve.
     * @exception SummitException No further Valves configured in the
     * Pipeline currently being processed.
     */
    public void invokeNext(StreamStorage storage) throws PipelineException;

}
