package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import jp.sf.grizzly.pipeline.GrizzlyPipeline;
import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;
import jp.sf.grizzly.storage.impl.FileStreamStorageImpl;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * Unit test for simple App.
 *
 * @author <a href="mailto:jason@zenplex.com">Jason van Zyl</a>
 */
public class HatenaPipelineTest extends AbstractValveTest
{
private static final String SOURCE_PATH = "C:/development/ework-jdk1.4/grizzly/convert/source/export.xml";
private static final String RESULT_PATH = "C:/development/ework-jdk1.4/grizzly/convert/result/result.xml";
	//	private static final String DICON_PATH = "jp/sf/grizzly/hatena/pipeline/valve/Grizzly.dicon";
	private static final String DICON_PATH = "Grizzly.dicon";
	/**
	 * Logger for this class
	 */
	private static final Log log = LogFactory.getLog(HatenaPipelineTest.class);

	/**
	 * Create the test case
	 *
	 * @param testName name of the test case
	 */
	public HatenaPipelineTest(String testName)
	{
		super(testName);
	}

	/**
	 * @return the suite of tests being tested
	 */
	public static Test suite()
	{
		return new TestSuite(HatenaPipelineTest.class);
	}

	/**
	 * Rigourous Test :-)
	 */
	public void testPipeline()
	{

		SingletonS2ContainerFactory
				.setConfigPath(DICON_PATH);
		SingletonS2ContainerFactory.init();
		S2Container container = SingletonS2ContainerFactory.getContainer();
//		S2Container container = S2ContainerFactory.create(DICON_PATH);
		
		GrizzlyPipeline pipeline = (GrizzlyPipeline) container
				.getComponent(GrizzlyPipeline.class);

		StringBuffer buffer = new StringBuffer();
		try
		{
			StreamStorage storage = new FileStreamStorageImpl(new FileInputStream(
					new File(SOURCE_PATH)), "UTF-8");
			pipeline.invoke(storage);

			BufferedReader r = null;
			BufferedWriter bw = null;
			try
			{
//				FileWriter fw = new FileWriter(new File(RESULT_PATH));
				FileOutputStream fos = new FileOutputStream(new File(RESULT_PATH));
				OutputStreamWriter ow = new OutputStreamWriter(fos,"UTF-8");
				bw = new BufferedWriter(ow);
				
				
				r = new BufferedReader(new InputStreamReader(storage
						.getResultInputStream(), storage.getEncoding()));
				String l = null;
				while ((l = r.readLine()) != null)
				{
					bw.write(l);
					bw.newLine();
				}
				bw.flush();
			}
			catch (UnsupportedEncodingException e)
			{
				log.warn("Unsupported Encoding. ", e);
			}
			catch (StreamStorageException e)
			{
				log.warn("Stream Storage Exception. ", e);
			}
			catch (IOException e)
			{
				log.error("I/O Exception. ", e);
			}
			finally
			{
				if(r != null)
				{
					try
					{
						r.close();
						bw.close();
					}
					catch (IOException e)
					{
					}
				}
			}
			storage.destroy();
		}
		catch (StreamStorageException e)
		{
			log.error("StreamStorage Exception.", e);
		}
		catch (PipelineException e)
		{
			log.error("Pipeline Exception.", e);
		}
		catch (FileNotFoundException e)
		{
			log.error("FileNotFound Exception.", e);
		}

		assertTrue(true);
	}
}
