
#==============================================================================#
# $Id: composite.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Attribute

    module Composite

      class Frame

        def initialize
          @fill      = Primitive::Fill.new
          @picture   = Primitive::Picture.new
          @gradation = Primitive::Gradation.new
          @border    = Primitive::Border.new
          @shadow    = Primitive::Shadow.new
          @padding   = Primitive::Padding.new
          @margin    = Primitive::Padding.new
        end

        attr_reader :fill, :picture, :gradation, :border, :shadow, :padding, :margin

        def setup
          @fill.visible          = true
          @fill.color            = Color.white
          @fill.opacity          = 100
          @picture.visible       = false
          @picture.filepath      = nil
          @picture.opacity       = 100
          @gradation.visible     = false
          @gradation.start_color = Color.new(192, 255, 255)
          @gradation.end_color   = Color.new(0, 128, 255)
          @gradation.angle       = 0
          @gradation.opacity     = 100
          @border.visible        = true
          @border.color          = Color.black
          @border.width          = 1
          @shadow.visible        = false
          @shadow.color          = Color.gray(192)
          @shadow.offset_x       = 3
          @shadow.offset_y       = 3
          @padding.left          = 5
          @padding.right         = 5
          @padding.top           = 5
          @padding.bottom        = 5
          @margin.left           = 0
          @margin.right          = 0
          @margin.top            = 0
          @margin.bottom         = 0
        end

        def create_decorator(decorator)
          decorator = @padding.create_decorator(decorator)
          decorator = @picture.create_decorator(decorator)
          decorator = @gradation.create_decorator(decorator)
          decorator = @fill.create_decorator(decorator)
          decorator = @border.create_decorator(decorator)
          decorator = @shadow.create_decorator(decorator)
          decorator = @margin.create_decorator(decorator)

          return decorator
        end

      end # Frame

      class Title

        def initialize
          @visible  = nil
          @text     = nil
          @position = nil
          @font     = Primitive::Font.new

          @fill      = Primitive::Fill.new
          @picture   = Primitive::Picture.new
          @gradation = Primitive::Gradation.new
          @border    = Primitive::Border.new
          @shadow    = Primitive::Shadow.new
          @padding   = Primitive::Padding.new
          @margin    = Primitive::Padding.new
        end

        attr_accessor :visible, :text, :position
        attr_reader   :font, :fill, :picture, :gradation, :border, :shadow, :padding, :margin

        def setup
          @visible               = true
          @text                  = 'Graph Title'
          @position              = :top_center
          @font.color            = Color.black
          @font.name             = Font::Giant
          @font.vertical         = false
          @font.filepath         = nil
          @font.size             = 10
          @font.angle            = 0
          @fill.visible          = false
          @fill.color            = Color.white
          @fill.opacity          = 100
          @picture.visible       = false
          @picture.filepath      = nil
          @picture.opacity       = 100
          @gradation.visible     = false
          @gradation.start_color = Color.new(192, 255, 255)
          @gradation.end_color   = Color.new(0, 128, 255)
          @gradation.angle       = 0
          @gradation.opacity     = 100
          @border.visible        = false
          @border.color          = Color.black
          @border.width          = 1
          @shadow.visible        = false
          @shadow.color          = Color.gray(192)
          @shadow.offset_x       = 3
          @shadow.offset_y       = 3
          @padding.left          = 0
          @padding.right         = 0
          @padding.top           = 0
          @padding.bottom        = 0
          @margin.left           = 5
          @margin.right          = 5
          @margin.top            = 5
          @margin.bottom         = 5
        end

        def create_decorator(decorator)
          decorator = @padding.create_decorator(decorator)
          decorator = @picture.create_decorator(decorator)
          decorator = @gradation.create_decorator(decorator)
          decorator = @fill.create_decorator(decorator)
          decorator = @border.create_decorator(decorator)
          decorator = @shadow.create_decorator(decorator)
          decorator = @margin.create_decorator(decorator)

          return decorator
        end

      end # Title

      class Legend

        def initialize
          @visible   = nil
          @interval  = nil
          @vertical  = nil
          @position  = nil
          @font      = Primitive::Font.new
          @fill      = Primitive::Fill.new
          @picture   = Primitive::Picture.new
          @gradation = Primitive::Gradation.new
          @border    = Primitive::Border.new
          @shadow    = Primitive::Shadow.new
          @padding   = Primitive::Padding.new
          @margin    = Primitive::Padding.new
          @marker    = Marker.new
        end

        attr_accessor :visible, :interval, :vertical, :position
        attr_reader   :font, :fill, :gradation, :picture, :border, :shadow, :padding, :margin, :marker

        def setup
          @visible               = true
          @interval              = 5
          @vertical              = true
          @position              = :middle_right
          @font.color            = Color.black
          @font.name             = Font::Small
          @font.vertical         = false
          @font.filepath         = nil
          @font.size             = 10
          @font.angle            = 0
          @fill.visible          = false
          @fill.color            = Color.white
          @fill.opacity          = 100
          @picture.visible       = false
          @picture.filepath      = nil
          @picture.opacity       = 100
          @gradation.visible     = false
          @gradation.start_color = Color.new(192, 255, 255)
          @gradation.end_color   = Color.new(0, 128, 255)
          @gradation.angle       = 0
          @gradation.opacity     = 100
          @border.visible        = true
          @border.color          = Color.black
          @border.width          = 1
          @shadow.visible        = false
          @shadow.color          = Color.gray(192)
          @shadow.offset_x       = 3
          @shadow.offset_y       = 3
          @padding.left          = 4
          @padding.right         = 4
          @padding.top           = 4
          @padding.bottom        = 4
          @margin.left           = 5
          @margin.right          = 5
          @margin.top            = 5
          @margin.bottom         = 5
          @marker.width          = 10
          @marker.height         = 10
          @marker.spacing        = 3
        end

        def create_decorator(decorator)
          decorator = @padding.create_decorator(decorator)
          decorator = @picture.create_decorator(decorator)
          decorator = @gradation.create_decorator(decorator)
          decorator = @fill.create_decorator(decorator)
          decorator = @border.create_decorator(decorator)
          decorator = @shadow.create_decorator(decorator)
          decorator = @margin.create_decorator(decorator)

          return decorator
        end

        class Marker

          def initialize
            @width   = nil
            @height  = nil
            @spacing = nil
          end

          attr_accessor :width, :height, :spacing

        end # Marker

      end # Legend

      class Scale

        def initialize
          @maximum  = nil
          @minimum  = nil
          @interval = Primitive::MajorMinor.new(nil, nil)
          @grid     = Primitive::MajorMinor.new(ScaleGrid.new, ScaleGrid.new)
          @tics     = Primitive::MajorMinor.new(ScaleTics.new, ScaleTics.new)
          @origin   = ScaleOrigin.new
          @label    = ScaleLabel.new
        end

        attr_accessor :maximum, :minimum
        attr_reader   :interval, :grid, :tics, :origin, :label

        class ScaleGrid
          def initialize
            @visible = nil
            @color   = nil
          end
          attr_accessor :visible, :color
        end # ScaleGrid

        class ScaleTics
          def initialize
            @visible = nil
            @color   = nil
            @size    = nil
            @inside  = nil
            @outside = nil
          end
          attr_accessor :visible, :color, :size, :inside, :outside
        end # ScaleTics

        class ScaleOrigin
          def initialize
            @visible = nil
            @color   = nil
          end
          attr_accessor :visible, :color
        end # ScaleOrigin

        class ScaleLabel
          def initialize
            @visible = nil
            @format  = nil
            @font    = Primitive::Font.new
          end
          attr_accessor :format, :visible
          attr_reader   :font
        end # ScaleLabel

      end # Scale

      class Axis

        def initialize
          @grid  = Primitive::MajorMinor.new(AxisGrid.new, AxisGrid.new)
          @tics  = Primitive::MajorMinor.new(AxisTics.new, AxisTics.new)
          @label = AxisLabel.new
        end

        attr_reader :grid, :tics, :label

        class AxisGrid
          def initialize
            @visible = nil
            @color   = nil
          end
          attr_accessor :visible, :color
        end # AxisGrid

        class AxisTics
          def initialize
            @visible = nil
            @color   = nil
            @size    = nil
            @inside  = nil
            @outside = nil
          end
          attr_accessor :visible, :color, :size, :inside, :outside
        end # AxisTics

        class AxisLabel
          def initialize
            @visible = nil
            @text    = nil
            @font    = Primitive::Font.new
          end
          attr_accessor :visible, :text
          attr_reader   :font
        end # AxisLabel

      end # Axis

    end # Composite

  end # Attribute

end # Graph

