
#==============================================================================#
# $Id: border.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Decorator

    class Border < Base

      def initialize(child = nil)
        super(child)

        @color = Color.black
        @width = 1
      end

      attr_accessor :color, :width

      def draw_self(image, box)
        color = @color.allocate(image)

        if @width == 1
          image.rectangle(box.x, box.y, box.x2, box.y2, color)
        else
          @width.times { |i|
            image.rectangle(box.x + i, box.y + i, box.x2 - i, box.y2 - i, color)
          }
        end
      end

      def draw_child(image, box)
        child_box = Box.new
        child_box.x  = box.x + @width
        child_box.y  = box.y + @width
        child_box.dx = [box.dx - @width * 2, 0].max
        child_box.dy = [box.dy - @width * 2, 0].max

        @child.draw(image, child_box)
      end

      def dx
        return child_dx + @width * 2
      end

      def dy
        return child_dy + @width * 2
      end

    end

  end

end
