
#==============================================================================#
# $Id: fill.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Decorator

    class Fill < Base

      def initialize(child = nil)
        super(child)
        @color   = nil
        @opacity = 100
      end

      attr_accessor :color, :opacity

      def draw_self(image, box)
        if @opacity >= 100
          color = @color.allocate(image)
          image.filledRectangle(box.x, box.y, box.x2, box.y2, color)
        else
          fill = GD::Image.new(box.dx, box.dy)
          @color.allocate(fill)
          fill.copyMerge(image, box.x, box.y, 0, 0, box.dx, box.dy, [[@opacity, 0].max, 100].min)
          fill.destroy
        end
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end

  end

end
