
#==============================================================================#
# $Id: picture.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Decorator

    class Picture < Base

      def initialize(child = nil)
        super(child)
        @filepath = nil
        @opacity  = 100
      end

      attr_accessor :filepath, :opacity

      def draw_self(image, box)
        picture = File.open(@filepath) { |file|
          GD::Image.newFromPng(file)
        }

        x2 = [box.dx, picture.width].min
        y2 = [box.dy, picture.height].min

        if @opacity >= 100
          picture.copy(image, box.x, box.y, 0, 0, x2, y2)
        else
          picture.copyMerge(image, box.x, box.y, 0, 0, x2, y2, [[@opacity, 0].max, 100].min)
        end

        picture.destroy
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end

  end

end
