
#==============================================================================#
# $Id: bar.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  class Bar < GraphBase

    def create_legend
      font = @legend.font.create_font

      legend = Legend.new(@legend)

      @data.each { |item|
        legend.add(font, item[:name], Legend::Marker::Color.new(item[:color], item[:color]))
      }

      return legend
    end
    private :create_legend

    def create_graph
      graph = create_chart

      @data.each { |item|
        graph.add_value(item[:name], item[:value], item[:color], nil)
      }

      return graph
    end
    private :create_graph

    def create_attribute_chart
      return Attribute::Chart::Bar.new
    end
    private :create_attribute_chart

    def create_chart
      return Chart::Bar.new(@chart)
    end
    private :create_chart

  end

end
