
#==============================================================================#
# $Id: text.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  class Text

    ALIGN_LEFT   = :left
    ALIGN_CENTER = :center
    ALIGN_RIGHT  = :right

    VALIGN_TOP     = :top
    VALIGN_MIDDLE  = :middle
    VALIGN_BOTTOM  = :bottom

    def initialize(font, text, align = ALIGN_LEFT, valign = VALIGN_TOP)
      @font   = font
      @text   = text
      @align  = align
      @valign = valign
    end

    def draw(image, box)
      font_width  = @font.width(@text)
      font_height = @font.height(@text)

      case @align
      when ALIGN_LEFT;   xx = box.x
      when ALIGN_CENTER; xx = box.x - (font_width / 2.0).to_i
      when ALIGN_RIGHT;  xx = box.x - font_width
      else
        raise 'bug?'
      end

      case @valign
      when VALIGN_TOP;    yy = box.y
      when VALIGN_MIDDLE; yy = box.y - (font_height / 2.0).to_i
      when VALIGN_BOTTOM; yy = box.y - font_height
      else
        raise 'bug?'
      end

      @font.draw(image, xx, yy, @text)
    end

    def draw2(image, x, y)
      self.draw(image, Box.new(x, y, 0, 0))
    end

    def dx
      return @font.width(@text)
    end

    def dy
      return @font.height(@text)
    end

  end

end
