
#==============================================================================#
# gruby/polygon.rb
# $Id: polygon.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

#==============================================================================#
# GRb Class
class GRb

  #============================================================================#
  # Polygon Class
  class Polygon

    def initialize
      @point = []
    end

    def add(x, y)
      @point << [x, y]
      return nil
    end

    def move(vx, vy)
      @point.collect! { |x, y|
        [x + vx, y + vy]
      }
      return nil
    end

    def to_polygon
      poly = ::GD::Polygon.new
      @point.each { |x, y| poly.addPt(x, y) }
      return poly
    end

  end # Polygon

end # GRb

#==============================================================================#
#==============================================================================#
