#! /usr/bin/ruby -Ke

#==============================================================================#
# example/graph/pie2.rb
# $Id: pie2.rb,v 1.2 2002/09/20 07:54:35 yuya Exp $
#==============================================================================#

require 'gruby/gruby'
require 'gruby/graph/graph'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.hex('CC3333') },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.hex('33CC33') },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.hex('3333CC') },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.hex('CCCC33') },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.hex('3399CC') },
  {:name => 'Field 6', :value => 2, :color => GRb::Color.hex('CC33CC') },
]

#==============================================================================#

graph = GRb::Graph::Pie.create(500, 300, true)
graph.title.text             = 'Pie Graph Sample 2'          # ȥ ʸ
graph.title.font.color       = GRb::Color.white              # ȥ ե 
graph.frame.picture.visible  = true                          # ط  ɽ
graph.frame.picture.filepath = 'background.png'              # ط  ե̾
graph.frame.border.visible   = false                         # ط  ɽ
graph.frame.shadow.visible   = true                          # ط  ɽ
graph.legend.fill.visible    = true                          #  طʿ ɽ
graph.legend.fill.color      = GRb::Color.white              #  طʿ 
graph.legend.fill.opacity    = 25                            #  طʿ Ʃ
graph.legend.border.visible  = false                         #   ɽ
graph.chart.fill.visible     = true                          # 㡼 طʿ ɽ
graph.chart.fill.color       = GRb::Color.new(192, 240, 255) # 㡼 طʿ 
graph.chart.fill.opacity     = 50                            # 㡼 طʿ Ʃ
graph.chart.edge.visible     = false                         # 㡼  ɽ
graph.chart.label.visible    = true                          # 㡼 ٥ ɽ
graph.chart.label.font.name  = GRb::Graph::Font::Medium      # 㡼 ٥ ե ̾
graph.chart.label.font.color = GRb::Color.white              # 㡼 ٥ ե 
graph.chart.label.line.color = GRb::Color.white              # 㡼 ٥ Ф 
graph.chart.padding.left     = 20                            # 㡼 ѥǥ 
graph.chart.padding.right    = 20                            # 㡼 ѥǥ 
graph.chart.padding.top      = 20                            # 㡼 ѥǥ 
graph.chart.padding.bottom   = 20                            # 㡼 ѥǥ 
graph.data                   = data
graph.png_file('pie2.png')

#==============================================================================#
#==============================================================================#
