
#==============================================================================#
# gruby/graph/attribute/chart.rb
# $Id: chart.rb,v 1.4 2002/09/19 08:44:25 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Attribute

      module Chart

        class Base

          def initialize
            @fill      = Primitive::Fill.new
            @picture   = Primitive::Picture.new
            @gradation = Primitive::Gradation.new
            @border    = Primitive::Border.new
            @shadow    = Primitive::Shadow.new
            @padding   = Primitive::Padding.new
            @margin    = Primitive::Padding.new
          end

          attr_reader :fill, :picture, :gradation, :border, :shadow, :padding, :margin

          def setup
            @fill.visible          = false
            @fill.color            = Color.white
            @fill.opacity          = 100
            @picture.visible       = false
            @picture.filepath      = nil
            @picture.opacity       = 100
            @gradation.visible     = false
            @gradation.start_color = Color.new(192, 255, 255)
            @gradation.end_color   = Color.new(0, 128, 255)
            @gradation.angle       = 0
            @gradation.opacity     = 100
            @border.visible        = false
            @border.color          = Color.black
            @border.width          = 1
            @shadow.visible        = false
            @shadow.color          = Color.gray(192)
            @shadow.offset_x       = 3
            @shadow.offset_y       = 3
            @padding.left          = 10
            @padding.right         = 10
            @padding.top           = 10
            @padding.bottom        = 10
            @margin.left           = 5
            @margin.right          = 5
            @margin.top            = 5
            @margin.bottom         = 5
          end

          def create_decorator(decorator)
            decorator = @padding.create_decorator(decorator)
            decorator = @picture.create_decorator(decorator)
            decorator = @gradation.create_decorator(decorator)
            decorator = @fill.create_decorator(decorator)
            decorator = @border.create_decorator(decorator)
            decorator = @shadow.create_decorator(decorator)
            decorator = @margin.create_decorator(decorator)

            return decorator
          end

        end # Base

        class PieBase < Base

          def initialize
            super()
            @stretch = nil
            @edge    = Edge.new
            @label   = Label.new
          end

          attr_accessor :stretch
          attr_reader   :edge, :label

          class Edge

            def initialize
              @visible = nil
              @color   = nil
            end

            attr_accessor :visible, :color

          end # Edge

          class Label

            def initialize
              @visible = nil
              @type    = nil
              @font    = Graph::Attribute::Primitive::Font.new
              @line    = Line.new
            end

            attr_accessor :visible, :type
            attr_reader   :font, :line

            class Line

              def initialize
                @color   = nil
                @length1 = nil
                @length2 = nil
              end

              attr_accessor :color, :length1, :length2

            end # Line

          end # Label

        end # PieBase

        class Pie < PieBase

          def initialize
            super()
          end

          def setup
            super()

            @stretch             = false
            @edge.visible        = true
            @edge.color          = Color.black
            @label.visible       = false
            @label.type          = :name # | :value | :raito
            @label.font.color    = Color.black
            @label.font.name     = Font::Small
            @label.font.vertical = false
            @label.font.filepath = nil
            @label.font.size     = 10
            @label.font.angle    = 0
            @label.line.color    = Color.black
            @label.line.length1  = 10
            @label.line.length2  = 30
          end

        end # Pie

        class Pie3D < PieBase

          def initialize
            super()
            @height = nil
            @shade  = nil
          end

          attr_accessor :height, :shade

          def setup
            super()

            @stretch             = false
            @height              = 20
            @shade               = 30
            @edge.visible        = true
            @edge.color          = Color.black
            @label.visible       = true
            @label.type          = :name
            @label.font.color    = Color.black
            @label.font.name     = Font::Small
            @label.font.vertical = false
            @label.font.filepath = nil
            @label.font.size     = 10
            @label.font.angle    = 0
            @label.line.color    = Color.black
            @label.line.length1  = 10
            @label.line.length2  = 30
          end

        end # Pie3D

        class XYBase < Base

          def initialize
            super()
            @scale1 = Graph::Attribute::Composite::Scale.new
            @scale2 = Graph::Attribute::Composite::Scale.new
            @axis   = Graph::Attribute::Composite::Axis.new
          end

          attr_accessor :scale1, :scale2, :axis

          def setup
            super()

            @scale1.maximum             = 50
            @scale1.minimum             = 0
            @scale1.interval.major      = 10
            @scale1.interval.minor      = 2
            @scale1.grid.major.visible  = true
            @scale1.grid.major.color    = Color.gray(192)
            @scale1.grid.minor.visible  = true
            @scale1.grid.minor.color    = Color.gray(240)
            @scale1.tics.major.visible  = true
            @scale1.tics.major.color    = Color.black
            @scale1.tics.major.size     = 5
            @scale1.tics.major.inside   = true
            @scale1.tics.major.outside  = false
            @scale1.tics.minor.visible  = true
            @scale1.tics.minor.color    = Color.black
            @scale1.tics.minor.size     = 3
            @scale1.tics.minor.inside   = true
            @scale1.tics.minor.outside  = false
            @scale1.origin.visible      = true
            @scale1.origin.color        = Color.black
            @scale1.label.visible       = true
            @scale1.label.format        = Proc.new { |value| value.to_s }
            @scale1.label.font.color    = Color.blue
            @scale1.label.font.name     = Font::Small
            @scale1.label.font.vertical = false
            @scale1.label.font.filepath = nil
            @scale1.label.font.size     = 10
            @scale1.label.font.angle    = 0

=begin
            @scale2.maximum            = 50
            @scale2.minimum            = 0
            @scale2.interval.major     = 10
            @scale2.interval.minor     = 5
            @scale2.grid.major.visible = true
            @scale2.grid.major.color   = Color.gray(255)
            @scale2.grid.minor.visible = true
            @scale2.grid.minor.color   = Color.gray(192)
            @scale2.tics.major.visible = true
            @scale2.tics.major.color   = Color.black
            @scale2.tics.major.size    = 5
            @scale2.tics.major.inside  = true
            @scale2.tics.major.outside = true
            @scale2.tics.minor.visible = true
            @scale2.tics.minor.color   = Color.black
            @scale2.tics.minor.size    = 3
            @scale2.tics.minor.inside  = true
            @scale2.tics.minor.outside = false
            @scale2.origin.visible     = true
            @scale2.origin.color       = Color.red
            @scale2.font.color         = Color.blue
            @scale2.font.name          = Font::Small
            @scale2.font.vertical      = false
            @scale2.font.filepath      = nil
            @scale2.font.size          = 10
            @scale2.font.angle         = 0
=end

            @axis.grid.major.visible  = true
            @axis.grid.major.color    = Color.gray(192)
            @axis.grid.minor.visible  = true
            @axis.grid.minor.color    = Color.gray(240)
            @axis.tics.major.visible  = true
            @axis.tics.major.color    = Color.black
            @axis.tics.major.size     = 5
            @axis.tics.major.inside   = true
            @axis.tics.major.outside  = false
            @axis.tics.minor.visible  = true
            @axis.tics.minor.color    = Color.black
            @axis.tics.minor.size     = 3
            @axis.tics.minor.inside   = true
            @axis.tics.minor.outside  = false
            @axis.label.visible       = true
            @axis.label.text          = []
            @axis.label.font.name     = Font::Small
            @axis.label.font.vertical = false
            @axis.label.font.color    = Color.red
          end

        end # XYBase

        class Line < XYBase

          def initialize
            super()
          end

          def setup()
            super()
          end

        end # Line

        class Bar < XYBase

          def initialize
            super()
          end

          def setup()
            super()
          end

        end # Bar

      end # Chart

    end # Attribute

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
