
#==============================================================================#
# gruby/graph/decorator/base.rb
# $Id: base.rb,v 1.4 2002/09/19 10:58:13 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class Base

        def initialize(child)
          @child = child
        end

        def has_child?
          return !@child.nil?
        end
        private :has_child?

        def draw(image, box)
          draw_self(image, box)
          if has_child?
            draw_child(image, box)
          end
        end

        def draw_self(image, box)
          raise NotImplementedError, "don't use this class"
        end
        private :draw_self

        def draw_child(image, box)
          raise NotImplementedError, "don't use this class"
        end
        private :draw_child

        def child_dx
          return ( @child ? @child.dx : 0 )
        end
        private :child_dx

        def child_dy
          return ( @child ? @child.dy : 0 )
        end
        private :child_dy

        def dx
          return child_dx
        end

        def dy
          return child_dy
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
