
#==============================================================================#
# gruby/graph/decorator/fill.rb
# $Id: fill.rb,v 1.4 2002/09/19 10:58:13 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class Fill < Base

        def initialize(child = nil)
          super(child)
          @color   = nil
          @opacity = 100
        end

        attr_accessor :color, :opacity

        def draw_self(image, box)
          image.rect(box.x, box.y, box.x2, box.y2, nil, {:color => @color, :opacity => @opacity})
        end

        def draw_child(image, box)
          @child.draw(image, box)
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
