
#==============================================================================#
# gruby/graph/decorator/shadow.rb
# $Id: shadow.rb,v 1.5 2002/09/19 16:31:23 yuya Exp $
#==============================================================================#

class GRb

  module Graph

    module Decorator

      class Shadow < Base

        def initialize(child = nil)
          super(child)

          @color    = Color.black
          @offset_x = 0
          @offset_y = 0
        end

        attr_accessor :color, :offset_x, :offset_y

        def draw_self(image, box)
          if @offset_x > 0
            x1 = box.x2 - (@offset_x - 1)
            x2 = box.x2
          elsif @offset_x < 0
            x1 = box.x
            x2 = box.x - @offset_x - 1
          else
            x1 = nil
            x2 = nil
          end
          if @offset_y > 0
            y1 = box.y + @offset_y
            y2 = box.y2
          elsif @offset_y < 0
            y1 = box.y
            y2 = box.y2 + @offset_y
          else
            y1 = nil
            y2 = nil
          end
          if x1 && x2 && y1 && y2
            image.rect(x1, y1, x2, y2, nil, @color)
          end

          if @offset_x > 0
            x3 = box.x + @offset_x
            x4 = box.x2
          elsif @offset_x < 0
            x3 = box.x
            x4 = box.x2 + @offset_x
          else
            x3 = nil
            x4 = nil
          end
          if @offset_y > 0
            y3 = box.y2 - (@offset_y - 1)
            y4 = box.y2
          elsif @offset_y < 0
            y3 = box.y
            y4 = box.y - @offset_y - 1
          else
            y3 = nil
            y4 = nil
          end
          if x3 && x4 && y3 && y4
            image.rect(x3, y3, x4, y4, nil, @color)
          end
        end

        def draw_child(image, box)
          child_box = Box.new

          if @offset_x > 0
            child_box.x  = box.x
            child_box.dx = [box.dx - @offset_x, 0].max
          elsif @offset_x < 0
            child_box.x  = box.x - @offset_x
            child_box.dx = [box.dx + @offset_x, 0].max
          else
            child_box.x  = box.x
            child_box.dx = box.dx
          end

          if @offset_y > 0
            child_box.y  = box.y
            child_box.dy = [box.dy - @offset_y, 0].max
          elsif @offset_y < 0
            child_box.y  = box.y - @offset_y
            child_box.dy = [box.dy + @offset_y, 0].max
          else
            child_box.y  = box.y
            child_box.dy = box.dy
          end

          @child.draw(image, child_box)
        end

        def dx
          return child_dx + @offset_x.abs
        end

        def dy
          return child_dy + @offset_y.abs
        end

      end

    end

  end

end # GRb

#==============================================================================#
#==============================================================================#
