
#==============================================================================#
# $Id: chart.rb,v 1.2 2004/01/23 00:38:03 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/bar/chart.rb,v $
#==============================================================================#

require 'grb/chart/bar_base/chart'
require 'grb/view'

#==============================================================================#

module GRb

  module Chart

    class BarChart < BarChartBase

      def initialize(property, major_scale, items)
        super(property)
        @value_set   = []
        @major_scale = major_scale
        @items       = items
      end

      def add_value_set(name, line, fill, values)
        @value_set << ValueSet.new(name, line, fill, values)
      end

      def draw_bar(view, groups, group_no, values, value_no, value, line, fill)
        column_dx = (@property.bar_width * groups) + (@property.bar_spacing * (groups - 1)) + (@property.column_spacing * 2)

        x1 = (column_dx * value_no) + @property.column_spacing + ((@property.bar_width + @property.bar_spacing) * group_no)
        y1 = -value
        x2 = x1 + @property.bar_width
        y2 = 0

        view.rect(x1, y1, x2, y2, line, fill)
      end

      def draw(image, box)
        groups = @value_set.size
        values = @value_set.collect { |vs| vs.values.size }.max

        column_dx = (@property.bar_width * groups) + (@property.bar_spacing * (groups - 1)) + (@property.column_spacing * 2)
        dx = column_dx * values

        view = image.view(box.x, box.y, box.dx - 1, box.dy - 1, 0, @major_scale.maximum, dx, @major_scale.delta)

        @value_set.each_with_index { |value_set, group_no|
          value_set.values.each_with_index { |value, value_no|
            draw_bar(view, groups, group_no, values, value_no, value, value_set.line, value_set.fill)
          }
        }
      end

      class ValueSet

        def initialize(name, line, fill, values)
          @name   = name
          @line   = line
          @fill   = fill
          @values = values
        end

        attr_reader :name, :line, :fill, :values

      end # ValueSet

    end # BarChart

  end # Graph

end # GRb


#==============================================================================#

if $0 == __FILE__
  require 'grb/image'
  require 'grb/chart/scale'
  require 'grb/chart/property/chart/bar'

  GRb::Image.create_and_write_png_file(400, 300, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    image.rect(10, 10, 390, 290, GRb::Color.red(128))

    scale = GRb::Chart::Scale.new(100, -20, 10)
    property = GRb::Chart::Property::Chart::Bar.new
    chart = GRb::Chart::Chart::Bar.new(property, scale, nil)
    chart.add_value_set('Field 1', GRb::Color.purple(128),  GRb::Color.purple(192),  [20, 40, 50, 80, 15])
    chart.add_value_set('Field 2', GRb::Color.yellow(128),  GRb::Color.yellow(192),  [15, 25, 45, 90, 45])
    chart.add_value_set('Field 3', GRb::Color.skyblue(128), GRb::Color.skyblue(192), [10, 30, 25, 70, 65])
    chart.draw(image, GRb::Chart::Box.new(10, 10, 380, 280))
  }
end

#==============================================================================#
#==============================================================================#
