
#==============================================================================#
# $Id: title.rb,v 1.2 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/composite/title.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/property/font'
require 'grb/chart/base/property/fill'
require 'grb/chart/base/property/picture'
require 'grb/chart/base/property/gradation'
require 'grb/chart/base/property/border'
require 'grb/chart/base/property/shadow'
require 'grb/chart/base/property/padding'

#==============================================================================#

module GRb

  module Chart

    class TitleProperty < PropertyBase

      def initialize
        @visible  = nil
        @text     = nil
        @position = nil
        @font     = FontProperty.new

        @fill      = FillProperty.new
        @picture   = PictureProperty.new
        @gradation = GradationProperty.new
        @border    = BorderProperty.new
        @shadow    = ShadowProperty.new
        @padding   = PaddingProperty.new
        @margin    = PaddingProperty.new

        self.setup
      end

      attr_accessor :visible, :text, :position
      attr_reader   :font, :fill, :picture, :gradation, :border, :shadow, :padding, :margin

      def setup
        @visible               = true
        @text                  = 'Graph Title'
        @position              = :top_center
        @font.color            = GRb::Color.black
        @font.name             = GRb::Chart::Font::Giant
        @font.vertical         = false
        @font.filepath         = nil
        @font.size             = 10
        @font.angle            = 0
        @fill.visible          = false
        @fill.color            = GRb::Color.white
        @fill.opacity          = 100
        @picture.visible       = false
        @picture.filepath      = nil
        @picture.opacity       = 100
        @gradation.visible     = false
        @gradation.start_color = GRb::Color.new(192, 255, 255)
        @gradation.end_color   = GRb::Color.new(0, 128, 255)
        @gradation.angle       = 0
        @gradation.opacity     = 100
        @border.visible        = false
        @border.color          = GRb::Color.black
        @border.width          = 1
        @shadow.visible        = false
        @shadow.color          = GRb::Color.gray(192)
        @shadow.offset_x       = 3
        @shadow.offset_y       = 3
        @padding.left          = 0
        @padding.right         = 0
        @padding.top           = 0
        @padding.bottom        = 0
        @margin.left           = 5
        @margin.right          = 5
        @margin.top            = 5
        @margin.bottom         = 5
      end

      def create_decorator(decorator)
        decorator = @padding.create_decorator(decorator)
        decorator = @picture.create_decorator(decorator)
        decorator = @gradation.create_decorator(decorator)
        decorator = @fill.create_decorator(decorator)
        decorator = @border.create_decorator(decorator)
        decorator = @shadow.create_decorator(decorator)
        decorator = @margin.create_decorator(decorator)

        return decorator
      end

    end # TitleProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
