/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;

class StatusDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int DIALOG_DEFAULT_WIDTH = 400;
    public static final int DIALOG_DEFAULT_HEIGHT = 300;
    private static final String format = "<html><head><style type=\"text/css\"><!--table{font-family : \"MS UI Gothic\"; border-style:\"solid\";} td{border-style:\"solid\";}--></style></head><body><h1>%s</h1><div align=\"center\"><table border=1><tr><td></td><td>%s-%3d</td><td>%s</td><td>%s</td></tr><tr><td rowspan=2><strong>\u30b9\u30c6\u30fc\u30bf\u30b9</strong></td><td>\u30b3\u30a6\u30b2\u30ad %d</td><td>\u30dc\u30a6\u30ae\u30e7 %d</td><td>\u30bf\u30a4\u30ea\u30e7\u30af %d</td></tr><tr><td colspan=3>\u30d2\u30c3\u30b5\u30c4 %d</td></tr><tr><td><strong>\u30b3\u30a6\u30a8\u30a4</strong></td><td colspan=3>%s</td></tr><tr><td><strong>\u76f8\u6027</strong></td><td colspan=3>\u76f8\u6027\u9069\u6b63\uff08\u653b%d\u3001\u9632%d\u3001\u4f53%d\u3001\u5fc5%d\uff09</td></tr><tr><td><strong>\u30b9\u30ad\u30eb</strong></td><td colspan=3>%s</td></tr></table></div></body></html>";
    JEditorPane browser = new JEditorPane();

    StatusDialog() {
        this.browser.setEditable(false);
        this.browser.setContentType("text/html");
        JButton button = new JButton("OK");
        button.addActionListener(this);
        this.getContentPane().add((Component)button, "South");
        this.getContentPane().add((Component)this.browser, "Center");
        this.setTitle("\u30b9\u30c6\u30fc\u30bf\u30b9\u8868\u793a");
        this.setSize(400, 300);
        this.setVisible(false);
    }

    void setRider(Rider r) {
        this.setSize(400, 300);
        this.browser.setText(String.format(format, r.getName(), r.getSeries(), r.getNumber(), this.getRarityString(r.getRarity()), this.getAttrString(r.getAttribute()), r.getOffense(), r.getDefense(), r.getHitpoint(), r.getSpecialAttack(), this.getRearGuardTacticsString(r.getRearGuardTactics()), r.getChemistry(0), r.getChemistry(1), r.getChemistry(3), r.getChemistry(2), r.getSkillStr()));
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private String getAttrString(int attr) {
        String prefix = (attr & 0x10000000) == 0x10000000 ? "\u8d85" : "";
        switch (attr & 0xEFFFFFFF) {
            case 1: {
                return "<font color=\"#0000FF\"><strong>" + prefix + "\u901f" + "</strong></font>";
            }
            case 2: {
                return "<font color=\"#FF0000\"><strong>" + prefix + "\u529b" + "</strong></font>";
            }
        }
        return "<font color=\"#30A000\"><strong>" + prefix + "\u6280" + "</strong></font>";
    }

    private String getRarityString(int rarity) {
        switch (rarity) {
            case 5: {
                return "LR";
            }
            case 4: {
                return "SR";
            }
            case 2: {
                return "R";
            }
        }
        return "N";
    }

    private String getRearGuardTacticsString(int rgt) {
        switch (rgt) {
            case 0: {
                return "\u30ac\u30f3\u30ac\u30f3\u30bb\u30e1\u30ed";
            }
            case 1: {
                return "\u30a2\u30a4\u30c6\u30f2\u30d6\u30c3\u30c8\u30d0\u30bb";
            }
            case 2: {
                return "\u30b5\u30dd\u30fc\u30c8\u30cf\u30de\u30ab\u30bb\u30ed";
            }
            case 3: {
                return "\u30a2\u30a4\u30c6\u30f2\u30e8\u30af\u30df\u30ed";
            }
        }
        return "\u30ac\u30fc\u30c9\u30f2\u30ab\u30bf\u30e1\u30ed";
    }
}

