package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * <I>m/z</I> 瓜C̑g\ServletNXłD
 * @author m
 * @version 20090102
 */
public class CompositionServlet extends HttpServlet
{
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        try
        {
            double mass_a, tolerance; // m/zCe덷
            Composition known_cp;     // mg
            String adduct;            // tCIiftHgNa+j
            boolean monoavg;          // Monoisotopic(ture),Averaget(false)
            boolean present_hex,   present_hexnac,   present_dhex,   present_pen;   // ȇ
            boolean present_hexme, present_hexnacme, present_dhexme, present_penme; // ȇ
            int select; // 0cZ~hgɂvZC1cZ~h̒YfɂvZC2ĉ݂̕qƂČvZ
            String known_cer; // Z~hgi[D(Z~hCCb_̋ʂ͂Ȃ)

            try
            {
                mass_a = Double.parseDouble(request.getParameter("mass_a")); // Ȃꍇ̏l

                if (mass_a > 3000) // m/z3000ȏ͌vZȂ
                    mass_a = 0;
            }
            catch (Exception e)
            {
                mass_a = 1493.8;
            }
            try
            {
                tolerance = Double.parseDouble(request.getParameter("tolerance"));
            }
            catch (Exception e)
            {
                tolerance = 1.0;
            }
            try
            {
                String temp = request.getParameter("known_cp");
                try
                {
                    known_cp = new Composition(new Glycan(temp)); // Linucs`ƂĊi[Ă݂D
                }
                catch (Exception e)
                {
                    known_cp = new Composition(temp);             // Linucs`̊i[ɎsCgƂĊi[
                }
            }
            catch (Exception e)
            {
                known_cp = new Composition("hex");
            }
            try
            {
                adduct = request.getParameter("adduct");

                if (adduct == null)           // w肳ȂꍇC
                    adduct = MassCalc.Na_ION; // ̃CItCIƂD
            }
            catch (Exception e)
            {
                adduct = MassCalc.Na_ION;     // ̃CItCIƂD
            }
            try
            {
                String temp = request.getParameter("monoavg");
                if (temp.equals("mono"))
                    monoavg = true;
                else if (temp.equals("avg"))
                    monoavg = false;
                else
                    monoavg = true;           // ̑̏ꍇMonoisotopicƂD
            }
            catch (Exception e)
            {
                monoavg = true;               // ̑̏ꍇMonoisotopicƂD
            }
            try
            {
                present_pen      = request.getParameter("present_pen").equals("yes");
                present_dhex     = request.getParameter("present_dhex").equals("yes");
                present_hex      = request.getParameter("present_hex").equals("yes");
                present_hexnac   = request.getParameter("present_hexnac").equals("yes");
                present_penme    = request.getParameter("present_penme").equals("yes");
                present_dhexme   = request.getParameter("present_dhexme").equals("yes");
                present_hexme    = request.getParameter("present_hexme").equals("yes");
                present_hexnacme = request.getParameter("present_hexnacme").equals("yes");
            }
            catch (Exception e)
            {
                present_pen      = false; // e݂邩Ȃw
                present_dhex     = true;
                present_hex      = true;
                present_hexnac   = true;
                present_penme    = false;
                present_dhexme   = false;
                present_hexme    = false;
                present_hexnacme = false;
            }
            try
            { // 0cZ~hgɂvZC1cZ~h̒YfɂvZC2ĉ݂̕qƂČvZ
                select = Integer.parseInt(request.getParameter("select"));
            }
            catch (Exception e)
            {
                select = 0; // ̑̏ꍇ́CZ~ht̓ƂČvZD
            }
            try
            {
                known_cer = request.getParameter("known_cer").toLowerCase(); // ɂi"C12:0"->"c12:0"j

                if (known_cer == null)
                    known_cer = "d14-20:1, c12-26:0,\nt14-20:0, h12-26:0";
            }
            catch (Exception e)
            {
                known_cer = "d14-20:1, c12-26:0,\nt14-20:0, h12-26:0";
            }

            out.println("<HTML><HEAD><TITLE>Composition Predictor</TITLE></HEAD><BODY>"); // ͕
            out.println("<FONT SIZE=+2>Composition Predictor</FONT><BR><BR>");
            out.println("<FORM>");
            out.println("Measured <I>m/z</I> : <INPUT TYPE=text NAME=mass_a VALUE=" + mass_a + " SIZE=16>");
            out.println("Tolerance (Da): <INPUT TYPE=text NAME=tolerance VALUE=" + tolerance + " SIZE=4>");

            out.println("Adduct ion: <SELECT NAME=adduct>"+adduct); // O̓elƂD
            if (adduct.equals(MassCalc.Na_ION))
                out.println("<OPTION VALUE="+MassCalc.Na_ION+" SELECTED>Na+");
            else
                out.println("<OPTION VALUE="+MassCalc.Na_ION+">Na+");
            if (adduct.equals(MassCalc.H_ION))
                out.println("<OPTION VALUE="+MassCalc.H_ION+" SELECTED>H+");
            else
                out.println("<OPTION VALUE="+MassCalc.H_ION+">H+");
            if (adduct.equals(MassCalc.Li_ION))
                out.println("<OPTION VALUE="+MassCalc.Li_ION+" SELECTED>Li+");
            else
                out.println("<OPTION VALUE="+MassCalc.Li_ION+">Li+");
            if (adduct.equals(MassCalc.K_ION))
                out.println("<OPTION VALUE="+MassCalc.K_ION+" SELECTED>K+");
            else
                out.println("<OPTION VALUE="+MassCalc.K_ION+">K+");
            if (adduct.equals(MassCalc.H_NION))
                out.println("<OPTION VALUE="+MassCalc.H_NION+" SELECTED>H-");
            else
                out.println("<OPTION VALUE="+MassCalc.H_NION+">H-");
            if (adduct.equals(""))
                out.println("<OPTION VALUE='' SELECTED>No adduct (Molecular weight)");
            else
                out.println("<OPTION VALUE=''>No adduct (Molecular weight)");
            out.println("</SELECT>");

            out.println("Mass mode: <SELECT NAME=monoavg>");
            if (monoavg)
            {
                out.println("<OPTION VALUE=mono SELECTED>Monoisotopic");
                out.println("<OPTION VALUE=avg>Average");
            }
            else
            {
                out.println("<OPTION VALUE=mono>Monoisotopic");
                out.println("<OPTION VALUE=avg SELECTED>Average");
            }
            out.println("</SELECT><BR>");


            out.println("Known composition: <INPUT TYPE=text NAME=known_cp VALUE='" + known_cp + "' SIZE=64><BR><BR>");

            out.println("Monosaccharide residues present<BR>");

            out.println("Pen: <SELECT NAME=present_pen>");           // Pen݂̑w
            if (present_pen)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("dHex: <SELECT NAME=present_dhex>");         // dHex݂̑w
            if (present_dhex)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("Hex: <SELECT NAME=present_hex>");           // Hex݂̑w
            if (present_hex)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("HexNAc: <SELECT NAME=present_hexnac>");     // HexNAc݂̑w
            if (present_hexnac)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("PenMe: <SELECT NAME=present_penme>");       // PenMȇ݂w
            if (present_penme)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("dHexMe: <SELECT NAME=present_dhexme>");     // dHexMȇ݂w
            if (present_dhexme)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("HexMe: <SELECT NAME=present_hexme>");       // HexMȇ݂w
            if (present_hexme)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("HexNAcMe: <SELECT NAME=present_hexnacme>"); // HexNAcMȇ݂w
            if (present_hexnacme)
                out.println("<OPTION VALUE=yes SELECTED>Yes\n<OPTION VALUE=no>No");
            else
                out.println("<OPTION VALUE=yes>Yes\n<OPTION VALUE=no SELECTED>No");
            out.println("</SELECT>");

            out.println("<BR><BR>");

            // Z~hg͕
            if (select == 0) // 0Ȃ΁CZ~hgɂvZD
                out.println("<INPUT TYPE=radio NAME=select VALUE=0 CHECKED>Ceramide composition: ");
            else
                out.println("<INPUT TYPE=radio NAME=select VALUE=0>Ceramide composition: ");

            out.println("<TEXTAREA NAME=known_cer ROWS=4 COLS=36>" + known_cer + "</TEXTAREA><BR>");

            if (select == 2) // 2Ȃ΁Ĉ݂̕qƂČvZD
                out.println("<INPUT TYPE=radio NAME=select VALUE=2 CHECKED>Glycan only<BR>");
            else
                out.println("<INPUT TYPE=radio NAME=select VALUE=2>Glycan only<BR>");

            out.println("<INPUT TYPE=submit>");
            out.println("</FORM>");

            // m/z1700ȏ̓mAC\gsbN}X𐳂IĂ邩xD
            if (mass_a > 1700)
                out.println("<FONT color=red>Confirm measured <I>m/z</I> is monoisotopic mass.</FONT><BR><BR>");

            out.println("<B>Predicted Compositions</B><BR><TABLE border=1>"); // \
            out.print("<TR>");
            out.print("<TH>Calculated <I>m/z</I></TH>");
            out.print("<TH>+-</TH>");
            out.print("<TH>Modif</TH>");
            out.print("<TH>Ceramide</TH>");
            if (present_pen || known_cp.contains("pen")) // Ŏw肵݂̂\D
                out.print("<TH>Pen</TH>");
            if (present_dhex || known_cp.contains("dhex"))
                out.print("<TH>dHex</TH>");
            if (present_hex || known_cp.contains("hex"))
                out.print("<TH>Hex</TH>");
            if (present_hexnac || known_cp.contains("hexnac"))
                out.print("<TH>HexNAc</TH>");
            if (present_penme || known_cp.contains("penme"))
                out.print("<TH>PenMe</TH>");
            if (present_dhexme || known_cp.contains("dhexme"))
                out.print("<TH>dHexMe</TH>");
            if (present_hexme || known_cp.contains("hexme"))
                out.print("<TH>HexMe</TH>");
            if (present_hexnacme || known_cp.contains("hexnacme"))
                out.print("<TH>HexNAcMe</TH>");

            out.print("<TH>Total</TH>");
            out.print("<TD>Permethylated <I>m/z</I></TD>");
            out.print("<TD>Possible series</TD>");
            out.println("</TR>");

            CompositionTools ci = new CompositionTools();
            ci.setComposition(known_cp);
            ci.setMsTolerance(tolerance);
            ci.setMass(mass_a);
            ci.setMonoavg(monoavg);             // mAC\gsbN}XŌvZ邩CAx[WŌvZ邩w
            ci.setAdduct(adduct);               // tCIw
            ci.setMax("pen",      present_pen); // e̍őlݒ肷D
            ci.setMax("dhex",     present_dhex);
            ci.setMax("hex",      present_hex);
            ci.setMax("hexnac",   present_hexnac);
            ci.setMax("penme",    present_penme);
            ci.setMax("dhexme",   present_dhexme);
            ci.setMax("hexme",    present_hexme);
            ci.setMax("hexnacme", present_hexnacme);

            if (select == 0)                                     // 0Ȃ΁CZ~hgɂvZD
            {
                List<String> ceramide = new ArrayList<String>(); // m̒gi[D
                List<String> lcb      = new ArrayList<String>(); // m̒gi[D
                List<String> fa       = new ArrayList<String>(); // m̎b_gi[D

                for (String str : known_cer.split("[^\\w:-]")) // P\':','-'ȊO̕ŕ
                    if (str.matches("^[dt][ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$"))  // Z~h̏ꍇ
                        ceramide.add(str);
                    else if (str.matches("^[dt][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ̏ꍇ
                        lcb.add(str);
                    else if (str.matches("^[ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // b_̏ꍇ
                        fa.add(str);

                ci.setCeramide(ceramide); // Z~hgo^
                ci.setLongChainBase(lcb); // go^
                ci.setFattyAcid(fa);      // b_go^
            }

            for (Composition cp : ci.getComposition())
            {
                Composition cp_hex = new Composition(cp); // CX^XRs[D
                cp_hex.toHexose();                        // "Glc"Ȃǂ"Hex"֕ϊ

                int pen      = Collections.frequency(cp_hex, "pen"); // w肵̌𐔂D
                int dhex     = Collections.frequency(cp_hex, "dhex");
                int hex      = Collections.frequency(cp_hex, "hex");
                int hexnac   = Collections.frequency(cp_hex, "hexnac");
                int penme    = Collections.frequency(cp_hex, "penme");
                int dhexme   = Collections.frequency(cp_hex, "dhexme");
                int hexme    = Collections.frequency(cp_hex, "hexme");
                int hexnacme = Collections.frequency(cp_hex, "hexnacme");
                int total  = pen + dhex + hex + hexnac + penme + dhexme + hexme + hexnacme; // v̓
                double mass_t = cp.getMass(monoavg, adduct);
                double difference = mass_a - mass_t;

                Composition modif = new Composition(cp_hex); // \ɑ݂ȊȌCmodif֊i[D
                // P폜
                modif.removeAll(new Composition("pen, dhex, hex, hexnac, penme, dhexme, hexme, hexnacme"));
                if (select != 2)                       // Z~h݂ꍇC
                    modif.remove(modif.getCeramide()); // Z~h폜

                out.print("<TR>");
                out.print(String.format("<TD align=right>%.4f</TD>", mass_t));
                out.print(String.format("<TD align=right>%.4f</TD>", difference));

                if (modif.size() > 0)                               // \ɑ݂ȊȌC݂ꍇC
                    out.print("<TD align=center>" + modif.toString() + "</TD>"); // \D
                else                                                // ݂Ȃꍇ́C
                    out.print("<TD align=center>-</TD>");           // \ȂD

                if (select != 2)                                                 // ݂̗̂\łȂꍇC
                    out.print("<TD align=center>" + cp.getCeramide() + "</TD>"); // Z~h݂͑D
                else                                                             // ݂̗̂\̏ꍇC
                    out.print("<TD align=center>-</TD>");                        // Z~h݂͑ȂD

                if (present_pen || known_cp.contains("pen"))            // Ŏw肵݂̂\D
                    out.print("<TD align=right>" + pen      + "</TD>"); // ě
                if (present_dhex || known_cp.contains("dhex"))
                    out.print("<TD align=right>" + dhex     + "</TD>");
                if (present_hex || known_cp.contains("hex"))
                    out.print("<TD align=right>" + hex      + "</TD>");
                if (present_hexnac || known_cp.contains("hexnac"))
                    out.print("<TD align=right>" + hexnac   + "</TD>");
                if (present_penme || known_cp.contains("penme"))
                    out.print("<TD align=right>" + penme    + "</TD>");
                if (present_dhexme || known_cp.contains("dhexme"))
                    out.print("<TD align=right>" + dhexme   + "</TD>");
                if (present_hexme || known_cp.contains("hexme"))
                    out.print("<TD align=right>" + hexme    + "</TD>");
                if (present_hexnacme || known_cp.contains("hexnacme"))
                    out.print("<TD align=right>" + hexnacme + "</TD>");

                out.print("<TD align=right>" + total  + "</TD>"); // ̍v

                try                                                    // `̓m/zo
                {
                    Composition methylated = new Composition(cp);
                    int count = methylated.countHydroxy();             // `OH̐𐔂D
                    methylated.addAll(new Composition("me*" + count)); // `ǉD
                    out.print(String.format("<TD align=right>%.4f</TD>", methylated.getMass(monoavg, adduct)));
                }
                catch (Exception e)
                {
                    out.println("<TD align=center>-</TD>");
                }

                try                                                    // \̂n\D
                {
                    StringBuilder sb = new StringBuilder();
                    if (cp.isGloboSeries())
                        sb.append("Globo, ");
                    if (cp.isLactoSeries())
                        sb.append("Lacto, ");
                    if (cp.isGanglioSeries())
                        sb.append("Ganglio, ");
                    if (cp.isLactoganglioSeries())
                        sb.append("Lactoganglio, ");
                    if (cp.isGalaSeries())
                        sb.append("Gala, ");
                    if (cp.isMucoSeries())
                        sb.append("Muco, ");
                    if (cp.isArthroSeries())
                        sb.append("Arthro, ");
                    if (cp.isMolluSeries())
                        sb.append("Mollu, ");
                    if (sb.length() > 2)
                        out.print("<TD>" + sb.substring(0, sb.length()-2) + "</TD>"); // Ō", "폜ĕ\
                    else
                        out.print("<TD></TD>"); // \̂n񂪑݂Ȃꍇ
                }
                catch (Exception e)
                {
                    out.println("<TD>" + e + "</TD>");
                }

                out.println("</TR>");
            }
        }
        catch (Exception e)
        {
            out.println("ERROR:" + e.getMessage());
        }
        out.println("</TABLE><BR>");

        out.println("<Div Align=right><FONT color=gray>(c) Kazuhito Yokoi</FONT></Div><BR>");
        out.println("<A HREF=../>Back</A>");              // gbvy[Wւ̃N

        out.println("<script type=\"text/javascript\">");
        out.println("var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");");
        out.println("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));");
        out.println("</script>");
        out.println("<script type=\"text/javascript\">");
        out.println("try {");
        out.println("var pageTracker = _gat._getTracker(\"UA-1643740-14\");");
        out.println("pageTracker._trackPageview();");
        out.println("} catch(err) {}</script>");
        out.println("</BODY></HTML>"); // I^O
    }
}
