package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;

/**
 * <I>m/z</I> 瓜C̑g\NXłD
 * @author  m
 * @version  20081221
 */
public class CompositionTools extends Observable                 // is󋵂̊Ď\ƂD
{
    ArrayList<Composition> al_cp = new ArrayList<Composition>(); // Compositioni[D
    double mass_a = 0.0;                          // m/z̎l
    double[] masses_a;                            // m/z̎lĩtOg\ꍇɗpj
    double tolerance_ms = 0.5;                    // w肪Ȃ΁C0.5ƂD
    double tolerance_psd = 1.0;                   // lƗ_l̋e덷iPSDj
    Set<String> ceramide = new HashSet<String>(); // m̃Z~hgi[D
    Set<String> lcb      = new HashSet<String>(); // m̒gi[D
    Set<String> fa       = new HashSet<String>(); // m̎b_gi[D
    Glycan known_gc;                              // m\
    Composition known_cp;                         // mg
    String adduct = MassCalc.Na_ION;              // tCIiftHgNa+j
    boolean monoavg = MassCalc.MONO_MASS;         // Monoisotopic(ture), Average(false)
    int hex_max = 10 ;
    int hexnac_max = 10 ;
    int dhex_max = 10 ;
    int pen_max = 0 ;
    int hexme_max = 0 ;
    int hexnacme_max = 0 ;
    int dhexme_max = 0 ;
    int penme_max = 0 ;
    int kdn_max = 0 ;
    int neuac_max = 0 ;
    int neugc_max = 0 ;

    /**
     * \ꂽgԂ܂D
     * @return ʌ덷̏ȂɊi[ĕԂ܂D
     */
    public List<Composition> getComposition() throws Exception
    {
        if (masses_a != null && masses_a.length > 0) // ̃tOg͂Ăꍇ
            return getCompositionFromMultiple();
        else
        {
            if (mass_a != 0.0) // mass_aɂ̂m/zo^Ăꍇ
                return getCompositionFromSingle();
            else               // \ɕKvm/zo^ĂȂC̃XgԂD
            {
                System.err.println("CompositionTools returns null composition.");
                return new ArrayList<Composition>();
            }
        }
    }

    /**
     * w肳ꂽg\܂Diw肳ꂽ<I>m/z</I> ݂ꍇj
     * @return Compositioni[List
     */
    private List<Composition> getCompositionFromMultiple() throws Exception
    {
        al_cp.clear(); // NX̍ėp̎̂߂ɗvfSč폜D

        CompositionTools ci = new CompositionTools();    // g\CX^X쐬D
        ci.setComposition(known_cp);                     // mgo^
        ci.setGlycan(known_gc);                          // m\o^
        ci.setCeramide(new ArrayList<String>(ceramide)); // mZ~hgo^iSetArrayListɕϊj
        ci.setMsTolerance(tolerance_ms);                 // e덷o^
        ci.setAdduct(adduct);                            // tCIo^
        ci.setMonoavg(monoavg);                          // MonoisotopicAverageI
        ci.setMax("hex",      hex_max);                  // e̍ő吔w肷D
        ci.setMax("hexnac",   hexnac_max);
        ci.setMax("dhex",     dhex_max);
        ci.setMax("pen",      pen_max);
        ci.setMax("hexme",    hexme_max);
        ci.setMax("hexnacme", hexnacme_max);
        ci.setMax("dhexme",   dhexme_max);
        ci.setMax("penme",    penme_max);
        ci.setMax("kdn",      kdn_max);
        ci.setMax("neuac",    neuac_max);
        ci.setMax("neugc",    neugc_max);

        int length;                   // z̉Ԗڂ܂œǂݍނw肷D
        if (mass_a != 0.0)            // \ʂ͂Ăꍇ́C
        {
            ci.setMass(mass_a);       // m/z\sD
            length = masses_a.length; // SẴtOgǂݍ
        }
        else                                         // ͂ĂȂꍇ́C
        {
            Arrays.sort(masses_a);                   // tOgm/zo^ꂢzɃ\[gC
            ci.setMass(masses_a[masses_a.length-1]); // őm/zg\
            length = masses_a.length - 1;            // Ō̃tOg͓ǂݍ܂ȂD
        }

        Map<Integer, List<Composition>> mp = new HashMap<Integer, List<Composition>>(); // etOg̑gi[
        for (int i = 0; i < length; i++)                                                // etOg̑g\
        {
            List<Composition> li = new ArrayList<Composition>();  // i[pList
            CompositionTools ci2;

            if (ceramide != null && ceramide.size() != 0)         // Z~ho^Ăꍇ
            {                                                     // tOg𓜎Ƃđg\sD
                ci2 = new CompositionTools();                     // g\CX^X쐬D
                ci2.setCeramide(new ArrayList<String>(ceramide)); // mZ~hgo^iSetArrayListɕϊj
                ci2.setMsTolerance(tolerance_psd);                // e덷o^iPSDł邱ƂɒӁIj
                ci2.setAdduct(adduct);                            // tCIo^
                ci2.setMonoavg(monoavg);                          // MonoisotopicAverageI
                ci2.setMass(masses_a[i]);
                ci2.setMax("hex",      hex_max);                  // e̍ő吔w肷D
                ci2.setMax("hexnac",   hexnac_max);
                ci2.setMax("dhex",     dhex_max);
                ci2.setMax("pen",      pen_max);
                ci2.setMax("hexme",    hexme_max);
                ci2.setMax("hexnacme", hexnacme_max);
                ci2.setMax("dhexme",   dhexme_max);
                ci2.setMax("penme",    penme_max);
                ci2.setMax("kdn",      kdn_max);
                ci2.setMax("neuac",    neuac_max);
                ci2.setMax("neugc",    neugc_max);
                li.addAll(ci2.getComposition());                  // ȏ̏g\D
            }
                                               // tOg𓜍Ƃđg\sD
            ci2 = new CompositionTools();      // g\CX^X쐬D
            ci2.setMsTolerance(tolerance_psd); // e덷o^iPSDł邱ƂɒӁIj
            ci2.setAdduct(adduct);             // tCIo^
            ci2.setMonoavg(monoavg);           // MonoisotopicAverageI
            ci2.setMass(masses_a[i]);
            ci2.setMax("hex",      hex_max);   // e̍ő吔w肷D
            ci2.setMax("hexnac",   hexnac_max);
            ci2.setMax("dhex",     dhex_max);
            ci2.setMax("pen",      pen_max);
            ci2.setMax("hexme",    hexme_max);
            ci2.setMax("hexnacme", hexnacme_max);
            ci2.setMax("dhexme",   dhexme_max);
            ci2.setMax("penme",    penme_max);
            ci2.setMax("kdn",      kdn_max);
            ci2.setMax("neuac",    neuac_max);
            ci2.setMax("neugc",    neugc_max);
            li.addAll(ci2.getComposition());   // ȏ̏g\D
                                                     // tOgEƂđg\sD
            ci2 = new CompositionTools();            // g\CX^X쐬D
            Composition temp_cp = new Composition(); // EɑΉ邽߂ɐVCX^X𐶐
            temp_cp.add("-h2o");                     // EɑΉ邽߂"-h2o"ǉ
            ci2.setComposition(temp_cp);             // mgo^
            ci2.setMsTolerance(tolerance_psd);       // e덷o^iPSDł邱ƂɒӁIj
            ci2.setAdduct(adduct);                   // tCIo^
            ci2.setMonoavg(monoavg);                 // MonoisotopicAverageI
            ci2.setMass(masses_a[i]);
            ci2.setMax("hex",      hex_max);         // e̍ő吔w肷D
            ci2.setMax("hexnac",   hexnac_max);
            ci2.setMax("dhex",     dhex_max);
            ci2.setMax("pen",      pen_max);
            ci2.setMax("hexme",    hexme_max);
            ci2.setMax("hexnacme", hexnacme_max);
            ci2.setMax("dhexme",   dhexme_max);
            ci2.setMax("penme",    penme_max);
            ci2.setMax("kdn",      kdn_max);
            ci2.setMax("neuac",    neuac_max);
            ci2.setMax("neugc",    neugc_max);
            for (Composition temp : ci2.getComposition()) // ȏ̏g\C
            {
                temp.remove("-h2o");                      // q폜C
                li.add(temp);                             // Xg֒ǉD
            }

            mp.put(i, li); // ȏ3ނ̃tOgg}bvɊi[
        }

        // ȉ̃vÓC3iKɕđg\ĂD
        // ܂tOglg1/4ȏ㎝Ce}XvZgXgɊi[D
        // āC1/4ȏ㎝g݂Ȃꍇ́C1/8ȏ㎝gi[D
        // 1/41/8SĂ̑gȂꍇ́CŏIi1ȏgĂ̂i[D
        ArrayList<Composition> al_cp1 = new ArrayList<Composition>(); // ⌇g1
        ArrayList<Composition> al_cp2 = new ArrayList<Composition>(); // ⌇g2
        for (Composition cp : ci.getComposition())                    // ȏ̏g\D
        {
            int count = 0; // gtOg瓾gCĂ邩JEgD

            for (int key : mp.keySet())
            {
                Iterator<Composition> it = mp.get(key).iterator();
                boolean flag = true; // while𔲂邽߂̃tbO
                while (it.hasNext() && flag)
                {
                    Composition temp = new Composition(cp);
                    temp.toHexose();                 // "Glc", "Gal"Ȃǂ"Hex"֕ϊ
                    if (temp.containsAll(it.next())) // cpɓo^ĂgCit.next()̑gSĎĂ鎞
                    {
                        count++;                     // vtOǧJEgC
                        flag = false;                // while𔲂C̃tOgƂ̃}b`OsD
                    }
                }
            }

            if (count >= (int)(length / 2) + 1)      // tOg瓾gxȏggƂD
                al_cp.add(cp);                       // tOg2{̂1{͎RłƂ
            else if (count >= (int)(length / 4) + 1) // tOg4{̂1{͎RłƂ
                al_cp1.add(cp);                      // o͂g݂Ȃꍇɒǉ⌇gƂD
            else if (count > 0)                      // vtOg1ȏ㑶݂ꍇ́C
                al_cp2.add(cp);                      // o͂g݂Ȃꍇɒǉ⌇gƂD
        }

        if (al_cp.size() == 0)    // tOg2{̂1{͎RłƂ̑g݂ȂC
            al_cp.addAll(al_cp1); // tOg4{̂1{͎RłƂ̑gǉD

        if (al_cp.size() == 0)    // ł𖞂g݂ȂC
            al_cp.addAll(al_cp2); // vtOg1ȏ㑶݂gǉD

        return al_cp;
    }

    /**
     * w肳ꂽg\܂Diw肳ꂽ<I>m/z</I> 1̏ꍇj
     * @return Compositioni[List
     */
    private List<Composition> getCompositionFromSingle() throws Exception
    {
        al_cp.clear();             // NX̍ėp̎̂߂ɗvfSč폜D

        Composition cp = new Composition();
        if (known_cp != null)      // mgo^Ăꍇ
            cp.addAll(known_cp);
        else if (known_gc != null) // m\o^Ăꍇ
            cp.addAll(new Composition(known_gc));

        double mass_t = cp.getMass(monoavg, adduct);

        if (ceramide != null && ceramide.size() != 0)         // Z~ho^Ăꍇ
        {
            if (mass_a > mass_t)
                addCer(cp);                                   // Z~h猟D
        }
        else                                                  // Z~ho^ĂȂꍇ́C[hƂD
        {
            if (Math.abs(mass_a - mass_t) < tolerance_ms)     // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(cp);
            else if (mass_a > mass_t)
                addHex(cp);                                   // Hex猟D
        }

        final double temp_a = mass_a;                         // NXŗpϐ́CfinalŐ錾KvD
        Collections.sort(al_cp, new Comparator<Composition>() // \[gsD
        {
            public int compare(Composition cp1, Composition cp2)
            {
                double sub = 0.0;

                try
                {
                    sub = Math.abs(cp1.getMass(monoavg, adduct) - temp_a)
                        - Math.abs(cp2.getMass(monoavg, adduct) - temp_a);
                } catch (Exception e) {/**/}

                return (int)(sub*1024); // compare\bh̕Ԃlint^󂯕tȂ̂1024{ĐxグD
            }
        });

        ceramide.clear(); // ̎s鎞ɓgQǉȂ悤
        lcb.clear();      // m̃Z~hgCgCb_g폜ĂD
        fa.clear();       // iɂCsɒʏʂZ~hǉłj

        return al_cp;
    }

    protected void addCer(Composition cp) throws Exception
    {
        for (String str : ceramide)
        {
            Composition temp = new Composition(str); // Z~ho^D
            temp.addAll(cp);

            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else
                addHex(temp);
        }
    }

    protected void addHex(Composition cp) throws Exception
    {
        addHexNAc(cp);                                    // HexNAcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hex") < hex_max)  // vfTC𐔂D
        {
            temp.add("hex");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHex(temp);
        }
    }

    protected void addHexNAc(Composition cp) throws Exception
    {
        adddHex(cp);                                           // dHexǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hexnac") < hexnac_max) // vfTC𐔂D
        {
            temp.add("hexnac");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)      // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHexNAc(temp);
        }
    }

    protected void adddHex(Composition cp) throws Exception
    {
        addPen(cp);                                       // dHexMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(cp,"dhex") < dhex_max)  // vfTC𐔂D
        {
            temp.add("dhex");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                adddHex(temp);
        }
    }

    protected void addPen(Composition cp) throws Exception
    {
        addHexMe(cp);                                     // HexMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"pen") < pen_max)  // vfTC𐔂D
        {
            temp.add("pen");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addPen(temp);
        }
    }

    protected void addHexMe(Composition cp) throws Exception
    {
        addHexNAcMe(cp);                                     // HexNAcMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hexme") < hexme_max) // vfTC𐔂D
        {
            temp.add("hexme");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)    // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHexMe(temp);
        }
    }

    protected void addHexNAcMe(Composition cp) throws Exception
    {
        adddHexMe(cp);                                             // dHexMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hexnacme") < hexnacme_max) // vfTC𐔂D
        {
            temp.add("hexnacme");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)          // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHexNAcMe(temp);
        }
    }

    protected void adddHexMe(Composition cp) throws Exception
    {
        addPenMe(cp);                                        // PenMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(cp,"dhexme") < dhexme_max) // vfTC𐔂D
        {
            temp.add("dhexme");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)    // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                adddHexMe(temp);
        }
    }

    protected void addPenMe(Composition cp) throws Exception
    {
        addKDN(cp);                                          // KDNǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"penme") < penme_max) // vfTC𐔂D
        {
            temp.add("penme");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)    // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addPenMe(temp);
        }
    }

    protected void addKDN(Composition cp) throws Exception
    {
        addNeuAc(cp);                                     // NeuAcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"kdn") < kdn_max)  // vfTC𐔂D
        {
            temp.add("kdn");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addKDN(temp);
        }
    }

    protected void addNeuAc(Composition cp) throws Exception
    {
        addNeuGc(cp);                                      // NeuGcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(cp,"neuac") < neuac_max) // vfTC𐔂D
        {
            temp.add("neuac");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)  // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addNeuAc(temp);
        }
    }

    protected void addNeuGc(Composition cp) throws Exception
    {
        Composition temp = new Composition(cp);

        if (Collections.frequency(temp,"neugc") < neugc_max) // vfTC𐔂D
        {
            temp.add("neugc");
            double mass_t = temp.getMass(monoavg, adduct);

            if (Math.abs(mass_a - mass_t) < tolerance_ms)    // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addNeuGc(temp);
        }
    }

    /**
     * mAC\g[vC܂̓Ax[WŌvZ邩ݒ肵܂D
     * @param monoavg mAC\gsbN܂̓Ax[WD
     */
    public void setMonoavg(boolean monoavg) throws Exception
    {
        this.monoavg = monoavg; // NXoƂD
    }

    /**
     * \ɗptCIw肵܂D
     * @param adduct tCIiftHgNa+j
     */
    public void setAdduct(String adduct) throws Exception
    {
        this.adduct = adduct; // NXoƂD
    }

    /**
     * \ōle̓w肵܂D
     * @param str w肷铜
     * @param max w肷铜
     */
    public void setMax(String str, int max) throws Exception
    { // ftHghex_max = 10, hexnac_max = 10, dhex_max = 10, dhexme_max = 0, pen_max = 0
        if (str.equals("hex"))
            hex_max = max;
        else if (str.equals("hexnac"))
            hexnac_max = max;
        else if (str.equals("dhex"))
            dhex_max = max;
        else if (str.equals("pen"))
            pen_max = max;
        else if (str.equals("hexme"))
            hexme_max = max;
        else if (str.equals("hexnacme"))
            hexnacme_max = max;
        else if (str.equals("dhexme"))
            dhexme_max = max;
        else if (str.equals("penme"))
            penme_max = max;
        else if (str.equals("kdn"))
            kdn_max = max;
        else if (str.equals("neuac"))
            neuac_max = max;
        else if (str.equals("neugc"))
            neugc_max = max;
        else
            throw new Exception("Unknown glycan cannot setMax(): " + str);
    }

    /**
     * \ōle̓w肵܂Dí͎j
     * @param str w肷铜
     */
    public void setMax(String str, boolean present) throws Exception
    {
        double temp = 0.0;                      // \ɗpm/zi[D

        if (mass_a != 0.0)                      // vJ[T[}Xm/zo^ĂꍇC
            temp = mass_a;
        else if (masses_a != null)
        {
            Arrays.sort(masses_a);              // tOgm/zo^ꂢzɃ\[gC
            temp = masses_a[masses_a.length-1]; // őm/zg\
        }

        if (present && temp != 0.0)             // \m/zo^Ăꍇ́C̒lő吔Zo
        {
            if (str.equals("hex"))
                hex_max      = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("hexnac"))
                hexnac_max   = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("dhex"))
                dhex_max     = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("pen"))
                pen_max      = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("hexme"))
                hexme_max    = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("hexnacme"))
                hexnacme_max = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("dhexme"))
                dhexme_max   = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("penme"))
                penme_max    = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("kdn"))
                kdn_max      = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("neuac"))
                neuac_max    = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else if (str.equals("neugc"))
                neugc_max    = (int)(temp / new Composition(str).getMass(monoavg, "")) + 1;
            else
                throw new Exception("Unknown glycan cannot setMax(): " + str);
        }
        else if (!present)         // ݂ȂƎw肳ꂽꍇ
        {
            if (str.equals("hex")) // 0ƂD
                hex_max    = 0;
            else if (str.equals("hexnac"))
                hexnac_max = 0;
            else if (str.equals("dhex"))
                dhex_max   = 0;
            else if (str.equals("pen"))
                pen_max    = 0;
            else if (str.equals("hexme"))
                hexme_max    = 0;
            else if (str.equals("hexnacme"))
                hexnacme_max = 0;
            else if (str.equals("dhexme"))
                dhexme_max   = 0;
            else if (str.equals("penme"))
                penme_max    = 0;
            else if (str.equals("kdn"))
                kdn_max      = 0;
            else if (str.equals("neuac"))
                neuac_max    = 0;
            else if (str.equals("neugc"))
                neugc_max    = 0;
            else
                throw new Exception("Unknown glycan cannot setMax(): " + str);
        }
        else // o^ĂȂꍇ́Cő哜10ƂD
        {
            if (str.equals("hex"))
                hex_max    = 10;
            else if (str.equals("hexnac"))
                hexnac_max = 10;
            else if (str.equals("dhex"))
                dhex_max   = 10;
            else if (str.equals("pen"))
                pen_max    = 10;
            else if (str.equals("hexme"))
                hexme_max    = 10;
            else if (str.equals("hexnacme"))
                hexnacme_max = 10;
            else if (str.equals("dhexme"))
                dhexme_max   = 10;
            else if (str.equals("penme"))
                penme_max    = 10;
            else if (str.equals("kdn"))
                kdn_max      = 10;
            else if (str.equals("neuac"))
                neuac_max    = 10;
            else if (str.equals("neugc"))
                neugc_max    = 10;
            else
                throw new Exception("Unknown glycan cannot setMax(): " + str);
        }
    }

    /**
     * m\ǉ܂D
     * @param known_gc m\
     */
    public void setGlycan(Glycan known_gc)
    {
        this.known_gc = known_gc;
    }

    /**
     * mgǉ܂D
     * @param known_cp mg
     */
    public void setComposition(Composition known_cp)
    {
        this.known_cp = known_cp;
    }

    /**
     * g̗\ɗpm/zo^܂D
     * @param mass_a g\m/z
     */
    public void setMass(double mass_a)
    {
        this.mass_a = mass_a;
    }

    /**
     * g̗\ɗpm/zo^܂Dim/zg܂\ꍇj
     * @param masses_a g\m/z̔z
     */
    public void setMass(double[] masses_a)
    {
        this.masses_a = masses_a;
    }

    /**
     * g̗\ɗp鋖e덷o^܂D
     * @param tolerance_ms e덷
     */
    public void setMsTolerance(double tolerance_ms)
    {
        this.tolerance_ms = tolerance_ms;
    }

    /**
     * PSDXyNg̎lƗ_l̋e덷o^܂D
     * @param tolerance_psd lƗ_l̋e덷
     */
    public void setPsdTolerance(double tolerance_psd) throws Exception
    {
        this.tolerance_psd = tolerance_psd; // NXoƂD
    }

    /**
     * g̗\ɗp钷go^܂D
     * @param lcb g
     */
    public void setLongChainBase(List<String> lcb) throws Exception
    {
        for (String str : lcb)                     // w肳ꂽgo^
            if (str.matches("^[dt][0-9]+:[0-9]$")) // ʏ̌`̏ꍇ
                this.lcb.add(str);
            else if (str.matches("^[dt][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ɕꍇ
            {
                Pattern pt = Pattern.compile("^([dt])([0-9]+)(-([0-9]+))*:([0-9])(-([0-9]))*$");
                Matcher mt = pt.matcher(str); //( 1  )(  2   )(3(  4   ))  (  5  )(6(  7  ))ŃO[vD

                if (mt.matches())
                {
                    String temp = mt.group(1);                       // "([dt])"擾
                    int corbons_min = Integer.parseInt(mt.group(2)); // ŏYfi܂̓ftHg̒Yfj
                    int corbons_max = corbons_min;                   // w肳Ȃꍇ́CftHg̒Yf
                    if (mt.group(4) != null)
                        corbons_max = Integer.parseInt(mt.group(4)); // őYf擾
                    int bonds_min = Integer.parseInt(mt.group(5));   // ŏdi܂̓ftHg̓dj
                    int bonds_max = bonds_min;                       // w肳Ȃꍇ́CftHg̓d
                    if (mt.group(7) != null)
                        bonds_max = Integer.parseInt(mt.group(7));   // őd擾

                    for (int corbons = corbons_min; corbons <= corbons_max; corbons++)
                        for (int bonds = bonds_min; bonds <= bonds_max; bonds++)
                        {
                            StringBuilder sb = new StringBuilder(temp);
                            sb.append(corbons);
                            sb.append(":");
                            sb.append(bonds);
                            this.lcb.add(sb.toString()); // 1ǉ
                        }
                }
            }
            else
                throw new Exception("Unknown lcb: " + str);

        if (fa.size() > 0) // b_o^ĂꍇC
            setCeramide(); // SZ~hgvZCi[D
    }

    /**
     * g̗\ɗp鎉b_go^܂D
     * @param fa b_g
     */
    public void setFattyAcid(List<String> fa) throws Exception
    {
        for (String str : fa)                                              // w肳ꂽb_go^
            if (str.matches("^[ch][0-9]+:[0-9]$"))                         // ʏ̌`̏ꍇ
                this.fa.add(str);
            else if (str.matches("^[ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ɕꍇ
            {
                Pattern pt = Pattern.compile("^([ch])([0-9]+)(-([0-9]+))*:([0-9])(-([0-9]))*$");
                Matcher mt = pt.matcher(str); // ( 1  )(  2   )(3(  4   ))  (  5  )(6(  7  ))ŃO[vD

                if (mt.matches())
                {
                    String temp = mt.group(1);                       // "([ch])"擾
                    int corbons_min = Integer.parseInt(mt.group(2)); // ŏYfi܂̓ftHg̒Yfj
                    int corbons_max = corbons_min;                   // w肳Ȃꍇ́CftHg̒Yf
                    if (mt.group(4) != null)
                        corbons_max = Integer.parseInt(mt.group(4)); // őYf擾
                    int bonds_min = Integer.parseInt(mt.group(5));   // ŏdi܂̓ftHg̓dj
                    int bonds_max = bonds_min;                       // w肳Ȃꍇ́CftHg̓d
                    if (mt.group(7) != null)
                        bonds_max = Integer.parseInt(mt.group(7));   // őd擾

                    for (int corbons = corbons_min; corbons <= corbons_max; corbons++)
                        for (int bonds = bonds_min; bonds <= bonds_max; bonds++)
                        {
                            StringBuilder sb = new StringBuilder(temp);
                            sb.append(corbons);
                            sb.append(":");
                            sb.append(bonds);
                            this.fa.add(sb.toString()); // 1ǉ
                        }
                }
            }
            else
                throw new Exception("Unknown fa: " + str);

        if (lcb.size() > 0) // o^ĂꍇC
            setCeramide();  // SZ~hgvZCi[D
    }

    /**
     * g̗\ɗp钷go^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     */
    public void setLongChainBase(int min, int max) throws Exception
    {
        boolean flag = true;

        for (int i = 0, num = 0; flag; i++)
        {
            StringBuilder line = new StringBuilder(8); // lineɕǉĂB
            num = i;                                   // i̒li[

            // m[}^tBg^ {0|1}
            int lcbDoubleBonds = 0;
            switch (num % 2) {
                case 0 : line.append("d");
                         lcbDoubleBonds++;
                         break;
                case 1 : line.append("t");
                         break;
            }
            num /= 2;

            // Z~h̒Yf [max-min]
            line.append(min + num % (max - min + 1));
            num /= max - min + 1;

            line.append(":");

            // Ab_̓d [0-1],[0-1]
            line.append(lcbDoubleBonds);
            num /= 2;

            if (num == 0)
                lcb.add(line.toString()); // Z~hgHashSetɒǉ
            else
                flag = false;             // for𔲂D
        }

        if (fa.size() > 0)                // b_o^ĂꍇC
            setCeramide();                // SZ~hgvZCi[D
    }

    /**
     * g̗\ɗp鎉b_go^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     */
    public void setFattyAcid(int min, int max, int bond) throws Exception
    {
        boolean flag = true;

        for (int i = 0, num = 0; flag; i++)
        {
            StringBuilder line = new StringBuilder(8); // lineɕǉĂB
            num = i;                                   // i̒li[

            // m[}b_qhLVb_ {0|1}
            switch (num % 2) {
                case 0 : line.append("c");
                         break;
                case 1 : line.append("h");
                         break;
            }
            num /= 2;

            // Z~h̒Yf [max-min]
            line.append(min + num % (max - min + 1));
            num /= max - min + 1;

            line.append(":");

            // Ab_̓d [0-1],[0-1]
            line.append(num % (bond + 1));
            num /= bond + 1;

            if (num == 0)
                fa.add(line.toString()); // Z~hgHashSetɒǉ
            else
                flag = false;            // for𔲂D
        }

        if (lcb.size() > 0)              // o^ĂꍇC
            setCeramide();               // SZ~hgvZCi[D
    }

    /**
     * g̗\ɗpZ~hgo^܂D
     */
    private void setCeramide() throws Exception          // SZ~hgvZCi[D
    {
        List<String> ceramide = new ArrayList<String>(); // \bh̍ŌɃNX̃oƂϐ

        for (String temp_lcb : lcb)
        {
            Pattern pt1 = Pattern.compile("^([dt])([0-9]+):([0-9])$");
            Matcher mt1 = pt1.matcher(temp_lcb);

            if (mt1.matches())
            {
                String str1 = null;                            // "d""t"i[
                int corbons = Integer.parseInt(mt1.group(2));
                int bonds   = Integer.parseInt(mt1.group(3));

                String temp1 = mt1.group(1);
                if (temp1.equals("d"))
                    str1 = "d";
                else if (temp1.equals("t"))
                    str1 = "t";

                for (String temp_fa : fa)
                {
                    StringBuilder str2 = new StringBuilder(8); // eʂ8ƂD"th38:0".length() = 6
                    str2.append(str1);                         // str1ɂ͒"d""t"ĂD
                    Pattern pt2 = Pattern.compile("^([ch])([0-9]+):([0-9])$");
                    Matcher mt2 = pt2.matcher(temp_fa);

                    if (mt2.matches())
                    {
                        String temp2 = mt2.group(1);
                        if (temp2.equals("c"))
                            str2.append("c");
                        else if (temp2.equals("h"))
                            str2.append("h");

                        str2.append(corbons + Integer.parseInt(mt2.group(2)));
                        str2.append(":");
                        str2.append(bonds + Integer.parseInt(mt2.group(3)));

                        ceramide.add(str2.toString());         // Z~hgƂĒǉ
                    }
                    else
                        throw new Exception("Unknown FattyAcid: " + temp_fa);
                }
            }
            else
                throw new Exception("Unknown LongChainBase: " + temp_lcb);
        }
        this.setCeramide(ceramide);                            // Z~hǉ
    }

    /**
     * g̗\ɗpZ~hgo^܂D
     * @param ceramide Z~hg
     */
    public void setCeramide(List<String> ceramide) throws Exception
    {
        for (String str : ceramide)                                            // w肳ꂽgo^
            if (str.matches("^[dt][ch][0-9]+:[0-9]$"))                         // ʏ̌`̏ꍇ
                this.ceramide.add(str);
            else if (str.matches("^[dt][ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ɕꍇ
            {
                Pattern pt = Pattern.compile("^([dt][ch])([0-9]+)(-([0-9]+))*:([0-9])(-([0-9]))*$");
                Matcher mt = pt.matcher(str); // (   1    )(  2   )(3(  4   ))  (  5  )(6(  7  ))ŃO[vD

                if (mt.matches())
                {
                    String temp = mt.group(1);                       // "([dt])"擾
                    int corbons_min = Integer.parseInt(mt.group(2)); // ŏYfi܂̓ftHg̒Yfj
                    int corbons_max = corbons_min;                   // w肳Ȃꍇ́CftHg̒Yf
                    if (mt.group(4) != null)
                        corbons_max = Integer.parseInt(mt.group(4)); // őYf擾
                    int bonds_min = Integer.parseInt(mt.group(5));   // ŏdi܂̓ftHg̓dj
                    int bonds_max = bonds_min;                       // w肳Ȃꍇ́CftHg̓d
                    if (mt.group(7) != null)
                        bonds_max = Integer.parseInt(mt.group(7));   // őd擾

                    for (int corbons = corbons_min; corbons <= corbons_max; corbons++)
                        for (int bonds = bonds_min; bonds <= bonds_max; bonds++)
                        {
                            StringBuilder sb = new StringBuilder(temp);
                            sb.append(corbons);
                            sb.append(":");
                            sb.append(bonds);
                            this.ceramide.add(sb.toString());        // 1ǉ
                        }
                }
            }
            else
                throw new Exception("Unknown ceramide: " + str);
    }

    /**
     * g̗\ɗpZ~hgo^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     * @param bond b_̓d̍ől
     */
    public void setCeramide(int min, int max, int bond)
    {
        boolean flag = true;

        for (int i = 0, num = 0; flag; i++)
        {
            StringBuilder line = new StringBuilder(8); // lineɕǉĂB
            num = i;                                   // i̒li[

            // m[}^tBg^ {0|1}
            int lcbDoubleBonds = 0;
            switch (num % 2) {
                case 0 : line.append("d");
                         lcbDoubleBonds++;
                         break;
                case 1 : line.append("t");
                         break;
            }
            num /= 2;

            // m[}b_qhLVb_ {0|1}
            switch (num % 2) {
                case 0 : line.append("c");
                         break;
                case 1 : line.append("h");
                         break;
            }
            num /= 2;

            // Z~h̒Yf [max-min]
            line.append(min + num % (max - min + 1));
            num /= max - min + 1;

            line.append(":");

            // Ab_̓d [0-1],[0-1]
            line.append(lcbDoubleBonds + num % (bond + 1));
            num /= bond + 1;

            if (num == 0)
                ceramide.add(line.toString()); // Z~hgHashSetɒǉ
            else
                flag = false;                  // for𔲂D
        }
    }

    /**
     * m/zƎw肳ꂽ瓜g\eXg
     */
    private static void testPredictComposition() throws Exception
    {
        CompositionTools ci = new CompositionTools();
        ci.setAdduct(MassCalc.Na_ION);
        ci.setMass(650.2385);
        ci.setMax("hex",      true); // e̗Lw肷D
        ci.setMax("hexnac",   true);
        ci.setMax("dhex",     true);
        ci.setMax("pen",      true);
        ci.setMax("hexme",    false);
        ci.setMax("hexnacme", false);
        ci.setMax("dhexme",   false);
        ci.setMax("penme",    false);
        ci.setMax("kdn",      false);
        ci.setMax("neuac",    true);
        ci.setMax("neugc",    false);
        for (Composition cp : ci.getComposition())
            System.out.println(cp);
    }

    /**
     * m/zƎw肳ꂽ瓜g\eXg
     */
    private static void testPredictComposition2() throws Exception
    {
        CompositionTools ci = new CompositionTools();
        ci.setComposition(new Composition("hex"));
        ci.setCeramide(30, 45, 1);
        ci.setMass(1493.6327);
        double[] temp = {1087.9, 975.0, 887.0, 793.6, 722.2, 632.3, 590.0, 432.0, 227.9};
        ci.setMass(temp);
        for (Composition cp : ci.getComposition())
            System.out.println(cp);
    }
}
