package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * 2̓\rCIȃtOgCIToServletNXłD
 * @author m
 * @version 20090102
 */
public class FragmentComparing extends HttpServlet
{
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        try
        {
            Glycan gc1;                                            // J􂳂\
            Glycan gc2;                                            // J􂳂\
            String adduct = "";                                    // tCI
            boolean monoavg = true;                                // Monoisotopic(ture), Average(false)

            try
            {
                gc1 = new Glycan(request.getParameter("struct1")); // w肳ȂꍇCO
            }
            catch (Exception e1)
            {
                try
                {
                    GlycanTools gi = new GlycanTools();            // Linucs`ȊǑ`ŎĂ݂D
                    gc1 = gi.readNormalFormat(request.getParameter("struct1"));
                }
                catch (Exception e2)
                {
                    GlycanTools gi = new GlycanTools();            // SĂɂĎsꍇCL5\D
                    gc1 = gi.readNormalFormat("dc36:1-hex3me-hex3me-hexnac3me-hexnac3me-hexnac4me");
                }
            }

            try
            {
                gc2 = new Glycan(request.getParameter("struct2")); // w肳ȂꍇCO
            }
            catch (Exception e1)
            {
                try
                {
                    GlycanTools gi = new GlycanTools();            // Linucs`ȊǑ`ŎĂ݂D
                    gc2 = gi.readNormalFormat(request.getParameter("struct2"));
                }
                catch (Exception e2)
                {                                                  // SĂɂĎsꍇC
                    GlycanTools gi = new GlycanTools();            // L5ƓtOg\\D
                    gc2 = gi.readNormalFormat("dc36:1-hex3me-hex3me-hexnac2me(-hexnac4me)-hexnac4me");
                }
            }

            try
            {
                adduct = request.getParameter("adduct");

                if (adduct == null)                                // w肳ȂꍇC
                    adduct = MassCalc.Na_ION;                      // ̃CItCIƂD
            }
            catch (Exception e)
            {
                adduct = MassCalc.Na_ION;                          // ̃CItCIƂD
            }

            try
            {
                String temp = request.getParameter("monoavg");
                if (temp.equals("mono"))
                    monoavg = true;
                else if (temp.equals("avg"))
                    monoavg = false;
                else
                    monoavg = true;                                // ̑̏ꍇMonoisotopicƂD
            }
            catch (Exception e)
            {
                monoavg = true;                                    // ̑̏ꍇMonoisotopicƂD
            }

            out.println("<HTML><HEAD><TITLE>Fragment Comparing</TITLE></HEAD><BODY>"); // ͕
            out.println("<FONT SIZE=+2>Fragment Comparing</FONT><BR><BR>");
            out.println("<FORM><BR>");

            try
            {
                String normal = gc1.toNormalFormat();              // m[}`擾C
                if (normal.length() <= 60)                         // ͕̃TCY𒲐߂D
                    out.println("Structure1: <INPUT TYPE=text NAME=struct1 VALUE='"
                               + normal + "' SIZE=100><BR>");
                else
                    out.println("Structure1: <INPUT TYPE=text NAME=struct1 VALUE='"
                               + normal + "' SIZE=" + (normal.length() + 40) + "><BR>");
            }
            catch (Exception e)                                    // 3ȏ̏ꍇCLinucs`ŕ\
            {
                String linucs = gc1.toString();                    // Linucs`擾C
                if (linucs.length() <= 60)                         // ͕̃TCY𒲐߂D
                    out.println("Structure1: <INPUT TYPE=text NAME=struct1 VALUE='"
                               + linucs + "' SIZE=100><BR>");
                else
                    out.println("Structure1: <INPUT TYPE=text NAME=struct1 VALUE='"
                               + linucs + "' SIZE=" + (linucs.length() + 40) + "><BR>");
            }

            try
            {
                String normal = gc2.toNormalFormat();              // m[}`擾C
                if (normal.length() <= 60)                         // ͕̃TCY𒲐߂D
                    out.println("Structure2: <INPUT TYPE=text NAME=struct2 VALUE='"
                               + normal + "' SIZE=100><BR>");
                else
                    out.println("Structure2: <INPUT TYPE=text NAME=struct2 VALUE='"
                               + normal + "' SIZE=" + (normal.length() + 40) + "><BR>");
            }
            catch (Exception e)                                    // 3ȏ̏ꍇCLinucs`ŕ\
            {
                String linucs = gc2.toString();                    // Linucs`擾C
                if (linucs.length() <= 60)                         // ͕̃TCY𒲐߂D
                    out.println("Structure2: <INPUT TYPE=text NAME=struct2 VALUE='"
                               + linucs + "' SIZE=100><BR>");
                else
                    out.println("Structure2: <INPUT TYPE=text NAME=struct2 VALUE='"
                               + linucs + "' SIZE=" + (linucs.length() + 40) + "><BR>");
            }

            out.println("Adduct ion: <SELECT NAME=adduct>"+adduct); // O̓elƂD
            if (adduct.equals(MassCalc.Na_ION))
                out.println("<OPTION VALUE="+MassCalc.Na_ION+" SELECTED>Na+");
            else
                out.println("<OPTION VALUE="+MassCalc.Na_ION+">Na+");
            if (adduct.equals(MassCalc.H_ION))
                out.println("<OPTION VALUE="+MassCalc.H_ION+" SELECTED>H+");
            else
                out.println("<OPTION VALUE="+MassCalc.H_ION+">H+");
            if (adduct.equals(MassCalc.Li_ION))
                out.println("<OPTION VALUE="+MassCalc.Li_ION+" SELECTED>Li+");
            else
                out.println("<OPTION VALUE="+MassCalc.Li_ION+">Li+");
            if (adduct.equals(MassCalc.K_ION))
                out.println("<OPTION VALUE="+MassCalc.K_ION+" SELECTED>K+");
            else
                out.println("<OPTION VALUE="+MassCalc.K_ION+">K+");
            if (adduct.equals(MassCalc.H_NION))
                out.println("<OPTION VALUE="+MassCalc.H_NION+" SELECTED>H-");
            else
                out.println("<OPTION VALUE="+MassCalc.H_NION+">H-");
            if (adduct.equals(""))
                out.println("<OPTION VALUE='' SELECTED>No adduct");
            else
                out.println("<OPTION VALUE=''>No adduct");
            out.println("</SELECT><BR>");
            out.println("Mass mode: <SELECT NAME=monoavg>");
            if (monoavg)
            {
                out.println("<OPTION VALUE=mono SELECTED>Monoisotopic");
                out.println("<OPTION VALUE=avg>Average");
            }
            else
            {
                out.println("<OPTION VALUE=mono>Monoisotopic");
                out.println("<OPTION VALUE=avg SELECTED>Average");
            }
            out.println("</SELECT><BR>");
            out.println("<INPUT TYPE=submit>");
            out.println("</FORM><BR>");

            out.println("<B>Result</B><BR>");             // \
            try
            {
                out.println("Structure1: " + gc1.toNormalFormat() + "<BR>");
            }
            catch (Exception e)
            {
                out.println("Structure1: " + e + "<BR>"); // 3ȏ̏ꍇ
            }
            try
            {
                out.println("Structure2: " + gc2.toNormalFormat() + "<BR>");
            }
            catch (Exception e)
            {
                out.println("Structure2: " + e + "<BR>"); // 3ȏ̏ꍇ
            }

            if (adduct.equals(MassCalc.Na_ION))
                out.println("Adduct ion: Na+<BR>");
            else if (adduct.equals(MassCalc.H_ION))
                out.println("Adduct ion: H+<BR>");
            else if (adduct.equals(MassCalc.Li_ION))
                out.println("Adduct ion: Li+<BR>");
            else if (adduct.equals(MassCalc.K_ION))
                out.println("Adduct ion: K+<BR>");
            else if (adduct.equals(MassCalc.H_NION))
                out.println("Adduct ion: H-<BR>");
            else if (adduct.equals(""))
                out.println("Adduct ion: No adduct<BR>");
            else
                out.println("Adduct ion: "+adduct+"<BR>");
            if (monoavg)
                out.println("Mass mode: Monoisotopic<BR><BR>");
            else
                out.println("Mass mode: Average<BR><BR>");
            out.println("<B>Fragment table</B><BR><TABLE border=1><TR>");
            out.println("<TH>Fragment composition<BR>(Structure1)</TH>");
            out.println("<TH><I>m/z</I></TH>");
            out.println("<TH>Fragment composition<BR>(Structure2)</TH>");
            out.println("<TH><I>m/z</I></TH>");
            out.println("</TR>");

            Fragmentation fg1 = new Fragmentation();
            Glycan temp1 = new Glycan(gc1.toString());   // Hex֕ϊ邽߂ɃCX^X𐶐
            temp1.toHexose();                            // Glc->Hex֕ϊ܂D
            fg1.setGlycan(temp1);
            List<Composition> cps1 = fg1.getComposition();

            Fragmentation fg2 = new Fragmentation();
            Glycan temp2 = new Glycan(gc2.toString());   // Hex֕ϊ邽߂ɃCX^X𐶐
            temp2.toHexose();                            // Glc->Hex֕ϊ܂D
            fg2.setGlycan(temp2);
            List<Composition> cps2 = fg2.getComposition();

            Set<Double> temp_st = new HashSet<Double>(); // 2̍\̃tOg̎ʂdđ킹D
            for (Composition cp : cps1)
                temp_st.add(cp.getMass(monoavg, adduct));
            for (Composition cp : cps2)
                temp_st.add(cp.getMass(monoavg, adduct));
            List<Double> temp_li = new ArrayList<Double>(temp_st); // \[ĝ߁CXgɕϊ

            Collections.sort(temp_li, new Comparator<Double>()     // \[gsD
            {
                public int compare(Double db1, Double db2)
                {
                    double sub = db1 - db2;
                    // compare\bh̕Ԃlint^󂯕tȂ̂1024{ĐxグD
                    return (int)(sub*1024);
                }
            });

            for (Double db : temp_li)
            {
                List<Composition> output1 = new ArrayList<Composition>(); // ʂ̑gi[D
                List<Composition> output2 = new ArrayList<Composition>();

                for (Composition cp : cps1)                               // ʂvgXgɊi[D
                    if (cp.getMass(monoavg, adduct) == db)
                        output1.add(cp);

                for (Composition cp : cps2)                               // ʂvgXgɊi[D
                    if (cp.getMass(monoavg, adduct) == db)
                        output2.add(cp);

                if (!output1.isEmpty())
                {
                    if (!output2.isEmpty())                               // ̍\tOgłꍇ
                    {
                        out.print("<TR>");
                        out.print("<TD>");                                // Z̊Jn
                        Iterator<Composition> it1 = output1.iterator();
                        while (it1.hasNext())
                        {
                            out.print(it1.next());
                            if (it1.hasNext())                            // g𕡐Ăꍇ̓Zŉs
                                out.print("<BR>");
                        }
                        out.print("</TD>");                               // Z̏I
                        out.print(String.format("<TD align=right>%.4f</TD>", db));
                        out.print("<TD>");                                // Z̊Jn
                        Iterator<Composition> it2 = output2.iterator();
                        while (it2.hasNext())
                        {
                            out.print(it2.next());
                            if (it2.hasNext())                            // g𕡐Ăꍇ̓Zŉs
                                out.print("<BR>");
                        }
                        out.print("</TD>");                               // Z̏I
                        out.print(String.format("<TD align=right>%.4f</TD>", db));
                        out.println("</TR>");
                    }
                    else                                                  // cp1݂̂tOgłꍇ
                    {
                        out.print("<TR>");
                        out.print("<TD bgcolor=#FF99FF>");                // Z̊Jn
                        Iterator<Composition> it1 = output1.iterator();
                        while (it1.hasNext())
                        {
                            out.print(it1.next());
                            if (it1.hasNext())                            // g𕡐Ăꍇ̓Zŉs
                                out.print("<BR>");
                        }
                        out.print("</TD>");                               // Z̏I
                        out.print(String.format("<TD bgcolor=#FF99FF align=right>%.4f</TD>", db));
                        out.print("<TD></TD><TD></TD>");
                        out.println("</TR>");
                    }
                }
                else if (!output2.isEmpty())                              // cp2݂̂tOgłꍇ
                {
                    out.print("<TR>");
                    out.print("<TD></TD><TD></TD>");
                        out.print("<TD bgcolor=#99FFFF>");                // Z̊Jn
                        Iterator<Composition> it2 = output2.iterator();
                        while (it2.hasNext())
                        {
                            out.print(it2.next());
                            if (it2.hasNext())                            // g𕡐Ăꍇ̓Zŉs
                                out.print("<BR>");
                        }
                        out.print("</TD>");                               // Z̏I
                    out.print(String.format("<TD bgcolor=#99FFFF align=right>%.4f</TD>", db));
                    out.println("</TR>");
                }
                else
                    throw new Exception("else if error!");
            }
        }
        catch (Exception e)
        {
            out.println("ERROR:"+e.getMessage());
        }
        out.println("</TABLE><BR>");

        out.println("<Div Align=right><FONT color=gray>(c) Kazuhito Yokoi</FONT></Div><BR>");
        out.println("<A HREF=../>Back</A>");              // gbvy[Wւ̃N

        out.println("<script type=\"text/javascript\">");
        out.println("var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");");
        out.println("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));");
        out.println("</script>");
        out.println("<script type=\"text/javascript\">");
        out.println("try {");
        out.println("var pageTracker = _gat._getTracker(\"UA-1643740-14\");");
        out.println("pageTracker._trackPageview();");
        out.println("} catch(err) {}</script>");
        out.println("</BODY></HTML>");                    // I^O
    }
}
