package jp.ac.ritsumei.is.infobio;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.jfree.chart.*;
import org.jfree.data.*;
import org.jfree.data.xy.*;
import org.jfree.data.general.*;
import org.jfree.chart.*;
import org.jfree.chart.plot.*;
import org.jfree.chart.axis.*;
import org.jfree.ui.*;

class IsotopeXYDataset extends AbstractSeriesDataset implements XYDataset
{
    double[] mass = {812.0, 813.0, 814.0, 815.0, 816.0};
    double[] intensity = {0.1, 0.8, 0.7, 0.8, 1.0};
    double fwhm = 5000.0;                                       // liقǕ\ǂj

    public IsotopeXYDataset(double[] mass, double[] intensity)
    {
        this.mass = mass;
        this.intensity = intensity;
    }

    public int getItemCount(int series)
    {
        return 200;                                             // }ϐ̐
    }

    public double getXValue(int series, int item)
    {
        return ((double)item) / 100.0 + mass[series] - 1.0;     // 1.0DaO\
    }

    /**
     * V[Y,}ϐwɉY̒l.
     */
    public double getYValue(int series, int item)
    {
        double x = ((double)item) / 100.0 + mass[series] - 1.0; // 1.0DaO\
        return Math.exp(-1.0 * Math.pow((x - mass[series]) / (x / 10000), 2)) * intensity[series] * 100;
    }

    /**
     * \OtԂ.
     */
    public int getSeriesCount()
    {
        return mass.length;                                     // zɓĂOt\D
    }

    public Comparable getSeriesKey(int key)
    {
        if (key == 0)
            return "Monoisotopic";
        else if (key == 1)
            return "1st isotopic";
        else if (key == 2)
            return "2nd isotopic";
        else if (key == 3)
            return "3rd isotopic";
        else
            return key + "th isotopic";
    }

    public Number getX(int series, int item) {return getXValue(series, item);}
    public Number getY(int series, int item) {return getYValue(series, item);}
    public DomainOrder getDomainOrder() {return DomainOrder.NONE;}
}

/**
 * ʑ̃CĨCIx\ServletNXłD
 * @author  m
 * @version  20081216
 */
public class Isotope extends HttpServlet
{
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        List<Double> li_mass      = new ArrayList<Double>();
        List<Double> li_intensity = new ArrayList<Double>();

        String str;
        for (int i = 0; (str = request.getParameter("mass" + i)) != null; i++) // ǂݎD
            li_mass.add(Double.parseDouble(str));

        for (int i = 0; (str = request.getParameter("intensity" + i)) != null; i++)
            li_intensity.add(Double.parseDouble(str));

        double[] mass = new double[li_mass.size()];                            // Xgz֕ϊ
        Iterator<Double> it_mass = li_mass.iterator();
        for (int i = 0; it_mass.hasNext(); i++)
            mass[i] = it_mass.next();

        double[] intensity = new double[li_intensity.size()];                  // Xgz֕ϊ
        Iterator<Double> it_intensity = li_intensity.iterator();
        for (int i = 0; it_intensity.hasNext(); i++)
            intensity[i] = it_intensity.next();

        XYDataset xy = new IsotopeXYDataset(mass, intensity);
        JFreeChart jc = ChartFactory.createXYLineChart("", "m/z", "Intensity (%)",
                                                       xy, PlotOrientation.VERTICAL,
                                                       true, true, true);
        response.setContentType("image/png");                                  // PNG`ŉ摜o
        ServletOutputStream so = response.getOutputStream();
        ChartUtilities.writeChartAsPNG(so, jc, 500, 300);                      // 500~300sNZ
    }
}
