package jp.ac.ritsumei.is.infobio;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import javax.swing.table.*;
import java.util.concurrent.*;
import java.lang.management.*;

/**
 * \\NXłD
 * @author m
 * @version 20081221
 */
class Candidate extends Glycan
{
    java.util.List<Composition> frags_t;         // _̃tOgg
    double[] masses_t;                           // _̃tOg̕q
    static double[] masses_a;                    // tOg̕qʁiCX^XԂŋLj
    static double[] freq;                        // omi[ziCX^XԂŋLj
    static String adduct = MassCalc.Na_ION;      // tCIiftHgNa+j
    static boolean monoavg = MassCalc.MONO_MASS; // Monoisotopic(ture),Averaget(false)
    static double tolerance_psd = 1.0;           // lƗ_l̋e덷iPSDj
    Fragmentation fg = new Fragmentation();      // tOgNX

    static int window = 1;                       // om̋敪(Da)
    static final int POSITIVE_SCORING     = 0;   // |WeBuȃtOĝ݂lȂXRAO
    static final int TFIDF_SCORING        = 1;   // tf-idf̃XRAO
    static final int PENALTY01_SCORING    = 2;   // yieBɌW0.1XRAO
    static final int PENALTY001_SCORING   = 3;   // yieBɌW0.01XRAO
    static final int PMF_SCORING          = 4;   // PMF@ɗpĂXRAO
    static final int GEOMETRICAVG_SCORING = 5;   // m̑敽ςpXRAO
    static int formula = TFIDF_SCORING;          // \ɗpXRAiftHgTFIDF_SCORINGj

    public Candidate()
    {
        // ݂̂ƂpɕKvłȊOC͉ȂD
    }

    public Candidate(Glycan gc) throws Exception
    {
        this.setNode(gc.getNode());                           // \o^D
        this.setEdge(gc.getEdge());
        this.setChildren(gc.getChildren());

        Glycan temp_gc = new Glycan(gc);
        temp_gc.toHexose();                                   // "Glc", "Gal"Ȃǂ"Hex"ɕϊ
        fg.setGlycan(temp_gc);
        this.frags_t  = fg.getComposition();                  // ꂼ̃tOg擾D
        this.masses_t = new double[this.frags_t.size()];      // tOgƓTCY̔zp

        int i = 0;
        for (Composition temp_cp : this.frags_t)
            masses_t[i++] = temp_cp.getMass(monoavg, adduct); // tOg̕qʂvZĂ
    }

    /**
     * tOg̒lo^܂D
     * @param temp_freq tOg̒li[z
     */
    public synchronized static void setMasses_a(double[] masses_a)
    {
        Candidate.masses_a = masses_a;
    }

    /**
     * omi[zo^܂D
     * @param freq omi[z
     */
    public synchronized static void setFreq(double[] freq)
    {
        Candidate.freq = freq;
    }

    /**
     * omi[zԂ܂D
     * @return omi[z
     */
    public synchronized static double[] getFreq()
    {
        return Candidate.freq;
    }

    /**
     * mAC\g[vC܂̓Ax[WŌvZ邩ݒ肵܂D
     * @param monoavg mAC\gsbN܂̓Ax[W
     */
    public synchronized static void setMonoavg(boolean monoavg) throws Exception
    {
        Candidate.monoavg = monoavg; // NXoƂD
    }

    /**
     * \ɗptCIw肵܂D
     * @param adduct tCIiftHgNa+j
     */
    public synchronized static void setAdduct(String adduct)
    {
        Candidate.adduct = adduct; // NXoƂD
    }

    /**
     * \ɗptCIw肵܂D
     * @param adduct tCIiftHgNa+j
     */
    public synchronized static void setPsdTolerance(double tolerance_psd)
    {
        Candidate.tolerance_psd = tolerance_psd; // NXoƂD
    }

    /**
     * \ɗpXRAw肵܂D
     * @param formula XRA
     */
    public synchronized static void setScoringFormula(int formula)
    {
        Candidate.formula = formula;             // NXoƂD
    }

    /**
     * \ɗpXRAԂ܂D
     * @return w肳ꂽXRA\
     */
    public synchronized static int getScoringFormula()
    {
        return Candidate.formula;
    }

    /**
     * omz̃EBhETCYw肵܂D
     * @param window EBhETCY
     */
    public synchronized static void setWindowSize(int window)
    {
        Candidate.window = window;               // NXoƂD
    }

    /**
     * ݓo^Ăomz̃EBhETCY擾܂D
     * @return EBhETCY
     */
    public synchronized static int getWindowSize()
    {
        return window;                           // CandidateNXstaticϐĂяoD
    }

    // lƏopxlC\̃XRAvZ܂D
    public synchronized double getScore() throws Exception
    {
        double score    = 0.0;
        double penalty  = 0.0;
        boolean[] check = new boolean[freq.length];         // ēxpȂ悤ɃtbO𗧂ĂD
        int count_posi = 0, count_nega = 0;                 // yieBɗpD

        for (double mass_t : masses_t)                      // ̃tOgqʂ擾D
            for (double mass_a : masses_a)                  // lƗ_lƂ̃}b`O
                if (!check[(int)(mass_t/window)] && Math.abs(mass_a - mass_t) < tolerance_psd)
                {
                    score += -Math.log(freq[(int)(mass_t/window)]);
                    check[(int)(mass_t/window)] = true;     // ēxpȂ悤ɃtbO𗧂ĂD
                    count_posi++;
                }
                else
                {
                    penalty += -Math.log(1.1 - freq[(int)(mass_t/window)]);
                    count_nega++;                           // }b`Ȃľ𐔂
                }

        if (formula == Candidate.POSITIVE_SCORING)          // |WeBuȃtOĝ݂lȂXRAO
            return score;                                   // omႢĈ̒lグD
        else if (formula == Candidate.TFIDF_SCORING)        // tf-idf̃XRAO
            return (score + 1.0) * count_posi / masses_t.length;
        else if (formula == Candidate.PENALTY01_SCORING)    // yieBɌW0.1XRAO
            return score - 0.1 * penalty;
        else if (formula == Candidate.PENALTY001_SCORING)   // yieBɌW0.01XRAO
            return score - 0.01 * penalty;
        else if (formula == Candidate.PMF_SCORING)          // PMF@ɗpĂXRAO
            return score + penalty;
        else if (formula == Candidate.GEOMETRICAVG_SCORING) // m̑敽ςpXRAO
            return (score + penalty) / masses_t.length;
        else
            throw new Exception("unknown scoring formula number: " + formula);
    }

    /**
     * \̃tOgtOgƉvԂ܂D
     * @return }b`tOg
     */
    public int countMatch()
    {
        int count = 0;
        for (double mass : this.masses_t)
        {
            boolean check = false;
            for (int i = 0; i < masses_a.length && !check; i++)
                if (mass - 1.0 < masses_a[i] && masses_a[i] < mass + 1.0)
                {
                    count++;      // lƗ_l}b`邩D
                    check = true; // tOgłQ񐔂Ȃ悤ɂD
                }
        }

        return count;
    }

    /**
     * \̃tOg̉%tOgƈvԂ܂D
     * @return _̃tOgɑ΂}b`tOg̊
     */
    public double getOccupancy()
    {
        return 100.0 * this.countMatch() / this.masses_t.length; // (100 * v / _tOg)
    }

    /**
     * \̃tOgm/zԂ܂D
     * @return tOgm/z̔z
     */
    public double[] getFragMasses()
    {
        return this.masses_t;
    }
}

/**
 * tOgCI瓜\\NXłD
 * @author m
 * @version 20080425
 */
public class Prediction extends Observable            // is󋵂̊Ď\ƂD
{
    CompositionTools cp_agg = new CompositionTools(); // p̑ɏWpD
    double precursor = 0.0;                           // vJ[T[CI̎l
    double[] masses_a;                                // tOgqʂ̎l
    double tolerance_psd;                             // lƗ_l̋e덷iPSDj
    double tolerance_ms = 1.0;                        // w肪Ȃ΁C1.0ƂD
    Glycan known_gc;                                  // m\
    Composition known_cp;                             // mg
    int percent;                                      // i\邽߂ɗpD
    boolean flag = true;                              // LZꂽɒfЉ𔲂邽߂̃tbO

    /**
     * mAC\g[vC܂̓Ax[WŌvZ邩ݒ肵܂D
     * @param monoavg mAC\gsbN܂̓Ax[WD
     */
    public void setMonoavg(boolean monoavg) throws Exception
    {
        Candidate.setMonoavg(monoavg);            // CandidateNXstaticϐƂēo^D
        cp_agg.setMonoavg(monoavg);               // g\NX̃\bh𗘗pēo^D
    }

    /**
     * \ɗptCIw肵܂D
     * @param adduct tCIiftHgNa+j
     */
    public void setAdduct(String adduct) throws Exception
    {
        Candidate.setAdduct(adduct);              // CandidateNXstaticϐƂēo^D
        cp_agg.setAdduct(adduct);                 // g\NX̃\bh𗘗pēo^D
    }

    /**
     * PSDXyNg̎lƗ_l̋e덷o^܂D
     * @param tolerance_psd lƗ_l̋e덷
     */
    public void setPsdTolerance(double tolerance_psd) throws Exception
    {
        this.tolerance_psd = tolerance_psd;       // NXoƂD
        Candidate.setPsdTolerance(tolerance_psd); // CandidateNXstaticϐƂēo^D
    }

    /**
     * tOgɂ<I>m/z</I> o^܂D
     * @param masses_a tOgɂ<I>m/z</I>
     */
    public void setFragments(double[] masses_a)
    {
        this.masses_a = masses_a;                 // oϐƂĊi[
        Candidate.setMasses_a(masses_a);          // CandidateNXstaticϐƂēo^D
    }

    /**
     * \ɗpXRAw肵܂D
     * @param formula XRA
     */
    public void setScoringFormula(int formula)
    {
        Candidate.setScoringFormula(formula);     // CandidateNXstaticϐƂēo^D
    }

    /**
     * omz̃EBhETCYw肵܂D
     * @param window EBhETCY
     */
    public void setWindowSize(int window)
    {
        Candidate.setWindowSize(window);          // CandidateNXstaticϐƂēo^D
    }

    /**
     * ݓo^Ăomz̃EBhETCY擾܂D
     * @return EBhETCY
     */
    public int getWindowSize()
    {
        return Candidate.getWindowSize();         // CandidateNXstaticϐĂяoD
    }

    /**
     * vJ[T[}X<I>m/z</I> o^܂D
     * @param precursor vJ[T[}X<I>m/z</I>
     */
    public void setPrecursorMass(double precursor)
    {
        this.precursor = precursor;               // oϐƂĊi[
    }

    /**
     * g̗\ɗp鋖e덷o^܂D
     * @param tolerance_ms e덷
     */
    public void setMsTolerance(double tolerance_ms)
    {
        this.tolerance_ms = tolerance_ms;
    }

    /**
     * m\o^܂D
     * @param known_gc m\
     */
    public void setGlycan(Glycan known_gc)
    {
        this.known_gc = known_gc;
    }

    /**
     * g̗\ɗp钷go^܂D
     * @param lcb g
     */
    public void setLongChainBase(java.util.List<String> lcb) throws Exception
    {
        cp_agg.setLongChainBase(lcb);
    }

    /**
     * g̗\ɗp鎉b_go^܂D
     * @param fa b_g
     */
    public void setFattyAcid(java.util.List<String> fa) throws Exception
    {
        cp_agg.setFattyAcid(fa);
    }

    /**
     * g̗\ɗp钷go^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     */
    public void setLongChainBase(int min, int max) throws Exception
    {
        cp_agg.setLongChainBase(min, max);
    }

    /**
     * g̗\ɗp鎉b_go^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     */
    public void setFattyAcid(int min, int max, int bond) throws Exception
    {
        cp_agg.setFattyAcid(min, max, bond);
    }

    /**
     * g̗\ɗpZ~hgo^܂D
     * @param ceramide Z~hg
     */
    public void setCeramide(java.util.List<String> ceramide) throws Exception
    {
        cp_agg.setCeramide(ceramide);
    }

    /**
     * g̗\ɗpZ~hgo^܂D
     * @param min Yf̍ŏl
     * @param max Yf̍ől
     * @param bond b_̓d̍ől
     */
    public void setCeramide(int min, int max, int bond)
    {
        cp_agg.setCeramide(min, max, bond);
    }

    /**
     * \ōle̓w肵܂D
     * @param str w肷铜
     * @param max w肷铜
     */
    public void setMax(String str, int max) throws Exception
    { // ftHghex_max = 10, hexnac_max = 10, dhex_max = 10, dhexme_max = 0, pen_max = 0
        cp_agg.setMax(str, max);
    }

    /**
     * \ōle̓w肵܂D
     * @param str w肷铜
     * @param bl  𑶍݂邩w
     */
    public void setMax(String str, boolean bl) throws Exception
    {
        cp_agg.setMax(str, bl);
    }

    /**
     * \ꂽ\Ԃ܂D
     * @return XRAɗ\z\Ԃ܂D
     */
    public java.util.List<? extends Candidate> getPrediction() throws Exception
    {   // w肳ꂽ\𐶐܂D
        java.util.List<Composition> cps = getCandidateComposition();     // g쐬
        java.util.List<Glycan> candi = this.getCandidateGlycan2(cps);    // \𐶐CXgɊi[
        java.util.List<Candidate> al = this.toCandidateInstance2(candi); // GlycanCCandidatě\Ƃēo^
        Candidate.setFreq(this.getFreqency(al));                         // omvZC
                                                                         // CandidateNXstaticϐƂēo^
        Collections.sort(al, new Comparator<Candidate>()                 // XRAɃ\[g
        {
            public int compare(Candidate cp1, Candidate cp2)
            {
                double sub = 0.0; // XRA̍
                try
                {
                    double score1 = cp1.getScore();
                    double score2 = cp2.getScore();

                    if (score1 == score2)                        // XRA\́C򐔂̏Ȃ
                        sub = cp1.countLeaf() - cp2.countLeaf(); // itm[h̐Ȃj\ʂɕ\
                    else
                        sub = score2 - score1;
                    
                }
                catch (Exception e)
                {
                    System.err.println("Prediction.getPrediction(): score compare error");
                }

                return (int)(sub*1024); // x1024{ɏグ
            }
        }); // XRAɃ\[gsD

        return al;
    }

    /**
     * g𐶐CXgɊi[܂D
     */
    protected java.util.List<Composition> getCandidateComposition() throws Exception
    {
        java.util.List<Composition> cps; // lgi[郊Xg

        cp_agg.setComposition(known_cp);
        cp_agg.setGlycan(known_gc);
        cp_agg.setMsTolerance(tolerance_ms);

        if (precursor == 0.0)            // e}X̕qʂo^ĂȂꍇC
        {                                // tOgqʂ̍őlvZD
            cp_agg.setMass(masses_a);    // tOgm/zẑ܂ܓ͂D
            cps = cp_agg.getComposition();
        }
        else                                                              // e}X̕qʂo^Ăꍇ
        {
            cp_agg.setMass(precursor);
            java.util.List<Double> masses_a_li = new ArrayList<Double>(); // vJ[T}XPSDXyNg̐e}XƂ
            for (double temp : masses_a)                                  // 덷PSDXyNg̋e덷ȓ̏ꍇC
                if (temp < precursor - tolerance_psd)                     // Ce}Xm/zCm/z
                    masses_a_li.add(temp);                                // PSDtOgg\D

            double[] masses_a_temp = new double[masses_a_li.size()];      // XgƓ傫̔zpӂD
            Iterator<Double> it = masses_a_li.iterator();
            for (int i = 0; it.hasNext(); i++)                            // Xg̓ezɃRs[
                masses_a_temp[i] = it.next();

            cp_agg.setMass(masses_a_temp);                                // tOgm/zzƂē
            cps = cp_agg.getComposition();
        }

        return cps;
    }

    /**
     * \𐶐CXgɊi[܂DiVOXbhŁj
     */
    protected java.util.List<Glycan> getCandidateGlycan(java.util.List<Composition> cps) throws Exception
    {
        java.util.List<Glycan> candi = new ArrayList<Glycan>(); // \i[郊Xg
        Iterator<Composition> it = cps.iterator();
        for (int i = 1; it.hasNext() && flag; i++)              // vJ[T[}XƃtOg狁߂g
        {                                         
            Composition cp = it.next();                         // g擾

            percent = (int)(i * 99.0 / cps.size());             // %i񂾂i[i\邽99%j
            String messege = (int)(i*100.0/cps.size()) + "% Creating candidate structure... " + "[" + cp + "]";
            this.setChanged();                                  // ύXƂ𖾎D
            this.notifyObservers(messege);                      // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                // ύXꂽԂłȂƂ𖾎D

            CandidateTools ct = new CandidateTools();           // \𐶐邽߂ɃCX^X𐶐
            ct.setComposition(cp);                              // m\̓o^łsetGlycan()͏ς݁D
            ct.setGlycan(known_gc);                             // m\o^
            candi.addAll(ct.getGlycan());                       // \擾CSHashSetɊi[
        }

        if (!flag)                                              // fꂽꍇC
            candi.clear();                                      // GlycanCX^X̌\폜

        return candi;
    }

    /**
     * \𐶐CXgɊi[܂Di}`XbhŁj
     */
    protected java.util.List<Glycan> getCandidateGlycan2(java.util.List<Composition> cps) throws Exception
    {
        java.util.List<Glycan> candi = new ArrayList<Glycan>(); // \i[郊Xg
        Iterator<Composition> it = cps.iterator();
        for (int i = 1; it.hasNext() && flag; i++)              // vJ[T[}XƃtOg狁߂g
        {
            StringBuffer cp_messege = new StringBuffer();       // ݏ̓𕶎\ɂĊi[
            java.util.List<Composition> cp_thread = new ArrayList<Composition>(); // 1̏ŕvZ^XN
            for (int j = 0; j < 8 && it.hasNext(); j++)         // 8Xbh
            {
                Composition temp = it.next();                   // g擾
                cp_messege.append("[" + temp + "], ");
                cp_thread.add(temp);                            // }`Xbh̃^XNɒǉ

                i++;                                            // ς݂̌𑝉D
            }
            i--;                                                // for̒Œl1Ȃ邽߁C폜

            percent = (int)(i * 99.0 / cps.size());             // %i񂾂i[i\邽99%j
            String messege = (int)(i*100.0/cps.size())
                           + "% Creating candidate structures. "
                           + cp_messege.toString();
            this.setChanged();                                  // ύXƂ𖾎D
            this.notifyObservers(messege);                      // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                // ύXꂽԂłȂƂ𖾎D

            java.util.List<Callable<java.util.List<Glycan>>> tasks
             = new ArrayList<Callable<java.util.List<Glycan>>>();  // ^XNi[郊Xg
            for (Composition temp : cp_thread)
            {
                Callable<java.util.List<Glycan>> task
                 = new MultiThreadTool2(new Composition(temp), new Glycan(known_gc));
                tasks.add(task);
            }
            ExecutorService es = Executors.newFixedThreadPool(8); // 8XbhŎs
            java.util.List<Future<java.util.List<Glycan>>> futures = es.invokeAll(tasks); // ^XN̎s

            for (Future<java.util.List<Glycan>> future : futures) // sʂ̉
                candi.addAll(future.get());                       // \擾CSHashSetɊi[
            es.shutdown();                                        // 񏈗̏I
        }

        if (!flag)                                                // fꂽꍇC
            candi.clear();                                        // GlycanCX^X̌\폜

        return candi;
    }

    /**
     * GlycanCX^XCCandidateCX^XƂCtOgs܂DiVOXbhŁj
     */
    protected java.util.List<Candidate> toCandidateInstance(java.util.List<Glycan> candi) throws Exception
    {
        java.util.List<Candidate> al = new ArrayList<Candidate>(); // XRAts\
        long start = new Date().getTime();                         // vOJn
        int candi_size = candi.size();                             // \i[
        ListIterator<Glycan> it2 = candi.listIterator();           // \̃Ce[^擾
        for (int i = 1; it2.hasNext() && flag; i++)                // lĝƂ蓾\ArrayListɊi[
        {
            Glycan temp = it2.next();
            it2.remove();                                          // sKvłGlycanCX^X폜D

            percent = (int)(i * 99.0 / candi_size);                // %i񂾂i[i\邽99%j
            String messege = progress(i, candi_size, start);       // IuU[oɑ郁bZ[W쐬D
            try
            {
                messege = messege + " [" + temp.toNormalFormat() + "]"; // m[}̃tH[}bgŊi[D
            }
            catch (Exception e)
            {
                messege = messege + " [" + temp.toString() + "]";  // 񕪊ȏ̍\Linucs`Ŋi[D
            }
            this.setChanged();                                     // ύXƂ𖾎D
            this.notifyObservers(messege);                         // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                   // ύXꂽԂłȂƂ𖾎D

            Candidate cd = new Candidate(temp);
            al.add(cd);
        }

        if (!flag)                                                 // fꂽꍇC
            al.clear();                                            // CandidateCX^X̌\폜
        else                                                       // ɊꍇC
        {
            percent = 100;                                         // ProgressMonitorI邽߂100%ɂD
            this.setChanged();                                     // ύXƂ𖾎D
            this.notifyObservers(progress(candi.size(), candi.size(), start)); // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                   // ύXꂽԂłȂƂ𖾎D
        }

        return al;
    }

    /**
     * GlycanCX^XCCandidateCX^XƂCtOgs܂Di}`XbhŁj
     */
    protected java.util.List<Candidate> toCandidateInstance2(java.util.List<Glycan> candi) throws Exception
    {
        java.util.List<Candidate> al = new ArrayList<Candidate>();   // XRAts\
        long start = new Date().getTime();                           // vOJn
        int candi_size = candi.size();                               // \i[
        ListIterator<Glycan> it2 = candi.listIterator();             // \̃Ce[^擾
        for (int i = 1; it2.hasNext() && flag; i++)                  // lĝƂ蓾\ArrayListɊi[D
        {
            StringBuffer gc_messege = new StringBuffer();            // ݏ̓𕶎\ɂĊi[D
            java.util.List<Glycan> gc_thread = new ArrayList<Glycan>(); // 1̏ŕvZGlycanCX^X
            for (int j = 0; j < 8 && it2.hasNext(); j++)             // 8Xbh񂳂̂ŁC8D
            {
                Glycan temp = it2.next();
                try
                {
                    gc_messege.append(temp.toNormalFormat() + ", "); // m[}̃tH[}bgŊi[D
                }
                catch (Exception e)
                {
                    gc_messege.append(temp.toString() + ", ");       // 񕪊ȏ̍\Linucs`Ŋi[D
                }
                gc_thread.add(temp);                                 // }`Xbh̃^XNɒǉ
                it2.remove();                                        // sKvłGlycanCX^X폜D

                i++;                                                 // ς݂̌𑝉D
            }
            i--;                                                     // for̒Œl1Ȃ邽߁C폜

            percent = (int)(i * 99.0 / candi_size);                  // %i񂾂i[i\邽99%j
            String messege = progress(i, candi_size, start);         // IuU[oɑ郁bZ[W
            messege = messege + " " + gc_messege.toString();
            this.setChanged();                                       // ύXƂ𖾎D
            this.notifyObservers(messege);                           // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                     // ύXꂽԂłȂƂ𖾎D

            java.util.List<Callable<Candidate>> tasks = new ArrayList<Callable<Candidate>>(); // ^XNi[郊Xg
            for (Glycan temp : gc_thread)
            {
                Callable<Candidate> task = new MultiThreadTool1(new Glycan(temp));
                tasks.add(task);
            }
            ExecutorService es = Executors.newFixedThreadPool(8);    // 8XbhŎs
            java.util.List<Future<Candidate>> futures = es.invokeAll(tasks); // ^XN̎s

            for (Future<Candidate> future : futures)                 // sʂ̉
            {
                Candidate cd = future.get();
                al.add(cd);
            }
            es.shutdown();                                           // 񏈗̏I
        }

        if (!flag)                                                   // fꂽꍇC
            al.clear();                                              // CandidateCX^X̌\폜
        else                                                         // ɊꍇC
        {
            percent = 100;                                           // ProgressMonitorI邽߂100%ɂD
            this.setChanged();                                       // ύXƂ𖾎D
            this.notifyObservers(progress(candi.size(), candi.size(), start)); // Ď҂ɐis󋵂ʒm
            this.clearChanged();                                     // ύXꂽԂłȂƂ𖾎D
        }

        return al;
    }

    /**
     * tOg̏om̌vZlԂ܂D
     */
    public double[] getFreqency(java.util.List<? extends Candidate> al) throws Exception
    {
        double[] freq;                                                    // returnmz

        if (precursor == 0.0)                                             // e}X̕qʂo^ĂȂꍇC
        {                                                                 // tOgqʂ̍őlvZ
            Arrays.sort(masses_a);                                        // őlo߂ɏɃ\[gD
            freq = new double[(int)(masses_a[masses_a.length-1]/this.getWindowSize())+100]; // 10DaopxvZ
        }
        else                                                              // e}X̕qʂo^Ăꍇ
            freq = new double[(int)(precursor/this.getWindowSize())+100]; // 10DaopxvZD

        for (Candidate cd : al)
        {
            boolean[] check = new boolean[freq.length];                      // 1\ŎʂdȂ߂Ɏgp

            double[] masses = cd.getFragMasses();
            for (int i = 0; i < masses.length; i++)                          // ꂼ̃tOg擾C
            {                                                                // tOg݂trueƂD
                if ((int)(masses[i]/this.getWindowSize()) > 0)
                    check[(int)(masses[i]/this.getWindowSize()) - 1] = true; // ÕtbO𗧂ĂD

                check[(int)(masses[i]/this.getWindowSize())] = true;         // ݂̈ʒũtbO𗧂ĂD

                if (i+1 < freq.length)
                    check[(int)(masses[i]/this.getWindowSize()) + 1] = true; // ̃tbOĂD
            }

            for (int i = 0; i < freq.length; i++)                            // tbOom̔zփRs[
                if (check[i])                                                // tOg݂1
                    freq[i] += 1.0;
        }

        double max = 1.0;                                                    // 0ŊȂ߂ɏl1ƂD
        for (double temp : freq)                                             // őlTD
            max = Math.max(temp,max);

        for (int i = 0; i < freq.length; i++)                                // őlŊC0.0`1.0͈̔͂ɕϊD
            freq[i] = freq[i] / max;

        return freq;
    }

    /**
     * i̕\
     * @parm prog ̏I
     * @parm total 
     * @parm strat Jn
     */
    protected String progress(int prog, int total, long start)
    {
        Calendar cd;
        StringBuilder temp = new StringBuilder(64); // ^[镶

        if (total != 0)                             // 0ŊȂ߂̏
            temp.append((int)(prog*100/total));
        else
            temp.append("100");
        temp.append("%");

        cd = Calendar.getInstance();
        cd.set(Calendar.DAY_OF_YEAR, 1);
        cd.set(Calendar.HOUR_OF_DAY, 0);
        cd.set(Calendar.MINUTE, 0);
        cd.set(Calendar.SECOND, 0);
        if (prog != 0)                              // 0ŊȂ߂̏
            cd.set(Calendar.MILLISECOND, (int)((new Date().getTime() - start)*(total-prog)/prog));
        else
            cd.set(Calendar.MILLISECOND, 0);
        temp.append(" Remain: ");
        temp.append(cd.get(Calendar.DAY_OF_YEAR)-1);
        temp.append(":");
        temp.append(new SimpleDateFormat("HH:mm:ss").format(cd.getTime()));

        cd = Calendar.getInstance();
        cd.set(Calendar.DAY_OF_YEAR, 1);
        cd.set(Calendar.HOUR_OF_DAY, 0);
        cd.set(Calendar.MINUTE, 0);
        cd.set(Calendar.SECOND, 0);
        cd.set(Calendar.MILLISECOND, (int)(new Date().getTime() - start));
        temp.append(" Current: ");
        temp.append(cd.get(Calendar.DAY_OF_YEAR)-1);
        temp.append(":");
        temp.append(new SimpleDateFormat("HH:mm:ss").format(cd.getTime()));

        cd = Calendar.getInstance();
        cd.set(Calendar.DAY_OF_YEAR, 1);
        cd.set(Calendar.HOUR_OF_DAY, 0);
        cd.set(Calendar.MINUTE, 0);
        cd.set(Calendar.SECOND, 0);
        if (prog != 0)                              // 0ŊȂ߂̏
            cd.set(Calendar.MILLISECOND, (int)((new Date().getTime() - start)*(total)/prog));
        else
            cd.set(Calendar.MILLISECOND, 0);
        temp.append(" Total: ");
        temp.append(cd.get(Calendar.DAY_OF_YEAR)-1);
        temp.append(":");
        temp.append(new SimpleDateFormat("HH:mm:ss").format(cd.getTime()));

        return temp.toString();
    }

    /**
     * _lɂ錟؁iʏo͗p\bhj
     * @parm args ؂n߂\m/z
     */
    private static void runSimulation(double args) throws Exception
    {
        System.out.println("Da,\tIflag,\t_flag,\t\,\t\,\to͏,\tXRA\,\t\,\tXRA,\t"
                         + "im[h-1j,\t\(msec),\t\,\tgp,\tq,\t\");
        CompositionTools ci = new CompositionTools();
        for (double d = args; ; d++)                   // w肵qʂV~[VsD
        {
            ci.setMass(d);
            ci.setGlycan(new Glycan("[][hex]{}"));
            java.util.List<String> ceramide = new ArrayList<String>();
            ceramide.add("dc34:1");
            ci.setCeramide(ceramide);                  // Z~hg"dc34:1"݂̂ƂD
            ci.setMax("pen",     0);                   // ȅ܂w
            ci.setMax("dhex",   10);
            ci.setMax("dhexme",  0);
            ci.setMax("hex",    10);
            ci.setMax("hexnac", 10);
            ci.setMsTolerance(0.5);
            for (Composition cp : ci.getComposition()) // e}Xg\
            {
                CandidateTools ct = new CandidateTools();
                ct.setGlycan(new Glycan("[][hex]{}"));
                ct.setComposition(cp);
                for (Glycan gc : ct.getGlycan())      // g猟؍\𐶐
                {
                    java.util.List<Composition> li = gc.getCompositionFragment() ; // ؍\̃tOg𓾂D
                    
                    double[] masses = new double[li.size()]; // ؍\̑SẴtOgqʂi[D
                    int i = 0;
                    for (Composition frags : li)             // tOgg̃Xg番qʂ̃Xgɕϊ
                    {
                        masses[i] = frags.getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);
                        i++;
                    }

                    System.out.print(d + "\t");              // Da\D
                    System.out.print(masses.length + "\t" + li.size() + "\t"); // tOg\
                    runPrediction(masses, gc);               // ^ꂽtOgqʂ\\
                }
            }
        }
    }

    /**
     * _lɂ錟؁iʏo͗p\bhj
     * @parm args ؂n߂\m/z
     * @parm percent ؍\̉%̃tOg_ɑI邩w
     */
    private static void runSimulation(double args, double percent) throws Exception
    {
        System.out.println("Da,\tIflag,\t_flag,\t\,\t\,\to͏,\t"
                         + "XRA\,\t\,\tXRA,\tim[h-1j,\t"
                         + "\(msec),\t\,\tgp,\tq,\t\");
        CompositionTools ci = new CompositionTools();
        for (double d = args; ; d++)                   // w肵qʂV~[VsD
        {
            ci.setMass(d);
            ci.setGlycan(new Glycan("[][hex]{}"));
            java.util.List<String> ceramide = new ArrayList<String>();
            ceramide.add("dc34:1");
            ci.setCeramide(ceramide);                  // Z~hg"dc34:1"݂̂ƂD
            ci.setMax("pen",     0);                   // ȅ܂w
            ci.setMax("dhex",   10);
            ci.setMax("dhexme",  0);
            ci.setMax("hex",    10);
            ci.setMax("hexnac", 10);
            ci.setMsTolerance(0.5);
            for (Composition cp : ci.getComposition()) // e}Xg\
            {
                CandidateTools ct = new CandidateTools();
                ct.setGlycan(new Glycan("[][hex]{}"));
                ct.setComposition(cp);
                for (Glycan gc : ct.getGlycan())       // g猟؍\𐶐
                {
                    java.util.List<Composition> li = gc.getCompositionFragment() ; // ؍\̃tOg𓾂D

                    double[] masses = new double[(int)((li.size()-1)*percent/100.0)+1];
                                                       // vJ[T[}X͕KID
                    masses[0] = li.remove(li.size()-1).getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);

                    int i = 1;                         // ɃvJ[T[}Xo^Ă̂ŁC1X^[g
                    while (i < masses.length)          // qʂi[z񂪈tɂȂ܂ŌJԂD
                    {                                  // _ɃtOgI
                        int index = (int)(Math.random() * (li.size()-2));
                        masses[i] = li.remove(index).getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);
                        i++;
                    }

                    for (int j = 1; j < masses.length; j++)            // masses[0]vJ[T[}Xł邩ǂ
                        if (masses[j] > masses[0])                     // imasses[0]傫m/z݂ĂȂj
                        {
                            throw new Exception("Fragment selection error: " // Ô߃`FbND
                             + masses[0] + " is not precursor mass.");
                        }

                    System.out.print(d + "\t");                                                // Da\
                    System.out.print(masses.length + "\t" + (li.size()+masses.length) + "\t"); // tOg\
                    runPrediction(masses, gc);                        // ^ꂽtOgʂ
                }                                                     // \\
            }
        }
    }

    /**
     * _lɂ錟؁iʏo͗p\bhj
     * @parm args ؂n߂\m/z
     */
    private static void runNoiseSimulation(double args) throws Exception
    {
        System.out.println("1,\t2,\tDa,\tIflag,\t_flag,\tmCYflag,\t\,\t"
                         + "\,\to͏,\tXRA\,\t\,\tXRA,\tim[h-1j,\t"
                         + "\(msec),\t\,\tgp,\tq,\t\");

        int[] percent = {100, 90, 80, 70, 60, 50, 40, 30, 20, 10}; // ؍\̉%̃tOgI邩w
        int[] noise = {2048, 1024, 512, 256, 128, 64, 32, 16, 8};  // DaƂ1{̃mCY݂邩w

        for (double d = args; ; d++)                               // w肵qʂV~[VsD
        for (int m = 0; m < percent.length; m++)
        for (int n = 0; n < noise.length; n++)
        {
            CompositionTools ci = new CompositionTools();
            ci.setMass(d);
            ci.setGlycan(new Glycan("[][hex]{}"));
            java.util.List<String> ceramide = new ArrayList<String>();
            ceramide.add("dc34:1");
            ci.setCeramide(ceramide);                  // Z~hg"dc34:1"݂̂ƂD
            ci.setMax("pen",     0);                   // ȅ܂w
            ci.setMax("dhex",   10);
            ci.setMax("dhexme",  0);
            ci.setMax("hex",    10);
            ci.setMax("hexnac", 10);
            ci.setMsTolerance(0.5);
            for (Composition cp : ci.getComposition()) // e}Xg\
            {
                CandidateTools ct = new CandidateTools();
                ct.setGlycan(new Glycan("[][hex]{}"));
                ct.setComposition(cp);
                for (Glycan gc : ct.getGlycan())       // g猟؍\𐶐
                {
                    java.util.List<Composition> li = gc.getCompositionFragment() ; // ؍\̃tOg𓾂D
                                                       // ؍\50%̃tOgqʂi[D
                    double[] masses = new double[(int)((li.size()-1)*percent[m]/100.0)+1];
                                                       // vJ[T[}X͕KID
                    masses[0] = li.remove(li.size()-1).getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);

                    int i = 1;                         // ɃvJ[T[}Xo^Ă̂ŁC1X^[g
                    while (i < masses.length)          // qʂi[z񂪈tɂȂ܂ŌJԂD
                    {                                  // _ɃtOgI
                        int index = (int)(Math.random() * (li.size()-2));
                        masses[i] = li.remove(index).getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);
                        i++;
                    }

                    // mCY}
                    double mass = gc.getMass(MassCalc.MONO_MASS, MassCalc.Na_ION);
                    int noise_count = (int)(mass / noise[n]);                        // mCY
                    double[] noise_masses = new double[masses.length + noise_count]; // mCYtOgĒ`
                    for (int j = 0; j < masses.length; j++)                          // mCY}OtOgRs[
                        noise_masses[j] = masses[j];
                    for (int j = masses.length; j < noise_masses.length; j++)        // mCYǉ
                        noise_masses[j] = Math.random() * mass;

                    for (int j = 1; j < masses.length; j++)              // masses[0]vJ[T[}Xł邩ǂ
                        if (masses[j] > masses[0])                       // imasses[0]傫m/z݂ĂȂj
                            throw new Exception("Fragment selection error: " // Ô߃`FbND
                             + masses[0] + " is not precursor mass.");

                    System.out.print(percent[m] + "\t" + noise[n] + "\t");   // \\D
                    System.out.print(d + "\t");                              // Da\D
                    System.out.print(masses.length + "\t" + (li.size()+masses.length) + "\t"); // tOg
                    System.out.print(noise_count + "\t");                    // mCYtOg
                    runPrediction(noise_masses, gc);                         // ^ꂽtOgqʂ
                }                                                            // \\
            }
        }
    }

    /**
     * ^ꂽtOg̎ʂ\\C̓vo͂܂D
     * @parm masses \ɗptOgq
     * @parm gc \
     */
    private static void runPrediction(double[] masses, Glycan gc) throws Exception
    {
        /**/long start = new Date().getTime(); // Jn

        Prediction pd = new Prediction();      // \
        pd.setFragments(masses);               // tOg̎l̔zo^
        pd.setMsTolerance(0.5);                // e덷i[
        pd.setGlycan(new Glycan("[][hex]{}")); // m\o^
        pd.setCeramide(30,44,0);               // Z~hg͒Yf30-44ƂD
        pd.setMax("pen",     0);               // ȅ܂w
        pd.setMax("dhex",   10);
        pd.setMax("dhexme",  0);
        pd.setMax("hex",    10);
        pd.setMax("hexnac", 10);
        pd.setScoringFormula(Candidate.TFIDF_SCORING);

        Iterator<? extends Candidate> it = pd.getPrediction().iterator(); // ʂ\
        boolean success = false;               // \ۂi[D
        boolean flag = true;                   // while𔲂̂ɗpD
        int rank = 0, count = 0;               // \ʂƌ\
        int rank2 = 0, same_score = 1; 
        double score = 0.0, previous_score = 0.0;
        while (it.hasNext())
        {
            Candidate cd = it.next();

            if (flag)                          // ܂͍\ȂꍇC\ʂ̒lXV
                rank++;

            if (previous_score != cd.getScore() && flag) // ÕXRAƈقȂꍇ
            {
                rank2++;                                 // ND
                same_score = 1;                          // NA
            }

            // ÕXRAƓXRAłꍇCm܂͍\ȂꍇC܂͓͍\ƓXRAłꍇn
            if (previous_score == cd.getScore() && (flag || score == cd.getScore()))
                same_score++;

            if (new Glycan(cd.toString()).equals(gc)) // ͍\݂ꍇ
            {
                success = true;                       // \ɐ
                score = cd.getScore();                // XRA̒lۑ
                flag = false;
            }

            previous_score = cd.getScore();           // XRA̒lۑ
            count++;                                  // \
        }

        /**/long end = new Date().getTime();          // I
        /**/long time = end - start;                  // Ԃ\
        Calendar cd = Calendar.getInstance();
        cd.set(Calendar.DAY_OF_YEAR, 1);
        cd.set(Calendar.HOUR_OF_DAY, 0);
        cd.set(Calendar.MINUTE, 0);
        cd.set(Calendar.SECOND, 0);
        cd.set(Calendar.MILLISECOND, (int)(new Date().getTime() - start));

        MemoryMXBean mm = ManagementFactory.getMemoryMXBean();
        MemoryUsage mu = mm.getHeapMemoryUsage();

        // \ہC\ʁCo͏ʁCXRA\C\CXRA
        // im[h-1jC\(msec)C\ԁCgpʁCqʁC\
        System.out.println(success
                             + "\t" + rank2 + "\t" + rank
                             + "\t" + same_score + "\t" + count
                             + "\t" + String.format("%.4f", score)
                             + "\t" + (gc.size()-1)
                             + "\t" + time
                             + "\t" + new SimpleDateFormat("HH:mm:ss").format(cd.getTime())
                             + "\t" + String.format("%.1f/", mu.getUsed() / 1024.0 / 1024)
                             + String.format("%.1fMB", mu.getMax() / 1024.0 / 1024)
                             + "\t" + String.format("%.4f", gc.getMass(MassCalc.MONO_MASS, MassCalc.Na_ION))
                             + "\t" + gc.toNormalFormat());
        it.hasNext(); // ̍s܂łɌ\ɂgpς݃Ȃ߂Ɏs
        System.gc();  // K[xWRN^ɂ郁̉
    }

    /**
     * V̍\\
     */
    private static void runFreeGlycanTest() throws Exception
    {                                             // HexNAc-HexNAc-HexNAc-HexNAc-HexNAc̎tOg
        double[] masses = {227.1, 346.3, 429.3, 447.1, 548.5, 631.4, 649.3, 833.8, 851.7, 1054.2};
        Prediction pd = new Prediction();         // \
        pd.setPrecursorMass(1056.4008);
        pd.setMsTolerance(0.5);                   // e덷i[
        pd.setFragments(masses);                  // tOg̎l̔zo^
        pd.setPsdTolerance(1.0);
        pd.setGlycan(new Glycan("[][hexnac]{}")); // m\o^
        pd.setMax("pen",    false);               // ȅ܂w
        pd.setMax("dhex",   false);
        pd.setMax("dhexme", false);
        pd.setMax("hex",    false);
        pd.setMax("hexnac", true);
        pd.setScoringFormula(Candidate.TFIDF_SCORING);

        for (Candidate cd : pd.getPrediction())
            System.out.println(cd);
    }
}

class MultiThreadTool1 implements Callable<Candidate>
{
    Glycan gc;                    // 񏈗̂߂ɕۑĂ\

    public MultiThreadTool1(Glycan gc) throws Exception
    {
        this.gc = gc;             // \o^
    }

    public Candidate call() throws Exception
    {
        return new Candidate(gc); // tOg̕qʂ̌vZς݂̌\ԂD
    }
}

class MultiThreadTool2 implements Callable<java.util.List<Glycan>>
{
    Composition cp;               // 񏈗̂߂ɕۑĂg
    Glycan known_gc;

    public MultiThreadTool2(Composition cp, Glycan known_gc) throws Exception
    {
        this.cp = cp;
        this.known_gc = known_gc;
    }

    public java.util.List<Glycan> call() throws Exception
    {
        CandidateTools ct = new CandidateTools(); // \𐶐邽߂ɃCX^X𐶐
        ct.setComposition(cp);                    // m\̓o^łsetGlycan()͏ς݁D
        ct.setGlycan(known_gc);                   // m\o^

        return ct.getGlycan();
    }
}
