package jp.ac.ritsumei.is.infobio;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import javax.swing.table.*;
import java.util.concurrent.*;
import java.lang.management.*;

/**
 * `KOIVh̃tOgCI\\NXłDiGUIŁj
 * @author m
 * @version 20081122
 */
public class PredictionGUIGa extends PredictionGUI
{
    PredictionGUIGa() throws Exception
    {
        super();
        jf.setTitle("Structure Predictor (ganglioside ver)"); // ^Cg̕ύX
    }

    /*
     * l͂镔JPanel擾܂D
     */
    protected JPanel getInputJPanel()
    {
        JPanel west_center = new JPanel();         // l͕
        west_center.setLayout(new BorderLayout()); // EBhEWESTɓ\tplCENTERiEBhE̍j
        west_center.add(new JLabel("Fragment mass (permethylated):"), BorderLayout.NORTH);
                                                   // `GM1̃tOg
        query_ta = new JTextArea("111.1\n154.0\n228.2\n259.5\n306.2\n343.8\n365.9\n375.8\n397.8\n415.7\n434.7\n"
                               + "457.6\n463.6\n486.6\n575.5\n588.2\n604.8\n675.8\n778.6\n794.4\n810.6\n819.5\n"
                               + "834.4\n848.9\n866.3\n898.2\n1009.4\n1023.7\n1039.7\n1241.6\n1257.7\n1273.6\n"
                               + "1385.3\n1400.4\n1414.8\n1474.0\n1488.1\n1502.7\n1862.6\n1877.2");
        west_center.add(new JScrollPane(query_ta), BorderLayout.CENTER); // JTextAreaփXN[o[D

        return west_center;
    }

    /*
     * Iȗ\ݒ肷镔JPanel擾܂D
     */
    protected JPanel getExperimentalConditionJPanel()
    {
        JPanel west_south_north = new JPanel(); // \͕ EBhEWESTɓ\tplSOUTH
                                                // EBhE̍
                                                // JComboBox̏Iڂw肷D
        pen_cb.setSelectedItem("No");           // PeñftHg"No"
        dhex_cb.setSelectedItem("Yes");         // dHex̃ftHg"Yes"
        hex_cb.setSelectedItem("Yes");          // Hex̃ftHg"Yes"
        hexnac_cb.setSelectedItem("Yes");       // HexNAc̃ftHg"Yes"
        penme_cb.setSelectedItem("No");         // PenMẽftHg"No"
        dhexme_cb.setSelectedItem("No");        // dHexMẽftHg"No"
        hexme_cb.setSelectedItem("No");         // HexMẽftHg"No"
        hexnacme_cb.setSelectedItem("No");      // HexNAcMẽftHg"No"

        formula_cb.setSelectedItem("TFIDF");    // XRAvZ̃ftHg"TFIDF"

        west_south_north.setLayout(new GridLayout(12, 2)); // c̐~̐
        west_south_north.add(new JLabel("Fragment tolerance: "));
        west_south_north.add(psd_tolerance_tf);
        west_south_north.add(new JLabel("Permethylated mass: "));
        precursor_mass_tf = new JTextField("1877.1972");   // `̐e}Xo^(GM1)
        west_south_north.add(precursor_mass_tf);
        west_south_north.add(new JLabel("Precursor tolerance: "));
        west_south_north.add(precursor_tolerance_tf);
        west_south_north.add(new JLabel("Adduct ion: "));
        west_south_north.add(adduct_cb);
        west_south_north.add(new JLabel("Pen: "));
        west_south_north.add(pen_cb);
        west_south_north.add(new JLabel("dHex: "));
        west_south_north.add(dhex_cb);
        west_south_north.add(new JLabel("Hex: "));
        west_south_north.add(hex_cb);
        west_south_north.add(new JLabel("HexNAc: "));
        west_south_north.add(hexnac_cb);
        west_south_north.add(new JLabel("PenMe: "));
        west_south_north.add(penme_cb);
        west_south_north.add(new JLabel("dHexMe: "));
        west_south_north.add(dhexme_cb);
        west_south_north.add(new JLabel("HexMe: "));
        west_south_north.add(hexme_cb);
        west_south_north.add(new JLabel("HexNAcMe: "));
        west_south_north.add(hexnacme_cb);

        return west_south_north;
    }

    /*
     * StartNbNɎsXbh
     */
    public void run()
    {
        System.out.println("PredictionGa mode...");
        try
        {
            PredictionGa pd_agg = new PredictionGa();                // p̑ɏWpD
            pd_agg.addObserver(this);                                // is󋵂̃NX֓`邽߂ɁC
                                                                     // ̃NXIuU[oƂD
                                                                     // eLXgGAl擾
            String[] strs = query_ta.getText().split("[^\\.\\d]");   // '.'ƐȊO̕Ő؂oD
            java.util.List<Double> massli = new ArrayList<Double>(); // ϒzpӂD
            for (String str : strs)
            {
                try
                {
                    massli.add(Double.parseDouble(str));
                }
                catch (Exception e)                                  // ȊO̕Ăꍇ̎C
                {                                                    // Ƃ
                    System.err.println(e);
                }
            }
            double[] frags = new double[massli.size()];              // ListƓ傫̔zp
            Iterator<Double> massit = massli.iterator();
            for (int i = 0; massit.hasNext(); i++)                   // double[]^frags֔ž^ϊ
                frags[i] = massit.next();
            pd_agg.setFragments(frags);                              // tOg̎l̔zo^

            try                                                      // vJ[T[}Xo^
            {
                pd_agg.setPrecursorMass(Double.parseDouble(precursor_mass_tf.getText()));
            }
            catch (Exception e)                                      // vJ[T[}Xo^ȂꍇC
            {                                                        // PSDtOg̍ől
                System.err.println("Precursor mass is null.");       // vJ[T[}XƂČvZ
            }

            try                                                      // vJ[T[}X̋e덷o^
            {
                pd_agg.setMsTolerance(Double.parseDouble(precursor_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'Precursor tolerance' contains error.\n" + e);
            }

            try                                                      // PSDtOg̋e덷o^
            {
                pd_agg.setPsdTolerance(Double.parseDouble(psd_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'PSD tolerance' contains error.\n" + e);
            }

            try                                                      // tCIo^
            {                                                        // IꂽtCI擾D
                String temp = (String)adduct_cb.getSelectedItem();   // \̕m/z擾̂ɕKvȂ߁C
                if (temp.equals("Na+"))                              // adduct̓O[oϐƂĂD
                    adduct = MassCalc.Na_ION;
                else if (temp.equals("H+"))
                    adduct = MassCalc.H_ION;
                else if (temp.equals("Li+"))
                    adduct = MassCalc.Li_ION;
                else if (temp.equals("K+"))
                    adduct = MassCalc.K_ION;
                else if (temp.equals("H-"))
                    adduct = MassCalc.H_NION;
                else if (temp.equals("no adduct"))
                    adduct = "";
                else
                    throw new Exception(temp + " is unknown adduct ion.");

                pd_agg.setAdduct(adduct);
            }
            catch (Exception e)
            {
                throw new Exception("'Adduct ion' contains error.\n" + e);
            }

            try                                                      // m\o^
            {
                pd_agg.setGlycan(new Glycan(known_gc_tf.getText())); // Linucs`m\o^
            }
            catch (Exception e1)                                     // Linucs`̓ǂݍ݂ɎsꍇC
            {                                                        // m[}`̓ǂݍ݂D
                try
                {
                    GlycanTools gi = new GlycanTools();
                    pd_agg.setGlycan(gi.readNormalFormat(known_gc_tf.getText())); // m\o^
                }
                catch (Exception e2)
                {
                    throw new Exception("'Known structure' contains error.\n" + e1 + e2);
                }
            }

            try                                                      // e̍ő吔o^
            {
                pd_agg.setMax("pen",    ((String)pen_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhex",   ((String)dhex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hex",    ((String)hex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnac", ((String)hexnac_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("penme",    ((String)penme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhexme",   ((String)dhexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexme",    ((String)hexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnacme", ((String)hexnacme_cb.getSelectedItem()).equals("Yes"));

                pd_agg.setMax("neuac",  true);                       // KOIVh̗\Ȃ̂NeuAcw
            }
            catch (Exception e)
            {
                throw new Exception("'max' contains error.\n" + e);
            }

            try                                                            // Z~hgo^
            {
                java.util.List<String> ceramide = new ArrayList<String>(); // m̒gi[D
                java.util.List<String> lcb     = new ArrayList<String>();  // m̒gi[D
                java.util.List<String> fa      = new ArrayList<String>();  // m̎b_gi[D

                for (String str : ceramide_tf.getText().split("[^\\w:-]")) // P\':','-'ȊO̕ŕ
                    if (str.matches("^[dt][ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$"))  // Z~h̏ꍇ
                        ceramide.add(str);
                    else if (str.matches("^[dt][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ̏ꍇ
                        lcb.add(str);
                    else if (str.matches("^[ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // b_̏ꍇ
                        fa.add(str);

                pd_agg.setCeramide(ceramide);                                      // Z~hgo^
                pd_agg.setLongChainBase(lcb);                                      // go^
                pd_agg.setFattyAcid(fa);                                           // b_go^
            }
            catch (Exception e)
            {
                throw new Exception("'Ceramide' contains error.\n" + e);
            }

            try                                                     // XRAO̎o^
            {
                String temp = (String)formula_cb.getSelectedItem(); // IꂽXRAO̎擾D
                if (temp.equals("POSITIVE"))
                    pd_agg.setScoringFormula(Candidate.POSITIVE_SCORING);
                else if (temp.equals("TFIDF"))
                    pd_agg.setScoringFormula(Candidate.TFIDF_SCORING);
                else if (temp.equals("PENALTY01"))
                    pd_agg.setScoringFormula(Candidate.PENALTY01_SCORING);
                else if (temp.equals("PENALTY001"))
                    pd_agg.setScoringFormula(Candidate.PENALTY001_SCORING);
                else if (temp.equals("PMF"))
                    pd_agg.setScoringFormula(Candidate.PMF_SCORING);
                else if (temp.equals("GEOMETRICAVG"))
                    pd_agg.setScoringFormula(Candidate.GEOMETRICAVG_SCORING);
                else
                    throw new Exception(temp + " is unknown adduct ion.");
            }
            catch (Exception e)
            {
                throw new Exception("'Scoring' contains error.\n" + e);
            }

            try                                                     // omz̃EBhETCYo^
            {
                pd_agg.setWindowSize(1);
            }
            catch (Exception e)
            {
                throw new Exception("'Window size' contains error.\n" + e);
            }
                                                                    // o͕
            java.util.List<? extends Candidate> cds = pd_agg.getPrediction();
            Iterator<? extends Candidate> it = cds.iterator();
            DefaultTableModel tm = new DefaultTableModel(title, 0);
            for (int i = 0; i < 50 && it.hasNext(); i++)            // 50\
            {
                Candidate cd = it.next();

                String[] table = new String[4];                     // J̒ǉ́Cz̑傫ɒӂD
                table[0] = String.format("%.4f", cd.getScore());

                try
                {
                    table[1] = ((CandidateGa)cd).getIntactGlycan().toNormalFormat(); // m[}̃tH[}bgŊi[
                }
                catch (Exception e)
                {
                    table[1] = ((CandidateGa)cd).getIntactGlycan().toString();       // 񕪊ȏLinucs`Ŋi[
                }

                table[2] = String.format("%.4f", cd.getOccupancy());
                table[3] = String.format("%.4f", ((CandidateGa)cd).getIntactGlycan().getMass(monoavg, adduct));
                tm.addRow(table);
            }
            result_ta.setModel(tm);
            RowSorter<TableModel> rs = new TableRowSorter<TableModel>(tm);           // \[g\ȃe[uɂD
            result_ta.setRowSorter(rs);
            super.resetTableColumnSize();                                            // Jw肷D

            java.awt.Toolkit.getDefaultToolkit().beep();                             // I鎞Ƀr[v炷D

            UIManager.put("OptionPane.messageDialogTitle", "Messege");               // "^Cg"Messege"ɕύX
            UIManager.put("OptionPane.okButtonText", "OK");                          // ""̕"OK"ɕύX
            JOptionPane.showMessageDialog(jf, "Calclation is finished.\n" + pm.getNote() + "\n"
                                            + "Candidate structure: " + cds.size());
            start.setEnabled(true);                                                  // {^悤ɂD
            reset.setEnabled(true);
        }
        catch (Exception e)                                                          // ɗOꍇC
        {                                                                            // x\𒆒f
            JOptionPane.showMessageDialog(jf, "ERROR: " + e);
            e.printStackTrace();
            start.setEnabled(true);                                                  // {^悤ɂD
            reset.setEnabled(true);
        }
    }

    public static void main(String[] args) throws Exception
    {
        new PredictionGUIGa();
    }
}
