package jp.ac.ritsumei.is.infobio;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import javax.swing.table.*;
import java.util.concurrent.*;
import java.lang.management.*;

/**
 * `㓜̃tOgCI\\NXłDiGUIŁj
 * @author m
 * @version 20080129
 */
public class PredictionGUIMe extends PredictionGUI
{
    JTextField precursorme_mass_tf;                                               // `vJ[T[}Xm/z

    PredictionGUIMe() throws Exception
    {
        super();
        jf.setTitle("Structure Predictor (permethylated glycosphingolipid ver)"); // ^Cg̕ύX
    }

    /*
     * l͂镔JPanel擾܂D
     */
    protected JPanel getInputJPanel()
    {
        JPanel west_center = new JPanel();                               // l͕
        west_center.setLayout(new BorderLayout());                       // EBhEWESTɓ\tplCENTER
                                                                         //iEBhE̍j
        west_center.add(new JLabel("Fragment mass (permethylated):"), BorderLayout.NORTH);
                                                                         // `L5̃tOg
        query_ta = new JTextArea("111.2\n154.3\n196.6\n222.4\n228.4\n245.5\n260.3\n268.4\n282.5\n416.8\n"
                               + "432.9\n449.7\n513.6\n527.5\n545.4\n694.1\n772.7\n792.9\n947.1\n968.1\n"
                               + "977.6\n997.1\n1012.4\n1065.7\n1166.8\n1183.4\n1198.9\n1242.7\n1258.2\n"
                               + "1746.3\n1760.8");
        west_center.add(new JScrollPane(query_ta), BorderLayout.CENTER); // JTextAreaփXN[o[D

        return west_center;
    }

    /*
     * Iȗ\ݒ肷镔JPanel擾܂D
     */
    protected JPanel getExperimentalConditionJPanel()
    {
        JPanel west_south_north = new JPanel();            // \͕ EBhEWEST
                                                           // \tplSOUTHiEBhE̍j
                                                           // JComboBox̏Iڂw肷D
        pen_cb.setSelectedItem("No");                      // PeñftHg"No"
        dhex_cb.setSelectedItem("Yes");                    // dHex̃ftHg"Yes"
        hex_cb.setSelectedItem("Yes");                     // Hex̃ftHg"Yes"
        hexnac_cb.setSelectedItem("Yes");                  // HexNAc̃ftHg"Yes"

        penme_cb.setSelectedItem("No");                    // PenMẽftHg"No"
        dhexme_cb.setSelectedItem("No");                   // dHexMẽftHg"No"
        hexme_cb.setSelectedItem("No");                    // Hex̃ftHg"No"
        hexnacme_cb.setSelectedItem("No");                 // HexNAc̃ftHg"No"

        formula_cb.setSelectedItem("TFIDF");               // XRAvZ̃ftHg"TFIDF"

        west_south_north.setLayout(new GridLayout(13, 2)); // c̐~̐
        west_south_north.add(new JLabel("Fragment tolerance: "));
        west_south_north.add(psd_tolerance_tf);
        west_south_north.add(new JLabel("Intact mass (optional): "));
        precursor_mass_tf = new JTextField("1493.6327");   // `O̐e}Xo^(L5)
        west_south_north.add(precursor_mass_tf);
        west_south_north.add(new JLabel("Permethylated mass: "));
        precursorme_mass_tf = new JTextField("1746.0816"); // `̐e}Xo^(L5)
        west_south_north.add(precursorme_mass_tf);
        west_south_north.add(new JLabel("Precursor tolerance: "));
        west_south_north.add(precursor_tolerance_tf);
        west_south_north.add(new JLabel("Adduct ion: "));
        west_south_north.add(adduct_cb);
        west_south_north.add(new JLabel("Pen: "));
        west_south_north.add(pen_cb);
        west_south_north.add(new JLabel("dHex: "));
        west_south_north.add(dhex_cb);
        west_south_north.add(new JLabel("Hex: "));
        west_south_north.add(hex_cb);
        west_south_north.add(new JLabel("HexNAc: "));
        west_south_north.add(hexnac_cb);
        west_south_north.add(new JLabel("PenMe: "));
        west_south_north.add(penme_cb);
        west_south_north.add(new JLabel("dHexMe: "));
        west_south_north.add(dhexme_cb);
        west_south_north.add(new JLabel("HexMe: "));
        west_south_north.add(hexme_cb);
        west_south_north.add(new JLabel("HexNAcMe: "));
        west_south_north.add(hexnacme_cb);

        return west_south_north;
    }

    /*
     * StartNbNɎsXbh
     */
    public void run()
    {
        System.out.println("PredictionMe mode...");
        try
        {
            PredictionMe pd_agg = new PredictionMe();                // p̑ɏWpD
            pd_agg.addObserver(this);                                // is󋵂̃NX֓`邽߂ɁC
                                                                     // ̃NXIuU[oƂD
                                                                     // eLXgGAl擾
            String[] strs = query_ta.getText().split("[^\\.\\d]");   // '.'ƐȊO̕Ő؂oD
            java.util.List<Double> massli = new ArrayList<Double>();
            for (String str : strs)
            {
                try
                {
                    massli.add(Double.parseDouble(str));
                }
                catch (Exception e)                                  // ȊO̕Ăꍇ̎C
                {                                                    // Ƃ
                    System.err.println(e);
                }
            }
            double[] frags = new double[massli.size()];              // XgƓ傫̔zpӂD
            Iterator<Double> massit = massli.iterator();
            for (int i = 0; massit.hasNext(); i++)                   // double[]^frags֔ž^ϊ
                frags[i] = massit.next();
            pd_agg.setFragments(frags);                              // tOg̎l̔zo^

            try                                                      // vJ[T[}Xo^
            {
                pd_agg.setPrecursorMass(Double.parseDouble(precursor_mass_tf.getText()));
            }
            catch (Exception e)
            {
                System.err.println("Precursor mass is null.");
            }

            try                                                      // vJ[T[}Xo^
            {
                pd_agg.setPrecursorMeMass(Double.parseDouble(precursorme_mass_tf.getText()));
            }
            catch (Exception e)                                      // vJ[T[}Xo^ȂꍇC
            {                                                        // PSDtOg̍ől
                                                                     // vJ[T[}XƂČvZ
                System.err.println("Precursor mass of permethylated glycosphingolipid is null.");
            }

            try                                                      // vJ[T[}X̋e덷o^
            {
                pd_agg.setMsTolerance(Double.parseDouble(precursor_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'Precursor tolerance' contains error.\n" + e);
            }

            try                                                      // PSDtOg̋e덷o^
            {
                pd_agg.setPsdTolerance(Double.parseDouble(psd_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'PSD tolerance' contains error.\n" + e);
            }

            try                                                      // tCIo^
            {                                                        // IꂽtCI擾D
                String temp = (String)adduct_cb.getSelectedItem();   // \̕m/z擾̂ɕKvȂ߁C
                if (temp.equals("Na+"))                              // adduct̓O[oϐƂĂD
                    adduct = MassCalc.Na_ION;
                else if (temp.equals("H+"))
                    adduct = MassCalc.H_ION;
                else if (temp.equals("Li+"))
                    adduct = MassCalc.Li_ION;
                else if (temp.equals("K+"))
                    adduct = MassCalc.K_ION;
                else if (temp.equals("H-"))
                    adduct = MassCalc.H_NION;
                else if (temp.equals("No adduct"))
                    adduct = "";
                else
                    throw new Exception(temp + " is unknown adduct ion.");

                pd_agg.setAdduct(adduct);
            }
            catch (Exception e)
            {
                throw new Exception("'Adduct ion' contains error.\n" + e);
            }

            try                                                      // m\o^
            {
                pd_agg.setGlycan(new Glycan(known_gc_tf.getText())); // Linucs`m\o^
            }
            catch (Exception e1)                                     // Linucs`̓ǂݍ݂ɎsꍇC
            {                                                        // m[}`̓ǂݍ݂D
                try
                {
                    GlycanTools gi = new GlycanTools();
                    pd_agg.setGlycan(gi.readNormalFormat(known_gc_tf.getText())); // m\o^
                }
                catch (Exception e2)
                {
                    throw new Exception("'Known structure' contains error.\n" + e1 + e2);
                }
            }

            try                                                      // e̍ő吔o^
            {
                pd_agg.setMax("pen",    ((String)pen_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhex",   ((String)dhex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hex",    ((String)hex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnac", ((String)hexnac_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("penme",    ((String)penme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhexme",   ((String)dhexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexme",    ((String)hexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnacme", ((String)hexnacme_cb.getSelectedItem()).equals("Yes"));
            }
            catch (Exception e)
            {
                throw new Exception("'max' contains error.\n" + e);
            }

            try                                                            // Z~hgo^
            {
                java.util.List<String> ceramide = new ArrayList<String>(); // m̒gi[
                java.util.List<String> lcb     = new ArrayList<String>();  // m̒gi[
                java.util.List<String> fa      = new ArrayList<String>();  // m̎b_gi[

                for (String str : ceramide_tf.getText().split("[^\\w:-]")) // P\':','-'ȊO̕ŕ
                    if (str.matches("^[dt][ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$"))  // Z~h̏ꍇ
                        ceramide.add(str);
                    else if (str.matches("^[dt][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // ̏ꍇ
                        lcb.add(str);
                    else if (str.matches("^[ch][0-9]+(-[0-9]+)?:[0-9](-[0-9])?$")) // b_̏ꍇ
                        fa.add(str);

                pd_agg.setCeramide(ceramide);                                      // Z~hgo^
                pd_agg.setLongChainBase(lcb);                                      // go^
                pd_agg.setFattyAcid(fa);                                           // b_go^
            }
            catch (Exception e)
            {
                throw new Exception("'Ceramide' contains error.\n" + e);
            }

            try                                                                    // XRAO̎o^
            {
                String temp = (String)formula_cb.getSelectedItem();                // IꂽXRAO̎擾
                if (temp.equals("POSITIVE"))
                    pd_agg.setScoringFormula(Candidate.POSITIVE_SCORING);
                else if (temp.equals("TFIDF"))
                    pd_agg.setScoringFormula(Candidate.TFIDF_SCORING);
                else if (temp.equals("PENALTY01"))
                    pd_agg.setScoringFormula(Candidate.PENALTY01_SCORING);
                else if (temp.equals("PENALTY001"))
                    pd_agg.setScoringFormula(Candidate.PENALTY001_SCORING);
                else if (temp.equals("PMF"))
                    pd_agg.setScoringFormula(Candidate.PMF_SCORING);
                else if (temp.equals("GEOMETRICAVG"))
                    pd_agg.setScoringFormula(Candidate.GEOMETRICAVG_SCORING);
                else
                    throw new Exception(temp + " is unknown adduct ion.");
            }
            catch (Exception e)
            {
                throw new Exception("'Scoring' contains error.\n" + e);
            }

            try                                                             // omz̃EBhETCYo^
            {
                pd_agg.setWindowSize(1);
            }
            catch (Exception e)
            {
                throw new Exception("'Window size' contains error.\n" + e);
            }

                                                                           // o͕
            java.util.List<? extends Candidate> cds = pd_agg.getPrediction();
            Iterator<? extends Candidate> it = cds.iterator();
            DefaultTableModel tm = new DefaultTableModel(title, 0);
            for (int i = 0; i < 50 && it.hasNext(); i++)                   // 50\
            {
                Candidate cd = it.next();

                String[] table = new String[4];                            // J̒ǉ́Cz̑傫ɒ
                table[0] = String.format("%.4f", cd.getScore());

                try
                {
                    table[1] = ((CandidateMe)cd).getIntactGlycan().toNormalFormat(); // m[}̃tH[}bgŊi[
                }
                catch (Exception e)
                {
                    table[1] = ((CandidateMe)cd).getIntactGlycan().toString();       // 񕪊ȏLinucs`Ŋi[
                }

                table[2] = String.format("%.4f", cd.getOccupancy());
                table[3] = String.format("%.4f", ((CandidateMe)cd).getIntactGlycan().getMass(monoavg, adduct));
                tm.addRow(table);
            }
            result_ta.setModel(tm);
            RowSorter<TableModel> rs = new TableRowSorter<TableModel>(tm); // \[g\ȃe[uɂD
            result_ta.setRowSorter(rs);
            super.resetTableColumnSize();                                  // Jw

            java.awt.Toolkit.getDefaultToolkit().beep();                   // I鎞Ƀr[v炷D

            UIManager.put("OptionPane.messageDialogTitle", "Messege");     // "^Cg"Messege"ɕύXD
            UIManager.put("OptionPane.okButtonText", "OK");                // ""̕"OK"ɕύXD
            JOptionPane.showMessageDialog(jf, "Calclation is finished.\n" + pm.getNote() + "\n"
                                            + "Candidate structure: " + cds.size());
            start.setEnabled(true);                                        // {^悤ɂD
            reset.setEnabled(true);
        }
        catch (Exception e)                                                // ̓rŗOꍇC
        {                                                                  // x_CAO\𒆒f
            JOptionPane.showMessageDialog(jf, "ERROR: " + e);
            e.printStackTrace();
            start.setEnabled(true);                                        // {^悤ɂD
            reset.setEnabled(true);
        }
    }

    public static void main(String[] args) throws Exception
    {
        new PredictionGUIMe();
    }
}
