package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;

/**
 * <I>m/z</I> 烁`C`̑g\NXłD
 * @author  m
 * @version  20090128
 */
public class CompositionToolsMe extends CompositionTools
{
    /**
     * \ꂽgԂ܂D
     * @return ʌ덷̏ȂɊi[ĕԂ܂D
     */
    public List<Composition> getComposition() throws Exception
    {
        al_cp.clear();                             // NX̍ėp̎̂߂ɗvfSč폜D

        Composition cp = new Composition();
        if (known_cp != null)                      // mgo^Ăꍇ
            cp.addAll(known_cp);
        else if (known_gc != null)                 // m\o^Ăꍇ
            cp.addAll(new Composition(known_gc));

        // pɂύX
        Composition temp_me = new Composition(cp); // VȃCX^X쐬D
        int count = temp_me.countHydroxy();        // `łOH̐𐔂D
        for (int i = 0; i < count; i++)            // OH̐MetD
            temp_me.add("me");
        double mass_t = temp_me.getMass(monoavg, adduct);
        // pɂύXi܂Łj

        if (ceramide != null && ceramide.size() != 0)     // Z~ho^Ăꍇ
        {
            if (mass_a > mass_t)
                addCer(cp);                               // Z~h猟D
        }
        else                                              // Z~ho^ĂȂꍇ́C[hƂD
        {
            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(cp);
            else if (mass_a > mass_t)
                addHex(cp);                               // Hex猟D
        }

        final double temp_a = mass_a;                         // NXŗpϐ́CfinalŐ錾KvD
        Collections.sort(al_cp, new Comparator<Composition>() // \[gsD
        {
            public int compare(Composition cp1, Composition cp2)
            {
                double sub = 0.0;

                try
                {
                    Composition temp1 = new Composition(cp1); // VȃCX^X쐬D
                    int count1 = temp1.countHydroxy();        // `łOH̐𐔂D
                    for (int i = 0; i < count1; i++)          // OH̐MetD
                        temp1.add("me");

                    Composition temp2 = new Composition(cp2); // VȃCX^X쐬D
                    int count2 = temp2.countHydroxy();        // `łOH̐𐔂D
                    for (int i = 0; i < count2; i++)          // OH̐MetD
                        temp2.add("me");

                    sub = Math.abs(temp1.getMass(monoavg, adduct) - temp_a)
                        - Math.abs(temp2.getMass(monoavg, adduct) - temp_a);
                }
                catch (Exception e)
                {

                }

                return (int)(sub*1024); // compare\bh̕Ԃlint^󂯕tȂ̂1024{ĐxグD
            }
        });

        ceramide.clear(); // ̎s鎞ɓgQǉȂ悤
        lcb.clear();      // m̃Z~hgCgCb_g폜ĂD
        fa.clear();       // iɂCsɒʏʂZ~hǉłj

        return al_cp;
    }

    protected void addCer(Composition cp) throws Exception
    {
        for (String str : ceramide)
        {
            Composition temp = new Composition(str);      // Z~ho^D
            temp.addAll(cp);

            // pɂύX
            Composition temp_me = new Composition(temp);  // VȃCX^X쐬D
            int count = temp_me.countHydroxy();           // `łOH̐𐔂D
            for (int i = 0; i < count; i++)               // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else
                addHex(temp);
        }
    }

    protected void addHex(Composition cp) throws Exception
    {
        addHexNAc(cp); // HexNAcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hex") < hex_max) // vfTC𐔂D
        {
            temp.add("hex");

            // pɂύX
            Composition temp_me = new Composition(temp); // VȃCX^X쐬D
            int count = temp_me.countHydroxy();          // `łOH̐𐔂D
            for (int i = 0; i < count; i++)              // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHex(temp);
        }
    }

    protected void addHexNAc(Composition cp) throws Exception
    {
        adddHex(cp);                                           // dHexǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"hexnac") < hexnac_max) // vfTC𐔂D
        {
            temp.add("hexnac");

            // pɂύX
            Composition temp_me = new Composition(temp);       // VȃCX^X쐬D
            int count = temp_me.countHydroxy();                // `łOH̐𐔂D
            for (int i = 0; i < count; i++)                    // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms)      // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addHexNAc(temp);
        }
    }

    protected void adddHex(Composition cp) throws Exception
    {
        addPen(cp);                                       // dHexMeǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(cp,"dhex") < dhex_max)  // vfTC𐔂D
        {
            temp.add("dhex");

            // pɂύX
            Composition temp_me = new Composition(temp);  // VȃCX^X쐬D
            int count = temp_me.countHydroxy();           // `łOH̐𐔂D
            for (int i = 0; i < count; i++)               // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                adddHex(temp);
        }
    }

    protected void addPen(Composition cp) throws Exception
    {
        addKDN(cp);                                       // KDNǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"pen") < pen_max)  // vfTC𐔂D
        {
            temp.add("pen");

            // pɂύX
            Composition temp_me = new Composition(temp);  // VȃCX^X쐬D
            int count = temp_me.countHydroxy();           // `łOH̐𐔂D
            for (int i = 0; i < count; i++)               // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addPen(temp);
        }
    }

    protected void addKDN(Composition cp) throws Exception
    {
        addNeuAc(cp);                                     // NeuAcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(temp,"kdn") < kdn_max)  // vfTC𐔂D
        {
            temp.add("kdn");

            // pɂύX
            Composition temp_me = new Composition(temp);  // VȃCX^X쐬D
            int count = temp_me.countHydroxy();           // `łOH̐𐔂D
            for (int i = 0; i < count; i++)               // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms) // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addKDN(temp);
        }
    }

    protected void addNeuAc(Composition cp) throws Exception
    {
        addNeuGc(cp);                                      // NeuGcǉ\

        Composition temp = new Composition(cp);
        if (Collections.frequency(cp,"neuac") < neuac_max) // vfTC𐔂D
        {
            temp.add("neuac");

            // pɂύX
            Composition temp_me = new Composition(temp);  // VȃCX^X쐬D
            int count = temp_me.countHydroxy();           // `łOH̐𐔂D
            for (int i = 0; i < count; i++)               // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms)  // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addNeuAc(temp);
        }
    }

    protected void addNeuGc(Composition cp) throws Exception
    {
        Composition temp = new Composition(cp);

        if (Collections.frequency(temp,"neugc") < neugc_max) // vfTC𐔂D
        {
            temp.add("neugc");

            // pɂύX
            Composition temp_me = new Composition(temp);     // VȃCX^X쐬D
            int count = temp_me.countHydroxy();              // `łOH̐𐔂D
            for (int i = 0; i < count; i++)                  // OH̐MetD
                temp_me.add("me");
            double mass_t = temp_me.getMass(monoavg, adduct);
            // pɂύXi܂Łj

            if (Math.abs(mass_a - mass_t) < tolerance_ms)    // lƗ_lƂ̍e덷ȉȂ΁Cǉ
                al_cp.add(temp);
            else if (mass_a > mass_t)
                addNeuGc(temp);
        }
    }

    /**
     * `̑g\eXg
     */
    private static void testPermetylatedGlycan() throws Exception
    {
        CompositionToolsMe cm = new CompositionToolsMe();
        cm.setCeramide(30, 44, 0);
        cm.setMass(1746.0537);
        for (Composition cp : cm.getComposition())
            System.out.println(cp);
    }

    /**
     * `KOIVh̑g\eXg
     */
    private static void testPermethylatedGanglioside(double mass) throws Exception
    {
        double start = new Date().getTime();

        CompositionToolsMe ci = new CompositionToolsMe();
        ci.setMsTolerance(0.5);
        ci.setComposition(new Composition("neuac"));
        ci.setCeramide(30, 44, 0);
        ci.setMass(mass);
        ci.setMax("hex",    true); // e̗Lw肷D
        ci.setMax("hexnac", true);
        ci.setMax("dhex",   true);
        ci.setMax("pen",    true);
        ci.setMax("kdn",    false);
        ci.setMax("neuac",  true);
        ci.setMax("neugc",  false);

        List<Composition> li = ci.getComposition();
        for (Composition cp : li)
            System.out.println(cp);

        System.out.println("\g: " + li.size());
        System.out.println("vZ: " + (new Date().getTime() - start)/1000 + "sec");
    }
}
