package jp.ac.ritsumei.is.infobio;
import java.util.*;
import java.util.regex.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Cѓɂ闝_<I>m/z</I> vZServletNXłD
 * @author m
 * @version 20090102
 */
public class MassCalcServlet extends HttpServlet
{
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        try
        {
            Composition cp;         // vZg
            String adduct = "";     // tCI
            boolean monoavg = true; // Monoisotopic(ture),Averaget(false)

            try
            {
                String temp = request.getParameter("comp");            // w肳ȂꍇCO
                if (temp == null || temp.equals(""))
                    temp = "dc34:1, glc, man, glcnac, galnac, galnac"; // ̑glƂD

                try                                                    // g܂͍\Composition𓾂
                {
                    cp = new Composition(new Glycan(temp));            // ܂Linucs`œ͂ł邩D
                }
                catch (Exception e)
                {
                    cp = new Composition(temp);                        // OꍇCComposition֎󂯓nD
                }
            }
            catch (Exception e)
            {
                cp = new Composition("dc34:1, glc, man, glcnac, galnac, galnac"); // ̑glƂD
            }
            try
            {
                adduct = request.getParameter("adduct");

                if (adduct == null)           // w肳ȂꍇC
                    adduct = MassCalc.Na_ION; // ̃CItCIƂD
            }
            catch (Exception e)
            {
                adduct = MassCalc.Na_ION;     // ̃CItCIƂD
            }
            try
            {
                String temp = request.getParameter("monoavg");
                if (temp.equals("mono"))
                    monoavg = true;
                else if (temp.equals("avg"))
                    monoavg = false;
                else
                    monoavg = true;           // ̑̏ꍇMonoisotopicƂD
            }
            catch (Exception e)
            {
                monoavg = true;               // ̑̏ꍇMonoisotopicƂD
            }

            out.println("<HTML><HEAD><TITLE>Mass Calculator</TITLE></HEAD><BODY>"); // ͕
            out.println("<FONT SIZE=+2>Mass Calculator</FONT><BR><BR>");
            out.println("<FORM>");
                               
            if (cp.toString().length() < 30)                           // g\̒̕擾D
                out.println("Composition: <INPUT TYPE=text NAME=comp " // ͂30ȉȂ΁C40\ƂD
                          + "SIZE=40 VALUE='" + cp + "'><BR>");
            else                                                       // 30ȏȂ΁C+10͉\ɂD
                out.println("Composition: <INPUT TYPE=text NAME=comp "
                          + "SIZE=" + (20 + cp.toString().length()) + " VALUE='" + cp + "'><BR>");

            out.println("Adduct ion: <SELECT NAME=adduct>");           // O̓elƂD
            if (adduct.equals(MassCalc.Na_ION))
                out.println("<OPTION VALUE="+MassCalc.Na_ION+" SELECTED>Na+");
            else
                out.println("<OPTION VALUE="+MassCalc.Na_ION+">Na+");
            if (adduct.equals(MassCalc.H_ION))
                out.println("<OPTION VALUE="+MassCalc.H_ION+" SELECTED>H+");
            else
                out.println("<OPTION VALUE="+MassCalc.H_ION+">H+");
            if (adduct.equals(MassCalc.Li_ION))
                out.println("<OPTION VALUE="+MassCalc.Li_ION+" SELECTED>Li+");
            else
                out.println("<OPTION VALUE="+MassCalc.Li_ION+">Li+");
            if (adduct.equals(MassCalc.K_ION))
                out.println("<OPTION VALUE="+MassCalc.K_ION+" SELECTED>K+");
            else
                out.println("<OPTION VALUE="+MassCalc.K_ION+">K+");
            if (adduct.equals(MassCalc.H_NION))
                out.println("<OPTION VALUE="+MassCalc.H_NION+" SELECTED>H-");
            else
                out.println("<OPTION VALUE="+MassCalc.H_NION+">H-");
            if (adduct.equals(""))
                out.println("<OPTION VALUE='' SELECTED>No adduct (Molecular weight)");
            else
                out.println("<OPTION VALUE=''>No adduct (Molecular weight)");
            out.println("</SELECT><BR>");
            out.println("Mass mode: <SELECT NAME=monoavg>");
            if (monoavg)
            {
                out.println("<OPTION VALUE=mono SELECTED>Monoisotopic");
                out.println("<OPTION VALUE=avg>Average");
            }
            else
            {
                out.println("<OPTION VALUE=mono>Monoisotopic");
                out.println("<OPTION VALUE=avg SELECTED>Average");
            }
            out.println("</SELECT><BR>");
            out.println("<INPUT TYPE=submit>");
            out.println("</FORM><BR>");

            out.println("<B>Result</B><BR>"); // \
            out.println("Composition: " + cp + "<BR>");
            if (adduct.equals(MassCalc.Na_ION))
                out.println("Adduct ion: Na+<BR>");
            else if (adduct.equals(MassCalc.H_ION))
                out.println("Adduct ion: H+<BR>");
            else if (adduct.equals(MassCalc.Li_ION))
                out.println("Adduct ion: Li+<BR>");
            else if (adduct.equals(MassCalc.K_ION))
                out.println("Adduct ion: K+<BR>");
            else if (adduct.equals(MassCalc.H_NION))
                out.println("Adduct ion: H-<BR>");
            else if (adduct.equals(""))
                out.println("Adduct ion: no adduct (molecular weight)<BR>");
            else
                out.println("Adduct ion: " + adduct + "<BR>");

            MassCalc mc_temp2 = new MassCalc(monoavg, adduct); // q\
            out.println("Molecular formula: " + mc_temp2.getMolecularFormula(cp) + "<BR>");

            if (monoavg)
                out.println("Mass mode: Monoisotopic mass<BR>");
            else
                out.println("Mass mode: Average mass<BR>");

            // 1Ԗڂ̃AC\g[ṽCIx\D
            MassCalc mc_temp = new MassCalc(monoavg, adduct);
            mc_temp.getMass(cp); // \o^D
            double intensity = mc_temp.getIsotopeIntensity(1);
            // CIx95%𒴂Ăꍇ́Cs[N̑I~X̉\邽߁CԐFŒӂ𑣂D
            if (intensity > 0.95 && monoavg) // Ax[W̎͐ԐF\Ȃ
                out.println(String.format("<B><I>m/z</I> = %.4f</B> "
                                        + "(If measured mass is <FONT color=red>%.1f</FONT>,"
                                        + " it may be 1st isotopic peak.)<BR><BR>",
                                        cp.getMass(monoavg, adduct), (cp.getMass(monoavg, adduct) + 1.0)));
            else
                out.println(String.format("<B><I>m/z</I> = %.4f</B><BR><BR>",cp.getMass(monoavg, adduct)));

            // AC\g[ṽp^[\D
            if (monoavg) // Ax[W͕̎\Ȃ
            {
                MassCalc mc = new MassCalc(monoavg, adduct);
                out.println("<B>Peak pattern</B><BR>");
                out.println("<IMG SRC=isotope.png"
                + "?mass0=" +  mc.getMass(cp)      + "&intensity0=" + mc.getIsotopeIntensity(0)
                + "&mass1=" + (mc.getMass(cp)+1.0) + "&intensity1=" + mc.getIsotopeIntensity(1)
                + "&mass2=" + (mc.getMass(cp)+2.0) + "&intensity2=" + mc.getIsotopeIntensity(2)
                + "&mass3=" + (mc.getMass(cp)+3.0) + "&intensity3=" + mc.getIsotopeIntensity(3)
                + "&mass4=" + (mc.getMass(cp)+4.0) + "&intensity4=" + mc.getIsotopeIntensity(4)
                + "><BR><BR>");
            }

            // `̍\m/z\D
            try
            {
                Composition methylated = new Composition(cp);
                int count = methylated.countHydroxy();               // `OH̐𐔂D
                methylated.addAll(new Composition("me*" + count));   // `ǉD
                out.println("<B>Permethylated composition</B><BR>"); // \
                out.println("Composition: " + methylated + "<BR>");
                out.println(String.format("<I>m/z</I> = %.4f<BR>",methylated.getMass(monoavg, adduct)));
            }
            catch (Exception e)
            {
                out.println("<B>Permethylated composition</B><BR>"); // \
                out.println("This composition is not supported.<BR>");
            }

            // ̓ǂݍ݁im/zCgCtCICMono/AvgCɂ5j
            out.println("<BR>");
            out.println("<B>Recent queries</B><BR>");
            out.println("<TABLE border=1>");
            out.println("<TR><TH><I>m/z</I></TH><TH>Composition</TH><TH>Adduct ion</TH><TH>Mass mode</TH><TH>Date</TH></TR>");
            LinkedList<String> ll = new LinkedList<String>();     // String^̃L[D
            RandomAccessFile ra = new RandomAccessFile("masscalc.log", "rw");
            if (ra.length() > 10240)
                ra.seek(ra.length()-10240);                       // t@C̏I[10KBڂɈړ
            String line;
            for (int i = 0; (line = ra.readLine()) != null; i++)
                if (i > 0)                                        // 1sڂ͓rł̂ŖD
                {
                    if (ll.size() >= 10)                          // vf10ȏ܂܂ĂꍇC
                        ll.remove();                              // Xg̐擪̗vf폜āC
                    ll.add(line);                                 // Xg̍ŌɗvfǉD
                }

            ListIterator<String> li = ll.listIterator(ll.size()); // tɓǂݍނɂ̓Xg̃TCY̎w肪Kv
            while (li.hasPrevious())                              // L[tɏo͂D
            {
                String[] strs = li.previous().split("\t");        // ^uŕD
                if (strs.length == 5)
                    out.println("<TR><TD align=right>" + strs[0] + "</TD><TD>" + strs[1]
                             + "</TD><TD align=center>" + strs[2] + "</TD><TD align=center>" + strs[3]
                             + "</TD><TD>" + strs[4] + "</TD></TR>");
            }
            out.println("</TABLE><BR>");

            // ̏݁im/zCgCtCICMono/AvgCɂ5j
            ra.seek(ra.length()); // t@C̏I[Ɉړ
            String temp_adduct, temp_monoavg;
            if (adduct.equals(MassCalc.Na_ION))
                temp_adduct = "Na+";
            else if (adduct.equals(MassCalc.H_ION))
                temp_adduct = "H+";
            else if (adduct.equals(MassCalc.Li_ION))
                temp_adduct = "Li+";
            else if (adduct.equals(MassCalc.K_ION))
                temp_adduct = "K+";
            else if (adduct.equals(MassCalc.H_NION))
                temp_adduct = "H-";
            else if (adduct.equals(""))
                temp_adduct = "no adduct";
            else
                temp_adduct = adduct;
            if (monoavg)
                temp_monoavg = "Monoisotopic";
            else
                temp_monoavg = "Average";
            ra.writeBytes(String.format("%.4f",cp.getMass(monoavg, adduct)) + "\t" + cp + "\t"
                        + temp_adduct + "\t" + temp_monoavg + "\t" + new Date() + "\n");
            ra.close(); // iN[YȂ"Too many open files"G[ƂȂj
        }
        catch (Exception e)
        {
            out.println("ERROR:" + e.getMessage() + "<BR><BR>");
        }

        out.println("<Div Align=right><FONT color=gray>(c) Kazuhito Yokoi</FONT></Div><BR>");
        out.println("<A HREF=../>Back</A>");              // gbvy[Wւ̃N

        out.println("<script type=\"text/javascript\">");
        out.println("var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");");
        out.println("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));");
        out.println("</script>");
        out.println("<script type=\"text/javascript\">");
        out.println("try {");
        out.println("var pageTracker = _gat._getTracker(\"UA-1643740-14\");");
        out.println("pageTracker._trackPageview();");
        out.println("} catch(err) {}</script>");
        out.println("</BODY></HTML>");                    // I^O
    }
}
