package jp.ac.ritsumei.is.infobio;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import javax.swing.table.*;
import java.util.concurrent.*;
import java.lang.management.*;

/**
 * CуsWA~m̃tOgCI\\NXłDiGUIŁj
 * @author m
 * @version 20090202
 */
public class PredictionGUIGlycan implements Observer, ActionListener, Runnable
{
    String adduct = MassCalc.Na_ION;      // tCIiftHgNa+jI𕔂̃R[h̏d߃O[oϐƂD
    boolean monoavg = MassCalc.MONO_MASS; // Monoisotopic(ture),Averaget(false)

    JFrame jf = new JFrame("Structure Predictor (free/PA oligosaccharide ver)"); // C̃t[

    // HexNAc-HexNAc-HexNAc-HexNAc-HexNAc̎tOg
    JTextArea query_ta = new JTextArea("210.46\n226.40\n259.28\n304.23\n322.24\n347.22\n388.27\n406.33\n507.56\n"
                                     + "512.00\n525.63\n532.50\n550.61\n568.62\n696.83\n712.80\n730.76\n753.75\n"
                                     + "760.46\n786.82\n831.78\n849.81\n874.75\n915.72\n933.68\n975.46\n990.71\n"
                                     + "993.66\n996.84\n1011.81\n1034.68\n1047.76\n1052.76\n1077.76\n1095.74\n"
                                     + "1111.85\n1118.75\n1126.02\n1129.14\n1151.93\n1171.90\n1196.97\n1199.47\n"
                                     + "1214.88\n1280.94\n1299.03\n1359.16\n1361.36\n1377.22\n1400.49\n1418.19\n"
                                     + "1472.53\n1579.87");
    JTextField precursor_mass_tf = new JTextField("");                        // vJ[T[}Xm/z
    JTextField precursor_tolerance_tf = new JTextField("2.0");                // vJ[T[}X̋e덷
    JTextField psd_tolerance_tf = new JTextField("2.0");                      // PSDtOg̋e덷
    JTextField known_gc_tf = new JTextField("GlcNAcPA-GlcNAc-Man(-Man)-Man"); // m\
    JComboBox adduct_cb = new JComboBox(new String[]{"Na+","H+","Li+","K+","H-","No adduct"}); // tCI
    JComboBox pen_cb    = new JComboBox(new String[] {"Yes", "No"});          // Pen݂Ă邩ۂw
    JComboBox dhex_cb   = new JComboBox(new String[] {"Yes", "No"});          // dHex݂Ă邩ۂw
    JComboBox hex_cb    = new JComboBox(new String[] {"Yes", "No"});          // Hex݂Ă邩ۂw
    JComboBox hexnac_cb = new JComboBox(new String[] {"Yes", "No"});          // HexNAc݂Ă邩ۂw
    JComboBox penme_cb    = new JComboBox(new String[] {"Yes", "No"});        // PenMe݂Ă邩ۂw
    JComboBox dhexme_cb   = new JComboBox(new String[] {"Yes", "No"});        // dHexMe݂Ă邩ۂw
    JComboBox hexme_cb    = new JComboBox(new String[] {"Yes", "No"});        // HexMe݂Ă邩ۂw
    JComboBox hexnacme_cb = new JComboBox(new String[] {"Yes", "No"});        // HexNAcMe݂Ă邩ۂw

    JTextArea ceramide_tf = new JTextArea("dc30-44:1, dh30-44:1,\ntc30-44:0, th30-44:0"); // mZ~hg
    JComboBox formula_cb = new JComboBox(new String[]                                     // XRAvZ
                                        {
                                            "POSITIVE",
                                            "TFIDF",
                                            "PENALTY01",
                                            "PENALTY001",
                                            "PMF",
                                            "GEOMETRICAVG"
                                        });
    JButton start = new JButton("Start search");                                          // Jn{^
    JButton reset = new JButton("Reset form");                                            // Zbg{^

    String[] title = {"Score", "Candidate structure", "Occupancy", "m/z"};        // \z\o͕
    DefaultTableModel tm = new DefaultTableModel(title, 0);
    JTable result_ta = new JTable(tm);

    ProgressMonitor pm;                                                                   // io[

    /*
     * l͂镔JPanel擾܂D
     */
    protected JPanel getInputJPanel()
    {
        JPanel west_center = new JPanel();                               // EBhEWESTɓ\tplCENTER
        west_center.setLayout(new BorderLayout());                       // EBhE̍
        west_center.add(new JLabel("Fragment mass:"), BorderLayout.NORTH);
        west_center.add(new JScrollPane(query_ta), BorderLayout.CENTER); // JTextAreaփXN[o[D

        return west_center;
    }

    /*
     * Iȗ\ݒ肷镔JPanel擾܂D
     */
    protected JPanel getExperimentalConditionJPanel()
    {
        JPanel west_south_north = new JPanel(); // \͕ EBhEWESTɓ\tplSOUTH
                                                // EBhE̍
                                                // JComboBox̏Iڂw肷D
        pen_cb.setSelectedItem("No");           // PeñftHg"No"
        dhex_cb.setSelectedItem("Yes");         // dHex̃ftHg"Yes"
        hex_cb.setSelectedItem("Yes");          // Hex̃ftHg"Yes"
        hexnac_cb.setSelectedItem("Yes");       // HexNAc̃ftHg"Yes"

        penme_cb.setSelectedItem("No");         // PenMẽftHg"No"
        dhexme_cb.setSelectedItem("No");        // dHexMẽftHg"No"
        hexme_cb.setSelectedItem("No");         // HexMẽftHg"No"
        hexnacme_cb.setSelectedItem("No");      // HexNAcMẽftHg"No"

        formula_cb.setSelectedItem("TFIDF");    // XRAvZ̃ftHg"TFIDF"

        west_south_north.setLayout(new GridLayout(12, 2)); // c̐~̐
        west_south_north.add(new JLabel("Fragment tolerance: "));
        west_south_north.add(psd_tolerance_tf);
        west_south_north.add(new JLabel("Precursor mass: "));
        west_south_north.add(precursor_mass_tf);
        west_south_north.add(new JLabel("Precursor tolerance: "));
        west_south_north.add(precursor_tolerance_tf);
        west_south_north.add(new JLabel("Adduct ion: "));
        west_south_north.add(adduct_cb);
        west_south_north.add(new JLabel("Pen: "));
        west_south_north.add(pen_cb);
        west_south_north.add(new JLabel("dHex: "));
        west_south_north.add(dhex_cb);
        west_south_north.add(new JLabel("Hex: "));
        west_south_north.add(hex_cb);
        west_south_north.add(new JLabel("HexNAc: "));
        west_south_north.add(hexnac_cb);
        west_south_north.add(new JLabel("PenMe: "));
        west_south_north.add(penme_cb);
        west_south_north.add(new JLabel("dHexMe: "));
        west_south_north.add(dhexme_cb);
        west_south_north.add(new JLabel("HexMe: "));
        west_south_north.add(hexme_cb);
        west_south_north.add(new JLabel("HexNAcMe: "));
        west_south_north.add(hexnacme_cb);

        return west_south_north;
    }

    /*
     * Iȗ\ݒ肷镔JPanel擾܂D
     */
    protected JPanel getKnownConditionJPanel()
    {
        JPanel west_south_center = new JPanel();
        west_south_center.setLayout(new GridBagLayout());  // ͕L邽߂GridBagLayoutpD

        GridBagConstraints gb3 = new GridBagConstraints(); // mg͕̃x
        gb3.gridx = 0;
        gb3.gridy = 1;
        gb3.anchor = GridBagConstraints.WEST;              // 
        west_south_center.add(new JLabel("Known: "), gb3);

        GridBagConstraints gb4 = new GridBagConstraints(); // mg͕
        gb4.gridx = 1;
        gb4.gridy = 1;
        gb4.fill = GridBagConstraints.HORIZONTAL;          // ݂̂ɓhԂsD
        gb4.weightx = 1.0;                                 // ƃCAEgD
        west_south_center.add(known_gc_tf, gb4);

        return west_south_center;
    }

    /*
     * vZ@Iȗ\ݒ肷镔JPanel擾܂D
     */
    protected JPanel getComputationalConditionJPanel()
    {
        byte[] bytes = {40, 99, 41, 32, 75, 97, 122, 117, 104, 105, 116, 111, 32, 89, 111, 107, 111, 105};

        // XRAOI𕔕BorderLayoutNORTHƂC
        // Jn{^ƃZbg{^SOUTHƂĕԂD
        JPanel west_south_south_north = new JPanel();           // XRAȎI
        west_south_south_north.setLayout(new GridLayout(1, 2)); // c̐~̐

        JPanel west_south_south_south = new JPanel();           // Jn{^ƃZbg{^
        west_south_south_south.setLayout(new GridLayout(1, 2)); // c̐~̐
        start.addActionListener(this);                          // Jn{^ɃXitD
        reset.addActionListener(this);                          // Zbg{^ɃXitD

        JLabel author = new JLabel(new String(bytes));
        author.setHorizontalAlignment(SwingConstants.CENTER);
        author.setForeground(Color.gray);
        west_south_south_south.add(author);
        west_south_south_south.add(start);

        JPanel west_south_south = new JPanel();                           // returnJPanelCX^X
        west_south_south.setLayout(new BorderLayout());
        west_south_south.add(west_south_south_north, BorderLayout.NORTH); // XRAȎI𕔕ǉ
        west_south_south.add(west_south_south_south, BorderLayout.SOUTH); // Jn{^ƃZbg{^ǉ

        return west_south_south;
    }

    /*
     * \ݒ肷镔JPanel擾܂D
     */
    protected JPanel getConditionJPanel()
    {                                                                          // \͕
        JPanel west_south = new JPanel();                                      // EBhEWESTɓ\t
                                                                               // plSOUTHiEBhE̍j
        west_south.setLayout(new BorderLayout());

        west_south.add(getExperimentalConditionJPanel(), BorderLayout.NORTH);  // Iȗ\ݒ
        west_south.add(getKnownConditionJPanel(), BorderLayout.CENTER);        // Iȗ\ݒ
        west_south.add(getComputationalConditionJPanel(), BorderLayout.SOUTH); // vZ@Iȗ\ݒ

        return west_south;
    }

    /*
     * \ʂo͂镔JPanel擾܂D
     */
    protected JPanel getOutputJPanel()
    {
        JPanel center = new JPanel();                       // \z\o͕
        center.setLayout(new BorderLayout());               // EBhECENTERɓ\tpliEBhẺEj
        this.resetTableColumnSize();                        // Jw肷D
        JScrollPane result_sp = new JScrollPane(result_ta); // JTableփXN[o[D
        result_sp.addMouseListener(new MouseListener()      // \ENbNƈD
        {
            public void mouseExited(MouseEvent me){}
            public void mouseEntered(MouseEvent me){}
            public void mousePressed(MouseEvent me){}
            public void mouseReleased(MouseEvent me){}
            public void mouseClicked(MouseEvent me)
            {
                if (me.getButton() == MouseEvent.BUTTON3)   // ENbN
                {
                    try
                    {
                        result_ta.print();                  // _CAO\
                    }
                    catch (Exception e)
                    {
                        System.out.println("Cannot print: " + e);
                    }
                }
            }
        });
        center.add(new JLabel("Result:"), BorderLayout.NORTH);
        center.add(result_sp, BorderLayout.CENTER);

        return center;
    }

    /*
     * e[ũJ𒲐߂܂D
     */
    protected void resetTableColumnSize()
    {
        DefaultTableCellRenderer tr = new DefaultTableCellRenderer(); // JE񂹂CX^X
        tr.setHorizontalAlignment(SwingConstants.RIGHT);

        TableColumn tc0 = result_ta.getColumnModel().getColumn(0);    // XRÃJi0Ԗځj̃TCYŒ
        tc0.setMinWidth(70);
        tc0.setMaxWidth(70);
        tc0.setCellRenderer(tr);                                      // JE
                                                                      // \̃J̓TCYw
        TableColumn tc2 = result_ta.getColumnModel().getColumn(2);    // L̃Ji2Ԗځj̃TCYŒ
        tc2.setMinWidth(70);
        tc2.setMaxWidth(70);
        tc2.setCellRenderer(tr);                                      // JE
        TableColumn tc3 = result_ta.getColumnModel().getColumn(3);    // m/z̃Ji3Ԗځj̃TCYŒ
        tc3.setMinWidth(80);
        tc3.setMaxWidth(80);
        tc3.setCellRenderer(tr);                                      // JE
    }

    public PredictionGUIGlycan() throws Exception
    {
        jf.setLayout(new BorderLayout());                             // EBhEւ̃R|[lg̓\t
                                                                      // BorderLayoutpD
        JPanel west = new JPanel();                                   // EBhEWESTɓ\tpl
        west.setLayout(new BorderLayout());                           // EBhE̍
        west.add(getInputJPanel(), BorderLayout.CENTER);              // l͂镔WESTCENTERɔzu
        west.add(getConditionJPanel(), BorderLayout.SOUTH);           // \ݒ肷镔WESTNORTHɔzu
        jf.getContentPane().add(west, BorderLayout.WEST);

        jf.getContentPane().add(getOutputJPanel(), BorderLayout.CENTER); // \ʂo͂镔CENTERɔzu

        try                                                              // ^XNgCɃACRǉD
        {
            SystemTray st = SystemTray.getSystemTray();
            ImageIcon ii = (ImageIcon)UIManager.getIcon("FileView.computerIcon"); // IconImageIcon֌^ϊ
            TrayIcon ti = new TrayIcon(ii.getImage()); 
            ti.addActionListener(new ActionListener()                    // gCACR_uNbN邱ƂŁC
            {                                                            // EBhE̕\/\؂ւD
                public void actionPerformed(ActionEvent e)
                {
                    if (jf.isShowing())                                  // EBhE\Ăꍇ́C
                        jf.setVisible(false);                            // \ɂD
                    else
                    {                                                    // \ĂȂꍇ́C
                        jf.setVisible(true);                             // \C
                        jf.toFront();                                    // ̃EBhEɃtH[JX𓖂ĂD
                    }
                }
            });
            st.add(ti);
        }
        catch (Exception e)
        {
            System.err.println("Cannot use SystemTray: " + e);
        }

        try                                                              // SwingCWindows̃fUC֕ύX
        {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"); // Oςݒ
            SwingUtilities.updateComponentTreeUI(jf);                                       // OϕύX
        }
        catch (Exception e)
        {
            System.err.println("Cannot use WindowsLookAndFeel: " + e);
        }

        jf.setSize(900,700);
        jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);               // EChEꂽɏI
        jf.setVisible(true);                                             // \
    }

    /*
     * Swing̃ANVCxg̓w肵܂D
     * @parm ae 擾ANVCxg
     */
    public void actionPerformed(ActionEvent ae)
    {
        if (ae.getSource() == start)                                        // Start{^ꂽ
        {
            DefaultTableModel tm = (DefaultTableModel)result_ta.getModel(); // e[uf擾C
            tm.setRowCount(0);                                              // \̓e폜D
            start.setEnabled(false);                                        // {^ȂD
            reset.setEnabled(false);

            try                                                             // ProgressMonitor̃^CgȂǂ
            {                                                               // ftHgł͓{̂߁CpꖼɕύX
                UIManager.put( "ProgressMonitor.progressText", "Progress Monitor" ); // EBhE
                UIManager.put( "OptionPane.cancelButtonText",  "Cancel" );           // LZ{^
            }
            catch (Exception e)
            {
                System.err.println("ProgressMonitor connot edit: " + e);
            }

                                                                            // \镶̃ev[g
            String length = "Creating Glycan Composition from precursor and fragment mass...                        ";
            pm = new ProgressMonitor(jf, "Calculating...", length, 0, 100); // io[
            pm.setMillisToDecideToPopup(0);
            pm.setMillisToPopup(0);
            pm.setProgress(0);                                              // ĎΏۂ̃CX^Xϐ擾
            Thread th = new Thread(this);
            th.start();
        }
        else if (ae.getSource() == reset)                                   // Reset{^ꂽ
        {
            query_ta.setText("");                                           // tOgqʂ̓e폜
            DefaultTableModel tm = (DefaultTableModel)result_ta.getModel(); // e[uf擾C
            tm.setRowCount(0);                                              // \̓e폜D
        }
    }

    /*
     * ĎΏۂXVꂽ̓w肵܂D
     * @parm ae 擾ANVCxg
     */
    public void update(Observable ob, Object arg)
    {
        if (ob instanceof Prediction)                   // PredictionNX̃CX^Xł邩𔻒
        {
            Prediction temp = (Prediction)ob;           // ObservableCX^XƂēn̂Ō^ϊ
            pm.setProgress(temp.percent);               // ĎΏۂ̃CX^X烁oϐ擾
            pm.setNote(arg.toString());                 // i̕\

            StringBuilder line = new StringBuilder(32); // R}hCɕ\镶
            MemoryMXBean mm = ManagementFactory.getMemoryMXBean();
            MemoryUsage mu = mm.getHeapMemoryUsage();
            line.append(" Memory: ");
            line.append(String.format("%.1f/", mu.getUsed() / 1024.0 / 1024));
            line.append(String.format("%.1fMB", mu.getMax() / 1024.0 / 1024));

            System.out.println(arg + " " + line);       // i̕\

            if (pm.isCanceled())                        // ProgressMonitor̃LZ{^ꂽ
            {
                pm.close();                             // ProgressMonitorEBhED
                temp.flag = false;                      // fЉ𔲂D
            }
        }
        else
            System.out.println("ERROR: unknown incetance of observerable class.");
    }

    /*
     * StartNbNɎsXbh
     */
    public void run()
    {
        try
        {
            Prediction pd_agg = new Prediction();                    // p̑ɏWpD
            pd_agg.addObserver(this);                                // is󋵂̃NX֓`邽߂ɁC
                                                                     // ̃NXIuU[oƂD
                                                                     // eLXgGAl擾
            String[] strs = query_ta.getText().split("[^\\.\\d]");   // '.'ƐȊO̕Ő؂oD
            java.util.List<Double> massli = new ArrayList<Double>(); // ϒzpӂD
            for (String str : strs)
            {
                try
                {
                    massli.add(Double.parseDouble(str));
                }
                catch (Exception e)                                  // ȊO̕Ăꍇ̎C
                {                                                    // Ƃ
                    System.err.println(e);
                }
            }
            double[] frags = new double[massli.size()];              // ListƓ傫̔zpӂD
            Iterator<Double> massit = massli.iterator();
            for (int i = 0; massit.hasNext(); i++)                   // double[]^frags֔ž^ϊ
                frags[i] = massit.next();
            pd_agg.setFragments(frags);                              // tOg̎l̔zo^

            try                                                      // vJ[T[}Xo^
            {
                pd_agg.setPrecursorMass(Double.parseDouble(precursor_mass_tf.getText()));
            }
            catch (Exception e)
            {                                                        // vJ[T[}Xo^ȂꍇC
                System.err.println("Precursor mass is null.");       // PSDtOg̍ől
            }                                                        // vJ[T[}XƂČvZ

            try                                                      // vJ[T[}X̋e덷o^
            {
                pd_agg.setMsTolerance(Double.parseDouble(precursor_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'Precursor tolerance' contains error.\n" + e);
            }

            try                                                      // PSDtOg̋e덷o^
            {
                pd_agg.setPsdTolerance(Double.parseDouble(psd_tolerance_tf.getText())); // e덷i[
            }
            catch (Exception e)
            {
                throw new Exception("'PSD tolerance' contains error.\n" + e);
            }

            try                                                      // tCIo^
            {                                                        // IꂽtCI擾D
                String temp = (String)adduct_cb.getSelectedItem();   // \̕m/z擾̂ɕKvȂ߁C
                if (temp.equals("Na+"))                              // adduct̓O[oϐƂĂD
                    adduct = MassCalc.Na_ION;
                else if (temp.equals("H+"))
                    adduct = MassCalc.H_ION;
                else if (temp.equals("Li+"))
                    adduct = MassCalc.Li_ION;
                else if (temp.equals("K+"))
                    adduct = MassCalc.K_ION;
                else if (temp.equals("H-"))
                    adduct = MassCalc.H_NION;
                else if (temp.equals("No adduct"))
                    adduct = "";
                else
                    throw new Exception(temp + " is unknown adduct ion.");

                pd_agg.setAdduct(adduct);
            }
            catch (Exception e)
            {
                throw new Exception("'Adduct ion' contains error.\n" + e);
            }

            try                                                      // m\o^
            {
                pd_agg.setGlycan(new Glycan(known_gc_tf.getText())); // Linucs`m\o^
            }
            catch (Exception e1)                                     // Linucs`̓ǂݍ݂ɎsꍇC
            {                                                        // m[}`̓ǂݍ݂D
                try
                {
                    GlycanTools gi = new GlycanTools();
                    pd_agg.setGlycan(gi.readNormalFormat(known_gc_tf.getText())); // m\o^
                }
                catch (Exception e2)
                {
                    throw new Exception("'Known structure' contains error.\n" + e1 + e2);
                }
            }

            try                                                      // e̍ő吔o^
            {
                pd_agg.setMax("pen",    ((String)pen_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhex",   ((String)dhex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hex",    ((String)hex_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnac", ((String)hexnac_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("penme",    ((String)penme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("dhexme",   ((String)dhexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexme",    ((String)hexme_cb.getSelectedItem()).equals("Yes"));
                pd_agg.setMax("hexnacme", ((String)hexnacme_cb.getSelectedItem()).equals("Yes"));
            }
            catch (Exception e)
            {
                throw new Exception("'max' contains error.\n" + e);
            }

            try                                                     // XRAO̎o^
            {
                String temp = (String)formula_cb.getSelectedItem(); // IꂽXRAO̎擾
                if (temp.equals("POSITIVE"))
                    pd_agg.setScoringFormula(Candidate.POSITIVE_SCORING);
                else if (temp.equals("TFIDF"))
                    pd_agg.setScoringFormula(Candidate.TFIDF_SCORING);
                else if (temp.equals("PENALTY01"))
                    pd_agg.setScoringFormula(Candidate.PENALTY01_SCORING);
                else if (temp.equals("PENALTY001"))
                    pd_agg.setScoringFormula(Candidate.PENALTY001_SCORING);
                else if (temp.equals("PMF"))
                    pd_agg.setScoringFormula(Candidate.PMF_SCORING);
                else if (temp.equals("GEOMETRICAVG"))
                    pd_agg.setScoringFormula(Candidate.GEOMETRICAVG_SCORING);
                else
                    throw new Exception(temp + " is unknown adduct ion.");
            }
            catch (Exception e)
            {
                throw new Exception("'Scoring' contains error.\n" + e);
            }

            try                                                      // omz̃EBhETCYo^
            {
                pd_agg.setWindowSize(1);
            }
            catch (Exception e)
            {
                throw new Exception("'Window size' contains error.\n" + e);
            }

            // o͕
            java.util.List<? extends Candidate> cds = pd_agg.getPrediction();
            Collections.sort(cds, new Comparator<Candidate>()        // tOg̑ݗ̍Ƀ\[g
            {
                public int compare(Candidate cp1, Candidate cp2)
                {
                    double sub = 0.0; // ݗ̍
                    try
                    {
                        double score1 = cp1.getOccupancy();
                        double score2 = cp2.getOccupancy();

                        if (score1 == score2)                        // ݗ\́C򐔂̏Ȃ
                            sub = cp1.countLeaf() - cp2.countLeaf(); // itm[h̐Ȃj\ʂɕ\
                        else
                            sub = score2 - score1;
                    }
                    catch (Exception e)
                    {
                        System.err.println("Prediction.getPrediction(): score compare error");
                    }

                    return (int)(sub*1024); // x1024{ɏグ
                }
            }); // ݗɃ\[gsD
            Iterator<? extends Candidate> it = cds.iterator();
            DefaultTableModel tm = new DefaultTableModel(title, 0);
            for (int i = 0; i < 50 && it.hasNext(); i++)             // 50\
            {
                Candidate cd = it.next();

                String[] table = new String[4];                      // J̒ǉ́Cz̑傫ɒ
                table[0] = String.format("%.4f", cd.getScore());

                try
                {
                    table[1] = cd.toNormalFormat();                  // m[}̃tH[}bgŊi[
                }
                catch (Exception e)
                {
                    table[1] = cd.toString();                        // 񕪊ȏ̍\Linucs`Ŋi[
                }

                table[2] = String.format("%.4f", cd.getOccupancy());
                table[3] = String.format("%.4f", cd.getMass(monoavg, adduct));
                tm.addRow(table);
            }
            result_ta.setModel(tm);
            RowSorter<TableModel> rs = new TableRowSorter<TableModel>(tm); // \[g\ȃe[uɂD
            result_ta.setRowSorter(rs);
            this.resetTableColumnSize();                                   // Jw肷D

            java.awt.Toolkit.getDefaultToolkit().beep();                   // I鎞Ƀr[v炷D

            UIManager.put("OptionPane.messageDialogTitle", "Messege");     // "^Cg"Messege"ɕύXD
            UIManager.put("OptionPane.okButtonText", "OK");                // ""̕"OK"ɕύXD
            JOptionPane.showMessageDialog(jf, "Calclation is finished.\n" + pm.getNote() + "\n"
                                            + "Candidate structure: " + cds.size());
            start.setEnabled(true);                                        // {^悤ɂD
            reset.setEnabled(true);
        }
        catch (Exception e)                                                // ̓rŗOꍇC
        {                                                                  // x_CAO\𒆒f
            JOptionPane.showMessageDialog(jf, "ERROR: " + e);
            e.printStackTrace();
            start.setEnabled(true);                                        // {^悤ɂD
            reset.setEnabled(true);
        }
    }

    public static void main(String[] args) throws Exception
    {
        new PredictionGUIGlycan();
    }
}
