/*
 *  Copyright (C) 2005 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __G_SYNAPTICS_H__
#define __G_SYNAPTICS_H__

#include <gtk/gtk.h>
#include "synshm.h"

G_BEGIN_DECLS

#define G_TYPE_SYNAPTICS            (g_synaptics_get_type ())
#define G_SYNAPTICS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_SYNAPTICS, GSynaptics))
#define G_SYNAPTICS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), G_TYPE_SYNAPTICS, GSynapticsClass))
#define G_IS_SYNAPTICS(obj)	    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_SYNAPTICS))
#define G_IS_SYNAPTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_TYPE_SYNAPTICS))
#define G_SYNAPTICS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), G_TYPE_SYNAPTICS, GSynapticsClass))

typedef struct _GSynaptics      GSynaptics;
typedef struct _GSynapticsClass	GSynapticsClass;

struct _GSynaptics
{
	GObject   parent;
};

struct _GSynapticsClass
{
	GObjectClass parent_class;
};

typedef enum
{
	NoTrigger=-1,
	AllCorners=0,
	TopEdge,
	TopRightCorner,
	RightEdge,
	BottomRightCorner,
	BottomEdge,
	BottomLeftCorner,
	LeftEdge,
	TopLeftCorner
} ScrollTrigger;

typedef enum
{
	None=0,
	Left,
	Middle,
	Right
} Button;

GType		g_synaptics_get_type (void);
GSynaptics     *g_synaptics_new      (void);

gboolean	g_synaptics_is_available		(GSynaptics *synaptics);

gboolean	g_synaptics_is_enabled                  (GSynaptics *synaptics);
void		g_synaptics_edges                       (GSynaptics *synaptics);
gboolean	g_synaptics_is_tapping_enabled          (GSynaptics *synaptics);
gint		g_synaptics_tap_time                    (GSynaptics *synaptics);
gint		g_synaptics_tap_action                  (GSynaptics *synaptics,
							 TapType     type );
gint		g_synaptics_sensitivity                 (GSynaptics *synaptics);
gboolean	g_synaptics_is_horizontal_scroll_enabled(GSynaptics *synaptics);
gint		g_synaptics_horizontal_scroll_delta     (GSynaptics *synaptics);
gboolean	g_synaptics_is_vertical_scroll_enabled  (GSynaptics *synaptics);
gint		g_synaptics_vertical_scroll_delta       (GSynaptics *synaptics);
gboolean	g_synaptics_is_edge_motion_enabled      (GSynaptics *synaptics);
gboolean	g_synaptics_is_coasting_enabled         (GSynaptics *synaptics);
gboolean	g_synaptics_is_circular_scroll_enabled  (GSynaptics *synaptics);
gint		g_synaptics_circular_scroll_delta       (GSynaptics *synaptics);
ScrollTrigger	g_synaptics_circular_scroll_trigger     (GSynaptics *synaptics);
Button		g_synaptics_button_for_tap              (GSynaptics *synaptics,
							 TapType     tap );
gboolean	g_synaptics_are_fast_taps_enabled       (GSynaptics *synaptics);
gint		g_synaptics_abs_coord_x                 (GSynaptics *synaptics);
gint		g_synaptics_abs_coord_y                 (GSynaptics *synaptics);

void		g_synaptics_set_enabled                 (GSynaptics *synaptics,
							 gint        enable);
void		g_synaptics_set_edges                   (GSynaptics *synaptics);
void		g_synaptics_set_tap_time                (GSynaptics *synaptics,
							 gint        time);
void		g_synaptics_set_tap_action              (GSynaptics *synaptics,
							 TapType     type,
							 int         action);
void		g_synaptics_set_sensitivity             (GSynaptics *synaptics,
							 gint        value);
void		g_synaptics_set_horizontal_scroll_delta (GSynaptics *synaptics,
							 gint        delta);
void		g_synaptics_set_vertical_scroll_delta   (GSynaptics *synaptics,
							 gint        delta);
void		g_synaptics_set_circular_scroll_enabled (GSynaptics *synaptics,
							 gboolean    enable);
void		g_synaptics_set_edge_motion_enabled     (GSynaptics *synaptics,
							 gboolean    enable);
void		g_synaptics_set_coasting_enabled        (GSynaptics *synaptics,
							 gboolean    enable);
void		g_synaptics_set_circular_scroll_delta   (GSynaptics *synaptics,
							 gint        delta);
void		g_synaptics_set_circular_scroll_trigger (GSynaptics *synaptics,
							 ScrollTrigger t);
void		g_synaptics_set_button_for_tap          (GSynaptics *synaptics,
							 TapType     tap,
							 Button      button);
void		g_synaptics_set_fast_taps               (GSynaptics *synaptics,
							 gboolean    enable);

G_END_DECLS

#endif /* __G_SYNAPTICS_H__ */
