/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Dialog;
import java.awt.GridLayout;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.Timer;
import jp.sourceforge.gtibuilder.editor.DefaultFilePreference;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.EditorUpdataManager;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.util.StringArray;

public class Editor
extends JInternalFrame
implements ProjectFile {
    private EditorComponent ecomp = null;
    private Timer timer = null;
    private EditorUpdataManager eumanager = null;
    private StringArray infomation = null;

    public Editor(EditorComponent editorComponent) {
        super("", true, true, true, true);
        this.init(editorComponent);
    }

    protected final void init(EditorComponent editorComponent) {
        if (editorComponent == null) {
            throw new NullPointerException();
        }
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.ecomp = editorComponent;
        this.getContentPane().add(this.ecomp.getComponent());
        this.setTitle(this.ecomp.getFileName());
        this.setDefaultCloseOperation(1);
        this.infomation = new StringArray();
        this.eumanager = new EditorUpdataManager();
        this.ecomp.addEditorUpdataListener(this.eumanager);
        this.ecomp.addEditorUpdataListener(new Listener());
    }

    public boolean readData(byte[] byArray) {
        return this.ecomp.readData(byArray);
    }

    public byte[] getData() {
        return this.ecomp.getData();
    }

    public FileType getFileType() {
        return this.ecomp.getFileType();
    }

    public boolean setFileType(FileType fileType) {
        if (this.ecomp.isSupportedType(fileType)) {
            return this.ecomp.setFileType(fileType);
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        return this.ecomp.isAutoCheckProperty();
    }

    public String getFileName() {
        return this.ecomp.getFileName();
    }

    public boolean setFileName(String string) {
        if (this.isAutoCheckProperty()) {
            return false;
        }
        return this.ecomp.setFileName(string);
    }

    public String getDirectory() {
        return this.ecomp.getDirectory();
    }

    public void setInfomation(String string, String string2) {
        if (!this.infomation.add(string, string2)) {
            this.infomation.change(string, string2);
        }
    }

    public String getInfomation(String string) {
        return (String)this.infomation.getContent(string);
    }

    public EditorComponent getEditorComponent() {
        return this.ecomp;
    }

    public boolean setDirectory(String string) {
        return this.ecomp.setDirectory(string);
    }

    public JMenu[] usingMenu() {
        return this.ecomp.usingMenu();
    }

    public boolean usingEditMenu() {
        return this.ecomp.usingEditMenu();
    }

    public boolean close() {
        return this.ecomp.close();
    }

    public void copy() {
        this.ecomp.copy();
    }

    public void cut() {
        this.ecomp.cut();
    }

    public void delete() {
        this.ecomp.delete();
    }

    public void paste() {
        this.ecomp.paste();
    }

    public void undo() {
        this.ecomp.undo();
    }

    public void redo() {
        this.ecomp.redo();
    }

    public void saved() {
        this.ecomp.saved();
    }

    public void showFilePreference() {
        Dialog dialog = this.ecomp.getFilePreference();
        if (dialog != null) {
            dialog.show();
        } else {
            new DefaultFilePreference(null, true, this.ecomp).show();
        }
    }

    public void compiled() {
        this.ecomp.compiled();
    }

    public boolean isCompiled() {
        return this.ecomp.isCompiled();
    }

    public boolean isEdited() {
        return this.ecomp.isEdited();
    }

    public void addEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eumanager.addEditorUpdataListener(editorUpdataListener);
    }

    public void removeEditorUpdataListener(EditorUpdataListener editorUpdataListener) {
        this.eumanager.removeEditorUpdataListener(editorUpdataListener);
    }

    private class Listener
    implements EditorUpdataListener {
        private Listener() {
        }

        public void updataEditor(EditorUpdataEvent editorUpdataEvent) {
            Editor.this.setTitle(editorUpdataEvent.getNewName());
        }
    }
}

