/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.Welcome;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class ProjectReader {
    private ProjectReader() {
    }

    public static Project read(File file, ProjectManager projectManager, boolean bl) {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            JProgressBar jProgressBar = null;
            if (bl) {
                MainWindow.getMainWindow().showProgressBar();
                MainWindow.getMainWindow().setStatus("Reading : " + file.getAbsolutePath());
                jProgressBar = MainWindow.getMainWindow().getProgressBar();
                jProgressBar.setMinimum(0);
                jProgressBar.setMaximum(n + 1);
                jProgressBar.setValue(0);
            }
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = null;
            Project project = null;
            Vector<Editor> vector = new Vector<Editor>();
            if (bl) {
                jProgressBar.setValue(1);
                jProgressBar.setStringPainted(true);
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] byArray;
                int n2;
                if (zipEntry.getName().equals("gtibuilder")) {
                    if (bl) {
                        MainWindow.getMainWindow().getProgressBar().setString("Reading : Project Info");
                    }
                    object = new ByteArrayOutputStream();
                    n2 = 0;
                    while ((n2 = ((InflaterInputStream)zipInputStream).read()) != -1) {
                        ((ByteArrayOutputStream)object).write(n2);
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                    project = new Project(byArray, projectManager.getWindowManager());
                    if (bl) {
                        jProgressBar.setValue(jProgressBar.getValue() + 1);
                    }
                } else {
                    Object object2;
                    String string;
                    Object object3;
                    if (bl) {
                        MainWindow.getMainWindow().getProgressBar().setString("Reading : " + zipEntry.getName());
                    }
                    object = new ByteArrayOutputStream();
                    n2 = 0;
                    while ((n2 = ((InflaterInputStream)zipInputStream).read()) != -1) {
                        ((ByteArrayOutputStream)object).write(n2);
                    }
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                    Object object4 = null;
                    Object object5 = null;
                    FileType fileType = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        object3 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "UTF-8"));
                        string = new String();
                        while (!(string = ((BufferedReader)object3).readLine()).equals("")) {
                            object2 = TextBuffer.cutString(string, "=");
                            if (object2[0].equals("Directory_Name") && object2[1] != null && !object2[1].equals("")) {
                                object4 = object2[1];
                            }
                            if (object2[0].equals("File_Name") && object2[1] != null && !((String)object2[1]).equals("")) {
                                object5 = object2[1];
                            }
                            if (object2[0].equals("Mime_Type") && object2[1] != null && !((String)object2[1]).equals("")) {
                                fileType = FileDataBase.getWithMime((String)object2[1]);
                            }
                            stringBuffer.append(string + "\n");
                        }
                    }
                    catch (Exception exception) {
                        ErrorDialog.showError(exception);
                    }
                    stringBuffer.append("\n");
                    object3 = new byte[byArray.length - stringBuffer.toString().length()];
                    System.arraycopy(byArray, stringBuffer.toString().length(), object3, 0, ((Object)object3).length);
                    string = ((String)object5).substring(((String)object5).lastIndexOf(46) + 1);
                    if (fileType == null) {
                        fileType = FileDataBase.getWithExtension(string);
                    }
                    if ((object2 = fileType.getEditor()) != null) {
                        StringArray stringArray = new StringArray();
                        stringArray.add("DIRECTORY", object4);
                        stringArray.add("NAME", object5);
                        object2.init(stringArray, fileType);
                        vector.addElement(new Editor((EditorComponent)object2));
                    }
                    object2.readData((byte[])object3);
                    if (bl) {
                        jProgressBar.setValue(jProgressBar.getValue() + 1);
                    } else {
                        Welcome.getWelcome().repaint();
                    }
                }
                zipInputStream.closeEntry();
            }
            if (bl) {
                jProgressBar.setString("Closing");
            }
            zipInputStream.close();
            if (project != null) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    project.addEditor((Editor)object.nextElement());
                }
                project.setSaveFile(file);
                if (bl) {
                    jProgressBar.setValue(jProgressBar.getMaximum());
                    jProgressBar.setString("");
                    jProgressBar.setStringPainted(false);
                    MainWindow.getMainWindow().hideProgressBar();
                    MainWindow.getMainWindow().setStatus("Done.");
                }
                return project;
            }
            if (bl) {
                MainWindow.getMainWindow().hideProgressBar();
                MainWindow.getMainWindow().setStatus("Error! Did not found Project Info.");
            }
            return null;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(MainWindow.getMainWindow(), "IO Error happend.so you cannot open this file.", "IO Error", 0);
            ErrorDialog.showError(iOException);
            return null;
        }
    }
}

