/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;
import jp.sourceforge.gtibuilder.main.MainWindow;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.ErrorDialog;

public class ProjectWriter {
    public static String HEADER_LAST = "END_OF_HEADER";

    private ProjectWriter() {
    }

    public static void save(File file, Project project) {
        try {
            ZipEntry zipEntry;
            ProjectFile[] projectFileArray = project.getProjectFiles();
            MainWindow.getMainWindow().showProgressBar();
            MainWindow.getMainWindow().setStatus("Saveing : " + file.getAbsolutePath());
            JProgressBar jProgressBar = MainWindow.getMainWindow().getProgressBar();
            jProgressBar.setMinimum(0);
            jProgressBar.setMaximum(projectFileArray.length + 3);
            jProgressBar.setValue(0);
            jProgressBar.setStringPainted(true);
            jProgressBar.setString("Opening file");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            jProgressBar.setValue(1);
            for (int i = 0; projectFileArray.length > i; ++i) {
                Object object;
                zipEntry = new ZipEntry("DATA-" + i);
                byte[] byArray = null;
                try {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Directory_Name=");
                    if (projectFileArray[i].getDirectory() == null) {
                        ((StringBuffer)object).append("");
                    } else {
                        ((StringBuffer)object).append(projectFileArray[i].getDirectory());
                    }
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append("File_Name=");
                    ((StringBuffer)object).append(projectFileArray[i].getFileName());
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append("Mime_Type=");
                    ((StringBuffer)object).append(projectFileArray[i].getFileType().getMimeType());
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append("\n");
                    byArray = ((StringBuffer)object).toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ErrorDialog.showError(unsupportedEncodingException);
                }
                jProgressBar.setString("Writing : " + zipEntry.getName());
                zipOutputStream.putNextEntry(zipEntry);
                object = projectFileArray[i];
                byte[] byArray2 = object.getData();
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                zipOutputStream.write(byArray3);
                zipOutputStream.closeEntry();
                jProgressBar.setValue(jProgressBar.getValue() + 1);
                projectFileArray[i].saved();
            }
            jProgressBar.setString("Writing : Project Info");
            zipEntry = new ZipEntry("gtibuilder");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(project.getProjectInfo());
            zipOutputStream.closeEntry();
            jProgressBar.setValue(jProgressBar.getValue() + 1);
            jProgressBar.setString("Closing : Project Info");
            zipOutputStream.close();
            jProgressBar.setValue(jProgressBar.getMaximum());
            jProgressBar.setStringPainted(false);
            jProgressBar.setString("");
            MainWindow.getMainWindow().hideProgressBar();
            MainWindow.getMainWindow().setStatus("Done.");
        }
        catch (IOException iOException) {
            MainWindow.getMainWindow().getProgressBar().setStringPainted(false);
            MainWindow.getMainWindow().getProgressBar().setString("");
            MainWindow.getMainWindow().hideProgressBar();
            MainWindow.getMainWindow().setStatus("Error.");
            ErrorDialog.showError(iOException);
        }
    }
}

