/*
    dirent
    Copyright (C) 2007 Kazuki IWAMOTO

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef _DIRENT_H_
#define _DIRENT_H_


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define _dirent dirent
#define _DIR DIR
#define _opendir opendir
#define _readdir readdir
#define _closedir closedir
#define _rewinddir rewinddir
#define _telldir telldir
#define _seekdir seekdir
#define _wdirent wdirent
#define _WDIR WDIR
#define _wopendir wopendir
#define _wreaddir wreaddir
#define _wclosedir wclosedir
#define _wrewinddir wrewinddir
#define _wtelldir wtelldir
#define _wseekdir wseekdir
#define _tdirent tdirent
#define _TDIR TDIR
#define _topendir topendir
#define _treaddir treaddir
#define _tclosedir tclosedir
#define _trewinddir trewinddir
#define _ttelldir ttelldir
#define _tseekdir tseekdir
#ifdef UNICODE
# define tdirent wdirent
# define TDIR _WDIR
# define topendir wopendir
# define treaddir wreaddir
# define tclosedir wclosedir
# define trewinddir wrewinddir
# define ttelldir wtelldir
# define tseekdir wseekdir
#else /* not UNICODE */
# define tdirent dirent
# define TDIR _DIR
# define topendir opendir
# define treaddir readdir
# define tclosedir closedir
# define trewinddir rewinddir
# define ttelldir telldir
# define tseekdir seekdir
#endif /* not UNICODE */


typedef struct dirent
{
  long           d_ino;
  unsigned short d_reclen;
  unsigned short d_namlen;
  char           d_name[MAX_PATH];
} DIRENT;
typedef struct dir
{
  int           nStat;
  CHAR          szPath[MAX_PATH];
  HANDLE        hFind;
  struct dirent dd_dir;
} DIR;


typedef struct wdirent
{
  long           d_ino;
  unsigned short d_reclen;
  unsigned short d_namlen;
  wchar_t        d_name[MAX_PATH];
} WDIRENT;
typedef struct wdir
{
  int            nStat;
  WCHAR          szPath[MAX_PATH];
  HANDLE         hFind;
  struct wdirent dd_dir;
} WDIR;


DIR *opendir (const char *);
struct dirent *readdir (DIR *);
int closedir (DIR *);
void rewinddir (DIR *);
long telldir (DIR *);
void seekdir (DIR *, long);


WDIR *wopendir (const wchar_t *);
struct wdirent *wreaddir (WDIR *);
int wclosedir (WDIR *);
void wrewinddir (WDIR *);
long wtelldir (WDIR *);
void wseekdir (WDIR *, long);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _DIRENT_H_ */