/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "kernel32.h"
#include "ia32/message.h"
#include "ia32/module.h"
#include "ia32/stack.h"
#include "misc/peimage.h"


/* AcquireSRWLockExclusive ordinal = 3, argument = 4 */
static gboolean kernel32_AcquireSRWLockExclusive (Ia32Thread *thread)
{
  return FALSE;
}


/* AcquireSRWLockShared ordinal = 4, argument = 4 */
static gboolean kernel32_AcquireSRWLockShared (Ia32Thread *thread)
{
  return FALSE;
}


/* ActivateActCtx ordinal = 5, argument = 8 */
static gboolean kernel32_ActivateActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* AddAtomA ordinal = 6, argument = 4 */
static gboolean kernel32_AddAtomA (Ia32Thread *thread)
{
  return FALSE;
}


/* AddAtomW ordinal = 7, argument = 4 */
static gboolean kernel32_AddAtomW (Ia32Thread *thread)
{
  return FALSE;
}


/* AddConsoleAliasA ordinal = 8, argument = 12 */
static gboolean kernel32_AddConsoleAliasA (Ia32Thread *thread)
{
  return FALSE;
}


/* AddConsoleAliasW ordinal = 9, argument = 12 */
static gboolean kernel32_AddConsoleAliasW (Ia32Thread *thread)
{
  return FALSE;
}


/* AddIntegrityLabelToBoundaryDescriptor ordinal = 10, argument = 0 */
static gboolean kernel32_AddIntegrityLabelToBoundaryDescriptor (Ia32Thread *thread)
{
  return FALSE;
}


/* AddLocalAlternateComputerNameA ordinal = 11, argument = 8 */
static gboolean kernel32_AddLocalAlternateComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* AddLocalAlternateComputerNameW ordinal = 12, argument = 8 */
static gboolean kernel32_AddLocalAlternateComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* AddRefActCtx ordinal = 13, argument = 4 */
static gboolean kernel32_AddRefActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* AddSIDToBoundaryDescriptor ordinal = 14, argument = 8 */
static gboolean kernel32_AddSIDToBoundaryDescriptor (Ia32Thread *thread)
{
  return FALSE;
}


/* AddSecureMemoryCacheCallback ordinal = 15, argument = 0 */
static gboolean kernel32_AddSecureMemoryCacheCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* AddVectoredContinueHandler ordinal = 16, argument = 8 */
static gboolean kernel32_AddVectoredContinueHandler (Ia32Thread *thread)
{
  return FALSE;
}


/* AddVectoredExceptionHandler ordinal = 17, argument = 8 */
static gboolean kernel32_AddVectoredExceptionHandler (Ia32Thread *thread)
{
  return FALSE;
}


/* AdjustCalendarDate ordinal = 18, argument = 0 */
static gboolean kernel32_AdjustCalendarDate (Ia32Thread *thread)
{
  return FALSE;
}


/* AllocConsole ordinal = 19, argument = 0 */
static gboolean kernel32_AllocConsole (Ia32Thread *thread)
{
  return FALSE;
}


/* AllocateUserPhysicalPages ordinal = 20, argument = 12 */
static gboolean kernel32_AllocateUserPhysicalPages (Ia32Thread *thread)
{
  return FALSE;
}


/* AllocateUserPhysicalPagesNuma ordinal = 21, argument = 16 */
static gboolean kernel32_AllocateUserPhysicalPagesNuma (Ia32Thread *thread)
{
  return FALSE;
}


/* ApplicationRecoveryFinished ordinal = 22, argument = 4 */
static gboolean kernel32_ApplicationRecoveryFinished (Ia32Thread *thread)
{
  return FALSE;
}


/* ApplicationRecoveryInProgress ordinal = 23, argument = 4 */
static gboolean kernel32_ApplicationRecoveryInProgress (Ia32Thread *thread)
{
  return FALSE;
}


/* AreFileApisANSI ordinal = 24, argument = 0 */
static gboolean kernel32_AreFileApisANSI (Ia32Thread *thread)
{
  return FALSE;
}


/* AssignProcessToJobObject ordinal = 25, argument = 8 */
static gboolean kernel32_AssignProcessToJobObject (Ia32Thread *thread)
{
  return FALSE;
}


/* AttachConsole ordinal = 26, argument = 4 */
static gboolean kernel32_AttachConsole (Ia32Thread *thread)
{
  return FALSE;
}


/* BackupRead ordinal = 27, argument = 28 */
static gboolean kernel32_BackupRead (Ia32Thread *thread)
{
  return FALSE;
}


/* BackupSeek ordinal = 28, argument = 24 */
static gboolean kernel32_BackupSeek (Ia32Thread *thread)
{
  return FALSE;
}


/* BackupWrite ordinal = 29, argument = 28 */
static gboolean kernel32_BackupWrite (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseCheckAppcompatCache ordinal = 30, argument = 0 */
static gboolean kernel32_BaseCheckAppcompatCache (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseCheckAppcompatCacheEx ordinal = 31, argument = 0 */
static gboolean kernel32_BaseCheckAppcompatCacheEx (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseCheckRunApp ordinal = 32, argument = 0 */
static gboolean kernel32_BaseCheckRunApp (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseCleanupAppcompatCacheSupport ordinal = 33, argument = 0 */
static gboolean kernel32_BaseCleanupAppcompatCacheSupport (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseDllReadWriteIniFile ordinal = 34, argument = 0 */
static gboolean kernel32_BaseDllReadWriteIniFile (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseDumpAppcompatCache ordinal = 35, argument = 0 */
static gboolean kernel32_BaseDumpAppcompatCache (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseFlushAppcompatCache ordinal = 36, argument = 0 */
static gboolean kernel32_BaseFlushAppcompatCache (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseFormatObjectAttributes ordinal = 37, argument = 0 */
static gboolean kernel32_BaseFormatObjectAttributes (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseFormatTimeOut ordinal = 38, argument = 0 */
static gboolean kernel32_BaseFormatTimeOut (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseGenerateAppCompatData ordinal = 39, argument = 0 */
static gboolean kernel32_BaseGenerateAppCompatData (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseGetNamedObjectDirectory ordinal = 40, argument = 0 */
static gboolean kernel32_BaseGetNamedObjectDirectory (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseInitAppcompatCacheSupport ordinal = 41, argument = 0 */
static gboolean kernel32_BaseInitAppcompatCacheSupport (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseIsAppcompatInfrastructureDisabled ordinal = 42, argument = 0 */
static gboolean kernel32_BaseIsAppcompatInfrastructureDisabled (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseQueryModuleData ordinal = 43, argument = 0 */
static gboolean kernel32_BaseQueryModuleData (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseSetLastNTError ordinal = 44, argument = 0 */
static gboolean kernel32_BaseSetLastNTError (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseThreadInitThunk ordinal = 1, argument = 0 */
static gboolean kernel32_BaseThreadInitThunk (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseUpdateAppcompatCache ordinal = 45, argument = 0 */
static gboolean kernel32_BaseUpdateAppcompatCache (Ia32Thread *thread)
{
  return FALSE;
}


/* BaseVerifyUnicodeString ordinal = 46, argument = 0 */
static gboolean kernel32_BaseVerifyUnicodeString (Ia32Thread *thread)
{
  return FALSE;
}


/* Basep8BitStringToDynamicUnicodeString ordinal = 47, argument = 0 */
static gboolean kernel32_Basep8BitStringToDynamicUnicodeString (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepAllocateActivationContextActivationBlock ordinal = 48, argument = 0 */
static gboolean kernel32_BasepAllocateActivationContextActivationBlock (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepAnsiStringToDynamicUnicodeString ordinal = 49, argument = 0 */
static gboolean kernel32_BasepAnsiStringToDynamicUnicodeString (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepCheckAppCompat ordinal = 50, argument = 0 */
static gboolean kernel32_BasepCheckAppCompat (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepCheckBadapp ordinal = 51, argument = 0 */
static gboolean kernel32_BasepCheckBadapp (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepCheckWinSaferRestrictions ordinal = 52, argument = 0 */
static gboolean kernel32_BasepCheckWinSaferRestrictions (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepFreeActivationContextActivationBlock ordinal = 53, argument = 0 */
static gboolean kernel32_BasepFreeActivationContextActivationBlock (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepFreeAppCompatData ordinal = 54, argument = 0 */
static gboolean kernel32_BasepFreeAppCompatData (Ia32Thread *thread)
{
  return FALSE;
}


/* BasepMapModuleHandle ordinal = 55, argument = 0 */
static gboolean kernel32_BasepMapModuleHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* Beep ordinal = 56, argument = 8 */
static gboolean kernel32_Beep (Ia32Thread *thread)
{
  return FALSE;
}


/* BeginUpdateResourceA ordinal = 57, argument = 8 */
static gboolean kernel32_BeginUpdateResourceA (Ia32Thread *thread)
{
  return FALSE;
}


/* BeginUpdateResourceW ordinal = 58, argument = 8 */
static gboolean kernel32_BeginUpdateResourceW (Ia32Thread *thread)
{
  return FALSE;
}


/* BindIoCompletionCallback ordinal = 59, argument = 12 */
static gboolean kernel32_BindIoCompletionCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* BuildCommDCBA ordinal = 60, argument = 8 */
static gboolean kernel32_BuildCommDCBA (Ia32Thread *thread)
{
  return FALSE;
}


/* BuildCommDCBAndTimeoutsA ordinal = 61, argument = 12 */
static gboolean kernel32_BuildCommDCBAndTimeoutsA (Ia32Thread *thread)
{
  return FALSE;
}


/* BuildCommDCBAndTimeoutsW ordinal = 62, argument = 12 */
static gboolean kernel32_BuildCommDCBAndTimeoutsW (Ia32Thread *thread)
{
  return FALSE;
}


/* BuildCommDCBW ordinal = 63, argument = 8 */
static gboolean kernel32_BuildCommDCBW (Ia32Thread *thread)
{
  return FALSE;
}


/* CallNamedPipeA ordinal = 64, argument = 28 */
static gboolean kernel32_CallNamedPipeA (Ia32Thread *thread)
{
  return FALSE;
}


/* CallNamedPipeW ordinal = 65, argument = 28 */
static gboolean kernel32_CallNamedPipeW (Ia32Thread *thread)
{
  return FALSE;
}


/* CallbackMayRunLong ordinal = 66, argument = 4 */
static gboolean kernel32_CallbackMayRunLong (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelDeviceWakeupRequest ordinal = 67, argument = 4 */
static gboolean kernel32_CancelDeviceWakeupRequest (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelIo ordinal = 68, argument = 4 */
static gboolean kernel32_CancelIo (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelIoEx ordinal = 69, argument = 8 */
static gboolean kernel32_CancelIoEx (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelSynchronousIo ordinal = 70, argument = 4 */
static gboolean kernel32_CancelSynchronousIo (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelThreadpoolIo ordinal = 71, argument = 4 */
static gboolean kernel32_CancelThreadpoolIo (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelTimerQueueTimer ordinal = 72, argument = 8 */
static gboolean kernel32_CancelTimerQueueTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* CancelWaitableTimer ordinal = 73, argument = 4 */
static gboolean kernel32_CancelWaitableTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* ChangeTimerQueueTimer ordinal = 74, argument = 16 */
static gboolean kernel32_ChangeTimerQueueTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckElevation ordinal = 75, argument = 0 */
static gboolean kernel32_CheckElevation (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckElevationEnabled ordinal = 76, argument = 0 */
static gboolean kernel32_CheckElevationEnabled (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckForReadOnlyResource ordinal = 77, argument = 0 */
static gboolean kernel32_CheckForReadOnlyResource (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckNameLegalDOS8Dot3A ordinal = 78, argument = 20 */
static gboolean kernel32_CheckNameLegalDOS8Dot3A (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckNameLegalDOS8Dot3W ordinal = 79, argument = 20 */
static gboolean kernel32_CheckNameLegalDOS8Dot3W (Ia32Thread *thread)
{
  return FALSE;
}


/* CheckRemoteDebuggerPresent ordinal = 80, argument = 8 */
static gboolean kernel32_CheckRemoteDebuggerPresent (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_stack_value (thread, 2);
  thread->reg.eax = ia32_memory_write_dword (thread->process,
                                                        address, FALSE, -1);
  ia32_message_record_api_with_argument (thread,
                                "CheckRemoteDebuggerPresent", IA32_MESSAGE_DEC,
                                "hProcess", IA32_MESSAGE_HEX,
                                "pbDebuggerPresent", IA32_MESSAGE_HEX,
                                NULL);
  return TRUE;
}


/* ClearCommBreak ordinal = 81, argument = 4 */
static gboolean kernel32_ClearCommBreak (Ia32Thread *thread)
{
  return FALSE;
}


/* ClearCommError ordinal = 82, argument = 12 */
static gboolean kernel32_ClearCommError (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseConsoleHandle ordinal = 83, argument = 0 */
static gboolean kernel32_CloseConsoleHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseHandle ordinal = 84, argument = 4 */
static gboolean kernel32_CloseHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* ClosePrivateNamespace ordinal = 85, argument = 8 */
static gboolean kernel32_ClosePrivateNamespace (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseProfileUserMapping ordinal = 86, argument = 0 */
static gboolean kernel32_CloseProfileUserMapping (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpool ordinal = 87, argument = 4 */
static gboolean kernel32_CloseThreadpool (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolCleanupGroup ordinal = 88, argument = 4 */
static gboolean kernel32_CloseThreadpoolCleanupGroup (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolCleanupGroupMembers ordinal = 89, argument = 12 */
static gboolean kernel32_CloseThreadpoolCleanupGroupMembers (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolIo ordinal = 90, argument = 4 */
static gboolean kernel32_CloseThreadpoolIo (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolTimer ordinal = 91, argument = 4 */
static gboolean kernel32_CloseThreadpoolTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolWait ordinal = 92, argument = 4 */
static gboolean kernel32_CloseThreadpoolWait (Ia32Thread *thread)
{
  return FALSE;
}


/* CloseThreadpoolWork ordinal = 93, argument = 4 */
static gboolean kernel32_CloseThreadpoolWork (Ia32Thread *thread)
{
  return FALSE;
}


/* CmdBatNotification ordinal = 94, argument = 0 */
static gboolean kernel32_CmdBatNotification (Ia32Thread *thread)
{
  return FALSE;
}


/* CommConfigDialogA ordinal = 95, argument = 12 */
static gboolean kernel32_CommConfigDialogA (Ia32Thread *thread)
{
  return FALSE;
}


/* CommConfigDialogW ordinal = 96, argument = 12 */
static gboolean kernel32_CommConfigDialogW (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareCalendarDates ordinal = 97, argument = 0 */
static gboolean kernel32_CompareCalendarDates (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareFileTime ordinal = 98, argument = 8 */
static gboolean kernel32_CompareFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareStringA ordinal = 99, argument = 24 */
static gboolean kernel32_CompareStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareStringEx ordinal = 100, argument = 36 */
static gboolean kernel32_CompareStringEx (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareStringOrdinal ordinal = 101, argument = 20 */
static gboolean kernel32_CompareStringOrdinal (Ia32Thread *thread)
{
  return FALSE;
}


/* CompareStringW ordinal = 102, argument = 24 */
static gboolean kernel32_CompareStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* ConnectNamedPipe ordinal = 103, argument = 8 */
static gboolean kernel32_ConnectNamedPipe (Ia32Thread *thread)
{
  return FALSE;
}


/* ConsoleMenuControl ordinal = 104, argument = 0 */
static gboolean kernel32_ConsoleMenuControl (Ia32Thread *thread)
{
  return FALSE;
}


/* ContinueDebugEvent ordinal = 105, argument = 12 */
static gboolean kernel32_ContinueDebugEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertCalDateTimeToSystemTime ordinal = 106, argument = 0 */
static gboolean kernel32_ConvertCalDateTimeToSystemTime (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertDefaultLocale ordinal = 107, argument = 4 */
static gboolean kernel32_ConvertDefaultLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertFiberToThread ordinal = 108, argument = 0 */
static gboolean kernel32_ConvertFiberToThread (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertNLSDayOfWeekToWin32DayOfWeek ordinal = 109, argument = 0 */
static gboolean kernel32_ConvertNLSDayOfWeekToWin32DayOfWeek (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertSystemTimeToCalDateTime ordinal = 110, argument = 0 */
static gboolean kernel32_ConvertSystemTimeToCalDateTime (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertThreadToFiber ordinal = 111, argument = 4 */
static gboolean kernel32_ConvertThreadToFiber (Ia32Thread *thread)
{
  return FALSE;
}


/* ConvertThreadToFiberEx ordinal = 112, argument = 8 */
static gboolean kernel32_ConvertThreadToFiberEx (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyExtendedContext ordinal = 113, argument = 0 */
static gboolean kernel32_CopyExtendedContext (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileA ordinal = 114, argument = 12 */
static gboolean kernel32_CopyFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileExA ordinal = 115, argument = 24 */
static gboolean kernel32_CopyFileExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileExW ordinal = 116, argument = 24 */
static gboolean kernel32_CopyFileExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileTransactedA ordinal = 117, argument = 28 */
static gboolean kernel32_CopyFileTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileTransactedW ordinal = 118, argument = 28 */
static gboolean kernel32_CopyFileTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyFileW ordinal = 119, argument = 12 */
static gboolean kernel32_CopyFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* CopyLZFile ordinal = 120, argument = 0 */
static gboolean kernel32_CopyLZFile (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateActCtxA ordinal = 121, argument = 4 */
static gboolean kernel32_CreateActCtxA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateActCtxW ordinal = 122, argument = 4 */
static gboolean kernel32_CreateActCtxW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateBoundaryDescriptorA ordinal = 123, argument = 8 */
static gboolean kernel32_CreateBoundaryDescriptorA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateBoundaryDescriptorW ordinal = 124, argument = 8 */
static gboolean kernel32_CreateBoundaryDescriptorW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateConsoleScreenBuffer ordinal = 125, argument = 20 */
static gboolean kernel32_CreateConsoleScreenBuffer (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryA ordinal = 126, argument = 8 */
static gboolean kernel32_CreateDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryExA ordinal = 127, argument = 12 */
static gboolean kernel32_CreateDirectoryExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryExW ordinal = 128, argument = 12 */
static gboolean kernel32_CreateDirectoryExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryTransactedA ordinal = 129, argument = 16 */
static gboolean kernel32_CreateDirectoryTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryTransactedW ordinal = 130, argument = 16 */
static gboolean kernel32_CreateDirectoryTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateDirectoryW ordinal = 131, argument = 8 */
static gboolean kernel32_CreateDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateEventA ordinal = 132, argument = 16 */
static gboolean kernel32_CreateEventA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateEventExA ordinal = 133, argument = 16 */
static gboolean kernel32_CreateEventExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateEventExW ordinal = 134, argument = 16 */
static gboolean kernel32_CreateEventExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateEventW ordinal = 135, argument = 16 */
static gboolean kernel32_CreateEventW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFiber ordinal = 136, argument = 12 */
static gboolean kernel32_CreateFiber (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFiberEx ordinal = 137, argument = 20 */
static gboolean kernel32_CreateFiberEx (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileA ordinal = 138, argument = 28 */
static gboolean kernel32_CreateFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileMappingA ordinal = 139, argument = 24 */
static gboolean kernel32_CreateFileMappingA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileMappingNumaA ordinal = 140, argument = 28 */
static gboolean kernel32_CreateFileMappingNumaA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileMappingNumaW ordinal = 141, argument = 28 */
static gboolean kernel32_CreateFileMappingNumaW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileMappingW ordinal = 142, argument = 24 */
static gboolean kernel32_CreateFileMappingW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileTransactedA ordinal = 143, argument = 40 */
static gboolean kernel32_CreateFileTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileTransactedW ordinal = 144, argument = 40 */
static gboolean kernel32_CreateFileTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateFileW ordinal = 145, argument = 28 */
static gboolean kernel32_CreateFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateHardLinkA ordinal = 146, argument = 12 */
static gboolean kernel32_CreateHardLinkA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateHardLinkTransactedA ordinal = 147, argument = 16 */
static gboolean kernel32_CreateHardLinkTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateHardLinkTransactedW ordinal = 148, argument = 16 */
static gboolean kernel32_CreateHardLinkTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateHardLinkW ordinal = 149, argument = 12 */
static gboolean kernel32_CreateHardLinkW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateIoCompletionPort ordinal = 150, argument = 16 */
static gboolean kernel32_CreateIoCompletionPort (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateJobObjectA ordinal = 151, argument = 8 */
static gboolean kernel32_CreateJobObjectA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateJobObjectW ordinal = 152, argument = 8 */
static gboolean kernel32_CreateJobObjectW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateJobSet ordinal = 153, argument = 12 */
static gboolean kernel32_CreateJobSet (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMailslotA ordinal = 154, argument = 16 */
static gboolean kernel32_CreateMailslotA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMailslotW ordinal = 155, argument = 16 */
static gboolean kernel32_CreateMailslotW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMemoryResourceNotification ordinal = 156, argument = 4 */
static gboolean kernel32_CreateMemoryResourceNotification (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMutexA ordinal = 157, argument = 12 */
static gboolean kernel32_CreateMutexA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMutexExA ordinal = 158, argument = 16 */
static gboolean kernel32_CreateMutexExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMutexExW ordinal = 159, argument = 16 */
static gboolean kernel32_CreateMutexExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateMutexW ordinal = 160, argument = 12 */
static gboolean kernel32_CreateMutexW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateNamedPipeA ordinal = 161, argument = 32 */
static gboolean kernel32_CreateNamedPipeA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateNamedPipeW ordinal = 162, argument = 32 */
static gboolean kernel32_CreateNamedPipeW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreatePipe ordinal = 163, argument = 16 */
static gboolean kernel32_CreatePipe (Ia32Thread *thread)
{
  return FALSE;
}


/* CreatePrivateNamespaceA ordinal = 164, argument = 12 */
static gboolean kernel32_CreatePrivateNamespaceA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreatePrivateNamespaceW ordinal = 165, argument = 12 */
static gboolean kernel32_CreatePrivateNamespaceW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateProcessA ordinal = 166, argument = 40 */
static gboolean kernel32_CreateProcessA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateProcessAsUserW ordinal = 167, argument = 0 */
static gboolean kernel32_CreateProcessAsUserW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateProcessInternalA ordinal = 168, argument = 0 */
static gboolean kernel32_CreateProcessInternalA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateProcessInternalW ordinal = 169, argument = 0 */
static gboolean kernel32_CreateProcessInternalW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateProcessW ordinal = 170, argument = 40 */
static gboolean kernel32_CreateProcessW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateRemoteThread ordinal = 171, argument = 28 */
static gboolean kernel32_CreateRemoteThread (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateRemoteThreadEx ordinal = 172, argument = 0 */
static gboolean kernel32_CreateRemoteThreadEx (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSemaphoreA ordinal = 173, argument = 16 */
static gboolean kernel32_CreateSemaphoreA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSemaphoreExA ordinal = 174, argument = 24 */
static gboolean kernel32_CreateSemaphoreExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSemaphoreExW ordinal = 175, argument = 24 */
static gboolean kernel32_CreateSemaphoreExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSemaphoreW ordinal = 176, argument = 16 */
static gboolean kernel32_CreateSemaphoreW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSocketHandle ordinal = 177, argument = 0 */
static gboolean kernel32_CreateSocketHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSymbolicLinkA ordinal = 178, argument = 12 */
static gboolean kernel32_CreateSymbolicLinkA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSymbolicLinkTransactedA ordinal = 179, argument = 16 */
static gboolean kernel32_CreateSymbolicLinkTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSymbolicLinkTransactedW ordinal = 180, argument = 16 */
static gboolean kernel32_CreateSymbolicLinkTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateSymbolicLinkW ordinal = 181, argument = 12 */
static gboolean kernel32_CreateSymbolicLinkW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateTapePartition ordinal = 182, argument = 16 */
static gboolean kernel32_CreateTapePartition (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThread ordinal = 183, argument = 24 */
static gboolean kernel32_CreateThread (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpool ordinal = 184, argument = 4 */
static gboolean kernel32_CreateThreadpool (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpoolCleanupGroup ordinal = 185, argument = 0 */
static gboolean kernel32_CreateThreadpoolCleanupGroup (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpoolIo ordinal = 186, argument = 16 */
static gboolean kernel32_CreateThreadpoolIo (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpoolTimer ordinal = 187, argument = 12 */
static gboolean kernel32_CreateThreadpoolTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpoolWait ordinal = 188, argument = 12 */
static gboolean kernel32_CreateThreadpoolWait (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateThreadpoolWork ordinal = 189, argument = 12 */
static gboolean kernel32_CreateThreadpoolWork (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateTimerQueue ordinal = 190, argument = 0 */
static gboolean kernel32_CreateTimerQueue (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateTimerQueueTimer ordinal = 191, argument = 28 */
static gboolean kernel32_CreateTimerQueueTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateToolhelp32Snapshot ordinal = 192, argument = 8 */
static gboolean kernel32_CreateToolhelp32Snapshot (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateWaitableTimerA ordinal = 193, argument = 12 */
static gboolean kernel32_CreateWaitableTimerA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateWaitableTimerExA ordinal = 194, argument = 16 */
static gboolean kernel32_CreateWaitableTimerExA (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateWaitableTimerExW ordinal = 195, argument = 16 */
static gboolean kernel32_CreateWaitableTimerExW (Ia32Thread *thread)
{
  return FALSE;
}


/* CreateWaitableTimerW ordinal = 196, argument = 12 */
static gboolean kernel32_CreateWaitableTimerW (Ia32Thread *thread)
{
  return FALSE;
}


/* CtrlRoutine ordinal = 197, argument = 0 */
static gboolean kernel32_CtrlRoutine (Ia32Thread *thread)
{
  return FALSE;
}


/* DeactivateActCtx ordinal = 198, argument = 8 */
static gboolean kernel32_DeactivateActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* DebugActiveProcess ordinal = 199, argument = 4 */
static gboolean kernel32_DebugActiveProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* DebugActiveProcessStop ordinal = 200, argument = 4 */
static gboolean kernel32_DebugActiveProcessStop (Ia32Thread *thread)
{
  return FALSE;
}


/* DebugBreak ordinal = 201, argument = 0 */
static gboolean kernel32_DebugBreak (Ia32Thread *thread)
{
  return FALSE;
}


/* DebugBreakProcess ordinal = 202, argument = 4 */
static gboolean kernel32_DebugBreakProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* DebugSetProcessKillOnExit ordinal = 203, argument = 4 */
static gboolean kernel32_DebugSetProcessKillOnExit (Ia32Thread *thread)
{
  return FALSE;
}


/* DecodePointer ordinal = 204, argument = 4 */
static gboolean kernel32_DecodePointer (Ia32Thread *thread)
{
  return FALSE;
}


/* DecodeSystemPointer ordinal = 205, argument = 4 */
static gboolean kernel32_DecodeSystemPointer (Ia32Thread *thread)
{
  return FALSE;
}


/* DefineDosDeviceA ordinal = 206, argument = 12 */
static gboolean kernel32_DefineDosDeviceA (Ia32Thread *thread)
{
  return FALSE;
}


/* DefineDosDeviceW ordinal = 207, argument = 12 */
static gboolean kernel32_DefineDosDeviceW (Ia32Thread *thread)
{
  return FALSE;
}


/* DelayLoadFailureHook ordinal = 208, argument = 0 */
static gboolean kernel32_DelayLoadFailureHook (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteAtom ordinal = 209, argument = 4 */
static gboolean kernel32_DeleteAtom (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteBoundaryDescriptor ordinal = 210, argument = 4 */
static gboolean kernel32_DeleteBoundaryDescriptor (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteCriticalSection ordinal = 211, argument = 4 */
static gboolean kernel32_DeleteCriticalSection (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteFiber ordinal = 212, argument = 4 */
static gboolean kernel32_DeleteFiber (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteFileA ordinal = 213, argument = 4 */
static gboolean kernel32_DeleteFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteFileTransactedA ordinal = 214, argument = 8 */
static gboolean kernel32_DeleteFileTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteFileTransactedW ordinal = 215, argument = 8 */
static gboolean kernel32_DeleteFileTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteFileW ordinal = 216, argument = 4 */
static gboolean kernel32_DeleteFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteProcThreadAttributeList ordinal = 217, argument = 4 */
static gboolean kernel32_DeleteProcThreadAttributeList (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteTimerQueue ordinal = 218, argument = 4 */
static gboolean kernel32_DeleteTimerQueue (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteTimerQueueEx ordinal = 219, argument = 8 */
static gboolean kernel32_DeleteTimerQueueEx (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteTimerQueueTimer ordinal = 220, argument = 12 */
static gboolean kernel32_DeleteTimerQueueTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteVolumeMountPointA ordinal = 221, argument = 4 */
static gboolean kernel32_DeleteVolumeMountPointA (Ia32Thread *thread)
{
  return FALSE;
}


/* DeleteVolumeMountPointW ordinal = 222, argument = 4 */
static gboolean kernel32_DeleteVolumeMountPointW (Ia32Thread *thread)
{
  return FALSE;
}


/* DeviceIoControl ordinal = 223, argument = 32 */
static gboolean kernel32_DeviceIoControl (Ia32Thread *thread)
{
  return FALSE;
}


/* DisableThreadLibraryCalls ordinal = 224, argument = 4 */
static gboolean kernel32_DisableThreadLibraryCalls (Ia32Thread *thread)
{
  return FALSE;
}


/* DisableThreadProfiling ordinal = 225, argument = 0 */
static gboolean kernel32_DisableThreadProfiling (Ia32Thread *thread)
{
  return FALSE;
}


/* DisassociateCurrentThreadFromCallback ordinal = 226, argument = 4 */
static gboolean kernel32_DisassociateCurrentThreadFromCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* DisconnectNamedPipe ordinal = 227, argument = 4 */
static gboolean kernel32_DisconnectNamedPipe (Ia32Thread *thread)
{
  return FALSE;
}


/* DnsHostnameToComputerNameA ordinal = 228, argument = 12 */
static gboolean kernel32_DnsHostnameToComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* DnsHostnameToComputerNameW ordinal = 229, argument = 12 */
static gboolean kernel32_DnsHostnameToComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* DosDateTimeToFileTime ordinal = 230, argument = 12 */
static gboolean kernel32_DosDateTimeToFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* DosPathToSessionPathA ordinal = 231, argument = 0 */
static gboolean kernel32_DosPathToSessionPathA (Ia32Thread *thread)
{
  return FALSE;
}


/* DosPathToSessionPathW ordinal = 232, argument = 0 */
static gboolean kernel32_DosPathToSessionPathW (Ia32Thread *thread)
{
  return FALSE;
}


/* DuplicateConsoleHandle ordinal = 233, argument = 0 */
static gboolean kernel32_DuplicateConsoleHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* DuplicateHandle ordinal = 234, argument = 28 */
static gboolean kernel32_DuplicateHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* EnableThreadProfiling ordinal = 235, argument = 0 */
static gboolean kernel32_EnableThreadProfiling (Ia32Thread *thread)
{
  return FALSE;
}


/* EncodePointer ordinal = 236, argument = 4 */
static gboolean kernel32_EncodePointer (Ia32Thread *thread)
{
  return FALSE;
}


/* EncodeSystemPointer ordinal = 237, argument = 4 */
static gboolean kernel32_EncodeSystemPointer (Ia32Thread *thread)
{
  return FALSE;
}


/* EndUpdateResourceA ordinal = 238, argument = 8 */
static gboolean kernel32_EndUpdateResourceA (Ia32Thread *thread)
{
  return FALSE;
}


/* EndUpdateResourceW ordinal = 239, argument = 8 */
static gboolean kernel32_EndUpdateResourceW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnterCriticalSection ordinal = 240, argument = 4 */
static gboolean kernel32_EnterCriticalSection (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumCalendarInfoA ordinal = 241, argument = 16 */
static gboolean kernel32_EnumCalendarInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumCalendarInfoExA ordinal = 242, argument = 16 */
static gboolean kernel32_EnumCalendarInfoExA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumCalendarInfoExEx ordinal = 243, argument = 24 */
static gboolean kernel32_EnumCalendarInfoExEx (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumCalendarInfoExW ordinal = 244, argument = 16 */
static gboolean kernel32_EnumCalendarInfoExW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumCalendarInfoW ordinal = 245, argument = 16 */
static gboolean kernel32_EnumCalendarInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumDateFormatsA ordinal = 246, argument = 12 */
static gboolean kernel32_EnumDateFormatsA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumDateFormatsExA ordinal = 247, argument = 12 */
static gboolean kernel32_EnumDateFormatsExA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumDateFormatsExEx ordinal = 248, argument = 16 */
static gboolean kernel32_EnumDateFormatsExEx (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumDateFormatsExW ordinal = 249, argument = 12 */
static gboolean kernel32_EnumDateFormatsExW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumDateFormatsW ordinal = 250, argument = 12 */
static gboolean kernel32_EnumDateFormatsW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumLanguageGroupLocalesA ordinal = 251, argument = 16 */
static gboolean kernel32_EnumLanguageGroupLocalesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumLanguageGroupLocalesW ordinal = 252, argument = 16 */
static gboolean kernel32_EnumLanguageGroupLocalesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceLanguagesA ordinal = 253, argument = 20 */
static gboolean kernel32_EnumResourceLanguagesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceLanguagesExA ordinal = 254, argument = 28 */
static gboolean kernel32_EnumResourceLanguagesExA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceLanguagesExW ordinal = 255, argument = 28 */
static gboolean kernel32_EnumResourceLanguagesExW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceLanguagesW ordinal = 256, argument = 20 */
static gboolean kernel32_EnumResourceLanguagesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceNamesA ordinal = 257, argument = 16 */
static gboolean kernel32_EnumResourceNamesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceNamesExA ordinal = 258, argument = 24 */
static gboolean kernel32_EnumResourceNamesExA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceNamesExW ordinal = 259, argument = 24 */
static gboolean kernel32_EnumResourceNamesExW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceNamesW ordinal = 260, argument = 16 */
static gboolean kernel32_EnumResourceNamesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceTypesA ordinal = 261, argument = 12 */
static gboolean kernel32_EnumResourceTypesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceTypesExA ordinal = 262, argument = 20 */
static gboolean kernel32_EnumResourceTypesExA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceTypesExW ordinal = 263, argument = 20 */
static gboolean kernel32_EnumResourceTypesExW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumResourceTypesW ordinal = 264, argument = 12 */
static gboolean kernel32_EnumResourceTypesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemCodePagesA ordinal = 265, argument = 8 */
static gboolean kernel32_EnumSystemCodePagesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemCodePagesW ordinal = 266, argument = 8 */
static gboolean kernel32_EnumSystemCodePagesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemFirmwareTables ordinal = 267, argument = 12 */
static gboolean kernel32_EnumSystemFirmwareTables (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemGeoID ordinal = 268, argument = 12 */
static gboolean kernel32_EnumSystemGeoID (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemLanguageGroupsA ordinal = 269, argument = 12 */
static gboolean kernel32_EnumSystemLanguageGroupsA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemLanguageGroupsW ordinal = 270, argument = 12 */
static gboolean kernel32_EnumSystemLanguageGroupsW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemLocalesA ordinal = 271, argument = 8 */
static gboolean kernel32_EnumSystemLocalesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemLocalesEx ordinal = 272, argument = 16 */
static gboolean kernel32_EnumSystemLocalesEx (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumSystemLocalesW ordinal = 273, argument = 8 */
static gboolean kernel32_EnumSystemLocalesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumTimeFormatsA ordinal = 274, argument = 12 */
static gboolean kernel32_EnumTimeFormatsA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumTimeFormatsEx ordinal = 275, argument = 16 */
static gboolean kernel32_EnumTimeFormatsEx (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumTimeFormatsW ordinal = 276, argument = 12 */
static gboolean kernel32_EnumTimeFormatsW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumUILanguagesA ordinal = 277, argument = 12 */
static gboolean kernel32_EnumUILanguagesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumUILanguagesW ordinal = 278, argument = 12 */
static gboolean kernel32_EnumUILanguagesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumerateLocalComputerNamesA ordinal = 279, argument = 16 */
static gboolean kernel32_EnumerateLocalComputerNamesA (Ia32Thread *thread)
{
  return FALSE;
}


/* EnumerateLocalComputerNamesW ordinal = 280, argument = 16 */
static gboolean kernel32_EnumerateLocalComputerNamesW (Ia32Thread *thread)
{
  return FALSE;
}


/* EraseTape ordinal = 281, argument = 12 */
static gboolean kernel32_EraseTape (Ia32Thread *thread)
{
  return FALSE;
}


/* EscapeCommFunction ordinal = 282, argument = 8 */
static gboolean kernel32_EscapeCommFunction (Ia32Thread *thread)
{
  return FALSE;
}


/* ExitProcess ordinal = 283, argument = 4 */
static gboolean kernel32_ExitProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* ExitThread ordinal = 284, argument = 4 */
static gboolean kernel32_ExitThread (Ia32Thread *thread)
{
  return FALSE;
}


/* ExitVDM ordinal = 285, argument = 0 */
static gboolean kernel32_ExitVDM (Ia32Thread *thread)
{
  return FALSE;
}


/* ExpandEnvironmentStringsA ordinal = 286, argument = 12 */
static gboolean kernel32_ExpandEnvironmentStringsA (Ia32Thread *thread)
{
  return FALSE;
}


/* ExpandEnvironmentStringsW ordinal = 287, argument = 12 */
static gboolean kernel32_ExpandEnvironmentStringsW (Ia32Thread *thread)
{
  return FALSE;
}


/* ExpungeConsoleCommandHistoryA ordinal = 288, argument = 0 */
static gboolean kernel32_ExpungeConsoleCommandHistoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* ExpungeConsoleCommandHistoryW ordinal = 289, argument = 0 */
static gboolean kernel32_ExpungeConsoleCommandHistoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* FatalAppExitA ordinal = 290, argument = 8 */
static gboolean kernel32_FatalAppExitA (Ia32Thread *thread)
{
  return FALSE;
}


/* FatalAppExitW ordinal = 291, argument = 8 */
static gboolean kernel32_FatalAppExitW (Ia32Thread *thread)
{
  return FALSE;
}


/* FatalExit ordinal = 292, argument = 4 */
static gboolean kernel32_FatalExit (Ia32Thread *thread)
{
  return FALSE;
}


/* FileTimeToDosDateTime ordinal = 293, argument = 12 */
static gboolean kernel32_FileTimeToDosDateTime (Ia32Thread *thread)
{
  return FALSE;
}


/* FileTimeToLocalFileTime ordinal = 294, argument = 8 */
static gboolean kernel32_FileTimeToLocalFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* FileTimeToSystemTime ordinal = 295, argument = 8 */
static gboolean kernel32_FileTimeToSystemTime (Ia32Thread *thread)
{
  return FALSE;
}


/* FillConsoleOutputAttribute ordinal = 296, argument = 20 */
static gboolean kernel32_FillConsoleOutputAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* FillConsoleOutputCharacterA ordinal = 297, argument = 20 */
static gboolean kernel32_FillConsoleOutputCharacterA (Ia32Thread *thread)
{
  return FALSE;
}


/* FillConsoleOutputCharacterW ordinal = 298, argument = 20 */
static gboolean kernel32_FillConsoleOutputCharacterW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindActCtxSectionGuid ordinal = 299, argument = 20 */
static gboolean kernel32_FindActCtxSectionGuid (Ia32Thread *thread)
{
  return FALSE;
}


/* FindActCtxSectionStringA ordinal = 300, argument = 20 */
static gboolean kernel32_FindActCtxSectionStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindActCtxSectionStringW ordinal = 301, argument = 20 */
static gboolean kernel32_FindActCtxSectionStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindAtomA ordinal = 302, argument = 4 */
static gboolean kernel32_FindAtomA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindAtomW ordinal = 303, argument = 4 */
static gboolean kernel32_FindAtomW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindClose ordinal = 304, argument = 4 */
static gboolean kernel32_FindClose (Ia32Thread *thread)
{
  return FALSE;
}


/* FindCloseChangeNotification ordinal = 305, argument = 4 */
static gboolean kernel32_FindCloseChangeNotification (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstChangeNotificationA ordinal = 306, argument = 12 */
static gboolean kernel32_FindFirstChangeNotificationA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstChangeNotificationW ordinal = 307, argument = 12 */
static gboolean kernel32_FindFirstChangeNotificationW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileA ordinal = 308, argument = 8 */
static gboolean kernel32_FindFirstFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileExA ordinal = 309, argument = 24 */
static gboolean kernel32_FindFirstFileExA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileExW ordinal = 310, argument = 24 */
static gboolean kernel32_FindFirstFileExW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileNameTransactedW ordinal = 311, argument = 20 */
static gboolean kernel32_FindFirstFileNameTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileNameW ordinal = 312, argument = 16 */
static gboolean kernel32_FindFirstFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileTransactedA ordinal = 313, argument = 28 */
static gboolean kernel32_FindFirstFileTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileTransactedW ordinal = 314, argument = 28 */
static gboolean kernel32_FindFirstFileTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstFileW ordinal = 315, argument = 8 */
static gboolean kernel32_FindFirstFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstStreamTransactedW ordinal = 316, argument = 20 */
static gboolean kernel32_FindFirstStreamTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstStreamW ordinal = 317, argument = 16 */
static gboolean kernel32_FindFirstStreamW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstVolumeA ordinal = 318, argument = 8 */
static gboolean kernel32_FindFirstVolumeA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstVolumeMountPointA ordinal = 319, argument = 12 */
static gboolean kernel32_FindFirstVolumeMountPointA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstVolumeMountPointW ordinal = 320, argument = 12 */
static gboolean kernel32_FindFirstVolumeMountPointW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindFirstVolumeW ordinal = 321, argument = 8 */
static gboolean kernel32_FindFirstVolumeW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNLSString ordinal = 322, argument = 28 */
static gboolean kernel32_FindNLSString (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNLSStringEx ordinal = 323, argument = 40 */
static gboolean kernel32_FindNLSStringEx (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextChangeNotification ordinal = 324, argument = 4 */
static gboolean kernel32_FindNextChangeNotification (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextFileA ordinal = 325, argument = 8 */
static gboolean kernel32_FindNextFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextFileNameW ordinal = 326, argument = 12 */
static gboolean kernel32_FindNextFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextFileW ordinal = 327, argument = 8 */
static gboolean kernel32_FindNextFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextStreamW ordinal = 328, argument = 8 */
static gboolean kernel32_FindNextStreamW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextVolumeA ordinal = 329, argument = 12 */
static gboolean kernel32_FindNextVolumeA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextVolumeMountPointA ordinal = 330, argument = 12 */
static gboolean kernel32_FindNextVolumeMountPointA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextVolumeMountPointW ordinal = 331, argument = 12 */
static gboolean kernel32_FindNextVolumeMountPointW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindNextVolumeW ordinal = 332, argument = 12 */
static gboolean kernel32_FindNextVolumeW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindResourceA ordinal = 333, argument = 12 */
static gboolean kernel32_FindResourceA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindResourceExA ordinal = 334, argument = 16 */
static gboolean kernel32_FindResourceExA (Ia32Thread *thread)
{
  return FALSE;
}


/* FindResourceExW ordinal = 335, argument = 16 */
static gboolean kernel32_FindResourceExW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindResourceW ordinal = 336, argument = 12 */
static gboolean kernel32_FindResourceW (Ia32Thread *thread)
{
  return FALSE;
}


/* FindStringOrdinal ordinal = 337, argument = 0 */
static gboolean kernel32_FindStringOrdinal (Ia32Thread *thread)
{
  return FALSE;
}


/* FindVolumeClose ordinal = 338, argument = 4 */
static gboolean kernel32_FindVolumeClose (Ia32Thread *thread)
{
  return FALSE;
}


/* FindVolumeMountPointClose ordinal = 339, argument = 4 */
static gboolean kernel32_FindVolumeMountPointClose (Ia32Thread *thread)
{
  return FALSE;
}


/* FlsAlloc ordinal = 340, argument = 4 */
static gboolean kernel32_FlsAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* FlsFree ordinal = 341, argument = 4 */
static gboolean kernel32_FlsFree (Ia32Thread *thread)
{
  return FALSE;
}


/* FlsGetValue ordinal = 342, argument = 4 */
static gboolean kernel32_FlsGetValue (Ia32Thread *thread)
{
  return FALSE;
}


/* FlsSetValue ordinal = 343, argument = 8 */
static gboolean kernel32_FlsSetValue (Ia32Thread *thread)
{
  return FALSE;
}


/* FlushConsoleInputBuffer ordinal = 344, argument = 4 */
static gboolean kernel32_FlushConsoleInputBuffer (Ia32Thread *thread)
{
  return FALSE;
}


/* FlushFileBuffers ordinal = 345, argument = 4 */
static gboolean kernel32_FlushFileBuffers (Ia32Thread *thread)
{
  return FALSE;
}


/* FlushInstructionCache ordinal = 346, argument = 12 */
static gboolean kernel32_FlushInstructionCache (Ia32Thread *thread)
{
  return FALSE;
}


/* FlushProcessWriteBuffers ordinal = 347, argument = 0 */
static gboolean kernel32_FlushProcessWriteBuffers (Ia32Thread *thread)
{
  return FALSE;
}


/* FlushViewOfFile ordinal = 348, argument = 8 */
static gboolean kernel32_FlushViewOfFile (Ia32Thread *thread)
{
  return FALSE;
}


/* FoldStringA ordinal = 349, argument = 20 */
static gboolean kernel32_FoldStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* FoldStringW ordinal = 350, argument = 20 */
static gboolean kernel32_FoldStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* FormatMessageA ordinal = 351, argument = 28 */
static gboolean kernel32_FormatMessageA (Ia32Thread *thread)
{
  return FALSE;
}


/* FormatMessageW ordinal = 352, argument = 28 */
static gboolean kernel32_FormatMessageW (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeConsole ordinal = 353, argument = 0 */
static gboolean kernel32_FreeConsole (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeEnvironmentStringsA ordinal = 354, argument = 4 */
static gboolean kernel32_FreeEnvironmentStringsA (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeEnvironmentStringsW ordinal = 355, argument = 4 */
static gboolean kernel32_FreeEnvironmentStringsW (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeLibrary ordinal = 356, argument = 4 */
static gboolean kernel32_FreeLibrary (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeLibraryAndExitThread ordinal = 357, argument = 8 */
static gboolean kernel32_FreeLibraryAndExitThread (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeLibraryWhenCallbackReturns ordinal = 358, argument = 8 */
static gboolean kernel32_FreeLibraryWhenCallbackReturns (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeResource ordinal = 359, argument = 4 */
static gboolean kernel32_FreeResource (Ia32Thread *thread)
{
  return FALSE;
}


/* FreeUserPhysicalPages ordinal = 360, argument = 12 */
static gboolean kernel32_FreeUserPhysicalPages (Ia32Thread *thread)
{
  return FALSE;
}


/* GenerateConsoleCtrlEvent ordinal = 361, argument = 8 */
static gboolean kernel32_GenerateConsoleCtrlEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* GetACP ordinal = 362, argument = 0 */
static gboolean kernel32_GetACP (Ia32Thread *thread)
{
  return FALSE;
}


/* GetActiveProcessorCount ordinal = 363, argument = 0 */
static gboolean kernel32_GetActiveProcessorCount (Ia32Thread *thread)
{
  return FALSE;
}


/* GetActiveProcessorGroupCount ordinal = 364, argument = 0 */
static gboolean kernel32_GetActiveProcessorGroupCount (Ia32Thread *thread)
{
  return FALSE;
}


/* GetApplicationRecoveryCallback ordinal = 365, argument = 20 */
static gboolean kernel32_GetApplicationRecoveryCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* GetApplicationRestartSettings ordinal = 366, argument = 16 */
static gboolean kernel32_GetApplicationRestartSettings (Ia32Thread *thread)
{
  return FALSE;
}


/* GetAtomNameA ordinal = 367, argument = 12 */
static gboolean kernel32_GetAtomNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetAtomNameW ordinal = 368, argument = 12 */
static gboolean kernel32_GetAtomNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetBinaryType ordinal = 369, argument = 8 */
/* static gboolean kernel32_GetBinaryType (Ia32Thread *thread) */


/* GetBinaryTypeA ordinal = 370, argument = 8 */
static gboolean kernel32_GetBinaryTypeA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetBinaryTypeW ordinal = 371, argument = 8 */
static gboolean kernel32_GetBinaryTypeW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCPInfo ordinal = 372, argument = 8 */
static gboolean kernel32_GetCPInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCPInfoExA ordinal = 373, argument = 12 */
static gboolean kernel32_GetCPInfoExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCPInfoExW ordinal = 374, argument = 12 */
static gboolean kernel32_GetCPInfoExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarDateFormat ordinal = 375, argument = 0 */
static gboolean kernel32_GetCalendarDateFormat (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarDateFormatEx ordinal = 376, argument = 0 */
static gboolean kernel32_GetCalendarDateFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarDaysInMonth ordinal = 377, argument = 0 */
static gboolean kernel32_GetCalendarDaysInMonth (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarDifferenceInDays ordinal = 378, argument = 0 */
static gboolean kernel32_GetCalendarDifferenceInDays (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarInfoA ordinal = 379, argument = 24 */
static gboolean kernel32_GetCalendarInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarInfoEx ordinal = 380, argument = 28 */
static gboolean kernel32_GetCalendarInfoEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarInfoW ordinal = 381, argument = 24 */
static gboolean kernel32_GetCalendarInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarMonthsInYear ordinal = 382, argument = 0 */
static gboolean kernel32_GetCalendarMonthsInYear (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarSupportedDateRange ordinal = 383, argument = 0 */
static gboolean kernel32_GetCalendarSupportedDateRange (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCalendarWeekNumber ordinal = 384, argument = 0 */
static gboolean kernel32_GetCalendarWeekNumber (Ia32Thread *thread)
{
  return FALSE;
}


/* GetComPlusPackageInstallStatus ordinal = 385, argument = 0 */
static gboolean kernel32_GetComPlusPackageInstallStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommConfig ordinal = 386, argument = 12 */
static gboolean kernel32_GetCommConfig (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommMask ordinal = 387, argument = 8 */
static gboolean kernel32_GetCommMask (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommModemStatus ordinal = 388, argument = 8 */
static gboolean kernel32_GetCommModemStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommProperties ordinal = 389, argument = 8 */
static gboolean kernel32_GetCommProperties (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommState ordinal = 390, argument = 8 */
static gboolean kernel32_GetCommState (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommTimeouts ordinal = 391, argument = 8 */
static gboolean kernel32_GetCommTimeouts (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommandLineA ordinal = 392, argument = 0 */
static gboolean kernel32_GetCommandLineA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCommandLineW ordinal = 393, argument = 0 */
static gboolean kernel32_GetCommandLineW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCompressedFileSizeA ordinal = 394, argument = 8 */
static gboolean kernel32_GetCompressedFileSizeA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCompressedFileSizeTransactedA ordinal = 395, argument = 12 */
static gboolean kernel32_GetCompressedFileSizeTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCompressedFileSizeTransactedW ordinal = 396, argument = 12 */
static gboolean kernel32_GetCompressedFileSizeTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCompressedFileSizeW ordinal = 397, argument = 8 */
static gboolean kernel32_GetCompressedFileSizeW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetComputerNameA ordinal = 398, argument = 8 */
static gboolean kernel32_GetComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetComputerNameExA ordinal = 399, argument = 12 */
static gboolean kernel32_GetComputerNameExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetComputerNameExW ordinal = 400, argument = 12 */
static gboolean kernel32_GetComputerNameExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetComputerNameW ordinal = 401, argument = 8 */
static gboolean kernel32_GetComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasA ordinal = 402, argument = 16 */
static gboolean kernel32_GetConsoleAliasA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasExesA ordinal = 403, argument = 8 */
static gboolean kernel32_GetConsoleAliasExesA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasExesLengthA ordinal = 404, argument = 0 */
static gboolean kernel32_GetConsoleAliasExesLengthA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasExesLengthW ordinal = 405, argument = 0 */
static gboolean kernel32_GetConsoleAliasExesLengthW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasExesW ordinal = 406, argument = 8 */
static gboolean kernel32_GetConsoleAliasExesW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasW ordinal = 407, argument = 16 */
static gboolean kernel32_GetConsoleAliasW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasesA ordinal = 408, argument = 12 */
static gboolean kernel32_GetConsoleAliasesA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasesLengthA ordinal = 409, argument = 4 */
static gboolean kernel32_GetConsoleAliasesLengthA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasesLengthW ordinal = 410, argument = 4 */
static gboolean kernel32_GetConsoleAliasesLengthW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleAliasesW ordinal = 411, argument = 12 */
static gboolean kernel32_GetConsoleAliasesW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCP ordinal = 412, argument = 0 */
static gboolean kernel32_GetConsoleCP (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCharType ordinal = 413, argument = 0 */
static gboolean kernel32_GetConsoleCharType (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCommandHistoryA ordinal = 414, argument = 0 */
static gboolean kernel32_GetConsoleCommandHistoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCommandHistoryLengthA ordinal = 415, argument = 0 */
static gboolean kernel32_GetConsoleCommandHistoryLengthA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCommandHistoryLengthW ordinal = 416, argument = 0 */
static gboolean kernel32_GetConsoleCommandHistoryLengthW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCommandHistoryW ordinal = 417, argument = 0 */
static gboolean kernel32_GetConsoleCommandHistoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCursorInfo ordinal = 418, argument = 8 */
static gboolean kernel32_GetConsoleCursorInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleCursorMode ordinal = 419, argument = 0 */
static gboolean kernel32_GetConsoleCursorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleDisplayMode ordinal = 420, argument = 4 */
static gboolean kernel32_GetConsoleDisplayMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleFontInfo ordinal = 421, argument = 0 */
static gboolean kernel32_GetConsoleFontInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleFontSize ordinal = 422, argument = 8 */
static gboolean kernel32_GetConsoleFontSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleHardwareState ordinal = 423, argument = 0 */
static gboolean kernel32_GetConsoleHardwareState (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleHistoryInfo ordinal = 424, argument = 4 */
static gboolean kernel32_GetConsoleHistoryInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleInputExeNameA ordinal = 425, argument = 0 */
static gboolean kernel32_GetConsoleInputExeNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleInputExeNameW ordinal = 426, argument = 0 */
static gboolean kernel32_GetConsoleInputExeNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleInputWaitHandle ordinal = 427, argument = 0 */
static gboolean kernel32_GetConsoleInputWaitHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleKeyboardLayoutNameA ordinal = 428, argument = 0 */
static gboolean kernel32_GetConsoleKeyboardLayoutNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleKeyboardLayoutNameW ordinal = 429, argument = 0 */
static gboolean kernel32_GetConsoleKeyboardLayoutNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleMode ordinal = 430, argument = 8 */
static gboolean kernel32_GetConsoleMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleNlsMode ordinal = 431, argument = 0 */
static gboolean kernel32_GetConsoleNlsMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleOriginalTitleA ordinal = 432, argument = 8 */
static gboolean kernel32_GetConsoleOriginalTitleA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleOriginalTitleW ordinal = 433, argument = 8 */
static gboolean kernel32_GetConsoleOriginalTitleW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleOutputCP ordinal = 434, argument = 0 */
static gboolean kernel32_GetConsoleOutputCP (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleProcessList ordinal = 435, argument = 8 */
static gboolean kernel32_GetConsoleProcessList (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleScreenBufferInfo ordinal = 436, argument = 8 */
static gboolean kernel32_GetConsoleScreenBufferInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleScreenBufferInfoEx ordinal = 437, argument = 8 */
static gboolean kernel32_GetConsoleScreenBufferInfoEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleSelectionInfo ordinal = 438, argument = 4 */
static gboolean kernel32_GetConsoleSelectionInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleTitleA ordinal = 439, argument = 8 */
static gboolean kernel32_GetConsoleTitleA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleTitleW ordinal = 440, argument = 8 */
static gboolean kernel32_GetConsoleTitleW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetConsoleWindow ordinal = 441, argument = 0 */
static gboolean kernel32_GetConsoleWindow (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrencyFormatA ordinal = 442, argument = 24 */
static gboolean kernel32_GetCurrencyFormatA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrencyFormatEx ordinal = 443, argument = 24 */
static gboolean kernel32_GetCurrencyFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrencyFormatW ordinal = 444, argument = 24 */
static gboolean kernel32_GetCurrencyFormatW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentActCtx ordinal = 445, argument = 4 */
static gboolean kernel32_GetCurrentActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentConsoleFont ordinal = 446, argument = 12 */
static gboolean kernel32_GetCurrentConsoleFont (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentConsoleFontEx ordinal = 447, argument = 12 */
static gboolean kernel32_GetCurrentConsoleFontEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentDirectoryA ordinal = 448, argument = 8 */
static gboolean kernel32_GetCurrentDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentDirectoryW ordinal = 449, argument = 8 */
static gboolean kernel32_GetCurrentDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentProcess ordinal = 450, argument = 0 */
static gboolean kernel32_GetCurrentProcess (Ia32Thread *thread)
{
  thread->reg.eax = thread->process->id;
  ia32_message_record_api_with_argument (thread,
                                        "GetCurrentProcess", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GetCurrentProcessId ordinal = 451, argument = 0 */
static gboolean kernel32_GetCurrentProcessId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentProcessorNumber ordinal = 452, argument = 0 */
static gboolean kernel32_GetCurrentProcessorNumber (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentProcessorNumberEx ordinal = 453, argument = 0 */
static gboolean kernel32_GetCurrentProcessorNumberEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentThread ordinal = 454, argument = 0 */
static gboolean kernel32_GetCurrentThread (Ia32Thread *thread)
{
  return FALSE;
}


/* GetCurrentThreadId ordinal = 455, argument = 0 */
static gboolean kernel32_GetCurrentThreadId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDateFormatA ordinal = 456, argument = 24 */
static gboolean kernel32_GetDateFormatA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDateFormatEx ordinal = 457, argument = 28 */
static gboolean kernel32_GetDateFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDateFormatW ordinal = 458, argument = 24 */
static gboolean kernel32_GetDateFormatW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDefaultCommConfigA ordinal = 459, argument = 12 */
static gboolean kernel32_GetDefaultCommConfigA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDefaultCommConfigW ordinal = 460, argument = 12 */
static gboolean kernel32_GetDefaultCommConfigW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDevicePowerState ordinal = 461, argument = 8 */
static gboolean kernel32_GetDevicePowerState (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDiskFreeSpaceA ordinal = 462, argument = 20 */
static gboolean kernel32_GetDiskFreeSpaceA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDiskFreeSpaceExA ordinal = 463, argument = 16 */
static gboolean kernel32_GetDiskFreeSpaceExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDiskFreeSpaceExW ordinal = 464, argument = 16 */
static gboolean kernel32_GetDiskFreeSpaceExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDiskFreeSpaceW ordinal = 465, argument = 20 */
static gboolean kernel32_GetDiskFreeSpaceW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDllDirectoryA ordinal = 466, argument = 8 */
static gboolean kernel32_GetDllDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDllDirectoryW ordinal = 467, argument = 8 */
static gboolean kernel32_GetDllDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDriveTypeA ordinal = 468, argument = 4 */
static gboolean kernel32_GetDriveTypeA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDriveTypeW ordinal = 469, argument = 4 */
static gboolean kernel32_GetDriveTypeW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDurationFormat ordinal = 470, argument = 32 */
static gboolean kernel32_GetDurationFormat (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDurationFormatEx ordinal = 471, argument = 32 */
static gboolean kernel32_GetDurationFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetDynamicTimeZoneInformation ordinal = 472, argument = 4 */
static gboolean kernel32_GetDynamicTimeZoneInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEnabledExtendedFeatures ordinal = 473, argument = 0 */
static gboolean kernel32_GetEnabledExtendedFeatures (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEnvironmentStrings ordinal = 474, argument = 0 */
/* static gboolean kernel32_GetEnvironmentStrings (Ia32Thread *thread) */


/* GetEnvironmentStringsA ordinal = 475, argument = 0 */
static gboolean kernel32_GetEnvironmentStringsA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEnvironmentStringsW ordinal = 476, argument = 0 */
static gboolean kernel32_GetEnvironmentStringsW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEnvironmentVariableA ordinal = 477, argument = 12 */
static gboolean kernel32_GetEnvironmentVariableA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEnvironmentVariableW ordinal = 478, argument = 12 */
static gboolean kernel32_GetEnvironmentVariableW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetEraNameCountedString ordinal = 479, argument = 0 */
static gboolean kernel32_GetEraNameCountedString (Ia32Thread *thread)
{
  return FALSE;
}


/* GetErrorMode ordinal = 480, argument = 0 */
static gboolean kernel32_GetErrorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExitCodeProcess ordinal = 481, argument = 8 */
static gboolean kernel32_GetExitCodeProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExitCodeThread ordinal = 482, argument = 8 */
static gboolean kernel32_GetExitCodeThread (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExpandedNameA ordinal = 483, argument = 0 */
static gboolean kernel32_GetExpandedNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExpandedNameW ordinal = 484, argument = 0 */
static gboolean kernel32_GetExpandedNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExtendedContextLength ordinal = 485, argument = 0 */
static gboolean kernel32_GetExtendedContextLength (Ia32Thread *thread)
{
  return FALSE;
}


/* GetExtendedFeaturesMask ordinal = 486, argument = 0 */
static gboolean kernel32_GetExtendedFeaturesMask (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesA ordinal = 487, argument = 4 */
static gboolean kernel32_GetFileAttributesA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesExA ordinal = 488, argument = 12 */
static gboolean kernel32_GetFileAttributesExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesExW ordinal = 489, argument = 12 */
static gboolean kernel32_GetFileAttributesExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesTransactedA ordinal = 490, argument = 16 */
static gboolean kernel32_GetFileAttributesTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesTransactedW ordinal = 491, argument = 16 */
static gboolean kernel32_GetFileAttributesTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileAttributesW ordinal = 492, argument = 4 */
static gboolean kernel32_GetFileAttributesW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileBandwidthReservation ordinal = 493, argument = 24 */
static gboolean kernel32_GetFileBandwidthReservation (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileInformationByHandle ordinal = 494, argument = 8 */
static gboolean kernel32_GetFileInformationByHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileInformationByHandleEx ordinal = 495, argument = 16 */
static gboolean kernel32_GetFileInformationByHandleEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileMUIInfo ordinal = 496, argument = 16 */
static gboolean kernel32_GetFileMUIInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileMUIPath ordinal = 497, argument = 28 */
static gboolean kernel32_GetFileMUIPath (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileSize ordinal = 498, argument = 8 */
static gboolean kernel32_GetFileSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileSizeEx ordinal = 499, argument = 8 */
static gboolean kernel32_GetFileSizeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileTime ordinal = 500, argument = 16 */
static gboolean kernel32_GetFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFileType ordinal = 501, argument = 4 */
static gboolean kernel32_GetFileType (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFinalPathNameByHandleA ordinal = 502, argument = 16 */
static gboolean kernel32_GetFinalPathNameByHandleA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFinalPathNameByHandleW ordinal = 503, argument = 16 */
static gboolean kernel32_GetFinalPathNameByHandleW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFirmwareEnvironmentVariableA ordinal = 504, argument = 16 */
static gboolean kernel32_GetFirmwareEnvironmentVariableA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFirmwareEnvironmentVariableW ordinal = 505, argument = 16 */
static gboolean kernel32_GetFirmwareEnvironmentVariableW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFullPathNameA ordinal = 506, argument = 16 */
static gboolean kernel32_GetFullPathNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFullPathNameTransactedA ordinal = 507, argument = 20 */
static gboolean kernel32_GetFullPathNameTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFullPathNameTransactedW ordinal = 508, argument = 20 */
static gboolean kernel32_GetFullPathNameTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetFullPathNameW ordinal = 509, argument = 16 */
static gboolean kernel32_GetFullPathNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetGeoInfoA ordinal = 510, argument = 20 */
static gboolean kernel32_GetGeoInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetGeoInfoW ordinal = 511, argument = 20 */
static gboolean kernel32_GetGeoInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetHandleContext ordinal = 512, argument = 0 */
static gboolean kernel32_GetHandleContext (Ia32Thread *thread)
{
  return FALSE;
}


/* GetHandleInformation ordinal = 513, argument = 8 */
static gboolean kernel32_GetHandleInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLargePageMinimum ordinal = 514, argument = 0 */
static gboolean kernel32_GetLargePageMinimum (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLargestConsoleWindowSize ordinal = 515, argument = 4 */
static gboolean kernel32_GetLargestConsoleWindowSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLastError ordinal = 516, argument = 0 */
static gboolean kernel32_GetLastError (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLocalTime ordinal = 517, argument = 4 */
static gboolean kernel32_GetLocalTime (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLocaleInfoA ordinal = 518, argument = 16 */
static gboolean kernel32_GetLocaleInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLocaleInfoEx ordinal = 519, argument = 16 */
static gboolean kernel32_GetLocaleInfoEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLocaleInfoW ordinal = 520, argument = 16 */
static gboolean kernel32_GetLocaleInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLogicalDriveStringsA ordinal = 521, argument = 8 */
static gboolean kernel32_GetLogicalDriveStringsA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLogicalDriveStringsW ordinal = 522, argument = 8 */
static gboolean kernel32_GetLogicalDriveStringsW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLogicalDrives ordinal = 523, argument = 0 */
static gboolean kernel32_GetLogicalDrives (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLogicalProcessorInformation ordinal = 524, argument = 8 */
static gboolean kernel32_GetLogicalProcessorInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLogicalProcessorInformationEx ordinal = 525, argument = 0 */
static gboolean kernel32_GetLogicalProcessorInformationEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLongPathNameA ordinal = 526, argument = 12 */
static gboolean kernel32_GetLongPathNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLongPathNameTransactedA ordinal = 527, argument = 16 */
static gboolean kernel32_GetLongPathNameTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLongPathNameTransactedW ordinal = 528, argument = 16 */
static gboolean kernel32_GetLongPathNameTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetLongPathNameW ordinal = 529, argument = 12 */
static gboolean kernel32_GetLongPathNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetMailslotInfo ordinal = 530, argument = 20 */
static gboolean kernel32_GetMailslotInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetMaximumProcessorCount ordinal = 531, argument = 0 */
static gboolean kernel32_GetMaximumProcessorCount (Ia32Thread *thread)
{
  return FALSE;
}


/* GetMaximumProcessorGroupCount ordinal = 532, argument = 0 */
static gboolean kernel32_GetMaximumProcessorGroupCount (Ia32Thread *thread)
{
  return FALSE;
}


/* GetModuleFileNameA ordinal = 533, argument = 12 */
static gboolean kernel32_GetModuleFileNameA (Ia32Thread *thread)
{
  guint32 address, size;
  gchar *name;
  const gchar *filename;

  address = ia32_stack_value (thread, 1);
  name = ia32_stack_pointer (thread, 2);
  size = ia32_stack_value (thread, 3);
  if (address == 0)
    address = thread->process->address;
  filename = ia32_module_get_filename (thread->process, address);
  if (name && filename)
    {
      gint i;

      for (i = 0; i < size - 1 && filename[i]; i++)
        name[i] = filename[i];
      name[i] = '\0';
      thread->reg.eax = i;
    }
  else
    {
      thread->reg.eax = 0;
    }
  ia32_message_record_api_with_argument (thread,
                                        "GetModuleFileNameA", IA32_MESSAGE_DEC,
                                        "hModule", IA32_MESSAGE_HEX,
                                        "lpFilename", IA32_MESSAGE_STRING,
                                        "nSize", IA32_MESSAGE_DEC,
                                        NULL);
  return TRUE;
}


/* GetModuleFileNameW ordinal = 534, argument = 12 */
static gboolean kernel32_GetModuleFileNameW (Ia32Thread *thread)
{
  guint32 address, size;
  gunichar2 *name;
  const gchar *filename;

  address = ia32_stack_value (thread, 1);
  name = ia32_stack_pointer (thread, 2);
  size = ia32_stack_value (thread, 3);
  if (address == 0)
    address = thread->process->address;
  filename = ia32_module_get_filename (thread->process, address);
  if (name && filename)
    {
      gint i;

      for (i = 0; i < size - 1 && filename[i]; i++)
        name[i] = filename[i];
      name[i] = '\0';
      thread->reg.eax = i;
    }
  else
    {
      thread->reg.eax = 0;
    }
  ia32_message_record_api_with_argument (thread,
                                        "GetModuleFileNameW", IA32_MESSAGE_DEC,
                                        "hModule", IA32_MESSAGE_HEX,
                                        "lpFilename", IA32_MESSAGE_STRINGW,
                                        "nSize", IA32_MESSAGE_DEC,
                                        NULL);
  return TRUE;
}


/* GetModuleHandleA ordinal = 535, argument = 4 */
static gboolean kernel32_GetModuleHandleA (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_module_get_library (thread->process,
                                                ia32_stack_string (thread, 1));
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "GetModuleHandleA", IA32_MESSAGE_HEX,
                                        "lpFileName", IA32_MESSAGE_STRING,
                                        NULL);
  return TRUE;
}


/* GetModuleHandleExA ordinal = 536, argument = 12 */
static gboolean kernel32_GetModuleHandleExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetModuleHandleExW ordinal = 537, argument = 12 */
static gboolean kernel32_GetModuleHandleExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetModuleHandleW ordinal = 538, argument = 4 */
static gboolean kernel32_GetModuleHandleW (Ia32Thread *thread)
{
  gchar *utf8str;
  guint32 address;

  utf8str = g_utf16_to_utf8 (ia32_stack_stringw (thread, 1), -1,
                                                            NULL, NULL, NULL);
  address = ia32_module_get_library (thread->process, utf8str);
  g_free (utf8str);
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "GetModuleHandleW", IA32_MESSAGE_HEX,
                                        "lpFileName", IA32_MESSAGE_STRINGW,
                                        NULL);
  return TRUE;
}


/* GetNLSVersion ordinal = 539, argument = 12 */
static gboolean kernel32_GetNLSVersion (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNLSVersionEx ordinal = 540, argument = 12 */
static gboolean kernel32_GetNLSVersionEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeAttribute ordinal = 541, argument = 20 */
static gboolean kernel32_GetNamedPipeAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeClientComputerNameA ordinal = 542, argument = 12 */
static gboolean kernel32_GetNamedPipeClientComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeClientComputerNameW ordinal = 543, argument = 12 */
static gboolean kernel32_GetNamedPipeClientComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeClientProcessId ordinal = 544, argument = 8 */
static gboolean kernel32_GetNamedPipeClientProcessId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeClientSessionId ordinal = 545, argument = 8 */
static gboolean kernel32_GetNamedPipeClientSessionId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeHandleStateA ordinal = 546, argument = 28 */
static gboolean kernel32_GetNamedPipeHandleStateA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeHandleStateW ordinal = 547, argument = 28 */
static gboolean kernel32_GetNamedPipeHandleStateW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeInfo ordinal = 548, argument = 20 */
static gboolean kernel32_GetNamedPipeInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeServerProcessId ordinal = 549, argument = 8 */
static gboolean kernel32_GetNamedPipeServerProcessId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNamedPipeServerSessionId ordinal = 550, argument = 8 */
static gboolean kernel32_GetNamedPipeServerSessionId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNativeSystemInfo ordinal = 551, argument = 4 */
static gboolean kernel32_GetNativeSystemInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNextVDMCommand ordinal = 552, argument = 0 */
static gboolean kernel32_GetNextVDMCommand (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaAvailableMemoryNode ordinal = 553, argument = 8 */
static gboolean kernel32_GetNumaAvailableMemoryNode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaAvailableMemoryNodeEx ordinal = 554, argument = 0 */
static gboolean kernel32_GetNumaAvailableMemoryNodeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaHighestNodeNumber ordinal = 555, argument = 4 */
static gboolean kernel32_GetNumaHighestNodeNumber (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaNodeNumberFromHandle ordinal = 556, argument = 0 */
static gboolean kernel32_GetNumaNodeNumberFromHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaNodeProcessorMask ordinal = 557, argument = 8 */
static gboolean kernel32_GetNumaNodeProcessorMask (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaNodeProcessorMaskEx ordinal = 558, argument = 0 */
static gboolean kernel32_GetNumaNodeProcessorMaskEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaProcessorNode ordinal = 559, argument = 8 */
static gboolean kernel32_GetNumaProcessorNode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaProcessorNodeEx ordinal = 560, argument = 0 */
static gboolean kernel32_GetNumaProcessorNodeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaProximityNode ordinal = 561, argument = 8 */
static gboolean kernel32_GetNumaProximityNode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumaProximityNodeEx ordinal = 562, argument = 0 */
static gboolean kernel32_GetNumaProximityNodeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberFormatA ordinal = 563, argument = 24 */
static gboolean kernel32_GetNumberFormatA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberFormatEx ordinal = 564, argument = 24 */
static gboolean kernel32_GetNumberFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberFormatW ordinal = 565, argument = 24 */
static gboolean kernel32_GetNumberFormatW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberOfConsoleFonts ordinal = 566, argument = 0 */
static gboolean kernel32_GetNumberOfConsoleFonts (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberOfConsoleInputEvents ordinal = 567, argument = 8 */
static gboolean kernel32_GetNumberOfConsoleInputEvents (Ia32Thread *thread)
{
  return FALSE;
}


/* GetNumberOfConsoleMouseButtons ordinal = 568, argument = 4 */
static gboolean kernel32_GetNumberOfConsoleMouseButtons (Ia32Thread *thread)
{
  return FALSE;
}


/* GetOEMCP ordinal = 569, argument = 0 */
static gboolean kernel32_GetOEMCP (Ia32Thread *thread)
{
  return FALSE;
}


/* GetOverlappedResult ordinal = 570, argument = 16 */
static gboolean kernel32_GetOverlappedResult (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPhysicallyInstalledSystemMemory ordinal = 571, argument = 0 */
static gboolean kernel32_GetPhysicallyInstalledSystemMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPriorityClass ordinal = 572, argument = 4 */
static gboolean kernel32_GetPriorityClass (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_message_record_api_with_argument (thread,
                                        "GetPriorityClass", IA32_MESSAGE_HEX,
                                        "hProcess", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GetPrivateProfileIntA ordinal = 573, argument = 16 */
static gboolean kernel32_GetPrivateProfileIntA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileIntW ordinal = 574, argument = 16 */
static gboolean kernel32_GetPrivateProfileIntW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileSectionA ordinal = 575, argument = 16 */
static gboolean kernel32_GetPrivateProfileSectionA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileSectionNamesA ordinal = 576, argument = 12 */
static gboolean kernel32_GetPrivateProfileSectionNamesA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileSectionNamesW ordinal = 577, argument = 12 */
static gboolean kernel32_GetPrivateProfileSectionNamesW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileSectionW ordinal = 578, argument = 16 */
static gboolean kernel32_GetPrivateProfileSectionW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileStringA ordinal = 579, argument = 24 */
static gboolean kernel32_GetPrivateProfileStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileStringW ordinal = 580, argument = 24 */
static gboolean kernel32_GetPrivateProfileStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileStructA ordinal = 581, argument = 20 */
static gboolean kernel32_GetPrivateProfileStructA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetPrivateProfileStructW ordinal = 582, argument = 20 */
static gboolean kernel32_GetPrivateProfileStructW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcAddress ordinal = 583, argument = 8 */
static gboolean kernel32_GetProcAddress (Ia32Thread *thread)
{
  gconstpointer func;
  guint8 *image;
  guint32 name, retval;

  image = ia32_stack_pointer (thread, 1);
  name = ia32_stack_value (thread, 2);
  if (name < 0x10000)
    func = peimage_file_get_proc (image, name);
  else if (ia32_memory_is_string (thread->process, name))
    func = peimage_file_get_func (image, ia32_stack_string (thread, 2));
  else
    func = NULL;
  retval = ia32_memory_virtual_address (thread->process, func);
  thread->reg.eax = retval != IA32_MEMORY_NULL ? retval : 0;
  ia32_message_record_api_with_argument (thread,
                            "GetProcAddress", IA32_MESSAGE_HEX,
                            "hModule", IA32_MESSAGE_HEX,
                            "lpProcName", name < 0x10000 ? IA32_MESSAGE_DEC
                                                         : IA32_MESSAGE_STRING,
                            NULL);
  return TRUE;
}


/* GetProcessAffinityMask ordinal = 584, argument = 12 */
static gboolean kernel32_GetProcessAffinityMask (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessDEPPolicy ordinal = 585, argument = 0 */
static gboolean kernel32_GetProcessDEPPolicy (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessGroupAffinity ordinal = 586, argument = 0 */
static gboolean kernel32_GetProcessGroupAffinity (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessHandleCount ordinal = 587, argument = 8 */
static gboolean kernel32_GetProcessHandleCount (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessHeap ordinal = 588, argument = 0 */
static gboolean kernel32_GetProcessHeap (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessHeaps ordinal = 589, argument = 8 */
static gboolean kernel32_GetProcessHeaps (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessId ordinal = 590, argument = 4 */
static gboolean kernel32_GetProcessId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessIdOfThread ordinal = 591, argument = 4 */
static gboolean kernel32_GetProcessIdOfThread (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessIoCounters ordinal = 592, argument = 8 */
static gboolean kernel32_GetProcessIoCounters (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessPreferredUILanguages ordinal = 593, argument = 0 */
static gboolean kernel32_GetProcessPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessPriorityBoost ordinal = 594, argument = 8 */
static gboolean kernel32_GetProcessPriorityBoost (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessShutdownParameters ordinal = 595, argument = 8 */
static gboolean kernel32_GetProcessShutdownParameters (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessTimes ordinal = 596, argument = 20 */
static gboolean kernel32_GetProcessTimes (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessVersion ordinal = 597, argument = 4 */
static gboolean kernel32_GetProcessVersion (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessWorkingSetSize ordinal = 598, argument = 12 */
static gboolean kernel32_GetProcessWorkingSetSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessWorkingSetSizeEx ordinal = 599, argument = 16 */
static gboolean kernel32_GetProcessWorkingSetSizeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProcessorSystemCycleTime ordinal = 600, argument = 0 */
static gboolean kernel32_GetProcessorSystemCycleTime (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProductInfo ordinal = 601, argument = 20 */
static gboolean kernel32_GetProductInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileIntA ordinal = 602, argument = 12 */
static gboolean kernel32_GetProfileIntA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileIntW ordinal = 603, argument = 12 */
static gboolean kernel32_GetProfileIntW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileSectionA ordinal = 604, argument = 12 */
static gboolean kernel32_GetProfileSectionA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileSectionW ordinal = 605, argument = 12 */
static gboolean kernel32_GetProfileSectionW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileStringA ordinal = 606, argument = 20 */
static gboolean kernel32_GetProfileStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetProfileStringW ordinal = 607, argument = 20 */
static gboolean kernel32_GetProfileStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetQueuedCompletionStatus ordinal = 608, argument = 20 */
static gboolean kernel32_GetQueuedCompletionStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GetQueuedCompletionStatusEx ordinal = 609, argument = 24 */
static gboolean kernel32_GetQueuedCompletionStatusEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetShortPathNameA ordinal = 610, argument = 12 */
static gboolean kernel32_GetShortPathNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetShortPathNameW ordinal = 611, argument = 12 */
static gboolean kernel32_GetShortPathNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStartupInfoA ordinal = 612, argument = 4 */
static gboolean kernel32_GetStartupInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStartupInfoW ordinal = 613, argument = 4 */
static gboolean kernel32_GetStartupInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStdHandle ordinal = 614, argument = 4 */
static gboolean kernel32_GetStdHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStringScripts ordinal = 615, argument = 20 */
static gboolean kernel32_GetStringScripts (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStringTypeA ordinal = 616, argument = 20 */
static gboolean kernel32_GetStringTypeA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStringTypeExA ordinal = 617, argument = 20 */
static gboolean kernel32_GetStringTypeExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStringTypeExW ordinal = 618, argument = 20 */
static gboolean kernel32_GetStringTypeExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetStringTypeW ordinal = 619, argument = 16 */
static gboolean kernel32_GetStringTypeW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDEPPolicy ordinal = 620, argument = 0 */
static gboolean kernel32_GetSystemDEPPolicy (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDefaultLCID ordinal = 621, argument = 0 */
static gboolean kernel32_GetSystemDefaultLCID (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDefaultLangID ordinal = 622, argument = 0 */
static gboolean kernel32_GetSystemDefaultLangID (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDefaultLocaleName ordinal = 623, argument = 8 */
static gboolean kernel32_GetSystemDefaultLocaleName (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDefaultUILanguage ordinal = 624, argument = 0 */
static gboolean kernel32_GetSystemDefaultUILanguage (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDirectoryA ordinal = 625, argument = 8 */
static gboolean kernel32_GetSystemDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemDirectoryW ordinal = 626, argument = 8 */
static gboolean kernel32_GetSystemDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemFileCacheSize ordinal = 627, argument = 12 */
static gboolean kernel32_GetSystemFileCacheSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemFirmwareTable ordinal = 628, argument = 16 */
static gboolean kernel32_GetSystemFirmwareTable (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemInfo ordinal = 629, argument = 4 */
static gboolean kernel32_GetSystemInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemPowerStatus ordinal = 630, argument = 4 */
static gboolean kernel32_GetSystemPowerStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemPreferredUILanguages ordinal = 631, argument = 16 */
static gboolean kernel32_GetSystemPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemRegistryQuota ordinal = 632, argument = 8 */
static gboolean kernel32_GetSystemRegistryQuota (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemTime ordinal = 633, argument = 4 */
static gboolean kernel32_GetSystemTime (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemTimeAdjustment ordinal = 634, argument = 12 */
static gboolean kernel32_GetSystemTimeAdjustment (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemTimeAsFileTime ordinal = 635, argument = 4 */
static gboolean kernel32_GetSystemTimeAsFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemTimes ordinal = 636, argument = 12 */
static gboolean kernel32_GetSystemTimes (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemWindowsDirectoryA ordinal = 637, argument = 8 */
static gboolean kernel32_GetSystemWindowsDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemWindowsDirectoryW ordinal = 638, argument = 8 */
static gboolean kernel32_GetSystemWindowsDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemWow64DirectoryA ordinal = 639, argument = 8 */
static gboolean kernel32_GetSystemWow64DirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetSystemWow64DirectoryW ordinal = 640, argument = 8 */
static gboolean kernel32_GetSystemWow64DirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTapeParameters ordinal = 641, argument = 16 */
static gboolean kernel32_GetTapeParameters (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTapePosition ordinal = 642, argument = 20 */
static gboolean kernel32_GetTapePosition (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTapeStatus ordinal = 643, argument = 4 */
static gboolean kernel32_GetTapeStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTempFileNameA ordinal = 644, argument = 16 */
static gboolean kernel32_GetTempFileNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTempFileNameW ordinal = 645, argument = 16 */
static gboolean kernel32_GetTempFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTempPathA ordinal = 646, argument = 8 */
static gboolean kernel32_GetTempPathA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTempPathW ordinal = 647, argument = 8 */
static gboolean kernel32_GetTempPathW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadContext ordinal = 648, argument = 8 */
static gboolean kernel32_GetThreadContext (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadErrorMode ordinal = 649, argument = 0 */
static gboolean kernel32_GetThreadErrorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadGroupAffinity ordinal = 650, argument = 0 */
static gboolean kernel32_GetThreadGroupAffinity (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadIOPendingFlag ordinal = 651, argument = 8 */
static gboolean kernel32_GetThreadIOPendingFlag (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadId ordinal = 652, argument = 4 */
static gboolean kernel32_GetThreadId (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadIdealProcessorEx ordinal = 653, argument = 0 */
static gboolean kernel32_GetThreadIdealProcessorEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadLocale ordinal = 654, argument = 0 */
static gboolean kernel32_GetThreadLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadPreferredUILanguages ordinal = 655, argument = 16 */
static gboolean kernel32_GetThreadPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadPriority ordinal = 656, argument = 4 */
static gboolean kernel32_GetThreadPriority (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadPriorityBoost ordinal = 657, argument = 8 */
static gboolean kernel32_GetThreadPriorityBoost (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadSelectorEntry ordinal = 658, argument = 12 */
static gboolean kernel32_GetThreadSelectorEntry (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadTimes ordinal = 659, argument = 20 */
static gboolean kernel32_GetThreadTimes (Ia32Thread *thread)
{
  return FALSE;
}


/* GetThreadUILanguage ordinal = 660, argument = 0 */
static gboolean kernel32_GetThreadUILanguage (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTickCount ordinal = 662, argument = 0 */
static gboolean kernel32_GetTickCount (Ia32Thread *thread)
{
  thread->reg.eax = time (NULL) * 1000;
  ia32_message_record_api_with_argument (thread,
                                        "GetTickCount", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GetTickCount64 ordinal = 661, argument = 0 */
static gboolean kernel32_GetTickCount64 (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTimeFormatA ordinal = 663, argument = 24 */
static gboolean kernel32_GetTimeFormatA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTimeFormatEx ordinal = 664, argument = 24 */
static gboolean kernel32_GetTimeFormatEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTimeFormatW ordinal = 665, argument = 24 */
static gboolean kernel32_GetTimeFormatW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTimeZoneInformation ordinal = 666, argument = 4 */
static gboolean kernel32_GetTimeZoneInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* GetTimeZoneInformationForYear ordinal = 667, argument = 0 */
static gboolean kernel32_GetTimeZoneInformationForYear (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUILanguageInfo ordinal = 668, argument = 20 */
static gboolean kernel32_GetUILanguageInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserDefaultLCID ordinal = 669, argument = 0 */
static gboolean kernel32_GetUserDefaultLCID (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserDefaultLangID ordinal = 670, argument = 0 */
static gboolean kernel32_GetUserDefaultLangID (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserDefaultLocaleName ordinal = 671, argument = 8 */
static gboolean kernel32_GetUserDefaultLocaleName (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserDefaultUILanguage ordinal = 672, argument = 0 */
static gboolean kernel32_GetUserDefaultUILanguage (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserGeoID ordinal = 673, argument = 4 */
static gboolean kernel32_GetUserGeoID (Ia32Thread *thread)
{
  return FALSE;
}


/* GetUserPreferredUILanguages ordinal = 674, argument = 16 */
static gboolean kernel32_GetUserPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVDMCurrentDirectories ordinal = 675, argument = 0 */
static gboolean kernel32_GetVDMCurrentDirectories (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVersion ordinal = 676, argument = 0 */
static gboolean kernel32_GetVersion (Ia32Thread *thread)
{
  thread->reg.eax = 0x1db00106;
  ia32_message_record_api_with_argument (thread,
                                        "GetVersion", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GetVersionExA ordinal = 677, argument = 4 */
static gboolean kernel32_GetVersionExA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVersionExW ordinal = 678, argument = 4 */
static gboolean kernel32_GetVersionExW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumeInformationA ordinal = 679, argument = 32 */
static gboolean kernel32_GetVolumeInformationA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumeInformationByHandleW ordinal = 680, argument = 32 */
static gboolean kernel32_GetVolumeInformationByHandleW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumeInformationW ordinal = 681, argument = 32 */
static gboolean kernel32_GetVolumeInformationW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumeNameForVolumeMountPointA ordinal = 682, argument = 12 */
static gboolean kernel32_GetVolumeNameForVolumeMountPointA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumeNameForVolumeMountPointW ordinal = 683, argument = 12 */
static gboolean kernel32_GetVolumeNameForVolumeMountPointW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumePathNameA ordinal = 684, argument = 12 */
static gboolean kernel32_GetVolumePathNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumePathNameW ordinal = 685, argument = 12 */
static gboolean kernel32_GetVolumePathNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumePathNamesForVolumeNameA ordinal = 686, argument = 16 */
static gboolean kernel32_GetVolumePathNamesForVolumeNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetVolumePathNamesForVolumeNameW ordinal = 687, argument = 16 */
static gboolean kernel32_GetVolumePathNamesForVolumeNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetWindowsDirectoryA ordinal = 688, argument = 8 */
static gboolean kernel32_GetWindowsDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* GetWindowsDirectoryW ordinal = 689, argument = 8 */
static gboolean kernel32_GetWindowsDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* GetWriteWatch ordinal = 690, argument = 24 */
static gboolean kernel32_GetWriteWatch (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalAddAtomA ordinal = 691, argument = 4 */
static gboolean kernel32_GlobalAddAtomA (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalAddAtomW ordinal = 692, argument = 4 */
static gboolean kernel32_GlobalAddAtomW (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalAlloc ordinal = 693, argument = 8 */
static gboolean kernel32_GlobalAlloc (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_memory_alloc (thread->process,
                              IA32_MEMORY_NULL,
                              ia32_stack_value (thread, 2),
                              IA32_MEMORY_ATTR_USER);
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "GlobalAlloc", IA32_MESSAGE_HEX,
                                        "uFlags", IA32_MESSAGE_HEX,
                                        "dwBytes", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GlobalCompact ordinal = 694, argument = 4 */
static gboolean kernel32_GlobalCompact (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalDeleteAtom ordinal = 695, argument = 4 */
static gboolean kernel32_GlobalDeleteAtom (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalFindAtomA ordinal = 696, argument = 4 */
static gboolean kernel32_GlobalFindAtomA (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalFindAtomW ordinal = 697, argument = 4 */
static gboolean kernel32_GlobalFindAtomW (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalFix ordinal = 698, argument = 4 */
static gboolean kernel32_GlobalFix (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalFlags ordinal = 699, argument = 4 */
static gboolean kernel32_GlobalFlags (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalFree ordinal = 700, argument = 4 */
static gboolean kernel32_GlobalFree (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_memory_free (thread->process, ia32_stack_value (thread, 1));
  ia32_message_record_api_with_argument (thread,
                                        "GlobalFree", IA32_MESSAGE_HEX,
                                        "hMem", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GlobalGetAtomNameA ordinal = 701, argument = 12 */
static gboolean kernel32_GlobalGetAtomNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalGetAtomNameW ordinal = 702, argument = 12 */
static gboolean kernel32_GlobalGetAtomNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalHandle ordinal = 703, argument = 4 */
static gboolean kernel32_GlobalHandle (Ia32Thread *thread)
{
  thread->reg.eax = ia32_stack_value (thread, 1);
  ia32_message_record_api_with_argument (thread,
                                        "GlobalHandle", IA32_MESSAGE_HEX,
                                        "pMem", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GlobalLock ordinal = 704, argument = 4 */
static gboolean kernel32_GlobalLock (Ia32Thread *thread)
{
  thread->reg.eax = ia32_stack_value (thread, 1);
  ia32_message_record_api_with_argument (thread,
                                        "GlobalLock", IA32_MESSAGE_HEX,
                                        "hMem", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GlobalMemoryStatus ordinal = 705, argument = 4 */
static gboolean kernel32_GlobalMemoryStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalMemoryStatusEx ordinal = 706, argument = 4 */
static gboolean kernel32_GlobalMemoryStatusEx (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalReAlloc ordinal = 707, argument = 12 */
static gboolean kernel32_GlobalReAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalSize ordinal = 708, argument = 4 */
static gboolean kernel32_GlobalSize (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalUnWire ordinal = 709, argument = 4 */
static gboolean kernel32_GlobalUnWire (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalUnfix ordinal = 710, argument = 4 */
static gboolean kernel32_GlobalUnfix (Ia32Thread *thread)
{
  return FALSE;
}


/* GlobalUnlock ordinal = 711, argument = 4 */
static gboolean kernel32_GlobalUnlock (Ia32Thread *thread)
{
  thread->reg.eax = FALSE;
  ia32_message_record_api_with_argument (thread,
                                        "GlobalUnlock", IA32_MESSAGE_DEC,
                                        "hMem", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* GlobalWire ordinal = 712, argument = 4 */
static gboolean kernel32_GlobalWire (Ia32Thread *thread)
{
  return FALSE;
}


/* Heap32First ordinal = 713, argument = 12 */
static gboolean kernel32_Heap32First (Ia32Thread *thread)
{
  return FALSE;
}


/* Heap32ListFirst ordinal = 714, argument = 8 */
static gboolean kernel32_Heap32ListFirst (Ia32Thread *thread)
{
  return FALSE;
}


/* Heap32ListNext ordinal = 715, argument = 8 */
static gboolean kernel32_Heap32ListNext (Ia32Thread *thread)
{
  return FALSE;
}


/* Heap32Next ordinal = 716, argument = 4 */
static gboolean kernel32_Heap32Next (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapAlloc ordinal = 717, argument = 12 */
static gboolean kernel32_HeapAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapCompact ordinal = 718, argument = 8 */
static gboolean kernel32_HeapCompact (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapCreate ordinal = 719, argument = 12 */
static gboolean kernel32_HeapCreate (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapDestroy ordinal = 720, argument = 4 */
static gboolean kernel32_HeapDestroy (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapFree ordinal = 721, argument = 12 */
static gboolean kernel32_HeapFree (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapLock ordinal = 722, argument = 4 */
static gboolean kernel32_HeapLock (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapQueryInformation ordinal = 723, argument = 20 */
static gboolean kernel32_HeapQueryInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapReAlloc ordinal = 724, argument = 16 */
static gboolean kernel32_HeapReAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapSetInformation ordinal = 725, argument = 16 */
static gboolean kernel32_HeapSetInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapSize ordinal = 726, argument = 12 */
static gboolean kernel32_HeapSize (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapSummary ordinal = 727, argument = 0 */
static gboolean kernel32_HeapSummary (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapUnlock ordinal = 728, argument = 4 */
static gboolean kernel32_HeapUnlock (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapValidate ordinal = 729, argument = 12 */
static gboolean kernel32_HeapValidate (Ia32Thread *thread)
{
  return FALSE;
}


/* HeapWalk ordinal = 730, argument = 8 */
static gboolean kernel32_HeapWalk (Ia32Thread *thread)
{
  return FALSE;
}


/* IdnToAscii ordinal = 731, argument = 0 */
static gboolean kernel32_IdnToAscii (Ia32Thread *thread)
{
  return FALSE;
}


/* IdnToNameprepUnicode ordinal = 732, argument = 0 */
static gboolean kernel32_IdnToNameprepUnicode (Ia32Thread *thread)
{
  return FALSE;
}


/* IdnToUnicode ordinal = 733, argument = 0 */
static gboolean kernel32_IdnToUnicode (Ia32Thread *thread)
{
  return FALSE;
}


/* InitAtomTable ordinal = 734, argument = 4 */
static gboolean kernel32_InitAtomTable (Ia32Thread *thread)
{
  return FALSE;
}


/* InitOnceBeginInitialize ordinal = 735, argument = 16 */
static gboolean kernel32_InitOnceBeginInitialize (Ia32Thread *thread)
{
  return FALSE;
}


/* InitOnceComplete ordinal = 736, argument = 12 */
static gboolean kernel32_InitOnceComplete (Ia32Thread *thread)
{
  return FALSE;
}


/* InitOnceExecuteOnce ordinal = 737, argument = 16 */
static gboolean kernel32_InitOnceExecuteOnce (Ia32Thread *thread)
{
  return FALSE;
}


/* InitOnceInitialize ordinal = 738, argument = 4 */
static gboolean kernel32_InitOnceInitialize (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeConditionVariable ordinal = 739, argument = 4 */
static gboolean kernel32_InitializeConditionVariable (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeCriticalSection ordinal = 740, argument = 4 */
static gboolean kernel32_InitializeCriticalSection (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeCriticalSectionAndSpinCount ordinal = 741, argument = 8 */
static gboolean kernel32_InitializeCriticalSectionAndSpinCount (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeCriticalSectionEx ordinal = 742, argument = 12 */
static gboolean kernel32_InitializeCriticalSectionEx (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeExtendedContext ordinal = 743, argument = 0 */
static gboolean kernel32_InitializeExtendedContext (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeProcThreadAttributeList ordinal = 744, argument = 16 */
static gboolean kernel32_InitializeProcThreadAttributeList (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeSListHead ordinal = 745, argument = 4 */
static gboolean kernel32_InitializeSListHead (Ia32Thread *thread)
{
  return FALSE;
}


/* InitializeSRWLock ordinal = 746, argument = 4 */
static gboolean kernel32_InitializeSRWLock (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedCompareExchange ordinal = 748, argument = 12 */
static gboolean kernel32_InterlockedCompareExchange (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedCompareExchange64 ordinal = 747, argument = 20 */
static gboolean kernel32_InterlockedCompareExchange64 (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedDecrement ordinal = 749, argument = 4 */
static gboolean kernel32_InterlockedDecrement (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedExchange ordinal = 750, argument = 8 */
static gboolean kernel32_InterlockedExchange (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedExchangeAdd ordinal = 751, argument = 8 */
static gboolean kernel32_InterlockedExchangeAdd (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedFlushSList ordinal = 752, argument = 4 */
static gboolean kernel32_InterlockedFlushSList (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedIncrement ordinal = 753, argument = 4 */
static gboolean kernel32_InterlockedIncrement (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedPopEntrySList ordinal = 754, argument = 4 */
static gboolean kernel32_InterlockedPopEntrySList (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedPushEntrySList ordinal = 755, argument = 8 */
static gboolean kernel32_InterlockedPushEntrySList (Ia32Thread *thread)
{
  return FALSE;
}


/* InterlockedPushListSList ordinal = 2, argument = 0 */
static gboolean kernel32_InterlockedPushListSList (Ia32Thread *thread)
{
  return FALSE;
}


/* InvalidateConsoleDIBits ordinal = 756, argument = 0 */
static gboolean kernel32_InvalidateConsoleDIBits (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadCodePtr ordinal = 757, argument = 4 */
static gboolean kernel32_IsBadCodePtr (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadHugeReadPtr ordinal = 758, argument = 8 */
static gboolean kernel32_IsBadHugeReadPtr (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadHugeWritePtr ordinal = 759, argument = 8 */
static gboolean kernel32_IsBadHugeWritePtr (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadReadPtr ordinal = 760, argument = 8 */
static gboolean kernel32_IsBadReadPtr (Ia32Thread *thread)
{
  thread->reg.eax = FALSE;
  ia32_message_record_api_with_argument (thread,
                                        "IsBadReadPtr", IA32_MESSAGE_DEC,
                                        "lp", IA32_MESSAGE_HEX,
                                        "ucb", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* IsBadStringPtrA ordinal = 761, argument = 8 */
static gboolean kernel32_IsBadStringPtrA (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadStringPtrW ordinal = 762, argument = 8 */
static gboolean kernel32_IsBadStringPtrW (Ia32Thread *thread)
{
  return FALSE;
}


/* IsBadWritePtr ordinal = 763, argument = 8 */
static gboolean kernel32_IsBadWritePtr (Ia32Thread *thread)
{
  guint32 s, address, size;

  address = ia32_stack_value (thread, 1);
  size = ia32_stack_value (thread, 2);
  while (size > 0
                && (s = ia32_memory_real_size (thread->process, address)) > 0)
    {
      address += s;
      size = size > s ? size - s : 0;
    }
  thread->reg.eax = size <= 0;
  ia32_message_record_api_with_argument (thread,
                                        "IsBadWritePtr", IA32_MESSAGE_DEC,
                                        "lp", IA32_MESSAGE_HEX,
                                        "ucp", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* IsCalendarLeapDay ordinal = 764, argument = 0 */
static gboolean kernel32_IsCalendarLeapDay (Ia32Thread *thread)
{
  return FALSE;
}


/* IsCalendarLeapMonth ordinal = 765, argument = 0 */
static gboolean kernel32_IsCalendarLeapMonth (Ia32Thread *thread)
{
  return FALSE;
}


/* IsCalendarLeapYear ordinal = 766, argument = 0 */
static gboolean kernel32_IsCalendarLeapYear (Ia32Thread *thread)
{
  return FALSE;
}


/* IsDBCSLeadByte ordinal = 767, argument = 4 */
static gboolean kernel32_IsDBCSLeadByte (Ia32Thread *thread)
{
  return FALSE;
}


/* IsDBCSLeadByteEx ordinal = 768, argument = 8 */
static gboolean kernel32_IsDBCSLeadByteEx (Ia32Thread *thread)
{
  return FALSE;
}


/* IsDebuggerPresent ordinal = 769, argument = 0 */
static gboolean kernel32_IsDebuggerPresent (Ia32Thread *thread)
{
  thread->reg.eax = FALSE;
  ia32_message_record_api_with_argument (thread,
                                        "IsDebuggerPresent", IA32_MESSAGE_DEC,
                                        NULL);
  return TRUE;
}


/* IsNLSDefinedString ordinal = 770, argument = 20 */
static gboolean kernel32_IsNLSDefinedString (Ia32Thread *thread)
{
  return FALSE;
}


/* IsNormalizedString ordinal = 771, argument = 0 */
static gboolean kernel32_IsNormalizedString (Ia32Thread *thread)
{
  return FALSE;
}


/* IsProcessInJob ordinal = 772, argument = 12 */
static gboolean kernel32_IsProcessInJob (Ia32Thread *thread)
{
  return FALSE;
}


/* IsProcessorFeaturePresent ordinal = 773, argument = 4 */
static gboolean kernel32_IsProcessorFeaturePresent (Ia32Thread *thread)
{
  return FALSE;
}


/* IsSystemResumeAutomatic ordinal = 774, argument = 0 */
static gboolean kernel32_IsSystemResumeAutomatic (Ia32Thread *thread)
{
  return FALSE;
}


/* IsThreadAFiber ordinal = 775, argument = 0 */
static gboolean kernel32_IsThreadAFiber (Ia32Thread *thread)
{
  return FALSE;
}


/* IsThreadpoolTimerSet ordinal = 776, argument = 4 */
static gboolean kernel32_IsThreadpoolTimerSet (Ia32Thread *thread)
{
  return FALSE;
}


/* IsTimeZoneRedirectionEnabled ordinal = 777, argument = 0 */
static gboolean kernel32_IsTimeZoneRedirectionEnabled (Ia32Thread *thread)
{
  return FALSE;
}


/* IsValidCalDateTime ordinal = 778, argument = 0 */
static gboolean kernel32_IsValidCalDateTime (Ia32Thread *thread)
{
  return FALSE;
}


/* IsValidCodePage ordinal = 779, argument = 4 */
static gboolean kernel32_IsValidCodePage (Ia32Thread *thread)
{
  return FALSE;
}


/* IsValidLanguageGroup ordinal = 780, argument = 8 */
static gboolean kernel32_IsValidLanguageGroup (Ia32Thread *thread)
{
  return FALSE;
}


/* IsValidLocale ordinal = 781, argument = 8 */
static gboolean kernel32_IsValidLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* IsValidLocaleName ordinal = 782, argument = 4 */
static gboolean kernel32_IsValidLocaleName (Ia32Thread *thread)
{
  return FALSE;
}


/* IsWow64Process ordinal = 783, argument = 8 */
static gboolean kernel32_IsWow64Process (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EmptyWorkingSet ordinal = 784, argument = 0 */
static gboolean kernel32_K32EmptyWorkingSet (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumDeviceDrivers ordinal = 785, argument = 0 */
static gboolean kernel32_K32EnumDeviceDrivers (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumPageFilesA ordinal = 786, argument = 0 */
static gboolean kernel32_K32EnumPageFilesA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumPageFilesW ordinal = 787, argument = 0 */
static gboolean kernel32_K32EnumPageFilesW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumProcessModules ordinal = 788, argument = 0 */
static gboolean kernel32_K32EnumProcessModules (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumProcessModulesEx ordinal = 789, argument = 0 */
static gboolean kernel32_K32EnumProcessModulesEx (Ia32Thread *thread)
{
  return FALSE;
}


/* K32EnumProcesses ordinal = 790, argument = 0 */
static gboolean kernel32_K32EnumProcesses (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetDeviceDriverBaseNameA ordinal = 791, argument = 0 */
static gboolean kernel32_K32GetDeviceDriverBaseNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetDeviceDriverBaseNameW ordinal = 792, argument = 0 */
static gboolean kernel32_K32GetDeviceDriverBaseNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetDeviceDriverFileNameA ordinal = 793, argument = 0 */
static gboolean kernel32_K32GetDeviceDriverFileNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetDeviceDriverFileNameW ordinal = 794, argument = 0 */
static gboolean kernel32_K32GetDeviceDriverFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetMappedFileNameA ordinal = 795, argument = 0 */
static gboolean kernel32_K32GetMappedFileNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetMappedFileNameW ordinal = 796, argument = 0 */
static gboolean kernel32_K32GetMappedFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetModuleBaseNameA ordinal = 797, argument = 0 */
static gboolean kernel32_K32GetModuleBaseNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetModuleBaseNameW ordinal = 798, argument = 0 */
static gboolean kernel32_K32GetModuleBaseNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetModuleFileNameExA ordinal = 799, argument = 0 */
static gboolean kernel32_K32GetModuleFileNameExA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetModuleFileNameExW ordinal = 800, argument = 0 */
static gboolean kernel32_K32GetModuleFileNameExW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetModuleInformation ordinal = 801, argument = 0 */
static gboolean kernel32_K32GetModuleInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetPerformanceInfo ordinal = 802, argument = 0 */
static gboolean kernel32_K32GetPerformanceInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetProcessImageFileNameA ordinal = 803, argument = 0 */
static gboolean kernel32_K32GetProcessImageFileNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetProcessImageFileNameW ordinal = 804, argument = 0 */
static gboolean kernel32_K32GetProcessImageFileNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetProcessMemoryInfo ordinal = 805, argument = 0 */
static gboolean kernel32_K32GetProcessMemoryInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetWsChanges ordinal = 806, argument = 0 */
static gboolean kernel32_K32GetWsChanges (Ia32Thread *thread)
{
  return FALSE;
}


/* K32GetWsChangesEx ordinal = 807, argument = 0 */
static gboolean kernel32_K32GetWsChangesEx (Ia32Thread *thread)
{
  return FALSE;
}


/* K32InitializeProcessForWsWatch ordinal = 808, argument = 0 */
static gboolean kernel32_K32InitializeProcessForWsWatch (Ia32Thread *thread)
{
  return FALSE;
}


/* K32QueryWorkingSet ordinal = 809, argument = 0 */
static gboolean kernel32_K32QueryWorkingSet (Ia32Thread *thread)
{
  return FALSE;
}


/* K32QueryWorkingSetEx ordinal = 810, argument = 0 */
static gboolean kernel32_K32QueryWorkingSetEx (Ia32Thread *thread)
{
  return FALSE;
}


/* LCIDToLocaleName ordinal = 811, argument = 16 */
static gboolean kernel32_LCIDToLocaleName (Ia32Thread *thread)
{
  return FALSE;
}


/* LCMapStringA ordinal = 812, argument = 24 */
static gboolean kernel32_LCMapStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* LCMapStringEx ordinal = 813, argument = 36 */
static gboolean kernel32_LCMapStringEx (Ia32Thread *thread)
{
  return FALSE;
}


/* LCMapStringW ordinal = 814, argument = 24 */
static gboolean kernel32_LCMapStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* LZClose ordinal = 815, argument = 0 */
static gboolean kernel32_LZClose (Ia32Thread *thread)
{
  return FALSE;
}


/* LZCloseFile ordinal = 816, argument = 0 */
static gboolean kernel32_LZCloseFile (Ia32Thread *thread)
{
  return FALSE;
}


/* LZCopy ordinal = 817, argument = 0 */
static gboolean kernel32_LZCopy (Ia32Thread *thread)
{
  return FALSE;
}


/* LZCreateFileW ordinal = 818, argument = 0 */
static gboolean kernel32_LZCreateFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* LZDone ordinal = 819, argument = 0 */
static gboolean kernel32_LZDone (Ia32Thread *thread)
{
  return FALSE;
}


/* LZInit ordinal = 820, argument = 0 */
static gboolean kernel32_LZInit (Ia32Thread *thread)
{
  return FALSE;
}


/* LZOpenFileA ordinal = 821, argument = 0 */
static gboolean kernel32_LZOpenFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* LZOpenFileW ordinal = 822, argument = 0 */
static gboolean kernel32_LZOpenFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* LZRead ordinal = 823, argument = 0 */
static gboolean kernel32_LZRead (Ia32Thread *thread)
{
  return FALSE;
}


/* LZSeek ordinal = 824, argument = 0 */
static gboolean kernel32_LZSeek (Ia32Thread *thread)
{
  return FALSE;
}


/* LZStart ordinal = 825, argument = 0 */
static gboolean kernel32_LZStart (Ia32Thread *thread)
{
  return FALSE;
}


/* LeaveCriticalSection ordinal = 826, argument = 4 */
static gboolean kernel32_LeaveCriticalSection (Ia32Thread *thread)
{
  return FALSE;
}


/* LeaveCriticalSectionWhenCallbackReturns ordinal = 827, argument = 8 */
static gboolean kernel32_LeaveCriticalSectionWhenCallbackReturns (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadAppInitDlls ordinal = 828, argument = 0 */
static gboolean kernel32_LoadAppInitDlls (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadLibraryA ordinal = 829, argument = 4 */
static gboolean kernel32_LoadLibraryA (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_module_load_library (thread->process,
                                                ia32_stack_string (thread, 1));
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "LoadLibraryA", IA32_MESSAGE_HEX,
                                        "lpFileName", IA32_MESSAGE_STRING,
                                        NULL);
  return TRUE;
}


/* LoadLibraryExA ordinal = 830, argument = 12 */
static gboolean kernel32_LoadLibraryExA (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadLibraryExW ordinal = 831, argument = 12 */
static gboolean kernel32_LoadLibraryExW (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadLibraryW ordinal = 832, argument = 4 */
static gboolean kernel32_LoadLibraryW (Ia32Thread *thread)
{
  gchar *utf8str;
  guint32 address;

  utf8str = g_utf16_to_utf8 (ia32_stack_stringw (thread, 1), -1,
                                                            NULL, NULL, NULL);
  address = ia32_module_load_library (thread->process, utf8str);
  g_free (utf8str);
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "LoadLibraryW", IA32_MESSAGE_HEX,
                                        "lpFileName", IA32_MESSAGE_STRINGW,
                                        NULL);
  return TRUE;
}


/* LoadModule ordinal = 833, argument = 8 */
static gboolean kernel32_LoadModule (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadResource ordinal = 834, argument = 8 */
static gboolean kernel32_LoadResource (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadStringBaseExW ordinal = 835, argument = 20 */
static gboolean kernel32_LoadStringBaseExW (Ia32Thread *thread)
{
  return FALSE;
}


/* LoadStringBaseW ordinal = 836, argument = 16 */
static gboolean kernel32_LoadStringBaseW (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalAlloc ordinal = 837, argument = 8 */
static gboolean kernel32_LocalAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalCompact ordinal = 838, argument = 4 */
static gboolean kernel32_LocalCompact (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalFileTimeToFileTime ordinal = 839, argument = 8 */
static gboolean kernel32_LocalFileTimeToFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalFlags ordinal = 840, argument = 4 */
static gboolean kernel32_LocalFlags (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalFree ordinal = 841, argument = 4 */
static gboolean kernel32_LocalFree (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalHandle ordinal = 842, argument = 4 */
static gboolean kernel32_LocalHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalLock ordinal = 843, argument = 4 */
static gboolean kernel32_LocalLock (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalReAlloc ordinal = 844, argument = 12 */
static gboolean kernel32_LocalReAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalShrink ordinal = 845, argument = 8 */
static gboolean kernel32_LocalShrink (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalSize ordinal = 846, argument = 4 */
static gboolean kernel32_LocalSize (Ia32Thread *thread)
{
  return FALSE;
}


/* LocalUnlock ordinal = 847, argument = 4 */
static gboolean kernel32_LocalUnlock (Ia32Thread *thread)
{
  return FALSE;
}


/* LocaleNameToLCID ordinal = 848, argument = 8 */
static gboolean kernel32_LocaleNameToLCID (Ia32Thread *thread)
{
  return FALSE;
}


/* LocateExtendedFeature ordinal = 849, argument = 0 */
static gboolean kernel32_LocateExtendedFeature (Ia32Thread *thread)
{
  return FALSE;
}


/* LocateLegacyContext ordinal = 850, argument = 0 */
static gboolean kernel32_LocateLegacyContext (Ia32Thread *thread)
{
  return FALSE;
}


/* LockFile ordinal = 851, argument = 20 */
static gboolean kernel32_LockFile (Ia32Thread *thread)
{
  return FALSE;
}


/* LockFileEx ordinal = 852, argument = 24 */
static gboolean kernel32_LockFileEx (Ia32Thread *thread)
{
  return FALSE;
}


/* LockResource ordinal = 853, argument = 4 */
static gboolean kernel32_LockResource (Ia32Thread *thread)
{
  return FALSE;
}


/* MapUserPhysicalPages ordinal = 854, argument = 12 */
static gboolean kernel32_MapUserPhysicalPages (Ia32Thread *thread)
{
  return FALSE;
}


/* MapUserPhysicalPagesScatter ordinal = 855, argument = 12 */
static gboolean kernel32_MapUserPhysicalPagesScatter (Ia32Thread *thread)
{
  return FALSE;
}


/* MapViewOfFile ordinal = 856, argument = 20 */
static gboolean kernel32_MapViewOfFile (Ia32Thread *thread)
{
  return FALSE;
}


/* MapViewOfFileEx ordinal = 857, argument = 24 */
static gboolean kernel32_MapViewOfFileEx (Ia32Thread *thread)
{
  return FALSE;
}


/* MapViewOfFileExNuma ordinal = 858, argument = 28 */
static gboolean kernel32_MapViewOfFileExNuma (Ia32Thread *thread)
{
  return FALSE;
}


/* Module32First ordinal = 859, argument = 8 */
static gboolean kernel32_Module32First (Ia32Thread *thread)
{
  return FALSE;
}


/* Module32FirstW ordinal = 860, argument = 8 */
static gboolean kernel32_Module32FirstW (Ia32Thread *thread)
{
  return FALSE;
}


/* Module32Next ordinal = 861, argument = 8 */
static gboolean kernel32_Module32Next (Ia32Thread *thread)
{
  return FALSE;
}


/* Module32NextW ordinal = 862, argument = 8 */
static gboolean kernel32_Module32NextW (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileA ordinal = 863, argument = 8 */
static gboolean kernel32_MoveFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileExA ordinal = 864, argument = 12 */
static gboolean kernel32_MoveFileExA (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileExW ordinal = 865, argument = 12 */
static gboolean kernel32_MoveFileExW (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileTransactedA ordinal = 866, argument = 24 */
static gboolean kernel32_MoveFileTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileTransactedW ordinal = 867, argument = 24 */
static gboolean kernel32_MoveFileTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileW ordinal = 868, argument = 8 */
static gboolean kernel32_MoveFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileWithProgressA ordinal = 869, argument = 20 */
static gboolean kernel32_MoveFileWithProgressA (Ia32Thread *thread)
{
  return FALSE;
}


/* MoveFileWithProgressW ordinal = 870, argument = 20 */
static gboolean kernel32_MoveFileWithProgressW (Ia32Thread *thread)
{
  return FALSE;
}


/* MulDiv ordinal = 871, argument = 12 */
static gboolean kernel32_MulDiv (Ia32Thread *thread)
{
  return FALSE;
}


/* MultiByteToWideChar ordinal = 872, argument = 24 */
static gboolean kernel32_MultiByteToWideChar (Ia32Thread *thread)
{
  return FALSE;
}


/* NeedCurrentDirectoryForExePathA ordinal = 873, argument = 4 */
static gboolean kernel32_NeedCurrentDirectoryForExePathA (Ia32Thread *thread)
{
  return FALSE;
}


/* NeedCurrentDirectoryForExePathW ordinal = 874, argument = 4 */
static gboolean kernel32_NeedCurrentDirectoryForExePathW (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsCheckPolicy ordinal = 875, argument = 0 */
static gboolean kernel32_NlsCheckPolicy (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsEventDataDescCreate ordinal = 876, argument = 0 */
static gboolean kernel32_NlsEventDataDescCreate (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsGetCacheUpdateCount ordinal = 877, argument = 0 */
static gboolean kernel32_NlsGetCacheUpdateCount (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsUpdateLocale ordinal = 878, argument = 0 */
static gboolean kernel32_NlsUpdateLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsUpdateSystemLocale ordinal = 879, argument = 0 */
static gboolean kernel32_NlsUpdateSystemLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* NlsWriteEtwEvent ordinal = 880, argument = 0 */
static gboolean kernel32_NlsWriteEtwEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* NormalizeString ordinal = 881, argument = 0 */
static gboolean kernel32_NormalizeString (Ia32Thread *thread)
{
  return FALSE;
}


/* NotifyMountMgr ordinal = 882, argument = 0 */
static gboolean kernel32_NotifyMountMgr (Ia32Thread *thread)
{
  return FALSE;
}


/* NotifyUILanguageChange ordinal = 883, argument = 20 */
static gboolean kernel32_NotifyUILanguageChange (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenConsoleW ordinal = 884, argument = 0 */
static gboolean kernel32_OpenConsoleW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenEventA ordinal = 885, argument = 12 */
static gboolean kernel32_OpenEventA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenEventW ordinal = 886, argument = 12 */
static gboolean kernel32_OpenEventW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenFile ordinal = 887, argument = 12 */
static gboolean kernel32_OpenFile (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenFileById ordinal = 888, argument = 24 */
static gboolean kernel32_OpenFileById (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenFileMappingA ordinal = 889, argument = 12 */
static gboolean kernel32_OpenFileMappingA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenFileMappingW ordinal = 890, argument = 12 */
static gboolean kernel32_OpenFileMappingW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenJobObjectA ordinal = 891, argument = 12 */
static gboolean kernel32_OpenJobObjectA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenJobObjectW ordinal = 892, argument = 12 */
static gboolean kernel32_OpenJobObjectW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenMutexA ordinal = 893, argument = 12 */
static gboolean kernel32_OpenMutexA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenMutexW ordinal = 894, argument = 12 */
static gboolean kernel32_OpenMutexW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenPrivateNamespaceA ordinal = 895, argument = 8 */
static gboolean kernel32_OpenPrivateNamespaceA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenPrivateNamespaceW ordinal = 896, argument = 8 */
static gboolean kernel32_OpenPrivateNamespaceW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenProcess ordinal = 897, argument = 12 */
static gboolean kernel32_OpenProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenProcessToken ordinal = 898, argument = 0 */
static gboolean kernel32_OpenProcessToken (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenProfileUserMapping ordinal = 899, argument = 0 */
static gboolean kernel32_OpenProfileUserMapping (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenSemaphoreA ordinal = 900, argument = 12 */
static gboolean kernel32_OpenSemaphoreA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenSemaphoreW ordinal = 901, argument = 12 */
static gboolean kernel32_OpenSemaphoreW (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenThread ordinal = 902, argument = 12 */
static gboolean kernel32_OpenThread (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenThreadToken ordinal = 903, argument = 0 */
static gboolean kernel32_OpenThreadToken (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenWaitableTimerA ordinal = 904, argument = 12 */
static gboolean kernel32_OpenWaitableTimerA (Ia32Thread *thread)
{
  return FALSE;
}


/* OpenWaitableTimerW ordinal = 905, argument = 12 */
static gboolean kernel32_OpenWaitableTimerW (Ia32Thread *thread)
{
  return FALSE;
}


/* OutputDebugStringA ordinal = 906, argument = 4 */
static gboolean kernel32_OutputDebugStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* OutputDebugStringW ordinal = 907, argument = 4 */
static gboolean kernel32_OutputDebugStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* PeekConsoleInputA ordinal = 908, argument = 16 */
static gboolean kernel32_PeekConsoleInputA (Ia32Thread *thread)
{
  return FALSE;
}


/* PeekConsoleInputW ordinal = 909, argument = 16 */
static gboolean kernel32_PeekConsoleInputW (Ia32Thread *thread)
{
  return FALSE;
}


/* PeekNamedPipe ordinal = 910, argument = 24 */
static gboolean kernel32_PeekNamedPipe (Ia32Thread *thread)
{
  return FALSE;
}


/* PostQueuedCompletionStatus ordinal = 911, argument = 16 */
static gboolean kernel32_PostQueuedCompletionStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* PowerClearRequest ordinal = 912, argument = 0 */
static gboolean kernel32_PowerClearRequest (Ia32Thread *thread)
{
  return FALSE;
}


/* PowerCreateRequest ordinal = 913, argument = 0 */
static gboolean kernel32_PowerCreateRequest (Ia32Thread *thread)
{
  return FALSE;
}


/* PowerSetRequest ordinal = 914, argument = 0 */
static gboolean kernel32_PowerSetRequest (Ia32Thread *thread)
{
  return FALSE;
}


/* PrepareTape ordinal = 915, argument = 12 */
static gboolean kernel32_PrepareTape (Ia32Thread *thread)
{
  return FALSE;
}


/* PrivCopyFileExW ordinal = 916, argument = 0 */
static gboolean kernel32_PrivCopyFileExW (Ia32Thread *thread)
{
  return FALSE;
}


/* PrivMoveFileIdentityW ordinal = 917, argument = 0 */
static gboolean kernel32_PrivMoveFileIdentityW (Ia32Thread *thread)
{
  return FALSE;
}


/* Process32First ordinal = 918, argument = 8 */
static gboolean kernel32_Process32First (Ia32Thread *thread)
{
  return FALSE;
}


/* Process32FirstW ordinal = 919, argument = 8 */
static gboolean kernel32_Process32FirstW (Ia32Thread *thread)
{
  return FALSE;
}


/* Process32Next ordinal = 920, argument = 8 */
static gboolean kernel32_Process32Next (Ia32Thread *thread)
{
  return FALSE;
}


/* Process32NextW ordinal = 921, argument = 8 */
static gboolean kernel32_Process32NextW (Ia32Thread *thread)
{
  return FALSE;
}


/* ProcessIdToSessionId ordinal = 922, argument = 8 */
static gboolean kernel32_ProcessIdToSessionId (Ia32Thread *thread)
{
  return FALSE;
}


/* PulseEvent ordinal = 923, argument = 4 */
static gboolean kernel32_PulseEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* PurgeComm ordinal = 924, argument = 8 */
static gboolean kernel32_PurgeComm (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryActCtxSettingsW ordinal = 925, argument = 28 */
static gboolean kernel32_QueryActCtxSettingsW (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryActCtxW ordinal = 926, argument = 28 */
static gboolean kernel32_QueryActCtxW (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryDepthSList ordinal = 927, argument = 4 */
static gboolean kernel32_QueryDepthSList (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryDosDeviceA ordinal = 928, argument = 12 */
static gboolean kernel32_QueryDosDeviceA (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryDosDeviceW ordinal = 929, argument = 12 */
static gboolean kernel32_QueryDosDeviceW (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryFullProcessImageNameA ordinal = 930, argument = 16 */
static gboolean kernel32_QueryFullProcessImageNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryFullProcessImageNameW ordinal = 931, argument = 16 */
static gboolean kernel32_QueryFullProcessImageNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryIdleProcessorCycleTime ordinal = 932, argument = 8 */
static gboolean kernel32_QueryIdleProcessorCycleTime (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryIdleProcessorCycleTimeEx ordinal = 933, argument = 0 */
static gboolean kernel32_QueryIdleProcessorCycleTimeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryInformationJobObject ordinal = 934, argument = 20 */
static gboolean kernel32_QueryInformationJobObject (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryMemoryResourceNotification ordinal = 935, argument = 8 */
static gboolean kernel32_QueryMemoryResourceNotification (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryPerformanceCounter ordinal = 936, argument = 4 */
static gboolean kernel32_QueryPerformanceCounter (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryPerformanceFrequency ordinal = 937, argument = 4 */
static gboolean kernel32_QueryPerformanceFrequency (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryProcessAffinityUpdateMode ordinal = 938, argument = 0 */
static gboolean kernel32_QueryProcessAffinityUpdateMode (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryProcessCycleTime ordinal = 939, argument = 8 */
static gboolean kernel32_QueryProcessCycleTime (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryThreadCycleTime ordinal = 940, argument = 8 */
static gboolean kernel32_QueryThreadCycleTime (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryThreadProfiling ordinal = 941, argument = 0 */
static gboolean kernel32_QueryThreadProfiling (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryThreadpoolStackInformation ordinal = 942, argument = 0 */
static gboolean kernel32_QueryThreadpoolStackInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* QueryUnbiasedInterruptTime ordinal = 943, argument = 0 */
static gboolean kernel32_QueryUnbiasedInterruptTime (Ia32Thread *thread)
{
  return FALSE;
}


/* QueueUserAPC ordinal = 944, argument = 12 */
static gboolean kernel32_QueueUserAPC (Ia32Thread *thread)
{
  return FALSE;
}


/* QueueUserWorkItem ordinal = 945, argument = 12 */
static gboolean kernel32_QueueUserWorkItem (Ia32Thread *thread)
{
  return FALSE;
}


/* RaiseException ordinal = 946, argument = 16 */
static gboolean kernel32_RaiseException (Ia32Thread *thread)
{
  return FALSE;
}


/* RaiseFailFastException ordinal = 947, argument = 0 */
static gboolean kernel32_RaiseFailFastException (Ia32Thread *thread)
{
  return FALSE;
}


/* ReOpenFile ordinal = 948, argument = 16 */
static gboolean kernel32_ReOpenFile (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleA ordinal = 949, argument = 20 */
static gboolean kernel32_ReadConsoleA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleInputA ordinal = 950, argument = 16 */
static gboolean kernel32_ReadConsoleInputA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleInputExA ordinal = 951, argument = 0 */
static gboolean kernel32_ReadConsoleInputExA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleInputExW ordinal = 952, argument = 0 */
static gboolean kernel32_ReadConsoleInputExW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleInputW ordinal = 953, argument = 16 */
static gboolean kernel32_ReadConsoleInputW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleOutputA ordinal = 954, argument = 20 */
static gboolean kernel32_ReadConsoleOutputA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleOutputAttribute ordinal = 955, argument = 20 */
static gboolean kernel32_ReadConsoleOutputAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleOutputCharacterA ordinal = 956, argument = 20 */
static gboolean kernel32_ReadConsoleOutputCharacterA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleOutputCharacterW ordinal = 957, argument = 20 */
static gboolean kernel32_ReadConsoleOutputCharacterW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleOutputW ordinal = 958, argument = 20 */
static gboolean kernel32_ReadConsoleOutputW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadConsoleW ordinal = 959, argument = 20 */
static gboolean kernel32_ReadConsoleW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadDirectoryChangesW ordinal = 960, argument = 32 */
static gboolean kernel32_ReadDirectoryChangesW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadFile ordinal = 961, argument = 20 */
static gboolean kernel32_ReadFile (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadFileEx ordinal = 962, argument = 20 */
static gboolean kernel32_ReadFileEx (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadFileScatter ordinal = 963, argument = 20 */
static gboolean kernel32_ReadFileScatter (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadProcessMemory ordinal = 964, argument = 20 */
static gboolean kernel32_ReadProcessMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* ReadThreadProfilingData ordinal = 965, argument = 0 */
static gboolean kernel32_ReadThreadProfilingData (Ia32Thread *thread)
{
  return FALSE;
}


/* RegCloseKey ordinal = 966, argument = 0 */
static gboolean kernel32_RegCloseKey (Ia32Thread *thread)
{
  return FALSE;
}


/* RegCreateKeyExA ordinal = 967, argument = 0 */
static gboolean kernel32_RegCreateKeyExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegCreateKeyExW ordinal = 968, argument = 0 */
static gboolean kernel32_RegCreateKeyExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteKeyExA ordinal = 969, argument = 0 */
static gboolean kernel32_RegDeleteKeyExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteKeyExW ordinal = 970, argument = 0 */
static gboolean kernel32_RegDeleteKeyExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteTreeA ordinal = 971, argument = 0 */
static gboolean kernel32_RegDeleteTreeA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteTreeW ordinal = 972, argument = 0 */
static gboolean kernel32_RegDeleteTreeW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteValueA ordinal = 973, argument = 0 */
static gboolean kernel32_RegDeleteValueA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDeleteValueW ordinal = 974, argument = 0 */
static gboolean kernel32_RegDeleteValueW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegDisablePredefinedCacheEx ordinal = 975, argument = 0 */
static gboolean kernel32_RegDisablePredefinedCacheEx (Ia32Thread *thread)
{
  return FALSE;
}


/* RegEnumKeyExA ordinal = 976, argument = 0 */
static gboolean kernel32_RegEnumKeyExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegEnumKeyExW ordinal = 977, argument = 0 */
static gboolean kernel32_RegEnumKeyExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegEnumValueA ordinal = 978, argument = 0 */
static gboolean kernel32_RegEnumValueA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegEnumValueW ordinal = 979, argument = 0 */
static gboolean kernel32_RegEnumValueW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegFlushKey ordinal = 980, argument = 0 */
static gboolean kernel32_RegFlushKey (Ia32Thread *thread)
{
  return FALSE;
}


/* RegGetKeySecurity ordinal = 981, argument = 0 */
static gboolean kernel32_RegGetKeySecurity (Ia32Thread *thread)
{
  return FALSE;
}


/* RegGetValueA ordinal = 982, argument = 0 */
static gboolean kernel32_RegGetValueA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegGetValueW ordinal = 983, argument = 0 */
static gboolean kernel32_RegGetValueW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegKrnGetGlobalState ordinal = 984, argument = 0 */
static gboolean kernel32_RegKrnGetGlobalState (Ia32Thread *thread)
{
  return FALSE;
}


/* RegKrnInitialize ordinal = 985, argument = 0 */
static gboolean kernel32_RegKrnInitialize (Ia32Thread *thread)
{
  return FALSE;
}


/* RegLoadKeyA ordinal = 986, argument = 0 */
static gboolean kernel32_RegLoadKeyA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegLoadKeyW ordinal = 987, argument = 0 */
static gboolean kernel32_RegLoadKeyW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegLoadMUIStringA ordinal = 988, argument = 0 */
static gboolean kernel32_RegLoadMUIStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegLoadMUIStringW ordinal = 989, argument = 0 */
static gboolean kernel32_RegLoadMUIStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegNotifyChangeKeyValue ordinal = 990, argument = 0 */
static gboolean kernel32_RegNotifyChangeKeyValue (Ia32Thread *thread)
{
  return FALSE;
}


/* RegOpenCurrentUser ordinal = 991, argument = 0 */
static gboolean kernel32_RegOpenCurrentUser (Ia32Thread *thread)
{
  return FALSE;
}


/* RegOpenKeyExA ordinal = 992, argument = 0 */
static gboolean kernel32_RegOpenKeyExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegOpenKeyExW ordinal = 993, argument = 0 */
static gboolean kernel32_RegOpenKeyExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegOpenUserClassesRoot ordinal = 994, argument = 0 */
static gboolean kernel32_RegOpenUserClassesRoot (Ia32Thread *thread)
{
  return FALSE;
}


/* RegQueryInfoKeyA ordinal = 995, argument = 0 */
static gboolean kernel32_RegQueryInfoKeyA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegQueryInfoKeyW ordinal = 996, argument = 0 */
static gboolean kernel32_RegQueryInfoKeyW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegQueryValueExA ordinal = 997, argument = 0 */
static gboolean kernel32_RegQueryValueExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegQueryValueExW ordinal = 998, argument = 0 */
static gboolean kernel32_RegQueryValueExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegRestoreKeyA ordinal = 999, argument = 0 */
static gboolean kernel32_RegRestoreKeyA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegRestoreKeyW ordinal = 1000, argument = 0 */
static gboolean kernel32_RegRestoreKeyW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegSaveKeyExA ordinal = 1001, argument = 0 */
static gboolean kernel32_RegSaveKeyExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegSaveKeyExW ordinal = 1002, argument = 0 */
static gboolean kernel32_RegSaveKeyExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegSetKeySecurity ordinal = 1003, argument = 0 */
static gboolean kernel32_RegSetKeySecurity (Ia32Thread *thread)
{
  return FALSE;
}


/* RegSetValueExA ordinal = 1004, argument = 0 */
static gboolean kernel32_RegSetValueExA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegSetValueExW ordinal = 1005, argument = 0 */
static gboolean kernel32_RegSetValueExW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegUnLoadKeyA ordinal = 1006, argument = 0 */
static gboolean kernel32_RegUnLoadKeyA (Ia32Thread *thread)
{
  return FALSE;
}


/* RegUnLoadKeyW ordinal = 1007, argument = 0 */
static gboolean kernel32_RegUnLoadKeyW (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterApplicationRecoveryCallback ordinal = 1008, argument = 16 */
static gboolean kernel32_RegisterApplicationRecoveryCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterApplicationRestart ordinal = 1009, argument = 8 */
static gboolean kernel32_RegisterApplicationRestart (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterConsoleIME ordinal = 1010, argument = 0 */
static gboolean kernel32_RegisterConsoleIME (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterConsoleOS2 ordinal = 1011, argument = 0 */
static gboolean kernel32_RegisterConsoleOS2 (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterConsoleVDM ordinal = 1012, argument = 0 */
static gboolean kernel32_RegisterConsoleVDM (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterWaitForInputIdle ordinal = 1013, argument = 0 */
static gboolean kernel32_RegisterWaitForInputIdle (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterWaitForSingleObject ordinal = 1014, argument = 24 */
static gboolean kernel32_RegisterWaitForSingleObject (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterWaitForSingleObjectEx ordinal = 1015, argument = 20 */
static gboolean kernel32_RegisterWaitForSingleObjectEx (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterWowBaseHandlers ordinal = 1016, argument = 0 */
static gboolean kernel32_RegisterWowBaseHandlers (Ia32Thread *thread)
{
  return FALSE;
}


/* RegisterWowExec ordinal = 1017, argument = 0 */
static gboolean kernel32_RegisterWowExec (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseActCtx ordinal = 1018, argument = 4 */
static gboolean kernel32_ReleaseActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseMutex ordinal = 1019, argument = 4 */
static gboolean kernel32_ReleaseMutex (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseMutexWhenCallbackReturns ordinal = 1020, argument = 8 */
static gboolean kernel32_ReleaseMutexWhenCallbackReturns (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseSRWLockExclusive ordinal = 1021, argument = 4 */
static gboolean kernel32_ReleaseSRWLockExclusive (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseSRWLockShared ordinal = 1022, argument = 4 */
static gboolean kernel32_ReleaseSRWLockShared (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseSemaphore ordinal = 1023, argument = 12 */
static gboolean kernel32_ReleaseSemaphore (Ia32Thread *thread)
{
  return FALSE;
}


/* ReleaseSemaphoreWhenCallbackReturns ordinal = 1024, argument = 12 */
static gboolean kernel32_ReleaseSemaphoreWhenCallbackReturns (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveDirectoryA ordinal = 1025, argument = 4 */
static gboolean kernel32_RemoveDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveDirectoryTransactedA ordinal = 1026, argument = 8 */
static gboolean kernel32_RemoveDirectoryTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveDirectoryTransactedW ordinal = 1027, argument = 8 */
static gboolean kernel32_RemoveDirectoryTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveDirectoryW ordinal = 1028, argument = 4 */
static gboolean kernel32_RemoveDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveLocalAlternateComputerNameA ordinal = 1029, argument = 8 */
static gboolean kernel32_RemoveLocalAlternateComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveLocalAlternateComputerNameW ordinal = 1030, argument = 8 */
static gboolean kernel32_RemoveLocalAlternateComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveSecureMemoryCacheCallback ordinal = 1031, argument = 0 */
static gboolean kernel32_RemoveSecureMemoryCacheCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveVectoredContinueHandler ordinal = 1032, argument = 4 */
static gboolean kernel32_RemoveVectoredContinueHandler (Ia32Thread *thread)
{
  return FALSE;
}


/* RemoveVectoredExceptionHandler ordinal = 1033, argument = 4 */
static gboolean kernel32_RemoveVectoredExceptionHandler (Ia32Thread *thread)
{
  return FALSE;
}


/* ReplaceFile ordinal = 1034, argument = 24 */
/* static gboolean kernel32_ReplaceFile (Ia32Thread *thread) */


/* ReplaceFileA ordinal = 1035, argument = 24 */
static gboolean kernel32_ReplaceFileA (Ia32Thread *thread)
{
  return FALSE;
}


/* ReplaceFileW ordinal = 1036, argument = 24 */
static gboolean kernel32_ReplaceFileW (Ia32Thread *thread)
{
  return FALSE;
}


/* ReplacePartitionUnit ordinal = 1037, argument = 0 */
static gboolean kernel32_ReplacePartitionUnit (Ia32Thread *thread)
{
  return FALSE;
}


/* RequestDeviceWakeup ordinal = 1038, argument = 4 */
static gboolean kernel32_RequestDeviceWakeup (Ia32Thread *thread)
{
  return FALSE;
}


/* RequestWakeupLatency ordinal = 1039, argument = 4 */
static gboolean kernel32_RequestWakeupLatency (Ia32Thread *thread)
{
  return FALSE;
}


/* ResetEvent ordinal = 1040, argument = 4 */
static gboolean kernel32_ResetEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* ResetWriteWatch ordinal = 1041, argument = 8 */
static gboolean kernel32_ResetWriteWatch (Ia32Thread *thread)
{
  return FALSE;
}


/* ResolveLocaleName ordinal = 1042, argument = 0 */
static gboolean kernel32_ResolveLocaleName (Ia32Thread *thread)
{
  return FALSE;
}


/* RestoreLastError ordinal = 1043, argument = 4 */
static gboolean kernel32_RestoreLastError (Ia32Thread *thread)
{
  return FALSE;
}


/* ResumeThread ordinal = 1044, argument = 4 */
static gboolean kernel32_ResumeThread (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlCaptureContext ordinal = 1045, argument = 4 */
static gboolean kernel32_RtlCaptureContext (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlCaptureStackBackTrace ordinal = 1046, argument = 16 */
static gboolean kernel32_RtlCaptureStackBackTrace (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlFillMemory ordinal = 1047, argument = 12 */
static gboolean kernel32_RtlFillMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlMoveMemory ordinal = 1048, argument = 12 */
static gboolean kernel32_RtlMoveMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlUnwind ordinal = 1049, argument = 16 */
static gboolean kernel32_RtlUnwind (Ia32Thread *thread)
{
  return FALSE;
}


/* RtlZeroMemory ordinal = 1050, argument = 8 */
static gboolean kernel32_RtlZeroMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* ScrollConsoleScreenBufferA ordinal = 1051, argument = 20 */
static gboolean kernel32_ScrollConsoleScreenBufferA (Ia32Thread *thread)
{
  return FALSE;
}


/* ScrollConsoleScreenBufferW ordinal = 1052, argument = 20 */
static gboolean kernel32_ScrollConsoleScreenBufferW (Ia32Thread *thread)
{
  return FALSE;
}


/* SearchPathA ordinal = 1053, argument = 24 */
static gboolean kernel32_SearchPathA (Ia32Thread *thread)
{
  return FALSE;
}


/* SearchPathW ordinal = 1054, argument = 24 */
static gboolean kernel32_SearchPathW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCalendarInfoA ordinal = 1055, argument = 16 */
static gboolean kernel32_SetCalendarInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCalendarInfoW ordinal = 1056, argument = 16 */
static gboolean kernel32_SetCalendarInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetClientTimeZoneInformation ordinal = 1057, argument = 0 */
static gboolean kernel32_SetClientTimeZoneInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetComPlusPackageInstallStatus ordinal = 1058, argument = 0 */
static gboolean kernel32_SetComPlusPackageInstallStatus (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCommBreak ordinal = 1059, argument = 4 */
static gboolean kernel32_SetCommBreak (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCommConfig ordinal = 1060, argument = 12 */
static gboolean kernel32_SetCommConfig (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCommMask ordinal = 1061, argument = 8 */
static gboolean kernel32_SetCommMask (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCommState ordinal = 1062, argument = 8 */
static gboolean kernel32_SetCommState (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCommTimeouts ordinal = 1063, argument = 8 */
static gboolean kernel32_SetCommTimeouts (Ia32Thread *thread)
{
  return FALSE;
}


/* SetComputerNameA ordinal = 1064, argument = 4 */
static gboolean kernel32_SetComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetComputerNameExA ordinal = 1065, argument = 8 */
static gboolean kernel32_SetComputerNameExA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetComputerNameExW ordinal = 1066, argument = 8 */
static gboolean kernel32_SetComputerNameExW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetComputerNameW ordinal = 1067, argument = 4 */
static gboolean kernel32_SetComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleActiveScreenBuffer ordinal = 1068, argument = 4 */
static gboolean kernel32_SetConsoleActiveScreenBuffer (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCP ordinal = 1069, argument = 4 */
static gboolean kernel32_SetConsoleCP (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCtrlHandler ordinal = 1070, argument = 8 */
static gboolean kernel32_SetConsoleCtrlHandler (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCursor ordinal = 1071, argument = 8 */
static gboolean kernel32_SetConsoleCursor (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCursorInfo ordinal = 1072, argument = 8 */
static gboolean kernel32_SetConsoleCursorInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCursorMode ordinal = 1073, argument = 0 */
static gboolean kernel32_SetConsoleCursorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleCursorPosition ordinal = 1074, argument = 8 */
static gboolean kernel32_SetConsoleCursorPosition (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleDisplayMode ordinal = 1075, argument = 12 */
static gboolean kernel32_SetConsoleDisplayMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleFont ordinal = 1076, argument = 0 */
static gboolean kernel32_SetConsoleFont (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleHardwareState ordinal = 1077, argument = 0 */
static gboolean kernel32_SetConsoleHardwareState (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleHistoryInfo ordinal = 1078, argument = 4 */
static gboolean kernel32_SetConsoleHistoryInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleIcon ordinal = 1079, argument = 0 */
static gboolean kernel32_SetConsoleIcon (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleInputExeNameA ordinal = 1080, argument = 0 */
static gboolean kernel32_SetConsoleInputExeNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleInputExeNameW ordinal = 1081, argument = 0 */
static gboolean kernel32_SetConsoleInputExeNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleKeyShortcuts ordinal = 1082, argument = 0 */
static gboolean kernel32_SetConsoleKeyShortcuts (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleLocalEUDC ordinal = 1083, argument = 0 */
static gboolean kernel32_SetConsoleLocalEUDC (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleMaximumWindowSize ordinal = 1084, argument = 0 */
static gboolean kernel32_SetConsoleMaximumWindowSize (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleMenuClose ordinal = 1085, argument = 0 */
static gboolean kernel32_SetConsoleMenuClose (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleMode ordinal = 1086, argument = 8 */
static gboolean kernel32_SetConsoleMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleNlsMode ordinal = 1087, argument = 0 */
static gboolean kernel32_SetConsoleNlsMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleNumberOfCommandsA ordinal = 1088, argument = 0 */
static gboolean kernel32_SetConsoleNumberOfCommandsA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleNumberOfCommandsW ordinal = 1089, argument = 0 */
static gboolean kernel32_SetConsoleNumberOfCommandsW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleOS2OemFormat ordinal = 1090, argument = 0 */
static gboolean kernel32_SetConsoleOS2OemFormat (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleOutputCP ordinal = 1091, argument = 4 */
static gboolean kernel32_SetConsoleOutputCP (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsolePalette ordinal = 1092, argument = 0 */
static gboolean kernel32_SetConsolePalette (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleScreenBufferInfoEx ordinal = 1093, argument = 8 */
static gboolean kernel32_SetConsoleScreenBufferInfoEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleScreenBufferSize ordinal = 1094, argument = 8 */
static gboolean kernel32_SetConsoleScreenBufferSize (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleTextAttribute ordinal = 1095, argument = 8 */
static gboolean kernel32_SetConsoleTextAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleTitleA ordinal = 1096, argument = 4 */
static gboolean kernel32_SetConsoleTitleA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleTitleW ordinal = 1097, argument = 4 */
static gboolean kernel32_SetConsoleTitleW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetConsoleWindowInfo ordinal = 1098, argument = 12 */
static gboolean kernel32_SetConsoleWindowInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCriticalSectionSpinCount ordinal = 1099, argument = 8 */
static gboolean kernel32_SetCriticalSectionSpinCount (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCurrentConsoleFontEx ordinal = 1100, argument = 12 */
static gboolean kernel32_SetCurrentConsoleFontEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCurrentDirectoryA ordinal = 1101, argument = 4 */
static gboolean kernel32_SetCurrentDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetCurrentDirectoryW ordinal = 1102, argument = 4 */
static gboolean kernel32_SetCurrentDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetDefaultCommConfigA ordinal = 1103, argument = 12 */
static gboolean kernel32_SetDefaultCommConfigA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetDefaultCommConfigW ordinal = 1104, argument = 12 */
static gboolean kernel32_SetDefaultCommConfigW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetDllDirectoryA ordinal = 1105, argument = 4 */
static gboolean kernel32_SetDllDirectoryA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetDllDirectoryW ordinal = 1106, argument = 4 */
static gboolean kernel32_SetDllDirectoryW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetDynamicTimeZoneInformation ordinal = 1107, argument = 4 */
static gboolean kernel32_SetDynamicTimeZoneInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEndOfFile ordinal = 1108, argument = 4 */
static gboolean kernel32_SetEndOfFile (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEnvironmentStringsA ordinal = 1109, argument = 4 */
static gboolean kernel32_SetEnvironmentStringsA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEnvironmentStringsW ordinal = 1110, argument = 4 */
static gboolean kernel32_SetEnvironmentStringsW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEnvironmentVariableA ordinal = 1111, argument = 8 */
static gboolean kernel32_SetEnvironmentVariableA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEnvironmentVariableW ordinal = 1112, argument = 8 */
static gboolean kernel32_SetEnvironmentVariableW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetErrorMode ordinal = 1113, argument = 4 */
static gboolean kernel32_SetErrorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEvent ordinal = 1114, argument = 4 */
static gboolean kernel32_SetEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* SetEventWhenCallbackReturns ordinal = 1115, argument = 8 */
static gboolean kernel32_SetEventWhenCallbackReturns (Ia32Thread *thread)
{
  return FALSE;
}


/* SetExtendedFeaturesMask ordinal = 1116, argument = 0 */
static gboolean kernel32_SetExtendedFeaturesMask (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileApisToANSI ordinal = 1117, argument = 0 */
static gboolean kernel32_SetFileApisToANSI (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileApisToOEM ordinal = 1118, argument = 0 */
static gboolean kernel32_SetFileApisToOEM (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileAttributesA ordinal = 1119, argument = 8 */
static gboolean kernel32_SetFileAttributesA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileAttributesTransactedA ordinal = 1120, argument = 12 */
static gboolean kernel32_SetFileAttributesTransactedA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileAttributesTransactedW ordinal = 1121, argument = 12 */
static gboolean kernel32_SetFileAttributesTransactedW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileAttributesW ordinal = 1122, argument = 8 */
static gboolean kernel32_SetFileAttributesW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileBandwidthReservation ordinal = 1123, argument = 24 */
static gboolean kernel32_SetFileBandwidthReservation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileCompletionNotificationModes ordinal = 1124, argument = 8 */
static gboolean kernel32_SetFileCompletionNotificationModes (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileInformationByHandle ordinal = 1125, argument = 16 */
static gboolean kernel32_SetFileInformationByHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileIoOverlappedRange ordinal = 1126, argument = 12 */
static gboolean kernel32_SetFileIoOverlappedRange (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFilePointer ordinal = 1127, argument = 16 */
static gboolean kernel32_SetFilePointer (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFilePointerEx ordinal = 1128, argument = 20 */
static gboolean kernel32_SetFilePointerEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileShortNameA ordinal = 1129, argument = 8 */
static gboolean kernel32_SetFileShortNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileShortNameW ordinal = 1130, argument = 8 */
static gboolean kernel32_SetFileShortNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileTime ordinal = 1131, argument = 16 */
static gboolean kernel32_SetFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFileValidData ordinal = 1132, argument = 12 */
static gboolean kernel32_SetFileValidData (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFirmwareEnvironmentVariableA ordinal = 1133, argument = 16 */
static gboolean kernel32_SetFirmwareEnvironmentVariableA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetFirmwareEnvironmentVariableW ordinal = 1134, argument = 16 */
static gboolean kernel32_SetFirmwareEnvironmentVariableW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetHandleContext ordinal = 1135, argument = 0 */
static gboolean kernel32_SetHandleContext (Ia32Thread *thread)
{
  return FALSE;
}


/* SetHandleCount ordinal = 1136, argument = 4 */
static gboolean kernel32_SetHandleCount (Ia32Thread *thread)
{
  return FALSE;
}


/* SetHandleInformation ordinal = 1137, argument = 12 */
static gboolean kernel32_SetHandleInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetInformationJobObject ordinal = 1138, argument = 16 */
static gboolean kernel32_SetInformationJobObject (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLastConsoleEventActive ordinal = 1139, argument = 0 */
static gboolean kernel32_SetLastConsoleEventActive (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLastError ordinal = 1140, argument = 4 */
static gboolean kernel32_SetLastError (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLocalPrimaryComputerNameA ordinal = 1141, argument = 8 */
static gboolean kernel32_SetLocalPrimaryComputerNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLocalPrimaryComputerNameW ordinal = 1142, argument = 8 */
static gboolean kernel32_SetLocalPrimaryComputerNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLocalTime ordinal = 1143, argument = 4 */
static gboolean kernel32_SetLocalTime (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLocaleInfoA ordinal = 1144, argument = 12 */
static gboolean kernel32_SetLocaleInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetLocaleInfoW ordinal = 1145, argument = 12 */
static gboolean kernel32_SetLocaleInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetMailslotInfo ordinal = 1146, argument = 8 */
static gboolean kernel32_SetMailslotInfo (Ia32Thread *thread)
{
  return FALSE;
}


/* SetMessageWaitingIndicator ordinal = 1147, argument = 8 */
static gboolean kernel32_SetMessageWaitingIndicator (Ia32Thread *thread)
{
  return FALSE;
}


/* SetNamedPipeAttribute ordinal = 1148, argument = 20 */
static gboolean kernel32_SetNamedPipeAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* SetNamedPipeHandleState ordinal = 1149, argument = 16 */
static gboolean kernel32_SetNamedPipeHandleState (Ia32Thread *thread)
{
  return FALSE;
}


/* SetPriorityClass ordinal = 1150, argument = 8 */
static gboolean kernel32_SetPriorityClass (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "SetPriorityClass", IA32_MESSAGE_DEC,
                                        "hProcess", IA32_MESSAGE_HEX,
                                        "dwPriorityClass", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* SetProcessAffinityMask ordinal = 1151, argument = 8 */
static gboolean kernel32_SetProcessAffinityMask (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessAffinityUpdateMode ordinal = 1152, argument = 0 */
static gboolean kernel32_SetProcessAffinityUpdateMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessDEPPolicy ordinal = 1153, argument = 0 */
static gboolean kernel32_SetProcessDEPPolicy (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessPreferredUILanguages ordinal = 1154, argument = 0 */
static gboolean kernel32_SetProcessPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessPriorityBoost ordinal = 1155, argument = 8 */
static gboolean kernel32_SetProcessPriorityBoost (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessShutdownParameters ordinal = 1156, argument = 8 */
static gboolean kernel32_SetProcessShutdownParameters (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessWorkingSetSize ordinal = 1157, argument = 12 */
static gboolean kernel32_SetProcessWorkingSetSize (Ia32Thread *thread)
{
  return FALSE;
}


/* SetProcessWorkingSetSizeEx ordinal = 1158, argument = 16 */
static gboolean kernel32_SetProcessWorkingSetSizeEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetSearchPathMode ordinal = 1159, argument = 0 */
static gboolean kernel32_SetSearchPathMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetStdHandle ordinal = 1160, argument = 8 */
static gboolean kernel32_SetStdHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* SetStdHandleEx ordinal = 1161, argument = 12 */
static gboolean kernel32_SetStdHandleEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetSystemFileCacheSize ordinal = 1162, argument = 12 */
static gboolean kernel32_SetSystemFileCacheSize (Ia32Thread *thread)
{
  return FALSE;
}


/* SetSystemPowerState ordinal = 1163, argument = 8 */
static gboolean kernel32_SetSystemPowerState (Ia32Thread *thread)
{
  return FALSE;
}


/* SetSystemTime ordinal = 1164, argument = 4 */
static gboolean kernel32_SetSystemTime (Ia32Thread *thread)
{
  return FALSE;
}


/* SetSystemTimeAdjustment ordinal = 1165, argument = 8 */
static gboolean kernel32_SetSystemTimeAdjustment (Ia32Thread *thread)
{
  return FALSE;
}


/* SetTapeParameters ordinal = 1166, argument = 12 */
static gboolean kernel32_SetTapeParameters (Ia32Thread *thread)
{
  return FALSE;
}


/* SetTapePosition ordinal = 1167, argument = 24 */
static gboolean kernel32_SetTapePosition (Ia32Thread *thread)
{
  return FALSE;
}


/* SetTermsrvAppInstallMode ordinal = 1168, argument = 0 */
static gboolean kernel32_SetTermsrvAppInstallMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadAffinityMask ordinal = 1169, argument = 8 */
static gboolean kernel32_SetThreadAffinityMask (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadContext ordinal = 1170, argument = 8 */
static gboolean kernel32_SetThreadContext (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadErrorMode ordinal = 1171, argument = 0 */
static gboolean kernel32_SetThreadErrorMode (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadExecutionState ordinal = 1172, argument = 4 */
static gboolean kernel32_SetThreadExecutionState (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadGroupAffinity ordinal = 1173, argument = 0 */
static gboolean kernel32_SetThreadGroupAffinity (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadIdealProcessor ordinal = 1174, argument = 8 */
static gboolean kernel32_SetThreadIdealProcessor (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadIdealProcessorEx ordinal = 1175, argument = 0 */
static gboolean kernel32_SetThreadIdealProcessorEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadLocale ordinal = 1176, argument = 4 */
static gboolean kernel32_SetThreadLocale (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadPreferredUILanguages ordinal = 1177, argument = 12 */
static gboolean kernel32_SetThreadPreferredUILanguages (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadPriority ordinal = 1178, argument = 8 */
static gboolean kernel32_SetThreadPriority (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadPriorityBoost ordinal = 1179, argument = 8 */
static gboolean kernel32_SetThreadPriorityBoost (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadStackGuarantee ordinal = 1180, argument = 4 */
static gboolean kernel32_SetThreadStackGuarantee (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadToken ordinal = 1181, argument = 0 */
static gboolean kernel32_SetThreadToken (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadUILanguage ordinal = 1182, argument = 4 */
static gboolean kernel32_SetThreadUILanguage (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadpoolStackInformation ordinal = 1183, argument = 0 */
static gboolean kernel32_SetThreadpoolStackInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadpoolThreadMaximum ordinal = 1184, argument = 8 */
static gboolean kernel32_SetThreadpoolThreadMaximum (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadpoolThreadMinimum ordinal = 1185, argument = 8 */
static gboolean kernel32_SetThreadpoolThreadMinimum (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadpoolTimer ordinal = 1186, argument = 16 */
static gboolean kernel32_SetThreadpoolTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* SetThreadpoolWait ordinal = 1187, argument = 12 */
static gboolean kernel32_SetThreadpoolWait (Ia32Thread *thread)
{
  return FALSE;
}


/* SetTimeZoneInformation ordinal = 1188, argument = 4 */
static gboolean kernel32_SetTimeZoneInformation (Ia32Thread *thread)
{
  return FALSE;
}


/* SetTimerQueueTimer ordinal = 1189, argument = 24 */
static gboolean kernel32_SetTimerQueueTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* SetUnhandledExceptionFilter ordinal = 1190, argument = 4 */
static gboolean kernel32_SetUnhandledExceptionFilter (Ia32Thread *thread)
{
  return FALSE;
}


/* SetUserGeoID ordinal = 1191, argument = 4 */
static gboolean kernel32_SetUserGeoID (Ia32Thread *thread)
{
  return FALSE;
}


/* SetVDMCurrentDirectories ordinal = 1192, argument = 0 */
static gboolean kernel32_SetVDMCurrentDirectories (Ia32Thread *thread)
{
  return FALSE;
}


/* SetVolumeLabelA ordinal = 1193, argument = 8 */
static gboolean kernel32_SetVolumeLabelA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetVolumeLabelW ordinal = 1194, argument = 8 */
static gboolean kernel32_SetVolumeLabelW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetVolumeMountPointA ordinal = 1195, argument = 8 */
static gboolean kernel32_SetVolumeMountPointA (Ia32Thread *thread)
{
  return FALSE;
}


/* SetVolumeMountPointW ordinal = 1196, argument = 8 */
static gboolean kernel32_SetVolumeMountPointW (Ia32Thread *thread)
{
  return FALSE;
}


/* SetWaitableTimer ordinal = 1197, argument = 24 */
static gboolean kernel32_SetWaitableTimer (Ia32Thread *thread)
{
  return FALSE;
}


/* SetWaitableTimerEx ordinal = 1198, argument = 0 */
static gboolean kernel32_SetWaitableTimerEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SetupComm ordinal = 1199, argument = 12 */
static gboolean kernel32_SetupComm (Ia32Thread *thread)
{
  return FALSE;
}


/* ShowConsoleCursor ordinal = 1200, argument = 0 */
static gboolean kernel32_ShowConsoleCursor (Ia32Thread *thread)
{
  return FALSE;
}


/* SignalObjectAndWait ordinal = 1201, argument = 16 */
static gboolean kernel32_SignalObjectAndWait (Ia32Thread *thread)
{
  return FALSE;
}


/* SizeofResource ordinal = 1202, argument = 8 */
static gboolean kernel32_SizeofResource (Ia32Thread *thread)
{
  return FALSE;
}


/* Sleep ordinal = 1203, argument = 4 */
static gboolean kernel32_Sleep (Ia32Thread *thread)
{
  return FALSE;
}


/* SleepConditionVariableCS ordinal = 1204, argument = 12 */
static gboolean kernel32_SleepConditionVariableCS (Ia32Thread *thread)
{
  return FALSE;
}


/* SleepConditionVariableSRW ordinal = 1205, argument = 16 */
static gboolean kernel32_SleepConditionVariableSRW (Ia32Thread *thread)
{
  return FALSE;
}


/* SleepEx ordinal = 1206, argument = 8 */
static gboolean kernel32_SleepEx (Ia32Thread *thread)
{
  return FALSE;
}


/* SortCloseHandle ordinal = 1207, argument = 0 */
static gboolean kernel32_SortCloseHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* SortGetHandle ordinal = 1208, argument = 0 */
static gboolean kernel32_SortGetHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* StartThreadpoolIo ordinal = 1209, argument = 4 */
static gboolean kernel32_StartThreadpoolIo (Ia32Thread *thread)
{
  return FALSE;
}


/* SubmitThreadpoolWork ordinal = 1210, argument = 4 */
static gboolean kernel32_SubmitThreadpoolWork (Ia32Thread *thread)
{
  return FALSE;
}


/* SuspendThread ordinal = 1211, argument = 4 */
static gboolean kernel32_SuspendThread (Ia32Thread *thread)
{
  return FALSE;
}


/* SwitchToFiber ordinal = 1212, argument = 4 */
static gboolean kernel32_SwitchToFiber (Ia32Thread *thread)
{
  return FALSE;
}


/* SwitchToThread ordinal = 1213, argument = 0 */
static gboolean kernel32_SwitchToThread (Ia32Thread *thread)
{
  return FALSE;
}


/* SystemTimeToFileTime ordinal = 1214, argument = 8 */
static gboolean kernel32_SystemTimeToFileTime (Ia32Thread *thread)
{
  return FALSE;
}


/* SystemTimeToTzSpecificLocalTime ordinal = 1215, argument = 12 */
static gboolean kernel32_SystemTimeToTzSpecificLocalTime (Ia32Thread *thread)
{
  return FALSE;
}


/* TerminateJobObject ordinal = 1216, argument = 8 */
static gboolean kernel32_TerminateJobObject (Ia32Thread *thread)
{
  return FALSE;
}


/* TerminateProcess ordinal = 1217, argument = 8 */
static gboolean kernel32_TerminateProcess (Ia32Thread *thread)
{
  return FALSE;
}


/* TerminateThread ordinal = 1218, argument = 8 */
static gboolean kernel32_TerminateThread (Ia32Thread *thread)
{
  return FALSE;
}


/* TermsrvAppInstallMode ordinal = 1219, argument = 0 */
static gboolean kernel32_TermsrvAppInstallMode (Ia32Thread *thread)
{
  return FALSE;
}


/* Thread32First ordinal = 1220, argument = 8 */
static gboolean kernel32_Thread32First (Ia32Thread *thread)
{
  return FALSE;
}


/* Thread32Next ordinal = 1221, argument = 8 */
static gboolean kernel32_Thread32Next (Ia32Thread *thread)
{
  return FALSE;
}


/* TlsAlloc ordinal = 1222, argument = 0 */
static gboolean kernel32_TlsAlloc (Ia32Thread *thread)
{
  return FALSE;
}


/* TlsFree ordinal = 1223, argument = 4 */
static gboolean kernel32_TlsFree (Ia32Thread *thread)
{
  return FALSE;
}


/* TlsGetValue ordinal = 1224, argument = 4 */
static gboolean kernel32_TlsGetValue (Ia32Thread *thread)
{
  return FALSE;
}


/* TlsSetValue ordinal = 1225, argument = 8 */
static gboolean kernel32_TlsSetValue (Ia32Thread *thread)
{
  return FALSE;
}


/* Toolhelp32ReadProcessMemory ordinal = 1226, argument = 20 */
static gboolean kernel32_Toolhelp32ReadProcessMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* TransactNamedPipe ordinal = 1227, argument = 28 */
static gboolean kernel32_TransactNamedPipe (Ia32Thread *thread)
{
  return FALSE;
}


/* TransmitCommChar ordinal = 1228, argument = 8 */
static gboolean kernel32_TransmitCommChar (Ia32Thread *thread)
{
  return FALSE;
}


/* TryAcquireSRWLockExclusive ordinal = 1229, argument = 0 */
static gboolean kernel32_TryAcquireSRWLockExclusive (Ia32Thread *thread)
{
  return FALSE;
}


/* TryAcquireSRWLockShared ordinal = 1230, argument = 0 */
static gboolean kernel32_TryAcquireSRWLockShared (Ia32Thread *thread)
{
  return FALSE;
}


/* TryEnterCriticalSection ordinal = 1231, argument = 4 */
static gboolean kernel32_TryEnterCriticalSection (Ia32Thread *thread)
{
  return FALSE;
}


/* TrySubmitThreadpoolCallback ordinal = 1232, argument = 12 */
static gboolean kernel32_TrySubmitThreadpoolCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* TzSpecificLocalTimeToSystemTime ordinal = 1233, argument = 12 */
static gboolean kernel32_TzSpecificLocalTimeToSystemTime (Ia32Thread *thread)
{
  return FALSE;
}


/* UTRegister ordinal = 1234, argument = 0 */
static gboolean kernel32_UTRegister (Ia32Thread *thread)
{
  return FALSE;
}


/* UTUnRegister ordinal = 1235, argument = 0 */
static gboolean kernel32_UTUnRegister (Ia32Thread *thread)
{
  return FALSE;
}


/* UnhandledExceptionFilter ordinal = 1236, argument = 4 */
static gboolean kernel32_UnhandledExceptionFilter (Ia32Thread *thread)
{
  return FALSE;
}


/* UnlockFile ordinal = 1237, argument = 20 */
static gboolean kernel32_UnlockFile (Ia32Thread *thread)
{
  return FALSE;
}


/* UnlockFileEx ordinal = 1238, argument = 20 */
static gboolean kernel32_UnlockFileEx (Ia32Thread *thread)
{
  return FALSE;
}


/* UnmapViewOfFile ordinal = 1239, argument = 4 */
static gboolean kernel32_UnmapViewOfFile (Ia32Thread *thread)
{
  return FALSE;
}


/* UnregisterApplicationRecoveryCallback ordinal = 1240, argument = 0 */
static gboolean kernel32_UnregisterApplicationRecoveryCallback (Ia32Thread *thread)
{
  return FALSE;
}


/* UnregisterApplicationRestart ordinal = 1241, argument = 0 */
static gboolean kernel32_UnregisterApplicationRestart (Ia32Thread *thread)
{
  return FALSE;
}


/* UnregisterConsoleIME ordinal = 1242, argument = 0 */
static gboolean kernel32_UnregisterConsoleIME (Ia32Thread *thread)
{
  return FALSE;
}


/* UnregisterWait ordinal = 1243, argument = 4 */
static gboolean kernel32_UnregisterWait (Ia32Thread *thread)
{
  return FALSE;
}


/* UnregisterWaitEx ordinal = 1244, argument = 8 */
static gboolean kernel32_UnregisterWaitEx (Ia32Thread *thread)
{
  return FALSE;
}


/* UpdateCalendarDayOfWeek ordinal = 1245, argument = 0 */
static gboolean kernel32_UpdateCalendarDayOfWeek (Ia32Thread *thread)
{
  return FALSE;
}


/* UpdateProcThreadAttribute ordinal = 1246, argument = 28 */
static gboolean kernel32_UpdateProcThreadAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* UpdateResourceA ordinal = 1247, argument = 24 */
static gboolean kernel32_UpdateResourceA (Ia32Thread *thread)
{
  return FALSE;
}


/* UpdateResourceW ordinal = 1248, argument = 24 */
static gboolean kernel32_UpdateResourceW (Ia32Thread *thread)
{
  return FALSE;
}


/* VDMConsoleOperation ordinal = 1249, argument = 0 */
static gboolean kernel32_VDMConsoleOperation (Ia32Thread *thread)
{
  return FALSE;
}


/* VDMOperationStarted ordinal = 1250, argument = 0 */
static gboolean kernel32_VDMOperationStarted (Ia32Thread *thread)
{
  return FALSE;
}


/* VerLanguageNameA ordinal = 1251, argument = 12 */
static gboolean kernel32_VerLanguageNameA (Ia32Thread *thread)
{
  return FALSE;
}


/* VerLanguageNameW ordinal = 1252, argument = 12 */
static gboolean kernel32_VerLanguageNameW (Ia32Thread *thread)
{
  return FALSE;
}


/* VerSetConditionMask ordinal = 1253, argument = 16 */
static gboolean kernel32_VerSetConditionMask (Ia32Thread *thread)
{
  return FALSE;
}


/* VerifyConsoleIoHandle ordinal = 1254, argument = 0 */
static gboolean kernel32_VerifyConsoleIoHandle (Ia32Thread *thread)
{
  return FALSE;
}


/* VerifyScripts ordinal = 1255, argument = 20 */
static gboolean kernel32_VerifyScripts (Ia32Thread *thread)
{
  return FALSE;
}


/* VerifyVersionInfoA ordinal = 1256, argument = 16 */
static gboolean kernel32_VerifyVersionInfoA (Ia32Thread *thread)
{
  return FALSE;
}


/* VerifyVersionInfoW ordinal = 1257, argument = 16 */
static gboolean kernel32_VerifyVersionInfoW (Ia32Thread *thread)
{
  return FALSE;
}


/* VirtualAlloc ordinal = 1258, argument = 16 */
static gboolean kernel32_VirtualAlloc (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_stack_value (thread, 1);
  if (address == 0)
    address = IA32_MEMORY_NULL;
  address = ia32_memory_alloc (thread->process,
                              address,
                              ia32_stack_value (thread, 2),
                              IA32_MEMORY_ATTR_USER);
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualAlloc", IA32_MESSAGE_HEX,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "flAllocationType", IA32_MESSAGE_HEX,
                                        "flProtect", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualAllocEx ordinal = 1259, argument = 20 */
static gboolean kernel32_VirtualAllocEx (Ia32Thread *thread)
{
  guint32 address;

  address = ia32_memory_alloc (thread->process,
                              ia32_stack_value (thread, 2),
                              ia32_stack_value (thread, 3),
                              IA32_MEMORY_ATTR_USER);
  thread->reg.eax = address != IA32_MEMORY_NULL ? address : 0;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualAllocEx", IA32_MESSAGE_HEX,
                                        "hProcess", IA32_MESSAGE_HEX,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "flAllocationType", IA32_MESSAGE_HEX,
                                        "flProtect", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualAllocExNuma ordinal = 1260, argument = 24 */
static gboolean kernel32_VirtualAllocExNuma (Ia32Thread *thread)
{
  return FALSE;
}


/* VirtualFree ordinal = 1261, argument = 12 */
static gboolean kernel32_VirtualFree (Ia32Thread *thread)
{
  thread->reg.eax = ia32_memory_free (thread->process,
                                                ia32_stack_value (thread, 1));
  ia32_message_record_api_with_argument (thread,
                                        "VirtualFree", IA32_MESSAGE_DEC,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "dwFreeType", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualFreeEx ordinal = 1262, argument = 16 */
static gboolean kernel32_VirtualFreeEx (Ia32Thread *thread)
{
  thread->reg.eax = ia32_memory_free (thread->process,
                                                ia32_stack_value (thread, 2));
  ia32_message_record_api_with_argument (thread,
                                        "VirtualFreeEx", IA32_MESSAGE_DEC,
                                        "hProcess", IA32_MESSAGE_HEX,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "dwFreeType", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualLock ordinal = 1263, argument = 8 */
static gboolean kernel32_VirtualLock (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualLock", IA32_MESSAGE_DEC,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualProtect ordinal = 1264, argument = 16 */
static gboolean kernel32_VirtualProtect (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualProtect", IA32_MESSAGE_DEC,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "flNewProtect", IA32_MESSAGE_HEX,
                                        "lpflOldProtect", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualProtectEx ordinal = 1265, argument = 20 */
static gboolean kernel32_VirtualProtectEx (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualProtectEx", IA32_MESSAGE_DEC,
                                        "hProcess", IA32_MESSAGE_HEX,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        "flNewProtect", IA32_MESSAGE_HEX,
                                        "lpflOldProtect", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* VirtualQuery ordinal = 1266, argument = 12 */
static gboolean kernel32_VirtualQuery (Ia32Thread *thread)
{
  return FALSE;
}


/* VirtualQueryEx ordinal = 1267, argument = 16 */
static gboolean kernel32_VirtualQueryEx (Ia32Thread *thread)
{
  return FALSE;
}


/* VirtualUnlock ordinal = 1268, argument = 8 */
static gboolean kernel32_VirtualUnlock (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "VirtualUnlock", IA32_MESSAGE_DEC,
                                        "lpAddress", IA32_MESSAGE_HEX,
                                        "dwSize", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* WTSGetActiveConsoleSessionId ordinal = 1269, argument = 0 */
static gboolean kernel32_WTSGetActiveConsoleSessionId (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitCommEvent ordinal = 1270, argument = 12 */
static gboolean kernel32_WaitCommEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForDebugEvent ordinal = 1271, argument = 8 */
static gboolean kernel32_WaitForDebugEvent (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForMultipleObjects ordinal = 1272, argument = 16 */
static gboolean kernel32_WaitForMultipleObjects (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForMultipleObjectsEx ordinal = 1273, argument = 20 */
static gboolean kernel32_WaitForMultipleObjectsEx (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForSingleObject ordinal = 1274, argument = 8 */
static gboolean kernel32_WaitForSingleObject (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForSingleObjectEx ordinal = 1275, argument = 12 */
static gboolean kernel32_WaitForSingleObjectEx (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForThreadpoolIoCallbacks ordinal = 1276, argument = 8 */
static gboolean kernel32_WaitForThreadpoolIoCallbacks (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForThreadpoolTimerCallbacks ordinal = 1277, argument = 8 */
static gboolean kernel32_WaitForThreadpoolTimerCallbacks (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForThreadpoolWaitCallbacks ordinal = 1278, argument = 8 */
static gboolean kernel32_WaitForThreadpoolWaitCallbacks (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitForThreadpoolWorkCallbacks ordinal = 1279, argument = 8 */
static gboolean kernel32_WaitForThreadpoolWorkCallbacks (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitNamedPipeA ordinal = 1280, argument = 8 */
static gboolean kernel32_WaitNamedPipeA (Ia32Thread *thread)
{
  return FALSE;
}


/* WaitNamedPipeW ordinal = 1281, argument = 8 */
static gboolean kernel32_WaitNamedPipeW (Ia32Thread *thread)
{
  return FALSE;
}


/* WakeAllConditionVariable ordinal = 1282, argument = 4 */
static gboolean kernel32_WakeAllConditionVariable (Ia32Thread *thread)
{
  return FALSE;
}


/* WakeConditionVariable ordinal = 1283, argument = 4 */
static gboolean kernel32_WakeConditionVariable (Ia32Thread *thread)
{
  return FALSE;
}


/* WerGetFlags ordinal = 1284, argument = 8 */
static gboolean kernel32_WerGetFlags (Ia32Thread *thread)
{
  return FALSE;
}


/* WerRegisterFile ordinal = 1285, argument = 12 */
static gboolean kernel32_WerRegisterFile (Ia32Thread *thread)
{
  return FALSE;
}


/* WerRegisterMemoryBlock ordinal = 1286, argument = 8 */
static gboolean kernel32_WerRegisterMemoryBlock (Ia32Thread *thread)
{
  return FALSE;
}


/* WerRegisterRuntimeExceptionModule ordinal = 1287, argument = 0 */
static gboolean kernel32_WerRegisterRuntimeExceptionModule (Ia32Thread *thread)
{
  return FALSE;
}


/* WerSetFlags ordinal = 1288, argument = 4 */
static gboolean kernel32_WerSetFlags (Ia32Thread *thread)
{
  return FALSE;
}


/* WerUnregisterFile ordinal = 1289, argument = 4 */
static gboolean kernel32_WerUnregisterFile (Ia32Thread *thread)
{
  return FALSE;
}


/* WerUnregisterMemoryBlock ordinal = 1290, argument = 4 */
static gboolean kernel32_WerUnregisterMemoryBlock (Ia32Thread *thread)
{
  return FALSE;
}


/* WerUnregisterRuntimeExceptionModule ordinal = 1291, argument = 0 */
static gboolean kernel32_WerUnregisterRuntimeExceptionModule (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpCleanupMessageMapping ordinal = 1292, argument = 0 */
static gboolean kernel32_WerpCleanupMessageMapping (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpInitiateRemoteRecovery ordinal = 1293, argument = 4 */
static gboolean kernel32_WerpInitiateRemoteRecovery (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpNotifyLoadStringResource ordinal = 1294, argument = 0 */
static gboolean kernel32_WerpNotifyLoadStringResource (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpNotifyLoadStringResourceEx ordinal = 1295, argument = 0 */
static gboolean kernel32_WerpNotifyLoadStringResourceEx (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpNotifyUseStringResource ordinal = 1296, argument = 0 */
static gboolean kernel32_WerpNotifyUseStringResource (Ia32Thread *thread)
{
  return FALSE;
}


/* WerpStringLookup ordinal = 1297, argument = 0 */
static gboolean kernel32_WerpStringLookup (Ia32Thread *thread)
{
  return FALSE;
}


/* WideCharToMultiByte ordinal = 1298, argument = 32 */
static gboolean kernel32_WideCharToMultiByte (Ia32Thread *thread)
{
  return FALSE;
}


/* WinExec ordinal = 1299, argument = 8 */
static gboolean kernel32_WinExec (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64DisableWow64FsRedirection ordinal = 1300, argument = 4 */
static gboolean kernel32_Wow64DisableWow64FsRedirection (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64EnableWow64FsRedirection ordinal = 1301, argument = 4 */
static gboolean kernel32_Wow64EnableWow64FsRedirection (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64GetThreadContext ordinal = 1302, argument = 8 */
static gboolean kernel32_Wow64GetThreadContext (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64GetThreadSelectorEntry ordinal = 1303, argument = 0 */
static gboolean kernel32_Wow64GetThreadSelectorEntry (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64RevertWow64FsRedirection ordinal = 1304, argument = 4 */
static gboolean kernel32_Wow64RevertWow64FsRedirection (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64SetThreadContext ordinal = 1305, argument = 8 */
static gboolean kernel32_Wow64SetThreadContext (Ia32Thread *thread)
{
  return FALSE;
}


/* Wow64SuspendThread ordinal = 1306, argument = 4 */
static gboolean kernel32_Wow64SuspendThread (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleA ordinal = 1307, argument = 20 */
static gboolean kernel32_WriteConsoleA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleInputA ordinal = 1308, argument = 16 */
static gboolean kernel32_WriteConsoleInputA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleInputVDMA ordinal = 1309, argument = 0 */
static gboolean kernel32_WriteConsoleInputVDMA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleInputVDMW ordinal = 1310, argument = 0 */
static gboolean kernel32_WriteConsoleInputVDMW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleInputW ordinal = 1311, argument = 16 */
static gboolean kernel32_WriteConsoleInputW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleOutputA ordinal = 1312, argument = 20 */
static gboolean kernel32_WriteConsoleOutputA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleOutputAttribute ordinal = 1313, argument = 20 */
static gboolean kernel32_WriteConsoleOutputAttribute (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleOutputCharacterA ordinal = 1314, argument = 20 */
static gboolean kernel32_WriteConsoleOutputCharacterA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleOutputCharacterW ordinal = 1315, argument = 20 */
static gboolean kernel32_WriteConsoleOutputCharacterW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleOutputW ordinal = 1316, argument = 20 */
static gboolean kernel32_WriteConsoleOutputW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteConsoleW ordinal = 1317, argument = 20 */
static gboolean kernel32_WriteConsoleW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteFile ordinal = 1318, argument = 20 */
static gboolean kernel32_WriteFile (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteFileEx ordinal = 1319, argument = 20 */
static gboolean kernel32_WriteFileEx (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteFileGather ordinal = 1320, argument = 20 */
static gboolean kernel32_WriteFileGather (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileSectionA ordinal = 1321, argument = 12 */
static gboolean kernel32_WritePrivateProfileSectionA (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileSectionW ordinal = 1322, argument = 12 */
static gboolean kernel32_WritePrivateProfileSectionW (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileStringA ordinal = 1323, argument = 16 */
static gboolean kernel32_WritePrivateProfileStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileStringW ordinal = 1324, argument = 16 */
static gboolean kernel32_WritePrivateProfileStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileStructA ordinal = 1325, argument = 20 */
static gboolean kernel32_WritePrivateProfileStructA (Ia32Thread *thread)
{
  return FALSE;
}


/* WritePrivateProfileStructW ordinal = 1326, argument = 20 */
static gboolean kernel32_WritePrivateProfileStructW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteProcessMemory ordinal = 1327, argument = 20 */
static gboolean kernel32_WriteProcessMemory (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteProfileSectionA ordinal = 1328, argument = 8 */
static gboolean kernel32_WriteProfileSectionA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteProfileSectionW ordinal = 1329, argument = 8 */
static gboolean kernel32_WriteProfileSectionW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteProfileStringA ordinal = 1330, argument = 12 */
static gboolean kernel32_WriteProfileStringA (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteProfileStringW ordinal = 1331, argument = 12 */
static gboolean kernel32_WriteProfileStringW (Ia32Thread *thread)
{
  return FALSE;
}


/* WriteTapemark ordinal = 1332, argument = 16 */
static gboolean kernel32_WriteTapemark (Ia32Thread *thread)
{
  return FALSE;
}


/* ZombifyActCtx ordinal = 1333, argument = 4 */
static gboolean kernel32_ZombifyActCtx (Ia32Thread *thread)
{
  return FALSE;
}


/* _hread ordinal = 1334, argument = 12 */
static gboolean kernel32__hread (Ia32Thread *thread)
{
  return FALSE;
}


/* _hwrite ordinal = 1335, argument = 12 */
static gboolean kernel32__hwrite (Ia32Thread *thread)
{
  return FALSE;
}


/* _lclose ordinal = 1336, argument = 4 */
static gboolean kernel32__lclose (Ia32Thread *thread)
{
  return FALSE;
}


/* _lcreat ordinal = 1337, argument = 8 */
static gboolean kernel32__lcreat (Ia32Thread *thread)
{
  return FALSE;
}


/* _llseek ordinal = 1338, argument = 12 */
static gboolean kernel32__llseek (Ia32Thread *thread)
{
  return FALSE;
}


/* _lopen ordinal = 1339, argument = 8 */
static gboolean kernel32__lopen (Ia32Thread *thread)
{
  return FALSE;
}


/* _lread ordinal = 1340, argument = 12 */
static gboolean kernel32__lread (Ia32Thread *thread)
{
  return FALSE;
}


/* _lwrite ordinal = 1341, argument = 12 */
static gboolean kernel32__lwrite (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcat ordinal = 1342, argument = 8 */
/* static gboolean kernel32_lstrcat (Ia32Thread *thread) */


/* lstrcatA ordinal = 1343, argument = 8 */
static gboolean kernel32_lstrcatA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcatW ordinal = 1344, argument = 8 */
static gboolean kernel32_lstrcatW (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcmp ordinal = 1345, argument = 8 */
/* static gboolean kernel32_lstrcmp (Ia32Thread *thread) */


/* lstrcmpA ordinal = 1346, argument = 8 */
static gboolean kernel32_lstrcmpA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcmpW ordinal = 1347, argument = 8 */
static gboolean kernel32_lstrcmpW (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcmpi ordinal = 1348, argument = 8 */
/* static gboolean kernel32_lstrcmpi (Ia32Thread *thread) */


/* lstrcmpiA ordinal = 1349, argument = 8 */
static gboolean kernel32_lstrcmpiA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcmpiW ordinal = 1350, argument = 8 */
static gboolean kernel32_lstrcmpiW (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcpy ordinal = 1351, argument = 8 */
/* static gboolean kernel32_lstrcpy (Ia32Thread *thread) */


/* lstrcpyA ordinal = 1352, argument = 8 */
static gboolean kernel32_lstrcpyA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcpyW ordinal = 1353, argument = 8 */
static gboolean kernel32_lstrcpyW (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcpyn ordinal = 1354, argument = 12 */
/* static gboolean kernel32_lstrcpyn (Ia32Thread *thread) */


/* lstrcpynA ordinal = 1355, argument = 12 */
static gboolean kernel32_lstrcpynA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrcpynW ordinal = 1356, argument = 12 */
static gboolean kernel32_lstrcpynW (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrlen ordinal = 1357, argument = 4 */
/* static gboolean kernel32_lstrlen (Ia32Thread *thread) */


/* lstrlenA ordinal = 1358, argument = 4 */
static gboolean kernel32_lstrlenA (Ia32Thread *thread)
{
  return FALSE;
}


/* lstrlenW ordinal = 1359, argument = 4 */
static gboolean kernel32_lstrlenW (Ia32Thread *thread)
{
  return FALSE;
}


Ia32Export ia32_kernel32_exports[] = {
{ 4,    3, "AcquireSRWLockExclusive",                       kernel32_AcquireSRWLockExclusive},
{ 4,    4, "AcquireSRWLockShared",                          kernel32_AcquireSRWLockShared},
{ 8,    5, "ActivateActCtx",                                kernel32_ActivateActCtx},
{ 4,    6, "AddAtomA",                                      kernel32_AddAtomA},
{ 4,    7, "AddAtomW",                                      kernel32_AddAtomW},
{12,    8, "AddConsoleAliasA",                              kernel32_AddConsoleAliasA},
{12,    9, "AddConsoleAliasW",                              kernel32_AddConsoleAliasW},
{ 0,   10, "AddIntegrityLabelToBoundaryDescriptor",         kernel32_AddIntegrityLabelToBoundaryDescriptor},
{ 8,   11, "AddLocalAlternateComputerNameA",                kernel32_AddLocalAlternateComputerNameA},
{ 8,   12, "AddLocalAlternateComputerNameW",                kernel32_AddLocalAlternateComputerNameW},
{ 4,   13, "AddRefActCtx",                                  kernel32_AddRefActCtx},
{ 8,   14, "AddSIDToBoundaryDescriptor",                    kernel32_AddSIDToBoundaryDescriptor},
{ 0,   15, "AddSecureMemoryCacheCallback",                  kernel32_AddSecureMemoryCacheCallback},
{ 8,   16, "AddVectoredContinueHandler",                    kernel32_AddVectoredContinueHandler},
{ 8,   17, "AddVectoredExceptionHandler",                   kernel32_AddVectoredExceptionHandler},
{ 0,   18, "AdjustCalendarDate",                            kernel32_AdjustCalendarDate},
{ 0,   19, "AllocConsole",                                  kernel32_AllocConsole},
{12,   20, "AllocateUserPhysicalPages",                     kernel32_AllocateUserPhysicalPages},
{16,   21, "AllocateUserPhysicalPagesNuma",                 kernel32_AllocateUserPhysicalPagesNuma},
{ 4,   22, "ApplicationRecoveryFinished",                   kernel32_ApplicationRecoveryFinished},
{ 4,   23, "ApplicationRecoveryInProgress",                 kernel32_ApplicationRecoveryInProgress},
{ 0,   24, "AreFileApisANSI",                               kernel32_AreFileApisANSI},
{ 8,   25, "AssignProcessToJobObject",                      kernel32_AssignProcessToJobObject},
{ 4,   26, "AttachConsole",                                 kernel32_AttachConsole},
{28,   27, "BackupRead",                                    kernel32_BackupRead},
{24,   28, "BackupSeek",                                    kernel32_BackupSeek},
{28,   29, "BackupWrite",                                   kernel32_BackupWrite},
{ 0,   30, "BaseCheckAppcompatCache",                       kernel32_BaseCheckAppcompatCache},
{ 0,   31, "BaseCheckAppcompatCacheEx",                     kernel32_BaseCheckAppcompatCacheEx},
{ 0,   32, "BaseCheckRunApp",                               kernel32_BaseCheckRunApp},
{ 0,   33, "BaseCleanupAppcompatCacheSupport",              kernel32_BaseCleanupAppcompatCacheSupport},
{ 0,   34, "BaseDllReadWriteIniFile",                       kernel32_BaseDllReadWriteIniFile},
{ 0,   35, "BaseDumpAppcompatCache",                        kernel32_BaseDumpAppcompatCache},
{ 0,   36, "BaseFlushAppcompatCache",                       kernel32_BaseFlushAppcompatCache},
{ 0,   37, "BaseFormatObjectAttributes",                    kernel32_BaseFormatObjectAttributes},
{ 0,   38, "BaseFormatTimeOut",                             kernel32_BaseFormatTimeOut},
{ 0,   39, "BaseGenerateAppCompatData",                     kernel32_BaseGenerateAppCompatData},
{ 0,   40, "BaseGetNamedObjectDirectory",                   kernel32_BaseGetNamedObjectDirectory},
{ 0,   41, "BaseInitAppcompatCacheSupport",                 kernel32_BaseInitAppcompatCacheSupport},
{ 0,   42, "BaseIsAppcompatInfrastructureDisabled",         kernel32_BaseIsAppcompatInfrastructureDisabled},
{ 0,   43, "BaseQueryModuleData",                           kernel32_BaseQueryModuleData},
{ 0,   44, "BaseSetLastNTError",                            kernel32_BaseSetLastNTError},
{ 0,    1, "BaseThreadInitThunk",                           kernel32_BaseThreadInitThunk},
{ 0,   45, "BaseUpdateAppcompatCache",                      kernel32_BaseUpdateAppcompatCache},
{ 0,   46, "BaseVerifyUnicodeString",                       kernel32_BaseVerifyUnicodeString},
{ 0,   47, "Basep8BitStringToDynamicUnicodeString",         kernel32_Basep8BitStringToDynamicUnicodeString},
{ 0,   48, "BasepAllocateActivationContextActivationBlock", kernel32_BasepAllocateActivationContextActivationBlock},
{ 0,   49, "BasepAnsiStringToDynamicUnicodeString",         kernel32_BasepAnsiStringToDynamicUnicodeString},
{ 0,   50, "BasepCheckAppCompat",                           kernel32_BasepCheckAppCompat},
{ 0,   51, "BasepCheckBadapp",                              kernel32_BasepCheckBadapp},
{ 0,   52, "BasepCheckWinSaferRestrictions",                kernel32_BasepCheckWinSaferRestrictions},
{ 0,   53, "BasepFreeActivationContextActivationBlock",     kernel32_BasepFreeActivationContextActivationBlock},
{ 0,   54, "BasepFreeAppCompatData",                        kernel32_BasepFreeAppCompatData},
{ 0,   55, "BasepMapModuleHandle",                          kernel32_BasepMapModuleHandle},
{ 8,   56, "Beep",                                          kernel32_Beep},
{ 8,   57, "BeginUpdateResourceA",                          kernel32_BeginUpdateResourceA},
{ 8,   58, "BeginUpdateResourceW",                          kernel32_BeginUpdateResourceW},
{12,   59, "BindIoCompletionCallback",                      kernel32_BindIoCompletionCallback},
{ 8,   60, "BuildCommDCBA",                                 kernel32_BuildCommDCBA},
{12,   61, "BuildCommDCBAndTimeoutsA",                      kernel32_BuildCommDCBAndTimeoutsA},
{12,   62, "BuildCommDCBAndTimeoutsW",                      kernel32_BuildCommDCBAndTimeoutsW},
{ 8,   63, "BuildCommDCBW",                                 kernel32_BuildCommDCBW},
{28,   64, "CallNamedPipeA",                                kernel32_CallNamedPipeA},
{28,   65, "CallNamedPipeW",                                kernel32_CallNamedPipeW},
{ 4,   66, "CallbackMayRunLong",                            kernel32_CallbackMayRunLong},
{ 4,   67, "CancelDeviceWakeupRequest",                     kernel32_CancelDeviceWakeupRequest},
{ 4,   68, "CancelIo",                                      kernel32_CancelIo},
{ 8,   69, "CancelIoEx",                                    kernel32_CancelIoEx},
{ 4,   70, "CancelSynchronousIo",                           kernel32_CancelSynchronousIo},
{ 4,   71, "CancelThreadpoolIo",                            kernel32_CancelThreadpoolIo},
{ 8,   72, "CancelTimerQueueTimer",                         kernel32_CancelTimerQueueTimer},
{ 4,   73, "CancelWaitableTimer",                           kernel32_CancelWaitableTimer},
{16,   74, "ChangeTimerQueueTimer",                         kernel32_ChangeTimerQueueTimer},
{ 0,   75, "CheckElevation",                                kernel32_CheckElevation},
{ 0,   76, "CheckElevationEnabled",                         kernel32_CheckElevationEnabled},
{ 0,   77, "CheckForReadOnlyResource",                      kernel32_CheckForReadOnlyResource},
{20,   78, "CheckNameLegalDOS8Dot3A",                       kernel32_CheckNameLegalDOS8Dot3A},
{20,   79, "CheckNameLegalDOS8Dot3W",                       kernel32_CheckNameLegalDOS8Dot3W},
{ 8,   80, "CheckRemoteDebuggerPresent",                    kernel32_CheckRemoteDebuggerPresent},
{ 4,   81, "ClearCommBreak",                                kernel32_ClearCommBreak},
{12,   82, "ClearCommError",                                kernel32_ClearCommError},
{ 0,   83, "CloseConsoleHandle",                            kernel32_CloseConsoleHandle},
{ 4,   84, "CloseHandle",                                   kernel32_CloseHandle},
{ 8,   85, "ClosePrivateNamespace",                         kernel32_ClosePrivateNamespace},
{ 0,   86, "CloseProfileUserMapping",                       kernel32_CloseProfileUserMapping},
{ 4,   87, "CloseThreadpool",                               kernel32_CloseThreadpool},
{ 4,   88, "CloseThreadpoolCleanupGroup",                   kernel32_CloseThreadpoolCleanupGroup},
{12,   89, "CloseThreadpoolCleanupGroupMembers",            kernel32_CloseThreadpoolCleanupGroupMembers},
{ 4,   90, "CloseThreadpoolIo",                             kernel32_CloseThreadpoolIo},
{ 4,   91, "CloseThreadpoolTimer",                          kernel32_CloseThreadpoolTimer},
{ 4,   92, "CloseThreadpoolWait",                           kernel32_CloseThreadpoolWait},
{ 4,   93, "CloseThreadpoolWork",                           kernel32_CloseThreadpoolWork},
{ 0,   94, "CmdBatNotification",                            kernel32_CmdBatNotification},
{12,   95, "CommConfigDialogA",                             kernel32_CommConfigDialogA},
{12,   96, "CommConfigDialogW",                             kernel32_CommConfigDialogW},
{ 0,   97, "CompareCalendarDates",                          kernel32_CompareCalendarDates},
{ 8,   98, "CompareFileTime",                               kernel32_CompareFileTime},
{24,   99, "CompareStringA",                                kernel32_CompareStringA},
{36,  100, "CompareStringEx",                               kernel32_CompareStringEx},
{20,  101, "CompareStringOrdinal",                          kernel32_CompareStringOrdinal},
{24,  102, "CompareStringW",                                kernel32_CompareStringW},
{ 8,  103, "ConnectNamedPipe",                              kernel32_ConnectNamedPipe},
{ 0,  104, "ConsoleMenuControl",                            kernel32_ConsoleMenuControl},
{12,  105, "ContinueDebugEvent",                            kernel32_ContinueDebugEvent},
{ 0,  106, "ConvertCalDateTimeToSystemTime",                kernel32_ConvertCalDateTimeToSystemTime},
{ 4,  107, "ConvertDefaultLocale",                          kernel32_ConvertDefaultLocale},
{ 0,  108, "ConvertFiberToThread",                          kernel32_ConvertFiberToThread},
{ 0,  109, "ConvertNLSDayOfWeekToWin32DayOfWeek",           kernel32_ConvertNLSDayOfWeekToWin32DayOfWeek},
{ 0,  110, "ConvertSystemTimeToCalDateTime",                kernel32_ConvertSystemTimeToCalDateTime},
{ 4,  111, "ConvertThreadToFiber",                          kernel32_ConvertThreadToFiber},
{ 8,  112, "ConvertThreadToFiberEx",                        kernel32_ConvertThreadToFiberEx},
{ 0,  113, "CopyExtendedContext",                           kernel32_CopyExtendedContext},
{12,  114, "CopyFileA",                                     kernel32_CopyFileA},
{24,  115, "CopyFileExA",                                   kernel32_CopyFileExA},
{24,  116, "CopyFileExW",                                   kernel32_CopyFileExW},
{28,  117, "CopyFileTransactedA",                           kernel32_CopyFileTransactedA},
{28,  118, "CopyFileTransactedW",                           kernel32_CopyFileTransactedW},
{12,  119, "CopyFileW",                                     kernel32_CopyFileW},
{ 0,  120, "CopyLZFile",                                    kernel32_CopyLZFile},
{ 4,  121, "CreateActCtxA",                                 kernel32_CreateActCtxA},
{ 4,  122, "CreateActCtxW",                                 kernel32_CreateActCtxW},
{ 8,  123, "CreateBoundaryDescriptorA",                     kernel32_CreateBoundaryDescriptorA},
{ 8,  124, "CreateBoundaryDescriptorW",                     kernel32_CreateBoundaryDescriptorW},
{20,  125, "CreateConsoleScreenBuffer",                     kernel32_CreateConsoleScreenBuffer},
{ 8,  126, "CreateDirectoryA",                              kernel32_CreateDirectoryA},
{12,  127, "CreateDirectoryExA",                            kernel32_CreateDirectoryExA},
{12,  128, "CreateDirectoryExW",                            kernel32_CreateDirectoryExW},
{16,  129, "CreateDirectoryTransactedA",                    kernel32_CreateDirectoryTransactedA},
{16,  130, "CreateDirectoryTransactedW",                    kernel32_CreateDirectoryTransactedW},
{ 8,  131, "CreateDirectoryW",                              kernel32_CreateDirectoryW},
{16,  132, "CreateEventA",                                  kernel32_CreateEventA},
{16,  133, "CreateEventExA",                                kernel32_CreateEventExA},
{16,  134, "CreateEventExW",                                kernel32_CreateEventExW},
{16,  135, "CreateEventW",                                  kernel32_CreateEventW},
{12,  136, "CreateFiber",                                   kernel32_CreateFiber},
{20,  137, "CreateFiberEx",                                 kernel32_CreateFiberEx},
{28,  138, "CreateFileA",                                   kernel32_CreateFileA},
{24,  139, "CreateFileMappingA",                            kernel32_CreateFileMappingA},
{28,  140, "CreateFileMappingNumaA",                        kernel32_CreateFileMappingNumaA},
{28,  141, "CreateFileMappingNumaW",                        kernel32_CreateFileMappingNumaW},
{24,  142, "CreateFileMappingW",                            kernel32_CreateFileMappingW},
{40,  143, "CreateFileTransactedA",                         kernel32_CreateFileTransactedA},
{40,  144, "CreateFileTransactedW",                         kernel32_CreateFileTransactedW},
{28,  145, "CreateFileW",                                   kernel32_CreateFileW},
{12,  146, "CreateHardLinkA",                               kernel32_CreateHardLinkA},
{16,  147, "CreateHardLinkTransactedA",                     kernel32_CreateHardLinkTransactedA},
{16,  148, "CreateHardLinkTransactedW",                     kernel32_CreateHardLinkTransactedW},
{12,  149, "CreateHardLinkW",                               kernel32_CreateHardLinkW},
{16,  150, "CreateIoCompletionPort",                        kernel32_CreateIoCompletionPort},
{ 8,  151, "CreateJobObjectA",                              kernel32_CreateJobObjectA},
{ 8,  152, "CreateJobObjectW",                              kernel32_CreateJobObjectW},
{12,  153, "CreateJobSet",                                  kernel32_CreateJobSet},
{16,  154, "CreateMailslotA",                               kernel32_CreateMailslotA},
{16,  155, "CreateMailslotW",                               kernel32_CreateMailslotW},
{ 4,  156, "CreateMemoryResourceNotification",              kernel32_CreateMemoryResourceNotification},
{12,  157, "CreateMutexA",                                  kernel32_CreateMutexA},
{16,  158, "CreateMutexExA",                                kernel32_CreateMutexExA},
{16,  159, "CreateMutexExW",                                kernel32_CreateMutexExW},
{12,  160, "CreateMutexW",                                  kernel32_CreateMutexW},
{32,  161, "CreateNamedPipeA",                              kernel32_CreateNamedPipeA},
{32,  162, "CreateNamedPipeW",                              kernel32_CreateNamedPipeW},
{16,  163, "CreatePipe",                                    kernel32_CreatePipe},
{12,  164, "CreatePrivateNamespaceA",                       kernel32_CreatePrivateNamespaceA},
{12,  165, "CreatePrivateNamespaceW",                       kernel32_CreatePrivateNamespaceW},
{40,  166, "CreateProcessA",                                kernel32_CreateProcessA},
{ 0,  167, "CreateProcessAsUserW",                          kernel32_CreateProcessAsUserW},
{ 0,  168, "CreateProcessInternalA",                        kernel32_CreateProcessInternalA},
{ 0,  169, "CreateProcessInternalW",                        kernel32_CreateProcessInternalW},
{40,  170, "CreateProcessW",                                kernel32_CreateProcessW},
{28,  171, "CreateRemoteThread",                            kernel32_CreateRemoteThread},
{ 0,  172, "CreateRemoteThreadEx",                          kernel32_CreateRemoteThreadEx},
{16,  173, "CreateSemaphoreA",                              kernel32_CreateSemaphoreA},
{24,  174, "CreateSemaphoreExA",                            kernel32_CreateSemaphoreExA},
{24,  175, "CreateSemaphoreExW",                            kernel32_CreateSemaphoreExW},
{16,  176, "CreateSemaphoreW",                              kernel32_CreateSemaphoreW},
{ 0,  177, "CreateSocketHandle",                            kernel32_CreateSocketHandle},
{12,  178, "CreateSymbolicLinkA",                           kernel32_CreateSymbolicLinkA},
{16,  179, "CreateSymbolicLinkTransactedA",                 kernel32_CreateSymbolicLinkTransactedA},
{16,  180, "CreateSymbolicLinkTransactedW",                 kernel32_CreateSymbolicLinkTransactedW},
{12,  181, "CreateSymbolicLinkW",                           kernel32_CreateSymbolicLinkW},
{16,  182, "CreateTapePartition",                           kernel32_CreateTapePartition},
{24,  183, "CreateThread",                                  kernel32_CreateThread},
{ 4,  184, "CreateThreadpool",                              kernel32_CreateThreadpool},
{ 0,  185, "CreateThreadpoolCleanupGroup",                  kernel32_CreateThreadpoolCleanupGroup},
{16,  186, "CreateThreadpoolIo",                            kernel32_CreateThreadpoolIo},
{12,  187, "CreateThreadpoolTimer",                         kernel32_CreateThreadpoolTimer},
{12,  188, "CreateThreadpoolWait",                          kernel32_CreateThreadpoolWait},
{12,  189, "CreateThreadpoolWork",                          kernel32_CreateThreadpoolWork},
{ 0,  190, "CreateTimerQueue",                              kernel32_CreateTimerQueue},
{28,  191, "CreateTimerQueueTimer",                         kernel32_CreateTimerQueueTimer},
{ 8,  192, "CreateToolhelp32Snapshot",                      kernel32_CreateToolhelp32Snapshot},
{12,  193, "CreateWaitableTimerA",                          kernel32_CreateWaitableTimerA},
{16,  194, "CreateWaitableTimerExA",                        kernel32_CreateWaitableTimerExA},
{16,  195, "CreateWaitableTimerExW",                        kernel32_CreateWaitableTimerExW},
{12,  196, "CreateWaitableTimerW",                          kernel32_CreateWaitableTimerW},
{ 0,  197, "CtrlRoutine",                                   kernel32_CtrlRoutine},
{ 8,  198, "DeactivateActCtx",                              kernel32_DeactivateActCtx},
{ 4,  199, "DebugActiveProcess",                            kernel32_DebugActiveProcess},
{ 4,  200, "DebugActiveProcessStop",                        kernel32_DebugActiveProcessStop},
{ 0,  201, "DebugBreak",                                    kernel32_DebugBreak},
{ 4,  202, "DebugBreakProcess",                             kernel32_DebugBreakProcess},
{ 4,  203, "DebugSetProcessKillOnExit",                     kernel32_DebugSetProcessKillOnExit},
{ 4,  204, "DecodePointer",                                 kernel32_DecodePointer},
{ 4,  205, "DecodeSystemPointer",                           kernel32_DecodeSystemPointer},
{12,  206, "DefineDosDeviceA",                              kernel32_DefineDosDeviceA},
{12,  207, "DefineDosDeviceW",                              kernel32_DefineDosDeviceW},
{ 0,  208, "DelayLoadFailureHook",                          kernel32_DelayLoadFailureHook},
{ 4,  209, "DeleteAtom",                                    kernel32_DeleteAtom},
{ 4,  210, "DeleteBoundaryDescriptor",                      kernel32_DeleteBoundaryDescriptor},
{ 4,  211, "DeleteCriticalSection",                         kernel32_DeleteCriticalSection},
{ 4,  212, "DeleteFiber",                                   kernel32_DeleteFiber},
{ 4,  213, "DeleteFileA",                                   kernel32_DeleteFileA},
{ 8,  214, "DeleteFileTransactedA",                         kernel32_DeleteFileTransactedA},
{ 8,  215, "DeleteFileTransactedW",                         kernel32_DeleteFileTransactedW},
{ 4,  216, "DeleteFileW",                                   kernel32_DeleteFileW},
{ 4,  217, "DeleteProcThreadAttributeList",                 kernel32_DeleteProcThreadAttributeList},
{ 4,  218, "DeleteTimerQueue",                              kernel32_DeleteTimerQueue},
{ 8,  219, "DeleteTimerQueueEx",                            kernel32_DeleteTimerQueueEx},
{12,  220, "DeleteTimerQueueTimer",                         kernel32_DeleteTimerQueueTimer},
{ 4,  221, "DeleteVolumeMountPointA",                       kernel32_DeleteVolumeMountPointA},
{ 4,  222, "DeleteVolumeMountPointW",                       kernel32_DeleteVolumeMountPointW},
{32,  223, "DeviceIoControl",                               kernel32_DeviceIoControl},
{ 4,  224, "DisableThreadLibraryCalls",                     kernel32_DisableThreadLibraryCalls},
{ 0,  225, "DisableThreadProfiling",                        kernel32_DisableThreadProfiling},
{ 4,  226, "DisassociateCurrentThreadFromCallback",         kernel32_DisassociateCurrentThreadFromCallback},
{ 4,  227, "DisconnectNamedPipe",                           kernel32_DisconnectNamedPipe},
{12,  228, "DnsHostnameToComputerNameA",                    kernel32_DnsHostnameToComputerNameA},
{12,  229, "DnsHostnameToComputerNameW",                    kernel32_DnsHostnameToComputerNameW},
{12,  230, "DosDateTimeToFileTime",                         kernel32_DosDateTimeToFileTime},
{ 0,  231, "DosPathToSessionPathA",                         kernel32_DosPathToSessionPathA},
{ 0,  232, "DosPathToSessionPathW",                         kernel32_DosPathToSessionPathW},
{ 0,  233, "DuplicateConsoleHandle",                        kernel32_DuplicateConsoleHandle},
{28,  234, "DuplicateHandle",                               kernel32_DuplicateHandle},
{ 0,  235, "EnableThreadProfiling",                         kernel32_EnableThreadProfiling},
{ 4,  236, "EncodePointer",                                 kernel32_EncodePointer},
{ 4,  237, "EncodeSystemPointer",                           kernel32_EncodeSystemPointer},
{ 8,  238, "EndUpdateResourceA",                            kernel32_EndUpdateResourceA},
{ 8,  239, "EndUpdateResourceW",                            kernel32_EndUpdateResourceW},
{ 4,  240, "EnterCriticalSection",                          kernel32_EnterCriticalSection},
{16,  241, "EnumCalendarInfoA",                             kernel32_EnumCalendarInfoA},
{16,  242, "EnumCalendarInfoExA",                           kernel32_EnumCalendarInfoExA},
{24,  243, "EnumCalendarInfoExEx",                          kernel32_EnumCalendarInfoExEx},
{16,  244, "EnumCalendarInfoExW",                           kernel32_EnumCalendarInfoExW},
{16,  245, "EnumCalendarInfoW",                             kernel32_EnumCalendarInfoW},
{12,  246, "EnumDateFormatsA",                              kernel32_EnumDateFormatsA},
{12,  247, "EnumDateFormatsExA",                            kernel32_EnumDateFormatsExA},
{16,  248, "EnumDateFormatsExEx",                           kernel32_EnumDateFormatsExEx},
{12,  249, "EnumDateFormatsExW",                            kernel32_EnumDateFormatsExW},
{12,  250, "EnumDateFormatsW",                              kernel32_EnumDateFormatsW},
{16,  251, "EnumLanguageGroupLocalesA",                     kernel32_EnumLanguageGroupLocalesA},
{16,  252, "EnumLanguageGroupLocalesW",                     kernel32_EnumLanguageGroupLocalesW},
{20,  253, "EnumResourceLanguagesA",                        kernel32_EnumResourceLanguagesA},
{28,  254, "EnumResourceLanguagesExA",                      kernel32_EnumResourceLanguagesExA},
{28,  255, "EnumResourceLanguagesExW",                      kernel32_EnumResourceLanguagesExW},
{20,  256, "EnumResourceLanguagesW",                        kernel32_EnumResourceLanguagesW},
{16,  257, "EnumResourceNamesA",                            kernel32_EnumResourceNamesA},
{24,  258, "EnumResourceNamesExA",                          kernel32_EnumResourceNamesExA},
{24,  259, "EnumResourceNamesExW",                          kernel32_EnumResourceNamesExW},
{16,  260, "EnumResourceNamesW",                            kernel32_EnumResourceNamesW},
{12,  261, "EnumResourceTypesA",                            kernel32_EnumResourceTypesA},
{20,  262, "EnumResourceTypesExA",                          kernel32_EnumResourceTypesExA},
{20,  263, "EnumResourceTypesExW",                          kernel32_EnumResourceTypesExW},
{12,  264, "EnumResourceTypesW",                            kernel32_EnumResourceTypesW},
{ 8,  265, "EnumSystemCodePagesA",                          kernel32_EnumSystemCodePagesA},
{ 8,  266, "EnumSystemCodePagesW",                          kernel32_EnumSystemCodePagesW},
{12,  267, "EnumSystemFirmwareTables",                      kernel32_EnumSystemFirmwareTables},
{12,  268, "EnumSystemGeoID",                               kernel32_EnumSystemGeoID},
{12,  269, "EnumSystemLanguageGroupsA",                     kernel32_EnumSystemLanguageGroupsA},
{12,  270, "EnumSystemLanguageGroupsW",                     kernel32_EnumSystemLanguageGroupsW},
{ 8,  271, "EnumSystemLocalesA",                            kernel32_EnumSystemLocalesA},
{16,  272, "EnumSystemLocalesEx",                           kernel32_EnumSystemLocalesEx},
{ 8,  273, "EnumSystemLocalesW",                            kernel32_EnumSystemLocalesW},
{12,  274, "EnumTimeFormatsA",                              kernel32_EnumTimeFormatsA},
{16,  275, "EnumTimeFormatsEx",                             kernel32_EnumTimeFormatsEx},
{12,  276, "EnumTimeFormatsW",                              kernel32_EnumTimeFormatsW},
{12,  277, "EnumUILanguagesA",                              kernel32_EnumUILanguagesA},
{12,  278, "EnumUILanguagesW",                              kernel32_EnumUILanguagesW},
{16,  279, "EnumerateLocalComputerNamesA",                  kernel32_EnumerateLocalComputerNamesA},
{16,  280, "EnumerateLocalComputerNamesW",                  kernel32_EnumerateLocalComputerNamesW},
{12,  281, "EraseTape",                                     kernel32_EraseTape},
{ 8,  282, "EscapeCommFunction",                            kernel32_EscapeCommFunction},
{ 4,  283, "ExitProcess",                                   kernel32_ExitProcess},
{ 4,  284, "ExitThread",                                    kernel32_ExitThread},
{ 0,  285, "ExitVDM",                                       kernel32_ExitVDM},
{12,  286, "ExpandEnvironmentStringsA",                     kernel32_ExpandEnvironmentStringsA},
{12,  287, "ExpandEnvironmentStringsW",                     kernel32_ExpandEnvironmentStringsW},
{ 0,  288, "ExpungeConsoleCommandHistoryA",                 kernel32_ExpungeConsoleCommandHistoryA},
{ 0,  289, "ExpungeConsoleCommandHistoryW",                 kernel32_ExpungeConsoleCommandHistoryW},
{ 8,  290, "FatalAppExitA",                                 kernel32_FatalAppExitA},
{ 8,  291, "FatalAppExitW",                                 kernel32_FatalAppExitW},
{ 4,  292, "FatalExit",                                     kernel32_FatalExit},
{12,  293, "FileTimeToDosDateTime",                         kernel32_FileTimeToDosDateTime},
{ 8,  294, "FileTimeToLocalFileTime",                       kernel32_FileTimeToLocalFileTime},
{ 8,  295, "FileTimeToSystemTime",                          kernel32_FileTimeToSystemTime},
{20,  296, "FillConsoleOutputAttribute",                    kernel32_FillConsoleOutputAttribute},
{20,  297, "FillConsoleOutputCharacterA",                   kernel32_FillConsoleOutputCharacterA},
{20,  298, "FillConsoleOutputCharacterW",                   kernel32_FillConsoleOutputCharacterW},
{20,  299, "FindActCtxSectionGuid",                         kernel32_FindActCtxSectionGuid},
{20,  300, "FindActCtxSectionStringA",                      kernel32_FindActCtxSectionStringA},
{20,  301, "FindActCtxSectionStringW",                      kernel32_FindActCtxSectionStringW},
{ 4,  302, "FindAtomA",                                     kernel32_FindAtomA},
{ 4,  303, "FindAtomW",                                     kernel32_FindAtomW},
{ 4,  304, "FindClose",                                     kernel32_FindClose},
{ 4,  305, "FindCloseChangeNotification",                   kernel32_FindCloseChangeNotification},
{12,  306, "FindFirstChangeNotificationA",                  kernel32_FindFirstChangeNotificationA},
{12,  307, "FindFirstChangeNotificationW",                  kernel32_FindFirstChangeNotificationW},
{ 8,  308, "FindFirstFileA",                                kernel32_FindFirstFileA},
{24,  309, "FindFirstFileExA",                              kernel32_FindFirstFileExA},
{24,  310, "FindFirstFileExW",                              kernel32_FindFirstFileExW},
{20,  311, "FindFirstFileNameTransactedW",                  kernel32_FindFirstFileNameTransactedW},
{16,  312, "FindFirstFileNameW",                            kernel32_FindFirstFileNameW},
{28,  313, "FindFirstFileTransactedA",                      kernel32_FindFirstFileTransactedA},
{28,  314, "FindFirstFileTransactedW",                      kernel32_FindFirstFileTransactedW},
{ 8,  315, "FindFirstFileW",                                kernel32_FindFirstFileW},
{20,  316, "FindFirstStreamTransactedW",                    kernel32_FindFirstStreamTransactedW},
{16,  317, "FindFirstStreamW",                              kernel32_FindFirstStreamW},
{ 8,  318, "FindFirstVolumeA",                              kernel32_FindFirstVolumeA},
{12,  319, "FindFirstVolumeMountPointA",                    kernel32_FindFirstVolumeMountPointA},
{12,  320, "FindFirstVolumeMountPointW",                    kernel32_FindFirstVolumeMountPointW},
{ 8,  321, "FindFirstVolumeW",                              kernel32_FindFirstVolumeW},
{28,  322, "FindNLSString",                                 kernel32_FindNLSString},
{40,  323, "FindNLSStringEx",                               kernel32_FindNLSStringEx},
{ 4,  324, "FindNextChangeNotification",                    kernel32_FindNextChangeNotification},
{ 8,  325, "FindNextFileA",                                 kernel32_FindNextFileA},
{12,  326, "FindNextFileNameW",                             kernel32_FindNextFileNameW},
{ 8,  327, "FindNextFileW",                                 kernel32_FindNextFileW},
{ 8,  328, "FindNextStreamW",                               kernel32_FindNextStreamW},
{12,  329, "FindNextVolumeA",                               kernel32_FindNextVolumeA},
{12,  330, "FindNextVolumeMountPointA",                     kernel32_FindNextVolumeMountPointA},
{12,  331, "FindNextVolumeMountPointW",                     kernel32_FindNextVolumeMountPointW},
{12,  332, "FindNextVolumeW",                               kernel32_FindNextVolumeW},
{12,  333, "FindResourceA",                                 kernel32_FindResourceA},
{16,  334, "FindResourceExA",                               kernel32_FindResourceExA},
{16,  335, "FindResourceExW",                               kernel32_FindResourceExW},
{12,  336, "FindResourceW",                                 kernel32_FindResourceW},
{ 0,  337, "FindStringOrdinal",                             kernel32_FindStringOrdinal},
{ 4,  338, "FindVolumeClose",                               kernel32_FindVolumeClose},
{ 4,  339, "FindVolumeMountPointClose",                     kernel32_FindVolumeMountPointClose},
{ 4,  340, "FlsAlloc",                                      kernel32_FlsAlloc},
{ 4,  341, "FlsFree",                                       kernel32_FlsFree},
{ 4,  342, "FlsGetValue",                                   kernel32_FlsGetValue},
{ 8,  343, "FlsSetValue",                                   kernel32_FlsSetValue},
{ 4,  344, "FlushConsoleInputBuffer",                       kernel32_FlushConsoleInputBuffer},
{ 4,  345, "FlushFileBuffers",                              kernel32_FlushFileBuffers},
{12,  346, "FlushInstructionCache",                         kernel32_FlushInstructionCache},
{ 0,  347, "FlushProcessWriteBuffers",                      kernel32_FlushProcessWriteBuffers},
{ 8,  348, "FlushViewOfFile",                               kernel32_FlushViewOfFile},
{20,  349, "FoldStringA",                                   kernel32_FoldStringA},
{20,  350, "FoldStringW",                                   kernel32_FoldStringW},
{28,  351, "FormatMessageA",                                kernel32_FormatMessageA},
{28,  352, "FormatMessageW",                                kernel32_FormatMessageW},
{ 0,  353, "FreeConsole",                                   kernel32_FreeConsole},
{ 4,  354, "FreeEnvironmentStringsA",                       kernel32_FreeEnvironmentStringsA},
{ 4,  355, "FreeEnvironmentStringsW",                       kernel32_FreeEnvironmentStringsW},
{ 4,  356, "FreeLibrary",                                   kernel32_FreeLibrary},
{ 8,  357, "FreeLibraryAndExitThread",                      kernel32_FreeLibraryAndExitThread},
{ 8,  358, "FreeLibraryWhenCallbackReturns",                kernel32_FreeLibraryWhenCallbackReturns},
{ 4,  359, "FreeResource",                                  kernel32_FreeResource},
{12,  360, "FreeUserPhysicalPages",                         kernel32_FreeUserPhysicalPages},
{ 8,  361, "GenerateConsoleCtrlEvent",                      kernel32_GenerateConsoleCtrlEvent},
{ 0,  362, "GetACP",                                        kernel32_GetACP},
{ 0,  363, "GetActiveProcessorCount",                       kernel32_GetActiveProcessorCount},
{ 0,  364, "GetActiveProcessorGroupCount",                  kernel32_GetActiveProcessorGroupCount},
{20,  365, "GetApplicationRecoveryCallback",                kernel32_GetApplicationRecoveryCallback},
{16,  366, "GetApplicationRestartSettings",                 kernel32_GetApplicationRestartSettings},
{12,  367, "GetAtomNameA",                                  kernel32_GetAtomNameA},
{12,  368, "GetAtomNameW",                                  kernel32_GetAtomNameW},
{ 8,  369, "GetBinaryType",                                 kernel32_GetBinaryTypeA},
{ 8,  370, "GetBinaryTypeA",                                kernel32_GetBinaryTypeA},
{ 8,  371, "GetBinaryTypeW",                                kernel32_GetBinaryTypeW},
{ 8,  372, "GetCPInfo",                                     kernel32_GetCPInfo},
{12,  373, "GetCPInfoExA",                                  kernel32_GetCPInfoExA},
{12,  374, "GetCPInfoExW",                                  kernel32_GetCPInfoExW},
{ 0,  375, "GetCalendarDateFormat",                         kernel32_GetCalendarDateFormat},
{ 0,  376, "GetCalendarDateFormatEx",                       kernel32_GetCalendarDateFormatEx},
{ 0,  377, "GetCalendarDaysInMonth",                        kernel32_GetCalendarDaysInMonth},
{ 0,  378, "GetCalendarDifferenceInDays",                   kernel32_GetCalendarDifferenceInDays},
{24,  379, "GetCalendarInfoA",                              kernel32_GetCalendarInfoA},
{28,  380, "GetCalendarInfoEx",                             kernel32_GetCalendarInfoEx},
{24,  381, "GetCalendarInfoW",                              kernel32_GetCalendarInfoW},
{ 0,  382, "GetCalendarMonthsInYear",                       kernel32_GetCalendarMonthsInYear},
{ 0,  383, "GetCalendarSupportedDateRange",                 kernel32_GetCalendarSupportedDateRange},
{ 0,  384, "GetCalendarWeekNumber",                         kernel32_GetCalendarWeekNumber},
{ 0,  385, "GetComPlusPackageInstallStatus",                kernel32_GetComPlusPackageInstallStatus},
{12,  386, "GetCommConfig",                                 kernel32_GetCommConfig},
{ 8,  387, "GetCommMask",                                   kernel32_GetCommMask},
{ 8,  388, "GetCommModemStatus",                            kernel32_GetCommModemStatus},
{ 8,  389, "GetCommProperties",                             kernel32_GetCommProperties},
{ 8,  390, "GetCommState",                                  kernel32_GetCommState},
{ 8,  391, "GetCommTimeouts",                               kernel32_GetCommTimeouts},
{ 0,  392, "GetCommandLineA",                               kernel32_GetCommandLineA},
{ 0,  393, "GetCommandLineW",                               kernel32_GetCommandLineW},
{ 8,  394, "GetCompressedFileSizeA",                        kernel32_GetCompressedFileSizeA},
{12,  395, "GetCompressedFileSizeTransactedA",              kernel32_GetCompressedFileSizeTransactedA},
{12,  396, "GetCompressedFileSizeTransactedW",              kernel32_GetCompressedFileSizeTransactedW},
{ 8,  397, "GetCompressedFileSizeW",                        kernel32_GetCompressedFileSizeW},
{ 8,  398, "GetComputerNameA",                              kernel32_GetComputerNameA},
{12,  399, "GetComputerNameExA",                            kernel32_GetComputerNameExA},
{12,  400, "GetComputerNameExW",                            kernel32_GetComputerNameExW},
{ 8,  401, "GetComputerNameW",                              kernel32_GetComputerNameW},
{16,  402, "GetConsoleAliasA",                              kernel32_GetConsoleAliasA},
{ 8,  403, "GetConsoleAliasExesA",                          kernel32_GetConsoleAliasExesA},
{ 0,  404, "GetConsoleAliasExesLengthA",                    kernel32_GetConsoleAliasExesLengthA},
{ 0,  405, "GetConsoleAliasExesLengthW",                    kernel32_GetConsoleAliasExesLengthW},
{ 8,  406, "GetConsoleAliasExesW",                          kernel32_GetConsoleAliasExesW},
{16,  407, "GetConsoleAliasW",                              kernel32_GetConsoleAliasW},
{12,  408, "GetConsoleAliasesA",                            kernel32_GetConsoleAliasesA},
{ 4,  409, "GetConsoleAliasesLengthA",                      kernel32_GetConsoleAliasesLengthA},
{ 4,  410, "GetConsoleAliasesLengthW",                      kernel32_GetConsoleAliasesLengthW},
{12,  411, "GetConsoleAliasesW",                            kernel32_GetConsoleAliasesW},
{ 0,  412, "GetConsoleCP",                                  kernel32_GetConsoleCP},
{ 0,  413, "GetConsoleCharType",                            kernel32_GetConsoleCharType},
{ 0,  414, "GetConsoleCommandHistoryA",                     kernel32_GetConsoleCommandHistoryA},
{ 0,  415, "GetConsoleCommandHistoryLengthA",               kernel32_GetConsoleCommandHistoryLengthA},
{ 0,  416, "GetConsoleCommandHistoryLengthW",               kernel32_GetConsoleCommandHistoryLengthW},
{ 0,  417, "GetConsoleCommandHistoryW",                     kernel32_GetConsoleCommandHistoryW},
{ 8,  418, "GetConsoleCursorInfo",                          kernel32_GetConsoleCursorInfo},
{ 0,  419, "GetConsoleCursorMode",                          kernel32_GetConsoleCursorMode},
{ 4,  420, "GetConsoleDisplayMode",                         kernel32_GetConsoleDisplayMode},
{ 0,  421, "GetConsoleFontInfo",                            kernel32_GetConsoleFontInfo},
{ 8,  422, "GetConsoleFontSize",                            kernel32_GetConsoleFontSize},
{ 0,  423, "GetConsoleHardwareState",                       kernel32_GetConsoleHardwareState},
{ 4,  424, "GetConsoleHistoryInfo",                         kernel32_GetConsoleHistoryInfo},
{ 0,  425, "GetConsoleInputExeNameA",                       kernel32_GetConsoleInputExeNameA},
{ 0,  426, "GetConsoleInputExeNameW",                       kernel32_GetConsoleInputExeNameW},
{ 0,  427, "GetConsoleInputWaitHandle",                     kernel32_GetConsoleInputWaitHandle},
{ 0,  428, "GetConsoleKeyboardLayoutNameA",                 kernel32_GetConsoleKeyboardLayoutNameA},
{ 0,  429, "GetConsoleKeyboardLayoutNameW",                 kernel32_GetConsoleKeyboardLayoutNameW},
{ 8,  430, "GetConsoleMode",                                kernel32_GetConsoleMode},
{ 0,  431, "GetConsoleNlsMode",                             kernel32_GetConsoleNlsMode},
{ 8,  432, "GetConsoleOriginalTitleA",                      kernel32_GetConsoleOriginalTitleA},
{ 8,  433, "GetConsoleOriginalTitleW",                      kernel32_GetConsoleOriginalTitleW},
{ 0,  434, "GetConsoleOutputCP",                            kernel32_GetConsoleOutputCP},
{ 8,  435, "GetConsoleProcessList",                         kernel32_GetConsoleProcessList},
{ 8,  436, "GetConsoleScreenBufferInfo",                    kernel32_GetConsoleScreenBufferInfo},
{ 8,  437, "GetConsoleScreenBufferInfoEx",                  kernel32_GetConsoleScreenBufferInfoEx},
{ 4,  438, "GetConsoleSelectionInfo",                       kernel32_GetConsoleSelectionInfo},
{ 8,  439, "GetConsoleTitleA",                              kernel32_GetConsoleTitleA},
{ 8,  440, "GetConsoleTitleW",                              kernel32_GetConsoleTitleW},
{ 0,  441, "GetConsoleWindow",                              kernel32_GetConsoleWindow},
{24,  442, "GetCurrencyFormatA",                            kernel32_GetCurrencyFormatA},
{24,  443, "GetCurrencyFormatEx",                           kernel32_GetCurrencyFormatEx},
{24,  444, "GetCurrencyFormatW",                            kernel32_GetCurrencyFormatW},
{ 4,  445, "GetCurrentActCtx",                              kernel32_GetCurrentActCtx},
{12,  446, "GetCurrentConsoleFont",                         kernel32_GetCurrentConsoleFont},
{12,  447, "GetCurrentConsoleFontEx",                       kernel32_GetCurrentConsoleFontEx},
{ 8,  448, "GetCurrentDirectoryA",                          kernel32_GetCurrentDirectoryA},
{ 8,  449, "GetCurrentDirectoryW",                          kernel32_GetCurrentDirectoryW},
{ 0,  450, "GetCurrentProcess",                             kernel32_GetCurrentProcess},
{ 0,  451, "GetCurrentProcessId",                           kernel32_GetCurrentProcessId},
{ 0,  452, "GetCurrentProcessorNumber",                     kernel32_GetCurrentProcessorNumber},
{ 0,  453, "GetCurrentProcessorNumberEx",                   kernel32_GetCurrentProcessorNumberEx},
{ 0,  454, "GetCurrentThread",                              kernel32_GetCurrentThread},
{ 0,  455, "GetCurrentThreadId",                            kernel32_GetCurrentThreadId},
{24,  456, "GetDateFormatA",                                kernel32_GetDateFormatA},
{28,  457, "GetDateFormatEx",                               kernel32_GetDateFormatEx},
{24,  458, "GetDateFormatW",                                kernel32_GetDateFormatW},
{12,  459, "GetDefaultCommConfigA",                         kernel32_GetDefaultCommConfigA},
{12,  460, "GetDefaultCommConfigW",                         kernel32_GetDefaultCommConfigW},
{ 8,  461, "GetDevicePowerState",                           kernel32_GetDevicePowerState},
{20,  462, "GetDiskFreeSpaceA",                             kernel32_GetDiskFreeSpaceA},
{16,  463, "GetDiskFreeSpaceExA",                           kernel32_GetDiskFreeSpaceExA},
{16,  464, "GetDiskFreeSpaceExW",                           kernel32_GetDiskFreeSpaceExW},
{20,  465, "GetDiskFreeSpaceW",                             kernel32_GetDiskFreeSpaceW},
{ 8,  466, "GetDllDirectoryA",                              kernel32_GetDllDirectoryA},
{ 8,  467, "GetDllDirectoryW",                              kernel32_GetDllDirectoryW},
{ 4,  468, "GetDriveTypeA",                                 kernel32_GetDriveTypeA},
{ 4,  469, "GetDriveTypeW",                                 kernel32_GetDriveTypeW},
{32,  470, "GetDurationFormat",                             kernel32_GetDurationFormat},
{32,  471, "GetDurationFormatEx",                           kernel32_GetDurationFormatEx},
{ 4,  472, "GetDynamicTimeZoneInformation",                 kernel32_GetDynamicTimeZoneInformation},
{ 0,  473, "GetEnabledExtendedFeatures",                    kernel32_GetEnabledExtendedFeatures},
{ 0,  474, "GetEnvironmentStrings",                         kernel32_GetEnvironmentStringsA},
{ 0,  475, "GetEnvironmentStringsA",                        kernel32_GetEnvironmentStringsA},
{ 0,  476, "GetEnvironmentStringsW",                        kernel32_GetEnvironmentStringsW},
{12,  477, "GetEnvironmentVariableA",                       kernel32_GetEnvironmentVariableA},
{12,  478, "GetEnvironmentVariableW",                       kernel32_GetEnvironmentVariableW},
{ 0,  479, "GetEraNameCountedString",                       kernel32_GetEraNameCountedString},
{ 0,  480, "GetErrorMode",                                  kernel32_GetErrorMode},
{ 8,  481, "GetExitCodeProcess",                            kernel32_GetExitCodeProcess},
{ 8,  482, "GetExitCodeThread",                             kernel32_GetExitCodeThread},
{ 0,  483, "GetExpandedNameA",                              kernel32_GetExpandedNameA},
{ 0,  484, "GetExpandedNameW",                              kernel32_GetExpandedNameW},
{ 0,  485, "GetExtendedContextLength",                      kernel32_GetExtendedContextLength},
{ 0,  486, "GetExtendedFeaturesMask",                       kernel32_GetExtendedFeaturesMask},
{ 4,  487, "GetFileAttributesA",                            kernel32_GetFileAttributesA},
{12,  488, "GetFileAttributesExA",                          kernel32_GetFileAttributesExA},
{12,  489, "GetFileAttributesExW",                          kernel32_GetFileAttributesExW},
{16,  490, "GetFileAttributesTransactedA",                  kernel32_GetFileAttributesTransactedA},
{16,  491, "GetFileAttributesTransactedW",                  kernel32_GetFileAttributesTransactedW},
{ 4,  492, "GetFileAttributesW",                            kernel32_GetFileAttributesW},
{24,  493, "GetFileBandwidthReservation",                   kernel32_GetFileBandwidthReservation},
{ 8,  494, "GetFileInformationByHandle",                    kernel32_GetFileInformationByHandle},
{16,  495, "GetFileInformationByHandleEx",                  kernel32_GetFileInformationByHandleEx},
{16,  496, "GetFileMUIInfo",                                kernel32_GetFileMUIInfo},
{28,  497, "GetFileMUIPath",                                kernel32_GetFileMUIPath},
{ 8,  498, "GetFileSize",                                   kernel32_GetFileSize},
{ 8,  499, "GetFileSizeEx",                                 kernel32_GetFileSizeEx},
{16,  500, "GetFileTime",                                   kernel32_GetFileTime},
{ 4,  501, "GetFileType",                                   kernel32_GetFileType},
{16,  502, "GetFinalPathNameByHandleA",                     kernel32_GetFinalPathNameByHandleA},
{16,  503, "GetFinalPathNameByHandleW",                     kernel32_GetFinalPathNameByHandleW},
{16,  504, "GetFirmwareEnvironmentVariableA",               kernel32_GetFirmwareEnvironmentVariableA},
{16,  505, "GetFirmwareEnvironmentVariableW",               kernel32_GetFirmwareEnvironmentVariableW},
{16,  506, "GetFullPathNameA",                              kernel32_GetFullPathNameA},
{20,  507, "GetFullPathNameTransactedA",                    kernel32_GetFullPathNameTransactedA},
{20,  508, "GetFullPathNameTransactedW",                    kernel32_GetFullPathNameTransactedW},
{16,  509, "GetFullPathNameW",                              kernel32_GetFullPathNameW},
{20,  510, "GetGeoInfoA",                                   kernel32_GetGeoInfoA},
{20,  511, "GetGeoInfoW",                                   kernel32_GetGeoInfoW},
{ 0,  512, "GetHandleContext",                              kernel32_GetHandleContext},
{ 8,  513, "GetHandleInformation",                          kernel32_GetHandleInformation},
{ 0,  514, "GetLargePageMinimum",                           kernel32_GetLargePageMinimum},
{ 4,  515, "GetLargestConsoleWindowSize",                   kernel32_GetLargestConsoleWindowSize},
{ 0,  516, "GetLastError",                                  kernel32_GetLastError},
{ 4,  517, "GetLocalTime",                                  kernel32_GetLocalTime},
{16,  518, "GetLocaleInfoA",                                kernel32_GetLocaleInfoA},
{16,  519, "GetLocaleInfoEx",                               kernel32_GetLocaleInfoEx},
{16,  520, "GetLocaleInfoW",                                kernel32_GetLocaleInfoW},
{ 8,  521, "GetLogicalDriveStringsA",                       kernel32_GetLogicalDriveStringsA},
{ 8,  522, "GetLogicalDriveStringsW",                       kernel32_GetLogicalDriveStringsW},
{ 0,  523, "GetLogicalDrives",                              kernel32_GetLogicalDrives},
{ 8,  524, "GetLogicalProcessorInformation",                kernel32_GetLogicalProcessorInformation},
{ 0,  525, "GetLogicalProcessorInformationEx",              kernel32_GetLogicalProcessorInformationEx},
{12,  526, "GetLongPathNameA",                              kernel32_GetLongPathNameA},
{16,  527, "GetLongPathNameTransactedA",                    kernel32_GetLongPathNameTransactedA},
{16,  528, "GetLongPathNameTransactedW",                    kernel32_GetLongPathNameTransactedW},
{12,  529, "GetLongPathNameW",                              kernel32_GetLongPathNameW},
{20,  530, "GetMailslotInfo",                               kernel32_GetMailslotInfo},
{ 0,  531, "GetMaximumProcessorCount",                      kernel32_GetMaximumProcessorCount},
{ 0,  532, "GetMaximumProcessorGroupCount",                 kernel32_GetMaximumProcessorGroupCount},
{12,  533, "GetModuleFileNameA",                            kernel32_GetModuleFileNameA},
{12,  534, "GetModuleFileNameW",                            kernel32_GetModuleFileNameW},
{ 4,  535, "GetModuleHandleA",                              kernel32_GetModuleHandleA},
{12,  536, "GetModuleHandleExA",                            kernel32_GetModuleHandleExA},
{12,  537, "GetModuleHandleExW",                            kernel32_GetModuleHandleExW},
{ 4,  538, "GetModuleHandleW",                              kernel32_GetModuleHandleW},
{12,  539, "GetNLSVersion",                                 kernel32_GetNLSVersion},
{12,  540, "GetNLSVersionEx",                               kernel32_GetNLSVersionEx},
{20,  541, "GetNamedPipeAttribute",                         kernel32_GetNamedPipeAttribute},
{12,  542, "GetNamedPipeClientComputerNameA",               kernel32_GetNamedPipeClientComputerNameA},
{12,  543, "GetNamedPipeClientComputerNameW",               kernel32_GetNamedPipeClientComputerNameW},
{ 8,  544, "GetNamedPipeClientProcessId",                   kernel32_GetNamedPipeClientProcessId},
{ 8,  545, "GetNamedPipeClientSessionId",                   kernel32_GetNamedPipeClientSessionId},
{28,  546, "GetNamedPipeHandleStateA",                      kernel32_GetNamedPipeHandleStateA},
{28,  547, "GetNamedPipeHandleStateW",                      kernel32_GetNamedPipeHandleStateW},
{20,  548, "GetNamedPipeInfo",                              kernel32_GetNamedPipeInfo},
{ 8,  549, "GetNamedPipeServerProcessId",                   kernel32_GetNamedPipeServerProcessId},
{ 8,  550, "GetNamedPipeServerSessionId",                   kernel32_GetNamedPipeServerSessionId},
{ 4,  551, "GetNativeSystemInfo",                           kernel32_GetNativeSystemInfo},
{ 0,  552, "GetNextVDMCommand",                             kernel32_GetNextVDMCommand},
{ 8,  553, "GetNumaAvailableMemoryNode",                    kernel32_GetNumaAvailableMemoryNode},
{ 0,  554, "GetNumaAvailableMemoryNodeEx",                  kernel32_GetNumaAvailableMemoryNodeEx},
{ 4,  555, "GetNumaHighestNodeNumber",                      kernel32_GetNumaHighestNodeNumber},
{ 0,  556, "GetNumaNodeNumberFromHandle",                   kernel32_GetNumaNodeNumberFromHandle},
{ 8,  557, "GetNumaNodeProcessorMask",                      kernel32_GetNumaNodeProcessorMask},
{ 0,  558, "GetNumaNodeProcessorMaskEx",                    kernel32_GetNumaNodeProcessorMaskEx},
{ 8,  559, "GetNumaProcessorNode",                          kernel32_GetNumaProcessorNode},
{ 0,  560, "GetNumaProcessorNodeEx",                        kernel32_GetNumaProcessorNodeEx},
{ 8,  561, "GetNumaProximityNode",                          kernel32_GetNumaProximityNode},
{ 0,  562, "GetNumaProximityNodeEx",                        kernel32_GetNumaProximityNodeEx},
{24,  563, "GetNumberFormatA",                              kernel32_GetNumberFormatA},
{24,  564, "GetNumberFormatEx",                             kernel32_GetNumberFormatEx},
{24,  565, "GetNumberFormatW",                              kernel32_GetNumberFormatW},
{ 0,  566, "GetNumberOfConsoleFonts",                       kernel32_GetNumberOfConsoleFonts},
{ 8,  567, "GetNumberOfConsoleInputEvents",                 kernel32_GetNumberOfConsoleInputEvents},
{ 4,  568, "GetNumberOfConsoleMouseButtons",                kernel32_GetNumberOfConsoleMouseButtons},
{ 0,  569, "GetOEMCP",                                      kernel32_GetOEMCP},
{16,  570, "GetOverlappedResult",                           kernel32_GetOverlappedResult},
{ 0,  571, "GetPhysicallyInstalledSystemMemory",            kernel32_GetPhysicallyInstalledSystemMemory},
{ 4,  572, "GetPriorityClass",                              kernel32_GetPriorityClass},
{16,  573, "GetPrivateProfileIntA",                         kernel32_GetPrivateProfileIntA},
{16,  574, "GetPrivateProfileIntW",                         kernel32_GetPrivateProfileIntW},
{16,  575, "GetPrivateProfileSectionA",                     kernel32_GetPrivateProfileSectionA},
{12,  576, "GetPrivateProfileSectionNamesA",                kernel32_GetPrivateProfileSectionNamesA},
{12,  577, "GetPrivateProfileSectionNamesW",                kernel32_GetPrivateProfileSectionNamesW},
{16,  578, "GetPrivateProfileSectionW",                     kernel32_GetPrivateProfileSectionW},
{24,  579, "GetPrivateProfileStringA",                      kernel32_GetPrivateProfileStringA},
{24,  580, "GetPrivateProfileStringW",                      kernel32_GetPrivateProfileStringW},
{20,  581, "GetPrivateProfileStructA",                      kernel32_GetPrivateProfileStructA},
{20,  582, "GetPrivateProfileStructW",                      kernel32_GetPrivateProfileStructW},
{ 8,  583, "GetProcAddress",                                kernel32_GetProcAddress},
{12,  584, "GetProcessAffinityMask",                        kernel32_GetProcessAffinityMask},
{ 0,  585, "GetProcessDEPPolicy",                           kernel32_GetProcessDEPPolicy},
{ 0,  586, "GetProcessGroupAffinity",                       kernel32_GetProcessGroupAffinity},
{ 8,  587, "GetProcessHandleCount",                         kernel32_GetProcessHandleCount},
{ 0,  588, "GetProcessHeap",                                kernel32_GetProcessHeap},
{ 8,  589, "GetProcessHeaps",                               kernel32_GetProcessHeaps},
{ 4,  590, "GetProcessId",                                  kernel32_GetProcessId},
{ 4,  591, "GetProcessIdOfThread",                          kernel32_GetProcessIdOfThread},
{ 8,  592, "GetProcessIoCounters",                          kernel32_GetProcessIoCounters},
{ 0,  593, "GetProcessPreferredUILanguages",                kernel32_GetProcessPreferredUILanguages},
{ 8,  594, "GetProcessPriorityBoost",                       kernel32_GetProcessPriorityBoost},
{ 8,  595, "GetProcessShutdownParameters",                  kernel32_GetProcessShutdownParameters},
{20,  596, "GetProcessTimes",                               kernel32_GetProcessTimes},
{ 4,  597, "GetProcessVersion",                             kernel32_GetProcessVersion},
{12,  598, "GetProcessWorkingSetSize",                      kernel32_GetProcessWorkingSetSize},
{16,  599, "GetProcessWorkingSetSizeEx",                    kernel32_GetProcessWorkingSetSizeEx},
{ 0,  600, "GetProcessorSystemCycleTime",                   kernel32_GetProcessorSystemCycleTime},
{20,  601, "GetProductInfo",                                kernel32_GetProductInfo},
{12,  602, "GetProfileIntA",                                kernel32_GetProfileIntA},
{12,  603, "GetProfileIntW",                                kernel32_GetProfileIntW},
{12,  604, "GetProfileSectionA",                            kernel32_GetProfileSectionA},
{12,  605, "GetProfileSectionW",                            kernel32_GetProfileSectionW},
{20,  606, "GetProfileStringA",                             kernel32_GetProfileStringA},
{20,  607, "GetProfileStringW",                             kernel32_GetProfileStringW},
{20,  608, "GetQueuedCompletionStatus",                     kernel32_GetQueuedCompletionStatus},
{24,  609, "GetQueuedCompletionStatusEx",                   kernel32_GetQueuedCompletionStatusEx},
{12,  610, "GetShortPathNameA",                             kernel32_GetShortPathNameA},
{12,  611, "GetShortPathNameW",                             kernel32_GetShortPathNameW},
{ 4,  612, "GetStartupInfoA",                               kernel32_GetStartupInfoA},
{ 4,  613, "GetStartupInfoW",                               kernel32_GetStartupInfoW},
{ 4,  614, "GetStdHandle",                                  kernel32_GetStdHandle},
{20,  615, "GetStringScripts",                              kernel32_GetStringScripts},
{20,  616, "GetStringTypeA",                                kernel32_GetStringTypeA},
{20,  617, "GetStringTypeExA",                              kernel32_GetStringTypeExA},
{20,  618, "GetStringTypeExW",                              kernel32_GetStringTypeExW},
{16,  619, "GetStringTypeW",                                kernel32_GetStringTypeW},
{ 0,  620, "GetSystemDEPPolicy",                            kernel32_GetSystemDEPPolicy},
{ 0,  621, "GetSystemDefaultLCID",                          kernel32_GetSystemDefaultLCID},
{ 0,  622, "GetSystemDefaultLangID",                        kernel32_GetSystemDefaultLangID},
{ 8,  623, "GetSystemDefaultLocaleName",                    kernel32_GetSystemDefaultLocaleName},
{ 0,  624, "GetSystemDefaultUILanguage",                    kernel32_GetSystemDefaultUILanguage},
{ 8,  625, "GetSystemDirectoryA",                           kernel32_GetSystemDirectoryA},
{ 8,  626, "GetSystemDirectoryW",                           kernel32_GetSystemDirectoryW},
{12,  627, "GetSystemFileCacheSize",                        kernel32_GetSystemFileCacheSize},
{16,  628, "GetSystemFirmwareTable",                        kernel32_GetSystemFirmwareTable},
{ 4,  629, "GetSystemInfo",                                 kernel32_GetSystemInfo},
{ 4,  630, "GetSystemPowerStatus",                          kernel32_GetSystemPowerStatus},
{16,  631, "GetSystemPreferredUILanguages",                 kernel32_GetSystemPreferredUILanguages},
{ 8,  632, "GetSystemRegistryQuota",                        kernel32_GetSystemRegistryQuota},
{ 4,  633, "GetSystemTime",                                 kernel32_GetSystemTime},
{12,  634, "GetSystemTimeAdjustment",                       kernel32_GetSystemTimeAdjustment},
{ 4,  635, "GetSystemTimeAsFileTime",                       kernel32_GetSystemTimeAsFileTime},
{12,  636, "GetSystemTimes",                                kernel32_GetSystemTimes},
{ 8,  637, "GetSystemWindowsDirectoryA",                    kernel32_GetSystemWindowsDirectoryA},
{ 8,  638, "GetSystemWindowsDirectoryW",                    kernel32_GetSystemWindowsDirectoryW},
{ 8,  639, "GetSystemWow64DirectoryA",                      kernel32_GetSystemWow64DirectoryA},
{ 8,  640, "GetSystemWow64DirectoryW",                      kernel32_GetSystemWow64DirectoryW},
{16,  641, "GetTapeParameters",                             kernel32_GetTapeParameters},
{20,  642, "GetTapePosition",                               kernel32_GetTapePosition},
{ 4,  643, "GetTapeStatus",                                 kernel32_GetTapeStatus},
{16,  644, "GetTempFileNameA",                              kernel32_GetTempFileNameA},
{16,  645, "GetTempFileNameW",                              kernel32_GetTempFileNameW},
{ 8,  646, "GetTempPathA",                                  kernel32_GetTempPathA},
{ 8,  647, "GetTempPathW",                                  kernel32_GetTempPathW},
{ 8,  648, "GetThreadContext",                              kernel32_GetThreadContext},
{ 0,  649, "GetThreadErrorMode",                            kernel32_GetThreadErrorMode},
{ 0,  650, "GetThreadGroupAffinity",                        kernel32_GetThreadGroupAffinity},
{ 8,  651, "GetThreadIOPendingFlag",                        kernel32_GetThreadIOPendingFlag},
{ 4,  652, "GetThreadId",                                   kernel32_GetThreadId},
{ 0,  653, "GetThreadIdealProcessorEx",                     kernel32_GetThreadIdealProcessorEx},
{ 0,  654, "GetThreadLocale",                               kernel32_GetThreadLocale},
{16,  655, "GetThreadPreferredUILanguages",                 kernel32_GetThreadPreferredUILanguages},
{ 4,  656, "GetThreadPriority",                             kernel32_GetThreadPriority},
{ 8,  657, "GetThreadPriorityBoost",                        kernel32_GetThreadPriorityBoost},
{12,  658, "GetThreadSelectorEntry",                        kernel32_GetThreadSelectorEntry},
{20,  659, "GetThreadTimes",                                kernel32_GetThreadTimes},
{ 0,  660, "GetThreadUILanguage",                           kernel32_GetThreadUILanguage},
{ 0,  662, "GetTickCount",                                  kernel32_GetTickCount},
{ 0,  661, "GetTickCount64",                                kernel32_GetTickCount64},
{24,  663, "GetTimeFormatA",                                kernel32_GetTimeFormatA},
{24,  664, "GetTimeFormatEx",                               kernel32_GetTimeFormatEx},
{24,  665, "GetTimeFormatW",                                kernel32_GetTimeFormatW},
{ 4,  666, "GetTimeZoneInformation",                        kernel32_GetTimeZoneInformation},
{ 0,  667, "GetTimeZoneInformationForYear",                 kernel32_GetTimeZoneInformationForYear},
{20,  668, "GetUILanguageInfo",                             kernel32_GetUILanguageInfo},
{ 0,  669, "GetUserDefaultLCID",                            kernel32_GetUserDefaultLCID},
{ 0,  670, "GetUserDefaultLangID",                          kernel32_GetUserDefaultLangID},
{ 8,  671, "GetUserDefaultLocaleName",                      kernel32_GetUserDefaultLocaleName},
{ 0,  672, "GetUserDefaultUILanguage",                      kernel32_GetUserDefaultUILanguage},
{ 4,  673, "GetUserGeoID",                                  kernel32_GetUserGeoID},
{16,  674, "GetUserPreferredUILanguages",                   kernel32_GetUserPreferredUILanguages},
{ 0,  675, "GetVDMCurrentDirectories",                      kernel32_GetVDMCurrentDirectories},
{ 0,  676, "GetVersion",                                    kernel32_GetVersion},
{ 4,  677, "GetVersionExA",                                 kernel32_GetVersionExA},
{ 4,  678, "GetVersionExW",                                 kernel32_GetVersionExW},
{32,  679, "GetVolumeInformationA",                         kernel32_GetVolumeInformationA},
{32,  680, "GetVolumeInformationByHandleW",                 kernel32_GetVolumeInformationByHandleW},
{32,  681, "GetVolumeInformationW",                         kernel32_GetVolumeInformationW},
{12,  682, "GetVolumeNameForVolumeMountPointA",             kernel32_GetVolumeNameForVolumeMountPointA},
{12,  683, "GetVolumeNameForVolumeMountPointW",             kernel32_GetVolumeNameForVolumeMountPointW},
{12,  684, "GetVolumePathNameA",                            kernel32_GetVolumePathNameA},
{12,  685, "GetVolumePathNameW",                            kernel32_GetVolumePathNameW},
{16,  686, "GetVolumePathNamesForVolumeNameA",              kernel32_GetVolumePathNamesForVolumeNameA},
{16,  687, "GetVolumePathNamesForVolumeNameW",              kernel32_GetVolumePathNamesForVolumeNameW},
{ 8,  688, "GetWindowsDirectoryA",                          kernel32_GetWindowsDirectoryA},
{ 8,  689, "GetWindowsDirectoryW",                          kernel32_GetWindowsDirectoryW},
{24,  690, "GetWriteWatch",                                 kernel32_GetWriteWatch},
{ 4,  691, "GlobalAddAtomA",                                kernel32_GlobalAddAtomA},
{ 4,  692, "GlobalAddAtomW",                                kernel32_GlobalAddAtomW},
{ 8,  693, "GlobalAlloc",                                   kernel32_GlobalAlloc},
{ 4,  694, "GlobalCompact",                                 kernel32_GlobalCompact},
{ 4,  695, "GlobalDeleteAtom",                              kernel32_GlobalDeleteAtom},
{ 4,  696, "GlobalFindAtomA",                               kernel32_GlobalFindAtomA},
{ 4,  697, "GlobalFindAtomW",                               kernel32_GlobalFindAtomW},
{ 4,  698, "GlobalFix",                                     kernel32_GlobalFix},
{ 4,  699, "GlobalFlags",                                   kernel32_GlobalFlags},
{ 4,  700, "GlobalFree",                                    kernel32_GlobalFree},
{12,  701, "GlobalGetAtomNameA",                            kernel32_GlobalGetAtomNameA},
{12,  702, "GlobalGetAtomNameW",                            kernel32_GlobalGetAtomNameW},
{ 4,  703, "GlobalHandle",                                  kernel32_GlobalHandle},
{ 4,  704, "GlobalLock",                                    kernel32_GlobalLock},
{ 4,  705, "GlobalMemoryStatus",                            kernel32_GlobalMemoryStatus},
{ 4,  706, "GlobalMemoryStatusEx",                          kernel32_GlobalMemoryStatusEx},
{12,  707, "GlobalReAlloc",                                 kernel32_GlobalReAlloc},
{ 4,  708, "GlobalSize",                                    kernel32_GlobalSize},
{ 4,  709, "GlobalUnWire",                                  kernel32_GlobalUnWire},
{ 4,  710, "GlobalUnfix",                                   kernel32_GlobalUnfix},
{ 4,  711, "GlobalUnlock",                                  kernel32_GlobalUnlock},
{ 4,  712, "GlobalWire",                                    kernel32_GlobalWire},
{12,  713, "Heap32First",                                   kernel32_Heap32First},
{ 8,  714, "Heap32ListFirst",                               kernel32_Heap32ListFirst},
{ 8,  715, "Heap32ListNext",                                kernel32_Heap32ListNext},
{ 4,  716, "Heap32Next",                                    kernel32_Heap32Next},
{12,  717, "HeapAlloc",                                     kernel32_HeapAlloc},
{ 8,  718, "HeapCompact",                                   kernel32_HeapCompact},
{12,  719, "HeapCreate",                                    kernel32_HeapCreate},
{ 4,  720, "HeapDestroy",                                   kernel32_HeapDestroy},
{12,  721, "HeapFree",                                      kernel32_HeapFree},
{ 4,  722, "HeapLock",                                      kernel32_HeapLock},
{20,  723, "HeapQueryInformation",                          kernel32_HeapQueryInformation},
{16,  724, "HeapReAlloc",                                   kernel32_HeapReAlloc},
{16,  725, "HeapSetInformation",                            kernel32_HeapSetInformation},
{12,  726, "HeapSize",                                      kernel32_HeapSize},
{ 0,  727, "HeapSummary",                                   kernel32_HeapSummary},
{ 4,  728, "HeapUnlock",                                    kernel32_HeapUnlock},
{12,  729, "HeapValidate",                                  kernel32_HeapValidate},
{ 8,  730, "HeapWalk",                                      kernel32_HeapWalk},
{ 0,  731, "IdnToAscii",                                    kernel32_IdnToAscii},
{ 0,  732, "IdnToNameprepUnicode",                          kernel32_IdnToNameprepUnicode},
{ 0,  733, "IdnToUnicode",                                  kernel32_IdnToUnicode},
{ 4,  734, "InitAtomTable",                                 kernel32_InitAtomTable},
{16,  735, "InitOnceBeginInitialize",                       kernel32_InitOnceBeginInitialize},
{12,  736, "InitOnceComplete",                              kernel32_InitOnceComplete},
{16,  737, "InitOnceExecuteOnce",                           kernel32_InitOnceExecuteOnce},
{ 4,  738, "InitOnceInitialize",                            kernel32_InitOnceInitialize},
{ 4,  739, "InitializeConditionVariable",                   kernel32_InitializeConditionVariable},
{ 4,  740, "InitializeCriticalSection",                     kernel32_InitializeCriticalSection},
{ 8,  741, "InitializeCriticalSectionAndSpinCount",         kernel32_InitializeCriticalSectionAndSpinCount},
{12,  742, "InitializeCriticalSectionEx",                   kernel32_InitializeCriticalSectionEx},
{ 0,  743, "InitializeExtendedContext",                     kernel32_InitializeExtendedContext},
{16,  744, "InitializeProcThreadAttributeList",             kernel32_InitializeProcThreadAttributeList},
{ 4,  745, "InitializeSListHead",                           kernel32_InitializeSListHead},
{ 4,  746, "InitializeSRWLock",                             kernel32_InitializeSRWLock},
{12,  748, "InterlockedCompareExchange",                    kernel32_InterlockedCompareExchange},
{20,  747, "InterlockedCompareExchange64",                  kernel32_InterlockedCompareExchange64},
{ 4,  749, "InterlockedDecrement",                          kernel32_InterlockedDecrement},
{ 8,  750, "InterlockedExchange",                           kernel32_InterlockedExchange},
{ 8,  751, "InterlockedExchangeAdd",                        kernel32_InterlockedExchangeAdd},
{ 4,  752, "InterlockedFlushSList",                         kernel32_InterlockedFlushSList},
{ 4,  753, "InterlockedIncrement",                          kernel32_InterlockedIncrement},
{ 4,  754, "InterlockedPopEntrySList",                      kernel32_InterlockedPopEntrySList},
{ 8,  755, "InterlockedPushEntrySList",                     kernel32_InterlockedPushEntrySList},
{ 0,    2, "InterlockedPushListSList",                      kernel32_InterlockedPushListSList},
{ 0,  756, "InvalidateConsoleDIBits",                       kernel32_InvalidateConsoleDIBits},
{ 4,  757, "IsBadCodePtr",                                  kernel32_IsBadCodePtr},
{ 8,  758, "IsBadHugeReadPtr",                              kernel32_IsBadHugeReadPtr},
{ 8,  759, "IsBadHugeWritePtr",                             kernel32_IsBadHugeWritePtr},
{ 8,  760, "IsBadReadPtr",                                  kernel32_IsBadReadPtr},
{ 8,  761, "IsBadStringPtrA",                               kernel32_IsBadStringPtrA},
{ 8,  762, "IsBadStringPtrW",                               kernel32_IsBadStringPtrW},
{ 8,  763, "IsBadWritePtr",                                 kernel32_IsBadWritePtr},
{ 0,  764, "IsCalendarLeapDay",                             kernel32_IsCalendarLeapDay},
{ 0,  765, "IsCalendarLeapMonth",                           kernel32_IsCalendarLeapMonth},
{ 0,  766, "IsCalendarLeapYear",                            kernel32_IsCalendarLeapYear},
{ 4,  767, "IsDBCSLeadByte",                                kernel32_IsDBCSLeadByte},
{ 8,  768, "IsDBCSLeadByteEx",                              kernel32_IsDBCSLeadByteEx},
{ 0,  769, "IsDebuggerPresent",                             kernel32_IsDebuggerPresent},
{20,  770, "IsNLSDefinedString",                            kernel32_IsNLSDefinedString},
{ 0,  771, "IsNormalizedString",                            kernel32_IsNormalizedString},
{12,  772, "IsProcessInJob",                                kernel32_IsProcessInJob},
{ 4,  773, "IsProcessorFeaturePresent",                     kernel32_IsProcessorFeaturePresent},
{ 0,  774, "IsSystemResumeAutomatic",                       kernel32_IsSystemResumeAutomatic},
{ 0,  775, "IsThreadAFiber",                                kernel32_IsThreadAFiber},
{ 4,  776, "IsThreadpoolTimerSet",                          kernel32_IsThreadpoolTimerSet},
{ 0,  777, "IsTimeZoneRedirectionEnabled",                  kernel32_IsTimeZoneRedirectionEnabled},
{ 0,  778, "IsValidCalDateTime",                            kernel32_IsValidCalDateTime},
{ 4,  779, "IsValidCodePage",                               kernel32_IsValidCodePage},
{ 8,  780, "IsValidLanguageGroup",                          kernel32_IsValidLanguageGroup},
{ 8,  781, "IsValidLocale",                                 kernel32_IsValidLocale},
{ 4,  782, "IsValidLocaleName",                             kernel32_IsValidLocaleName},
{ 8,  783, "IsWow64Process",                                kernel32_IsWow64Process},
{ 0,  784, "K32EmptyWorkingSet",                            kernel32_K32EmptyWorkingSet},
{ 0,  785, "K32EnumDeviceDrivers",                          kernel32_K32EnumDeviceDrivers},
{ 0,  786, "K32EnumPageFilesA",                             kernel32_K32EnumPageFilesA},
{ 0,  787, "K32EnumPageFilesW",                             kernel32_K32EnumPageFilesW},
{ 0,  788, "K32EnumProcessModules",                         kernel32_K32EnumProcessModules},
{ 0,  789, "K32EnumProcessModulesEx",                       kernel32_K32EnumProcessModulesEx},
{ 0,  790, "K32EnumProcesses",                              kernel32_K32EnumProcesses},
{ 0,  791, "K32GetDeviceDriverBaseNameA",                   kernel32_K32GetDeviceDriverBaseNameA},
{ 0,  792, "K32GetDeviceDriverBaseNameW",                   kernel32_K32GetDeviceDriverBaseNameW},
{ 0,  793, "K32GetDeviceDriverFileNameA",                   kernel32_K32GetDeviceDriverFileNameA},
{ 0,  794, "K32GetDeviceDriverFileNameW",                   kernel32_K32GetDeviceDriverFileNameW},
{ 0,  795, "K32GetMappedFileNameA",                         kernel32_K32GetMappedFileNameA},
{ 0,  796, "K32GetMappedFileNameW",                         kernel32_K32GetMappedFileNameW},
{ 0,  797, "K32GetModuleBaseNameA",                         kernel32_K32GetModuleBaseNameA},
{ 0,  798, "K32GetModuleBaseNameW",                         kernel32_K32GetModuleBaseNameW},
{ 0,  799, "K32GetModuleFileNameExA",                       kernel32_K32GetModuleFileNameExA},
{ 0,  800, "K32GetModuleFileNameExW",                       kernel32_K32GetModuleFileNameExW},
{ 0,  801, "K32GetModuleInformation",                       kernel32_K32GetModuleInformation},
{ 0,  802, "K32GetPerformanceInfo",                         kernel32_K32GetPerformanceInfo},
{ 0,  803, "K32GetProcessImageFileNameA",                   kernel32_K32GetProcessImageFileNameA},
{ 0,  804, "K32GetProcessImageFileNameW",                   kernel32_K32GetProcessImageFileNameW},
{ 0,  805, "K32GetProcessMemoryInfo",                       kernel32_K32GetProcessMemoryInfo},
{ 0,  806, "K32GetWsChanges",                               kernel32_K32GetWsChanges},
{ 0,  807, "K32GetWsChangesEx",                             kernel32_K32GetWsChangesEx},
{ 0,  808, "K32InitializeProcessForWsWatch",                kernel32_K32InitializeProcessForWsWatch},
{ 0,  809, "K32QueryWorkingSet",                            kernel32_K32QueryWorkingSet},
{ 0,  810, "K32QueryWorkingSetEx",                          kernel32_K32QueryWorkingSetEx},
{16,  811, "LCIDToLocaleName",                              kernel32_LCIDToLocaleName},
{24,  812, "LCMapStringA",                                  kernel32_LCMapStringA},
{36,  813, "LCMapStringEx",                                 kernel32_LCMapStringEx},
{24,  814, "LCMapStringW",                                  kernel32_LCMapStringW},
{ 0,  815, "LZClose",                                       kernel32_LZClose},
{ 0,  816, "LZCloseFile",                                   kernel32_LZCloseFile},
{ 0,  817, "LZCopy",                                        kernel32_LZCopy},
{ 0,  818, "LZCreateFileW",                                 kernel32_LZCreateFileW},
{ 0,  819, "LZDone",                                        kernel32_LZDone},
{ 0,  820, "LZInit",                                        kernel32_LZInit},
{ 0,  821, "LZOpenFileA",                                   kernel32_LZOpenFileA},
{ 0,  822, "LZOpenFileW",                                   kernel32_LZOpenFileW},
{ 0,  823, "LZRead",                                        kernel32_LZRead},
{ 0,  824, "LZSeek",                                        kernel32_LZSeek},
{ 0,  825, "LZStart",                                       kernel32_LZStart},
{ 4,  826, "LeaveCriticalSection",                          kernel32_LeaveCriticalSection},
{ 8,  827, "LeaveCriticalSectionWhenCallbackReturns",       kernel32_LeaveCriticalSectionWhenCallbackReturns},
{ 0,  828, "LoadAppInitDlls",                               kernel32_LoadAppInitDlls},
{ 4,  829, "LoadLibraryA",                                  kernel32_LoadLibraryA},
{12,  830, "LoadLibraryExA",                                kernel32_LoadLibraryExA},
{12,  831, "LoadLibraryExW",                                kernel32_LoadLibraryExW},
{ 4,  832, "LoadLibraryW",                                  kernel32_LoadLibraryW},
{ 8,  833, "LoadModule",                                    kernel32_LoadModule},
{ 8,  834, "LoadResource",                                  kernel32_LoadResource},
{20,  835, "LoadStringBaseExW",                             kernel32_LoadStringBaseExW},
{16,  836, "LoadStringBaseW",                               kernel32_LoadStringBaseW},
{ 8,  837, "LocalAlloc",                                    kernel32_LocalAlloc},
{ 4,  838, "LocalCompact",                                  kernel32_LocalCompact},
{ 8,  839, "LocalFileTimeToFileTime",                       kernel32_LocalFileTimeToFileTime},
{ 4,  840, "LocalFlags",                                    kernel32_LocalFlags},
{ 4,  841, "LocalFree",                                     kernel32_LocalFree},
{ 4,  842, "LocalHandle",                                   kernel32_LocalHandle},
{ 4,  843, "LocalLock",                                     kernel32_LocalLock},
{12,  844, "LocalReAlloc",                                  kernel32_LocalReAlloc},
{ 8,  845, "LocalShrink",                                   kernel32_LocalShrink},
{ 4,  846, "LocalSize",                                     kernel32_LocalSize},
{ 4,  847, "LocalUnlock",                                   kernel32_LocalUnlock},
{ 8,  848, "LocaleNameToLCID",                              kernel32_LocaleNameToLCID},
{ 0,  849, "LocateExtendedFeature",                         kernel32_LocateExtendedFeature},
{ 0,  850, "LocateLegacyContext",                           kernel32_LocateLegacyContext},
{20,  851, "LockFile",                                      kernel32_LockFile},
{24,  852, "LockFileEx",                                    kernel32_LockFileEx},
{ 4,  853, "LockResource",                                  kernel32_LockResource},
{12,  854, "MapUserPhysicalPages",                          kernel32_MapUserPhysicalPages},
{12,  855, "MapUserPhysicalPagesScatter",                   kernel32_MapUserPhysicalPagesScatter},
{20,  856, "MapViewOfFile",                                 kernel32_MapViewOfFile},
{24,  857, "MapViewOfFileEx",                               kernel32_MapViewOfFileEx},
{28,  858, "MapViewOfFileExNuma",                           kernel32_MapViewOfFileExNuma},
{ 8,  859, "Module32First",                                 kernel32_Module32First},
{ 8,  860, "Module32FirstW",                                kernel32_Module32FirstW},
{ 8,  861, "Module32Next",                                  kernel32_Module32Next},
{ 8,  862, "Module32NextW",                                 kernel32_Module32NextW},
{ 8,  863, "MoveFileA",                                     kernel32_MoveFileA},
{12,  864, "MoveFileExA",                                   kernel32_MoveFileExA},
{12,  865, "MoveFileExW",                                   kernel32_MoveFileExW},
{24,  866, "MoveFileTransactedA",                           kernel32_MoveFileTransactedA},
{24,  867, "MoveFileTransactedW",                           kernel32_MoveFileTransactedW},
{ 8,  868, "MoveFileW",                                     kernel32_MoveFileW},
{20,  869, "MoveFileWithProgressA",                         kernel32_MoveFileWithProgressA},
{20,  870, "MoveFileWithProgressW",                         kernel32_MoveFileWithProgressW},
{12,  871, "MulDiv",                                        kernel32_MulDiv},
{24,  872, "MultiByteToWideChar",                           kernel32_MultiByteToWideChar},
{ 4,  873, "NeedCurrentDirectoryForExePathA",               kernel32_NeedCurrentDirectoryForExePathA},
{ 4,  874, "NeedCurrentDirectoryForExePathW",               kernel32_NeedCurrentDirectoryForExePathW},
{ 0,  875, "NlsCheckPolicy",                                kernel32_NlsCheckPolicy},
{ 0,  876, "NlsEventDataDescCreate",                        kernel32_NlsEventDataDescCreate},
{ 0,  877, "NlsGetCacheUpdateCount",                        kernel32_NlsGetCacheUpdateCount},
{ 0,  878, "NlsUpdateLocale",                               kernel32_NlsUpdateLocale},
{ 0,  879, "NlsUpdateSystemLocale",                         kernel32_NlsUpdateSystemLocale},
{ 0,  880, "NlsWriteEtwEvent",                              kernel32_NlsWriteEtwEvent},
{ 0,  881, "NormalizeString",                               kernel32_NormalizeString},
{ 0,  882, "NotifyMountMgr",                                kernel32_NotifyMountMgr},
{20,  883, "NotifyUILanguageChange",                        kernel32_NotifyUILanguageChange},
{ 0,  884, "OpenConsoleW",                                  kernel32_OpenConsoleW},
{12,  885, "OpenEventA",                                    kernel32_OpenEventA},
{12,  886, "OpenEventW",                                    kernel32_OpenEventW},
{12,  887, "OpenFile",                                      kernel32_OpenFile},
{24,  888, "OpenFileById",                                  kernel32_OpenFileById},
{12,  889, "OpenFileMappingA",                              kernel32_OpenFileMappingA},
{12,  890, "OpenFileMappingW",                              kernel32_OpenFileMappingW},
{12,  891, "OpenJobObjectA",                                kernel32_OpenJobObjectA},
{12,  892, "OpenJobObjectW",                                kernel32_OpenJobObjectW},
{12,  893, "OpenMutexA",                                    kernel32_OpenMutexA},
{12,  894, "OpenMutexW",                                    kernel32_OpenMutexW},
{ 8,  895, "OpenPrivateNamespaceA",                         kernel32_OpenPrivateNamespaceA},
{ 8,  896, "OpenPrivateNamespaceW",                         kernel32_OpenPrivateNamespaceW},
{12,  897, "OpenProcess",                                   kernel32_OpenProcess},
{ 0,  898, "OpenProcessToken",                              kernel32_OpenProcessToken},
{ 0,  899, "OpenProfileUserMapping",                        kernel32_OpenProfileUserMapping},
{12,  900, "OpenSemaphoreA",                                kernel32_OpenSemaphoreA},
{12,  901, "OpenSemaphoreW",                                kernel32_OpenSemaphoreW},
{12,  902, "OpenThread",                                    kernel32_OpenThread},
{ 0,  903, "OpenThreadToken",                               kernel32_OpenThreadToken},
{12,  904, "OpenWaitableTimerA",                            kernel32_OpenWaitableTimerA},
{12,  905, "OpenWaitableTimerW",                            kernel32_OpenWaitableTimerW},
{ 4,  906, "OutputDebugStringA",                            kernel32_OutputDebugStringA},
{ 4,  907, "OutputDebugStringW",                            kernel32_OutputDebugStringW},
{16,  908, "PeekConsoleInputA",                             kernel32_PeekConsoleInputA},
{16,  909, "PeekConsoleInputW",                             kernel32_PeekConsoleInputW},
{24,  910, "PeekNamedPipe",                                 kernel32_PeekNamedPipe},
{16,  911, "PostQueuedCompletionStatus",                    kernel32_PostQueuedCompletionStatus},
{ 0,  912, "PowerClearRequest",                             kernel32_PowerClearRequest},
{ 0,  913, "PowerCreateRequest",                            kernel32_PowerCreateRequest},
{ 0,  914, "PowerSetRequest",                               kernel32_PowerSetRequest},
{12,  915, "PrepareTape",                                   kernel32_PrepareTape},
{ 0,  916, "PrivCopyFileExW",                               kernel32_PrivCopyFileExW},
{ 0,  917, "PrivMoveFileIdentityW",                         kernel32_PrivMoveFileIdentityW},
{ 8,  918, "Process32First",                                kernel32_Process32First},
{ 8,  919, "Process32FirstW",                               kernel32_Process32FirstW},
{ 8,  920, "Process32Next",                                 kernel32_Process32Next},
{ 8,  921, "Process32NextW",                                kernel32_Process32NextW},
{ 8,  922, "ProcessIdToSessionId",                          kernel32_ProcessIdToSessionId},
{ 4,  923, "PulseEvent",                                    kernel32_PulseEvent},
{ 8,  924, "PurgeComm",                                     kernel32_PurgeComm},
{28,  925, "QueryActCtxSettingsW",                          kernel32_QueryActCtxSettingsW},
{28,  926, "QueryActCtxW",                                  kernel32_QueryActCtxW},
{ 4,  927, "QueryDepthSList",                               kernel32_QueryDepthSList},
{12,  928, "QueryDosDeviceA",                               kernel32_QueryDosDeviceA},
{12,  929, "QueryDosDeviceW",                               kernel32_QueryDosDeviceW},
{16,  930, "QueryFullProcessImageNameA",                    kernel32_QueryFullProcessImageNameA},
{16,  931, "QueryFullProcessImageNameW",                    kernel32_QueryFullProcessImageNameW},
{ 8,  932, "QueryIdleProcessorCycleTime",                   kernel32_QueryIdleProcessorCycleTime},
{ 0,  933, "QueryIdleProcessorCycleTimeEx",                 kernel32_QueryIdleProcessorCycleTimeEx},
{20,  934, "QueryInformationJobObject",                     kernel32_QueryInformationJobObject},
{ 8,  935, "QueryMemoryResourceNotification",               kernel32_QueryMemoryResourceNotification},
{ 4,  936, "QueryPerformanceCounter",                       kernel32_QueryPerformanceCounter},
{ 4,  937, "QueryPerformanceFrequency",                     kernel32_QueryPerformanceFrequency},
{ 0,  938, "QueryProcessAffinityUpdateMode",                kernel32_QueryProcessAffinityUpdateMode},
{ 8,  939, "QueryProcessCycleTime",                         kernel32_QueryProcessCycleTime},
{ 8,  940, "QueryThreadCycleTime",                          kernel32_QueryThreadCycleTime},
{ 0,  941, "QueryThreadProfiling",                          kernel32_QueryThreadProfiling},
{ 0,  942, "QueryThreadpoolStackInformation",               kernel32_QueryThreadpoolStackInformation},
{ 0,  943, "QueryUnbiasedInterruptTime",                    kernel32_QueryUnbiasedInterruptTime},
{12,  944, "QueueUserAPC",                                  kernel32_QueueUserAPC},
{12,  945, "QueueUserWorkItem",                             kernel32_QueueUserWorkItem},
{16,  946, "RaiseException",                                kernel32_RaiseException},
{ 0,  947, "RaiseFailFastException",                        kernel32_RaiseFailFastException},
{16,  948, "ReOpenFile",                                    kernel32_ReOpenFile},
{20,  949, "ReadConsoleA",                                  kernel32_ReadConsoleA},
{16,  950, "ReadConsoleInputA",                             kernel32_ReadConsoleInputA},
{ 0,  951, "ReadConsoleInputExA",                           kernel32_ReadConsoleInputExA},
{ 0,  952, "ReadConsoleInputExW",                           kernel32_ReadConsoleInputExW},
{16,  953, "ReadConsoleInputW",                             kernel32_ReadConsoleInputW},
{20,  954, "ReadConsoleOutputA",                            kernel32_ReadConsoleOutputA},
{20,  955, "ReadConsoleOutputAttribute",                    kernel32_ReadConsoleOutputAttribute},
{20,  956, "ReadConsoleOutputCharacterA",                   kernel32_ReadConsoleOutputCharacterA},
{20,  957, "ReadConsoleOutputCharacterW",                   kernel32_ReadConsoleOutputCharacterW},
{20,  958, "ReadConsoleOutputW",                            kernel32_ReadConsoleOutputW},
{20,  959, "ReadConsoleW",                                  kernel32_ReadConsoleW},
{32,  960, "ReadDirectoryChangesW",                         kernel32_ReadDirectoryChangesW},
{20,  961, "ReadFile",                                      kernel32_ReadFile},
{20,  962, "ReadFileEx",                                    kernel32_ReadFileEx},
{20,  963, "ReadFileScatter",                               kernel32_ReadFileScatter},
{20,  964, "ReadProcessMemory",                             kernel32_ReadProcessMemory},
{ 0,  965, "ReadThreadProfilingData",                       kernel32_ReadThreadProfilingData},
{ 0,  966, "RegCloseKey",                                   kernel32_RegCloseKey},
{ 0,  967, "RegCreateKeyExA",                               kernel32_RegCreateKeyExA},
{ 0,  968, "RegCreateKeyExW",                               kernel32_RegCreateKeyExW},
{ 0,  969, "RegDeleteKeyExA",                               kernel32_RegDeleteKeyExA},
{ 0,  970, "RegDeleteKeyExW",                               kernel32_RegDeleteKeyExW},
{ 0,  971, "RegDeleteTreeA",                                kernel32_RegDeleteTreeA},
{ 0,  972, "RegDeleteTreeW",                                kernel32_RegDeleteTreeW},
{ 0,  973, "RegDeleteValueA",                               kernel32_RegDeleteValueA},
{ 0,  974, "RegDeleteValueW",                               kernel32_RegDeleteValueW},
{ 0,  975, "RegDisablePredefinedCacheEx",                   kernel32_RegDisablePredefinedCacheEx},
{ 0,  976, "RegEnumKeyExA",                                 kernel32_RegEnumKeyExA},
{ 0,  977, "RegEnumKeyExW",                                 kernel32_RegEnumKeyExW},
{ 0,  978, "RegEnumValueA",                                 kernel32_RegEnumValueA},
{ 0,  979, "RegEnumValueW",                                 kernel32_RegEnumValueW},
{ 0,  980, "RegFlushKey",                                   kernel32_RegFlushKey},
{ 0,  981, "RegGetKeySecurity",                             kernel32_RegGetKeySecurity},
{ 0,  982, "RegGetValueA",                                  kernel32_RegGetValueA},
{ 0,  983, "RegGetValueW",                                  kernel32_RegGetValueW},
{ 0,  984, "RegKrnGetGlobalState",                          kernel32_RegKrnGetGlobalState},
{ 0,  985, "RegKrnInitialize",                              kernel32_RegKrnInitialize},
{ 0,  986, "RegLoadKeyA",                                   kernel32_RegLoadKeyA},
{ 0,  987, "RegLoadKeyW",                                   kernel32_RegLoadKeyW},
{ 0,  988, "RegLoadMUIStringA",                             kernel32_RegLoadMUIStringA},
{ 0,  989, "RegLoadMUIStringW",                             kernel32_RegLoadMUIStringW},
{ 0,  990, "RegNotifyChangeKeyValue",                       kernel32_RegNotifyChangeKeyValue},
{ 0,  991, "RegOpenCurrentUser",                            kernel32_RegOpenCurrentUser},
{ 0,  992, "RegOpenKeyExA",                                 kernel32_RegOpenKeyExA},
{ 0,  993, "RegOpenKeyExW",                                 kernel32_RegOpenKeyExW},
{ 0,  994, "RegOpenUserClassesRoot",                        kernel32_RegOpenUserClassesRoot},
{ 0,  995, "RegQueryInfoKeyA",                              kernel32_RegQueryInfoKeyA},
{ 0,  996, "RegQueryInfoKeyW",                              kernel32_RegQueryInfoKeyW},
{ 0,  997, "RegQueryValueExA",                              kernel32_RegQueryValueExA},
{ 0,  998, "RegQueryValueExW",                              kernel32_RegQueryValueExW},
{ 0,  999, "RegRestoreKeyA",                                kernel32_RegRestoreKeyA},
{ 0, 1000, "RegRestoreKeyW",                                kernel32_RegRestoreKeyW},
{ 0, 1001, "RegSaveKeyExA",                                 kernel32_RegSaveKeyExA},
{ 0, 1002, "RegSaveKeyExW",                                 kernel32_RegSaveKeyExW},
{ 0, 1003, "RegSetKeySecurity",                             kernel32_RegSetKeySecurity},
{ 0, 1004, "RegSetValueExA",                                kernel32_RegSetValueExA},
{ 0, 1005, "RegSetValueExW",                                kernel32_RegSetValueExW},
{ 0, 1006, "RegUnLoadKeyA",                                 kernel32_RegUnLoadKeyA},
{ 0, 1007, "RegUnLoadKeyW",                                 kernel32_RegUnLoadKeyW},
{16, 1008, "RegisterApplicationRecoveryCallback",           kernel32_RegisterApplicationRecoveryCallback},
{ 8, 1009, "RegisterApplicationRestart",                    kernel32_RegisterApplicationRestart},
{ 0, 1010, "RegisterConsoleIME",                            kernel32_RegisterConsoleIME},
{ 0, 1011, "RegisterConsoleOS2",                            kernel32_RegisterConsoleOS2},
{ 0, 1012, "RegisterConsoleVDM",                            kernel32_RegisterConsoleVDM},
{ 0, 1013, "RegisterWaitForInputIdle",                      kernel32_RegisterWaitForInputIdle},
{24, 1014, "RegisterWaitForSingleObject",                   kernel32_RegisterWaitForSingleObject},
{20, 1015, "RegisterWaitForSingleObjectEx",                 kernel32_RegisterWaitForSingleObjectEx},
{ 0, 1016, "RegisterWowBaseHandlers",                       kernel32_RegisterWowBaseHandlers},
{ 0, 1017, "RegisterWowExec",                               kernel32_RegisterWowExec},
{ 4, 1018, "ReleaseActCtx",                                 kernel32_ReleaseActCtx},
{ 4, 1019, "ReleaseMutex",                                  kernel32_ReleaseMutex},
{ 8, 1020, "ReleaseMutexWhenCallbackReturns",               kernel32_ReleaseMutexWhenCallbackReturns},
{ 4, 1021, "ReleaseSRWLockExclusive",                       kernel32_ReleaseSRWLockExclusive},
{ 4, 1022, "ReleaseSRWLockShared",                          kernel32_ReleaseSRWLockShared},
{12, 1023, "ReleaseSemaphore",                              kernel32_ReleaseSemaphore},
{12, 1024, "ReleaseSemaphoreWhenCallbackReturns",           kernel32_ReleaseSemaphoreWhenCallbackReturns},
{ 4, 1025, "RemoveDirectoryA",                              kernel32_RemoveDirectoryA},
{ 8, 1026, "RemoveDirectoryTransactedA",                    kernel32_RemoveDirectoryTransactedA},
{ 8, 1027, "RemoveDirectoryTransactedW",                    kernel32_RemoveDirectoryTransactedW},
{ 4, 1028, "RemoveDirectoryW",                              kernel32_RemoveDirectoryW},
{ 8, 1029, "RemoveLocalAlternateComputerNameA",             kernel32_RemoveLocalAlternateComputerNameA},
{ 8, 1030, "RemoveLocalAlternateComputerNameW",             kernel32_RemoveLocalAlternateComputerNameW},
{ 0, 1031, "RemoveSecureMemoryCacheCallback",               kernel32_RemoveSecureMemoryCacheCallback},
{ 4, 1032, "RemoveVectoredContinueHandler",                 kernel32_RemoveVectoredContinueHandler},
{ 4, 1033, "RemoveVectoredExceptionHandler",                kernel32_RemoveVectoredExceptionHandler},
{24, 1034, "ReplaceFile",                                   kernel32_ReplaceFileA},
{24, 1035, "ReplaceFileA",                                  kernel32_ReplaceFileA},
{24, 1036, "ReplaceFileW",                                  kernel32_ReplaceFileW},
{ 0, 1037, "ReplacePartitionUnit",                          kernel32_ReplacePartitionUnit},
{ 4, 1038, "RequestDeviceWakeup",                           kernel32_RequestDeviceWakeup},
{ 4, 1039, "RequestWakeupLatency",                          kernel32_RequestWakeupLatency},
{ 4, 1040, "ResetEvent",                                    kernel32_ResetEvent},
{ 8, 1041, "ResetWriteWatch",                               kernel32_ResetWriteWatch},
{ 0, 1042, "ResolveLocaleName",                             kernel32_ResolveLocaleName},
{ 4, 1043, "RestoreLastError",                              kernel32_RestoreLastError},
{ 4, 1044, "ResumeThread",                                  kernel32_ResumeThread},
{ 4, 1045, "RtlCaptureContext",                             kernel32_RtlCaptureContext},
{16, 1046, "RtlCaptureStackBackTrace",                      kernel32_RtlCaptureStackBackTrace},
{12, 1047, "RtlFillMemory",                                 kernel32_RtlFillMemory},
{12, 1048, "RtlMoveMemory",                                 kernel32_RtlMoveMemory},
{16, 1049, "RtlUnwind",                                     kernel32_RtlUnwind},
{ 8, 1050, "RtlZeroMemory",                                 kernel32_RtlZeroMemory},
{20, 1051, "ScrollConsoleScreenBufferA",                    kernel32_ScrollConsoleScreenBufferA},
{20, 1052, "ScrollConsoleScreenBufferW",                    kernel32_ScrollConsoleScreenBufferW},
{24, 1053, "SearchPathA",                                   kernel32_SearchPathA},
{24, 1054, "SearchPathW",                                   kernel32_SearchPathW},
{16, 1055, "SetCalendarInfoA",                              kernel32_SetCalendarInfoA},
{16, 1056, "SetCalendarInfoW",                              kernel32_SetCalendarInfoW},
{ 0, 1057, "SetClientTimeZoneInformation",                  kernel32_SetClientTimeZoneInformation},
{ 0, 1058, "SetComPlusPackageInstallStatus",                kernel32_SetComPlusPackageInstallStatus},
{ 4, 1059, "SetCommBreak",                                  kernel32_SetCommBreak},
{12, 1060, "SetCommConfig",                                 kernel32_SetCommConfig},
{ 8, 1061, "SetCommMask",                                   kernel32_SetCommMask},
{ 8, 1062, "SetCommState",                                  kernel32_SetCommState},
{ 8, 1063, "SetCommTimeouts",                               kernel32_SetCommTimeouts},
{ 4, 1064, "SetComputerNameA",                              kernel32_SetComputerNameA},
{ 8, 1065, "SetComputerNameExA",                            kernel32_SetComputerNameExA},
{ 8, 1066, "SetComputerNameExW",                            kernel32_SetComputerNameExW},
{ 4, 1067, "SetComputerNameW",                              kernel32_SetComputerNameW},
{ 4, 1068, "SetConsoleActiveScreenBuffer",                  kernel32_SetConsoleActiveScreenBuffer},
{ 4, 1069, "SetConsoleCP",                                  kernel32_SetConsoleCP},
{ 8, 1070, "SetConsoleCtrlHandler",                         kernel32_SetConsoleCtrlHandler},
{ 8, 1071, "SetConsoleCursor",                              kernel32_SetConsoleCursor},
{ 8, 1072, "SetConsoleCursorInfo",                          kernel32_SetConsoleCursorInfo},
{ 0, 1073, "SetConsoleCursorMode",                          kernel32_SetConsoleCursorMode},
{ 8, 1074, "SetConsoleCursorPosition",                      kernel32_SetConsoleCursorPosition},
{12, 1075, "SetConsoleDisplayMode",                         kernel32_SetConsoleDisplayMode},
{ 0, 1076, "SetConsoleFont",                                kernel32_SetConsoleFont},
{ 0, 1077, "SetConsoleHardwareState",                       kernel32_SetConsoleHardwareState},
{ 4, 1078, "SetConsoleHistoryInfo",                         kernel32_SetConsoleHistoryInfo},
{ 0, 1079, "SetConsoleIcon",                                kernel32_SetConsoleIcon},
{ 0, 1080, "SetConsoleInputExeNameA",                       kernel32_SetConsoleInputExeNameA},
{ 0, 1081, "SetConsoleInputExeNameW",                       kernel32_SetConsoleInputExeNameW},
{ 0, 1082, "SetConsoleKeyShortcuts",                        kernel32_SetConsoleKeyShortcuts},
{ 0, 1083, "SetConsoleLocalEUDC",                           kernel32_SetConsoleLocalEUDC},
{ 0, 1084, "SetConsoleMaximumWindowSize",                   kernel32_SetConsoleMaximumWindowSize},
{ 0, 1085, "SetConsoleMenuClose",                           kernel32_SetConsoleMenuClose},
{ 8, 1086, "SetConsoleMode",                                kernel32_SetConsoleMode},
{ 0, 1087, "SetConsoleNlsMode",                             kernel32_SetConsoleNlsMode},
{ 0, 1088, "SetConsoleNumberOfCommandsA",                   kernel32_SetConsoleNumberOfCommandsA},
{ 0, 1089, "SetConsoleNumberOfCommandsW",                   kernel32_SetConsoleNumberOfCommandsW},
{ 0, 1090, "SetConsoleOS2OemFormat",                        kernel32_SetConsoleOS2OemFormat},
{ 4, 1091, "SetConsoleOutputCP",                            kernel32_SetConsoleOutputCP},
{ 0, 1092, "SetConsolePalette",                             kernel32_SetConsolePalette},
{ 8, 1093, "SetConsoleScreenBufferInfoEx",                  kernel32_SetConsoleScreenBufferInfoEx},
{ 8, 1094, "SetConsoleScreenBufferSize",                    kernel32_SetConsoleScreenBufferSize},
{ 8, 1095, "SetConsoleTextAttribute",                       kernel32_SetConsoleTextAttribute},
{ 4, 1096, "SetConsoleTitleA",                              kernel32_SetConsoleTitleA},
{ 4, 1097, "SetConsoleTitleW",                              kernel32_SetConsoleTitleW},
{12, 1098, "SetConsoleWindowInfo",                          kernel32_SetConsoleWindowInfo},
{ 8, 1099, "SetCriticalSectionSpinCount",                   kernel32_SetCriticalSectionSpinCount},
{12, 1100, "SetCurrentConsoleFontEx",                       kernel32_SetCurrentConsoleFontEx},
{ 4, 1101, "SetCurrentDirectoryA",                          kernel32_SetCurrentDirectoryA},
{ 4, 1102, "SetCurrentDirectoryW",                          kernel32_SetCurrentDirectoryW},
{12, 1103, "SetDefaultCommConfigA",                         kernel32_SetDefaultCommConfigA},
{12, 1104, "SetDefaultCommConfigW",                         kernel32_SetDefaultCommConfigW},
{ 4, 1105, "SetDllDirectoryA",                              kernel32_SetDllDirectoryA},
{ 4, 1106, "SetDllDirectoryW",                              kernel32_SetDllDirectoryW},
{ 4, 1107, "SetDynamicTimeZoneInformation",                 kernel32_SetDynamicTimeZoneInformation},
{ 4, 1108, "SetEndOfFile",                                  kernel32_SetEndOfFile},
{ 4, 1109, "SetEnvironmentStringsA",                        kernel32_SetEnvironmentStringsA},
{ 4, 1110, "SetEnvironmentStringsW",                        kernel32_SetEnvironmentStringsW},
{ 8, 1111, "SetEnvironmentVariableA",                       kernel32_SetEnvironmentVariableA},
{ 8, 1112, "SetEnvironmentVariableW",                       kernel32_SetEnvironmentVariableW},
{ 4, 1113, "SetErrorMode",                                  kernel32_SetErrorMode},
{ 4, 1114, "SetEvent",                                      kernel32_SetEvent},
{ 8, 1115, "SetEventWhenCallbackReturns",                   kernel32_SetEventWhenCallbackReturns},
{ 0, 1116, "SetExtendedFeaturesMask",                       kernel32_SetExtendedFeaturesMask},
{ 0, 1117, "SetFileApisToANSI",                             kernel32_SetFileApisToANSI},
{ 0, 1118, "SetFileApisToOEM",                              kernel32_SetFileApisToOEM},
{ 8, 1119, "SetFileAttributesA",                            kernel32_SetFileAttributesA},
{12, 1120, "SetFileAttributesTransactedA",                  kernel32_SetFileAttributesTransactedA},
{12, 1121, "SetFileAttributesTransactedW",                  kernel32_SetFileAttributesTransactedW},
{ 8, 1122, "SetFileAttributesW",                            kernel32_SetFileAttributesW},
{24, 1123, "SetFileBandwidthReservation",                   kernel32_SetFileBandwidthReservation},
{ 8, 1124, "SetFileCompletionNotificationModes",            kernel32_SetFileCompletionNotificationModes},
{16, 1125, "SetFileInformationByHandle",                    kernel32_SetFileInformationByHandle},
{12, 1126, "SetFileIoOverlappedRange",                      kernel32_SetFileIoOverlappedRange},
{16, 1127, "SetFilePointer",                                kernel32_SetFilePointer},
{20, 1128, "SetFilePointerEx",                              kernel32_SetFilePointerEx},
{ 8, 1129, "SetFileShortNameA",                             kernel32_SetFileShortNameA},
{ 8, 1130, "SetFileShortNameW",                             kernel32_SetFileShortNameW},
{16, 1131, "SetFileTime",                                   kernel32_SetFileTime},
{12, 1132, "SetFileValidData",                              kernel32_SetFileValidData},
{16, 1133, "SetFirmwareEnvironmentVariableA",               kernel32_SetFirmwareEnvironmentVariableA},
{16, 1134, "SetFirmwareEnvironmentVariableW",               kernel32_SetFirmwareEnvironmentVariableW},
{ 0, 1135, "SetHandleContext",                              kernel32_SetHandleContext},
{ 4, 1136, "SetHandleCount",                                kernel32_SetHandleCount},
{12, 1137, "SetHandleInformation",                          kernel32_SetHandleInformation},
{16, 1138, "SetInformationJobObject",                       kernel32_SetInformationJobObject},
{ 0, 1139, "SetLastConsoleEventActive",                     kernel32_SetLastConsoleEventActive},
{ 4, 1140, "SetLastError",                                  kernel32_SetLastError},
{ 8, 1141, "SetLocalPrimaryComputerNameA",                  kernel32_SetLocalPrimaryComputerNameA},
{ 8, 1142, "SetLocalPrimaryComputerNameW",                  kernel32_SetLocalPrimaryComputerNameW},
{ 4, 1143, "SetLocalTime",                                  kernel32_SetLocalTime},
{12, 1144, "SetLocaleInfoA",                                kernel32_SetLocaleInfoA},
{12, 1145, "SetLocaleInfoW",                                kernel32_SetLocaleInfoW},
{ 8, 1146, "SetMailslotInfo",                               kernel32_SetMailslotInfo},
{ 8, 1147, "SetMessageWaitingIndicator",                    kernel32_SetMessageWaitingIndicator},
{20, 1148, "SetNamedPipeAttribute",                         kernel32_SetNamedPipeAttribute},
{16, 1149, "SetNamedPipeHandleState",                       kernel32_SetNamedPipeHandleState},
{ 8, 1150, "SetPriorityClass",                              kernel32_SetPriorityClass},
{ 8, 1151, "SetProcessAffinityMask",                        kernel32_SetProcessAffinityMask},
{ 0, 1152, "SetProcessAffinityUpdateMode",                  kernel32_SetProcessAffinityUpdateMode},
{ 0, 1153, "SetProcessDEPPolicy",                           kernel32_SetProcessDEPPolicy},
{ 0, 1154, "SetProcessPreferredUILanguages",                kernel32_SetProcessPreferredUILanguages},
{ 8, 1155, "SetProcessPriorityBoost",                       kernel32_SetProcessPriorityBoost},
{ 8, 1156, "SetProcessShutdownParameters",                  kernel32_SetProcessShutdownParameters},
{12, 1157, "SetProcessWorkingSetSize",                      kernel32_SetProcessWorkingSetSize},
{16, 1158, "SetProcessWorkingSetSizeEx",                    kernel32_SetProcessWorkingSetSizeEx},
{ 0, 1159, "SetSearchPathMode",                             kernel32_SetSearchPathMode},
{ 8, 1160, "SetStdHandle",                                  kernel32_SetStdHandle},
{12, 1161, "SetStdHandleEx",                                kernel32_SetStdHandleEx},
{12, 1162, "SetSystemFileCacheSize",                        kernel32_SetSystemFileCacheSize},
{ 8, 1163, "SetSystemPowerState",                           kernel32_SetSystemPowerState},
{ 4, 1164, "SetSystemTime",                                 kernel32_SetSystemTime},
{ 8, 1165, "SetSystemTimeAdjustment",                       kernel32_SetSystemTimeAdjustment},
{12, 1166, "SetTapeParameters",                             kernel32_SetTapeParameters},
{24, 1167, "SetTapePosition",                               kernel32_SetTapePosition},
{ 0, 1168, "SetTermsrvAppInstallMode",                      kernel32_SetTermsrvAppInstallMode},
{ 8, 1169, "SetThreadAffinityMask",                         kernel32_SetThreadAffinityMask},
{ 8, 1170, "SetThreadContext",                              kernel32_SetThreadContext},
{ 0, 1171, "SetThreadErrorMode",                            kernel32_SetThreadErrorMode},
{ 4, 1172, "SetThreadExecutionState",                       kernel32_SetThreadExecutionState},
{ 0, 1173, "SetThreadGroupAffinity",                        kernel32_SetThreadGroupAffinity},
{ 8, 1174, "SetThreadIdealProcessor",                       kernel32_SetThreadIdealProcessor},
{ 0, 1175, "SetThreadIdealProcessorEx",                     kernel32_SetThreadIdealProcessorEx},
{ 4, 1176, "SetThreadLocale",                               kernel32_SetThreadLocale},
{12, 1177, "SetThreadPreferredUILanguages",                 kernel32_SetThreadPreferredUILanguages},
{ 8, 1178, "SetThreadPriority",                             kernel32_SetThreadPriority},
{ 8, 1179, "SetThreadPriorityBoost",                        kernel32_SetThreadPriorityBoost},
{ 4, 1180, "SetThreadStackGuarantee",                       kernel32_SetThreadStackGuarantee},
{ 0, 1181, "SetThreadToken",                                kernel32_SetThreadToken},
{ 4, 1182, "SetThreadUILanguage",                           kernel32_SetThreadUILanguage},
{ 0, 1183, "SetThreadpoolStackInformation",                 kernel32_SetThreadpoolStackInformation},
{ 8, 1184, "SetThreadpoolThreadMaximum",                    kernel32_SetThreadpoolThreadMaximum},
{ 8, 1185, "SetThreadpoolThreadMinimum",                    kernel32_SetThreadpoolThreadMinimum},
{16, 1186, "SetThreadpoolTimer",                            kernel32_SetThreadpoolTimer},
{12, 1187, "SetThreadpoolWait",                             kernel32_SetThreadpoolWait},
{ 4, 1188, "SetTimeZoneInformation",                        kernel32_SetTimeZoneInformation},
{24, 1189, "SetTimerQueueTimer",                            kernel32_SetTimerQueueTimer},
{ 4, 1190, "SetUnhandledExceptionFilter",                   kernel32_SetUnhandledExceptionFilter},
{ 4, 1191, "SetUserGeoID",                                  kernel32_SetUserGeoID},
{ 0, 1192, "SetVDMCurrentDirectories",                      kernel32_SetVDMCurrentDirectories},
{ 8, 1193, "SetVolumeLabelA",                               kernel32_SetVolumeLabelA},
{ 8, 1194, "SetVolumeLabelW",                               kernel32_SetVolumeLabelW},
{ 8, 1195, "SetVolumeMountPointA",                          kernel32_SetVolumeMountPointA},
{ 8, 1196, "SetVolumeMountPointW",                          kernel32_SetVolumeMountPointW},
{24, 1197, "SetWaitableTimer",                              kernel32_SetWaitableTimer},
{ 0, 1198, "SetWaitableTimerEx",                            kernel32_SetWaitableTimerEx},
{12, 1199, "SetupComm",                                     kernel32_SetupComm},
{ 0, 1200, "ShowConsoleCursor",                             kernel32_ShowConsoleCursor},
{16, 1201, "SignalObjectAndWait",                           kernel32_SignalObjectAndWait},
{ 8, 1202, "SizeofResource",                                kernel32_SizeofResource},
{ 4, 1203, "Sleep",                                         kernel32_Sleep},
{12, 1204, "SleepConditionVariableCS",                      kernel32_SleepConditionVariableCS},
{16, 1205, "SleepConditionVariableSRW",                     kernel32_SleepConditionVariableSRW},
{ 8, 1206, "SleepEx",                                       kernel32_SleepEx},
{ 0, 1207, "SortCloseHandle",                               kernel32_SortCloseHandle},
{ 0, 1208, "SortGetHandle",                                 kernel32_SortGetHandle},
{ 4, 1209, "StartThreadpoolIo",                             kernel32_StartThreadpoolIo},
{ 4, 1210, "SubmitThreadpoolWork",                          kernel32_SubmitThreadpoolWork},
{ 4, 1211, "SuspendThread",                                 kernel32_SuspendThread},
{ 4, 1212, "SwitchToFiber",                                 kernel32_SwitchToFiber},
{ 0, 1213, "SwitchToThread",                                kernel32_SwitchToThread},
{ 8, 1214, "SystemTimeToFileTime",                          kernel32_SystemTimeToFileTime},
{12, 1215, "SystemTimeToTzSpecificLocalTime",               kernel32_SystemTimeToTzSpecificLocalTime},
{ 8, 1216, "TerminateJobObject",                            kernel32_TerminateJobObject},
{ 8, 1217, "TerminateProcess",                              kernel32_TerminateProcess},
{ 8, 1218, "TerminateThread",                               kernel32_TerminateThread},
{ 0, 1219, "TermsrvAppInstallMode",                         kernel32_TermsrvAppInstallMode},
{ 8, 1220, "Thread32First",                                 kernel32_Thread32First},
{ 8, 1221, "Thread32Next",                                  kernel32_Thread32Next},
{ 0, 1222, "TlsAlloc",                                      kernel32_TlsAlloc},
{ 4, 1223, "TlsFree",                                       kernel32_TlsFree},
{ 4, 1224, "TlsGetValue",                                   kernel32_TlsGetValue},
{ 8, 1225, "TlsSetValue",                                   kernel32_TlsSetValue},
{20, 1226, "Toolhelp32ReadProcessMemory",                   kernel32_Toolhelp32ReadProcessMemory},
{28, 1227, "TransactNamedPipe",                             kernel32_TransactNamedPipe},
{ 8, 1228, "TransmitCommChar",                              kernel32_TransmitCommChar},
{ 0, 1229, "TryAcquireSRWLockExclusive",                    kernel32_TryAcquireSRWLockExclusive},
{ 0, 1230, "TryAcquireSRWLockShared",                       kernel32_TryAcquireSRWLockShared},
{ 4, 1231, "TryEnterCriticalSection",                       kernel32_TryEnterCriticalSection},
{12, 1232, "TrySubmitThreadpoolCallback",                   kernel32_TrySubmitThreadpoolCallback},
{12, 1233, "TzSpecificLocalTimeToSystemTime",               kernel32_TzSpecificLocalTimeToSystemTime},
{ 0, 1234, "UTRegister",                                    kernel32_UTRegister},
{ 0, 1235, "UTUnRegister",                                  kernel32_UTUnRegister},
{ 4, 1236, "UnhandledExceptionFilter",                      kernel32_UnhandledExceptionFilter},
{20, 1237, "UnlockFile",                                    kernel32_UnlockFile},
{20, 1238, "UnlockFileEx",                                  kernel32_UnlockFileEx},
{ 4, 1239, "UnmapViewOfFile",                               kernel32_UnmapViewOfFile},
{ 0, 1240, "UnregisterApplicationRecoveryCallback",         kernel32_UnregisterApplicationRecoveryCallback},
{ 0, 1241, "UnregisterApplicationRestart",                  kernel32_UnregisterApplicationRestart},
{ 0, 1242, "UnregisterConsoleIME",                          kernel32_UnregisterConsoleIME},
{ 4, 1243, "UnregisterWait",                                kernel32_UnregisterWait},
{ 8, 1244, "UnregisterWaitEx",                              kernel32_UnregisterWaitEx},
{ 0, 1245, "UpdateCalendarDayOfWeek",                       kernel32_UpdateCalendarDayOfWeek},
{28, 1246, "UpdateProcThreadAttribute",                     kernel32_UpdateProcThreadAttribute},
{24, 1247, "UpdateResourceA",                               kernel32_UpdateResourceA},
{24, 1248, "UpdateResourceW",                               kernel32_UpdateResourceW},
{ 0, 1249, "VDMConsoleOperation",                           kernel32_VDMConsoleOperation},
{ 0, 1250, "VDMOperationStarted",                           kernel32_VDMOperationStarted},
{12, 1251, "VerLanguageNameA",                              kernel32_VerLanguageNameA},
{12, 1252, "VerLanguageNameW",                              kernel32_VerLanguageNameW},
{16, 1253, "VerSetConditionMask",                           kernel32_VerSetConditionMask},
{ 0, 1254, "VerifyConsoleIoHandle",                         kernel32_VerifyConsoleIoHandle},
{20, 1255, "VerifyScripts",                                 kernel32_VerifyScripts},
{16, 1256, "VerifyVersionInfoA",                            kernel32_VerifyVersionInfoA},
{16, 1257, "VerifyVersionInfoW",                            kernel32_VerifyVersionInfoW},
{16, 1258, "VirtualAlloc",                                  kernel32_VirtualAlloc},
{20, 1259, "VirtualAllocEx",                                kernel32_VirtualAllocEx},
{24, 1260, "VirtualAllocExNuma",                            kernel32_VirtualAllocExNuma},
{12, 1261, "VirtualFree",                                   kernel32_VirtualFree},
{16, 1262, "VirtualFreeEx",                                 kernel32_VirtualFreeEx},
{ 8, 1263, "VirtualLock",                                   kernel32_VirtualLock},
{16, 1264, "VirtualProtect",                                kernel32_VirtualProtect},
{20, 1265, "VirtualProtectEx",                              kernel32_VirtualProtectEx},
{12, 1266, "VirtualQuery",                                  kernel32_VirtualQuery},
{16, 1267, "VirtualQueryEx",                                kernel32_VirtualQueryEx},
{ 8, 1268, "VirtualUnlock",                                 kernel32_VirtualUnlock},
{ 0, 1269, "WTSGetActiveConsoleSessionId",                  kernel32_WTSGetActiveConsoleSessionId},
{12, 1270, "WaitCommEvent",                                 kernel32_WaitCommEvent},
{ 8, 1271, "WaitForDebugEvent",                             kernel32_WaitForDebugEvent},
{16, 1272, "WaitForMultipleObjects",                        kernel32_WaitForMultipleObjects},
{20, 1273, "WaitForMultipleObjectsEx",                      kernel32_WaitForMultipleObjectsEx},
{ 8, 1274, "WaitForSingleObject",                           kernel32_WaitForSingleObject},
{12, 1275, "WaitForSingleObjectEx",                         kernel32_WaitForSingleObjectEx},
{ 8, 1276, "WaitForThreadpoolIoCallbacks",                  kernel32_WaitForThreadpoolIoCallbacks},
{ 8, 1277, "WaitForThreadpoolTimerCallbacks",               kernel32_WaitForThreadpoolTimerCallbacks},
{ 8, 1278, "WaitForThreadpoolWaitCallbacks",                kernel32_WaitForThreadpoolWaitCallbacks},
{ 8, 1279, "WaitForThreadpoolWorkCallbacks",                kernel32_WaitForThreadpoolWorkCallbacks},
{ 8, 1280, "WaitNamedPipeA",                                kernel32_WaitNamedPipeA},
{ 8, 1281, "WaitNamedPipeW",                                kernel32_WaitNamedPipeW},
{ 4, 1282, "WakeAllConditionVariable",                      kernel32_WakeAllConditionVariable},
{ 4, 1283, "WakeConditionVariable",                         kernel32_WakeConditionVariable},
{ 8, 1284, "WerGetFlags",                                   kernel32_WerGetFlags},
{12, 1285, "WerRegisterFile",                               kernel32_WerRegisterFile},
{ 8, 1286, "WerRegisterMemoryBlock",                        kernel32_WerRegisterMemoryBlock},
{ 0, 1287, "WerRegisterRuntimeExceptionModule",             kernel32_WerRegisterRuntimeExceptionModule},
{ 4, 1288, "WerSetFlags",                                   kernel32_WerSetFlags},
{ 4, 1289, "WerUnregisterFile",                             kernel32_WerUnregisterFile},
{ 4, 1290, "WerUnregisterMemoryBlock",                      kernel32_WerUnregisterMemoryBlock},
{ 0, 1291, "WerUnregisterRuntimeExceptionModule",           kernel32_WerUnregisterRuntimeExceptionModule},
{ 0, 1292, "WerpCleanupMessageMapping",                     kernel32_WerpCleanupMessageMapping},
{ 4, 1293, "WerpInitiateRemoteRecovery",                    kernel32_WerpInitiateRemoteRecovery},
{ 0, 1294, "WerpNotifyLoadStringResource",                  kernel32_WerpNotifyLoadStringResource},
{ 0, 1295, "WerpNotifyLoadStringResourceEx",                kernel32_WerpNotifyLoadStringResourceEx},
{ 0, 1296, "WerpNotifyUseStringResource",                   kernel32_WerpNotifyUseStringResource},
{ 0, 1297, "WerpStringLookup",                              kernel32_WerpStringLookup},
{32, 1298, "WideCharToMultiByte",                           kernel32_WideCharToMultiByte},
{ 8, 1299, "WinExec",                                       kernel32_WinExec},
{ 4, 1300, "Wow64DisableWow64FsRedirection",                kernel32_Wow64DisableWow64FsRedirection},
{ 4, 1301, "Wow64EnableWow64FsRedirection",                 kernel32_Wow64EnableWow64FsRedirection},
{ 8, 1302, "Wow64GetThreadContext",                         kernel32_Wow64GetThreadContext},
{ 0, 1303, "Wow64GetThreadSelectorEntry",                   kernel32_Wow64GetThreadSelectorEntry},
{ 4, 1304, "Wow64RevertWow64FsRedirection",                 kernel32_Wow64RevertWow64FsRedirection},
{ 8, 1305, "Wow64SetThreadContext",                         kernel32_Wow64SetThreadContext},
{ 4, 1306, "Wow64SuspendThread",                            kernel32_Wow64SuspendThread},
{20, 1307, "WriteConsoleA",                                 kernel32_WriteConsoleA},
{16, 1308, "WriteConsoleInputA",                            kernel32_WriteConsoleInputA},
{ 0, 1309, "WriteConsoleInputVDMA",                         kernel32_WriteConsoleInputVDMA},
{ 0, 1310, "WriteConsoleInputVDMW",                         kernel32_WriteConsoleInputVDMW},
{16, 1311, "WriteConsoleInputW",                            kernel32_WriteConsoleInputW},
{20, 1312, "WriteConsoleOutputA",                           kernel32_WriteConsoleOutputA},
{20, 1313, "WriteConsoleOutputAttribute",                   kernel32_WriteConsoleOutputAttribute},
{20, 1314, "WriteConsoleOutputCharacterA",                  kernel32_WriteConsoleOutputCharacterA},
{20, 1315, "WriteConsoleOutputCharacterW",                  kernel32_WriteConsoleOutputCharacterW},
{20, 1316, "WriteConsoleOutputW",                           kernel32_WriteConsoleOutputW},
{20, 1317, "WriteConsoleW",                                 kernel32_WriteConsoleW},
{20, 1318, "WriteFile",                                     kernel32_WriteFile},
{20, 1319, "WriteFileEx",                                   kernel32_WriteFileEx},
{20, 1320, "WriteFileGather",                               kernel32_WriteFileGather},
{12, 1321, "WritePrivateProfileSectionA",                   kernel32_WritePrivateProfileSectionA},
{12, 1322, "WritePrivateProfileSectionW",                   kernel32_WritePrivateProfileSectionW},
{16, 1323, "WritePrivateProfileStringA",                    kernel32_WritePrivateProfileStringA},
{16, 1324, "WritePrivateProfileStringW",                    kernel32_WritePrivateProfileStringW},
{20, 1325, "WritePrivateProfileStructA",                    kernel32_WritePrivateProfileStructA},
{20, 1326, "WritePrivateProfileStructW",                    kernel32_WritePrivateProfileStructW},
{20, 1327, "WriteProcessMemory",                            kernel32_WriteProcessMemory},
{ 8, 1328, "WriteProfileSectionA",                          kernel32_WriteProfileSectionA},
{ 8, 1329, "WriteProfileSectionW",                          kernel32_WriteProfileSectionW},
{12, 1330, "WriteProfileStringA",                           kernel32_WriteProfileStringA},
{12, 1331, "WriteProfileStringW",                           kernel32_WriteProfileStringW},
{16, 1332, "WriteTapemark",                                 kernel32_WriteTapemark},
{ 4, 1333, "ZombifyActCtx",                                 kernel32_ZombifyActCtx},
{12, 1334, "_hread",                                        kernel32__hread},
{12, 1335, "_hwrite",                                       kernel32__hwrite},
{ 4, 1336, "_lclose",                                       kernel32__lclose},
{ 8, 1337, "_lcreat",                                       kernel32__lcreat},
{12, 1338, "_llseek",                                       kernel32__llseek},
{ 8, 1339, "_lopen",                                        kernel32__lopen},
{12, 1340, "_lread",                                        kernel32__lread},
{12, 1341, "_lwrite",                                       kernel32__lwrite},
{ 8, 1342, "lstrcat",                                       kernel32_lstrcatA},
{ 8, 1343, "lstrcatA",                                      kernel32_lstrcatA},
{ 8, 1344, "lstrcatW",                                      kernel32_lstrcatW},
{ 8, 1345, "lstrcmp",                                       kernel32_lstrcmpA},
{ 8, 1346, "lstrcmpA",                                      kernel32_lstrcmpA},
{ 8, 1347, "lstrcmpW",                                      kernel32_lstrcmpW},
{ 8, 1348, "lstrcmpi",                                      kernel32_lstrcmpiA},
{ 8, 1349, "lstrcmpiA",                                     kernel32_lstrcmpiA},
{ 8, 1350, "lstrcmpiW",                                     kernel32_lstrcmpiW},
{ 8, 1351, "lstrcpy",                                       kernel32_lstrcpyA},
{ 8, 1352, "lstrcpyA",                                      kernel32_lstrcpyA},
{ 8, 1353, "lstrcpyW",                                      kernel32_lstrcpyW},
{12, 1354, "lstrcpyn",                                      kernel32_lstrcpynA},
{12, 1355, "lstrcpynA",                                     kernel32_lstrcpynA},
{12, 1356, "lstrcpynW",                                     kernel32_lstrcpynW},
{ 4, 1357, "lstrlen",                                       kernel32_lstrlenA},
{ 4, 1358, "lstrlenA",                                      kernel32_lstrlenA},
{ 4, 1359, "lstrlenW",                                      kernel32_lstrlenW},
{ 0,    0, NULL,                                            NULL}};
