/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __SYSTEM_H__
#define __SYSTEM_H__


#include "ia32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:システム構造体                                                           *
*                                                                             *
******************************************************************************/
#define LSTE_SIZE 0x008
#define NTTIB_SIZE 0x01c
#define USTR_SIZE 0x008
#define CID_SIZE 0x008
#define PEBLD_SIZE 0x024
#define GDITEBB_SIZE 0x4e0
#define ACS_SIZE 0x014
#define PEB_SIZE 0x22c
#define TEB_SIZE 0xfb8


#ifdef USE_GCC


typedef struct _ListEntry {
  guint32 Flink __attribute__((packed));                            /* 000 */
  guint32 Blink __attribute__((packed));                            /* 004 */
} ListEntry;
typedef struct _NtThreadInformationBlock
{
  guint32 ExceptionList __attribute__((packed));                    /* 000 */
  guint32 StackBase __attribute__((packed));                        /* 004 */
  guint32 StackLimit __attribute__((packed));                       /* 008 */
  guint32 SubSystemTib __attribute__((packed));                     /* 00c */
  union
  {
    guint32 FiberData __attribute__((packed));                      /* 010 */
    guint32 Version __attribute__((packed));                        /* 010 */
  } DUMMYUNIONNAME __attribute__((packed));
  guint32 ArbitraryUserPointer __attribute__((packed));             /* 014 */
  guint32 Self __attribute__((packed));                             /* 018 */
} NtThreadInformationBlock;
typedef struct _UnicodeString
{
  guint16 Length __attribute__((packed));                           /* 000 */
  guint16 MaximumLength __attribute__((packed));                    /* 002 */
  guint32 Buffer __attribute__((packed));                           /* 004 */
} UnicodeString;
typedef struct _ClientId
{
  guint32 UniqueProcess __attribute__((packed));                    /* 000 */
  guint32 UniqueThread __attribute__((packed));                     /* 004 */
} ClientId;
typedef struct _ProcessEnvironmentBlockLdrData
{
  guint32 Length __attribute__((packed));                           /* 000 */
  guint8 Initialized __attribute__((packed));                       /* 004 */
  guint8 Reserved[3] __attribute__((packed));                       /* 005 */
  guint32 SsHandle __attribute__((packed));                         /* 008 */
  ListEntry InLoadOrderModuleList __attribute__((packed));          /* 00c */
  ListEntry InMemoryOrderModuleList __attribute__((packed));        /* 014 */
  ListEntry InInitializationOrderModuleList __attribute__((packed));/* 01c */
} ProcessEnvironmentBlockLdrData;
typedef struct _GdiThreadEnvironmentBlockBatch
{
  guint32 Offset __attribute__((packed));                           /* 000 */
  guint32 HDC __attribute__((packed));                              /* 004 */
  guint32 Buffer[0x136] __attribute__((packed));                    /* 008 */
} GdiThreadEnvironmentBlockBatch;
typedef struct _ActivationContextStack
{
  guint32 Flags __attribute__((packed));                            /* 000 */
  guint32 NextCookieSequenceNumber __attribute__((packed));         /* 004 */
  guint32 ActiveFrame __attribute__((packed));                      /* 008 */
  ListEntry FrameListCache __attribute__((packed));                 /* 00c */
} ActivationContextStack;
Typedef struct _ProcessEnvironmentBlock
{
  guint8 InheritedAddressSpace __attribute__((packed));             /* 000 */
  guint8 ReadImageFileExecOptions __attribute__((packed));          /* 001 */
  guint8 BeingDebugged __attribute__((packed));                     /* 002 */
  guint8 SpareBool __attribute__((packed));                         /* 003 */
  guint32 Mutant __attribute__((packed));                           /* 004 */
  guint32 ImageBaseAddress __attribute__((packed));                 /* 008 */
  guint32 LdrData __attribute__((packed));                          /* 00c */
  guint32 ProcessParameters __attribute__((packed));                /* 010 */
  guint32 SubSystemData __attribute__((packed));                    /* 014 */
  guint32 ProcessHeap __attribute__((packed));                      /* 018 */
  guint32 FastPebLock __attribute__((packed));                      /* 01c */
  guint32 FastPebLockRoutine __attribute__((packed));               /* 020 */
  guint32 FastPebUnlockRoutine __attribute__((packed));             /* 024 */
  guint32 EnvironmentUpdateCount __attribute__((packed));           /* 028 */
  guint32 KernelCallbackTable __attribute__((packed));              /* 02c */
  guint32 Reserved[2] __attribute__((packed));                      /* 030 */
  guint32 FreeList __attribute__((packed));                         /* 038 */
  guint32 TlsExpansionCounter __attribute__((packed));              /* 03c */
  guint32 TlsBitmap __attribute__((packed));                        /* 040 */
  guint32 TlsBitmapBits[2] __attribute__((packed));                 /* 044 */
  guint32 ReadOnlySharedMemoryBase __attribute__((packed));         /* 04c */
  guint32 ReadOnlySharedMemoryHeap __attribute__((packed));         /* 050 */
  guint32 ReadOnlyStaticServerData __attribute__((packed));         /* 054 */
  guint32 AnsiCodePageData __attribute__((packed));                 /* 058 */
  guint32 OemCodePageData __attribute__((packed));                  /* 05c */
  guint32 UnicodeCaseTableData __attribute__((packed));             /* 060 */
  guint32 NumberOfProcessors __attribute__((packed));               /* 064 */
  guint32 NtGlobalFlag __attribute__((packed));                     /* 068 */
  gint64 CriticalSectionTimeout __attribute__((packed));            /* 070 */
  guint32 HeapSegmentReserve __attribute__((packed));               /* 078 */
  guint32 HeapSegmentCommit __attribute__((packed));                /* 07c */
  guint32 HeapDeCommitTotalFreeThreshold __attribute__((packed));   /* 080 */
  guint32 HeapDeCommitFreeBlockThreshold __attribute__((packed));   /* 084 */
  guint32 NumberOfHeaps __attribute__((packed));                    /* 088 */
  guint32 MaximumNumberOfHeaps __attribute__((packed));             /* 08c */
  guint32 ProcessHeaps __attribute__((packed));                     /* 090 */
  guint32 GdiSharedHandleTable __attribute__((packed));             /* 094 */
  guint32 ProcessStarterHelper __attribute__((packed));             /* 098 */
  guint32 GdiDCAttributeList __attribute__((packed));               /* 09c */
  guint32 LoaderLock __attribute__((packed));                       /* 0a0 */
  guint32 OSMajorVersion __attribute__((packed));                   /* 0a4 */
  guint32 OSMinorVersion __attribute__((packed));                   /* 0a8 */
  guint32 OSBuildNumber __attribute__((packed));                    /* 0ac */
  guint32 OSPlatformId __attribute__((packed));                     /* 0b0 */
  guint32 ImageSubSystem __attribute__((packed));                   /* 0b4 */
  guint32 ImageSubSystemMajorVersion __attribute__((packed));       /* 0b8 */
  guint32 ImageSubSystemMinorVersion __attribute__((packed));       /* 0bc */
  guint32 ImageProcessAffinityMask __attribute__((packed));         /* 0c0 */
  guint32 GdiHandleBuffer[28] __attribute__((packed));              /* 0c4 */
  guint32 unknown[6] __attribute__((packed));                       /* 134 */
  guint32 PostProcessInitRoutine __attribute__((packed));           /* 14c */
  guint32 TlsExpansionBitmap __attribute__((packed));               /* 150 */
  guint32 TlsExpansionBitmapBits[32] __attribute__((packed));       /* 154 */
  guint32 SessionId __attribute__((packed));                        /* 1d4 */
  guint64 AppCompatFlags __attribute__((packed));                   /* 1d8 */
  guint64 AppCompatFlagsUser __attribute__((packed));               /* 1e0 */
  guint32 ShimData __attribute__((packed));                         /* 1e8 */
  guint32 AppCompatInfo __attribute__((packed));                    /* 1ec */
  UnicodeString CSDVersion __attribute__((packed));                 /* 1f0 */
  guint32 ActivationContextData __attribute__((packed));            /* 1f8 */
  guint32 ProcessAssemblyStorageMap __attribute__((packed));        /* 1fc */
  guint32 SystemDefaultActivationData __attribute__((packed));      /* 200 */
  guint32 SystemAssemblyStorageMap __attribute__((packed));         /* 204 */
  guint32 MinimumStackCommit __attribute__((packed));               /* 208 */
  guint32 FlsCallback __attribute__((packed));                      /* 20c */
  ListEntry FlsListHead __attribute__((packed));                    /* 210 */
  guint32 FlsBitmap __attribute__((packed));                        /* 218 */
  guint32 FlsBitmapBits[4] __attribute__((packed));                 /* 21c */
} ProcessEnvironmentBlock
typedef struct _ThreadEnvironmentBlock
{
  NtThreadInformationBlock Tib __attribute__((packed));             /* 000 */
  guint32 EnvironmentPointer __attribute__((packed));               /* 01c */
  ClientId ClientId __attribute__((packed));                        /* 020 */
  guint32 ActiveRpcHandle __attribute__((packed));                  /* 028 */
  guint32 ThreadLocalStoragePointer __attribute__((packed));        /* 02c */
  guint32 Peb __attribute__((packed));                              /* 030 */
  guint32 LastErrorValue __attribute__((packed));                   /* 034 */
  guint32 CountOfOwnedCriticalSections __attribute__((packed));     /* 038 */
  guint32 CsrClientThread __attribute__((packed));                  /* 03c */
  guint32 Win32ThreadInfo __attribute__((packed));                  /* 040 */
  guint32 Win32ClientInfo[31] __attribute__((packed));              /* 044 */
  guint32 WOW32Reserved __attribute__((packed));                    /* 0c0 */
  guint32 CurrentLocale __attribute__((packed));                    /* 0c4 */
  guint32 FpSoftwareStatusRegister __attribute__((packed));         /* 0c8 */
  guint32 SystemReserved1[54] __attribute__((packed));              /* 0cc */
  gint32 ExceptionCode __attribute__((packed));                     /* 1a4 */
  ActivationContextStack ActivationContextStack __attribute__((packed));
  guint8 SpareBytes1[24] __attribute__((packed));                   /* 1bc */
  guint32 SystemReserved2[10] __attribute__((packed));              /* 1d4 */
  GdiThreadEnvironmentBlockBatch GdiTebBatch __attribute__((packed));/* 1fc */
  guint32 gdiRgn __attribute__((packed));                           /* 6dc */
  guint32 gdiPen __attribute__((packed));                           /* 6e0 */
  guint32 gdiBrush __attribute__((packed));                         /* 6e4 */
  ClientId RealClientId __attribute__((packed));                    /* 6e8 */
  guint32 GdiCachedProcessHandle __attribute__((packed));           /* 6f0 */
  guint32 GdiClientPID __attribute__((packed));                     /* 6f4 */
  guint32 GdiClientTID __attribute__((packed));                     /* 6f8 */
  guint32 GdiThreadLocaleInfo __attribute__((packed));              /* 6fc */
  guint32 UserReserved[5] __attribute__((packed));                  /* 700 */
  guint32 glDispachTable[280] __attribute__((packed));              /* 714 */
  guint32 glReserved1[26] __attribute__((packed));                  /* b74 */
  guint32 glReserved2 __attribute__((packed));                      /* bdc */
  guint32 glSectionInfo __attribute__((packed));                    /* be0 */
  guint32 glSection __attribute__((packed));                        /* be4 */
  guint32 glTable __attribute__((packed));                          /* be8 */
  guint32 glCurrentRC __attribute__((packed));                      /* bec */
  guint32 glContext __attribute__((packed));                        /* bf0 */
  guint32 LastStatusValue __attribute__((packed));                  /* bf4 */
  UnicodeString StaticUnicodeString __attribute__((packed));        /* bf8 */
  guint16 StaticUnicodeBuffer[261] __attribute__((packed));         /* c00 */
  guint32 DeallocationStack __attribute__((packed));                /* e0c */
  guint32 TlsSlots[64] __attribute__((packed));                     /* e10 */
  ListEntry TlsLinks __attribute__((packed));                       /* f10 */
  guint32 Vdm __attribute__((packed));                              /* f18 */
  guint32 ReservedForNtRpc __attribute__((packed));                 /* f1c */
  guint32 DbgSsReserved[2] __attribute__((packed));                 /* f20 */
  guint32 HardErrorDisabled __attribute__((packed));                /* f28 */
  guint32 Instrumentation[16] __attribute__((packed));              /* f2c */
  guint32 WinSockData __attribute__((packed));                      /* f6c */
  guint32 GdiBatchCount __attribute__((packed));                    /* f70 */
  guint32 Spare2 __attribute__((packed));                           /* f74 */
  guint32 Spare3 __attribute__((packed));                           /* f78 */
  guint32 Spare4 __attribute__((packed));                           /* f7c */
  guint32 ReservedForOle __attribute__((packed));                   /* f80 */
  guint32 WaitingOnLoaderLock __attribute__((packed));              /* f84 */
  guint32 Reserved5[3] __attribute__((packed));                     /* f88 */
  guint32 TlsExpansionSlots __attribute__((packed));                /* f94 */
  guint32 ImpersonationLocale __attribute__((packed));              /* f98 */
  guint32 IsImpersonating __attribute__((packed));                  /* f9c */
  guint32 NlsCache __attribute__((packed));                         /* fa0 */
  guint32 ShimData __attribute__((packed));                         /* fa4 */
  guint32 HeapVirtualAffinity __attribute__((packed));              /* fa8 */
  guint32 CurrentTransactionHandle __attribute__((packed));         /* fac */
  guint32 ActiveFrame __attribute__((packed));                      /* fb0 */
  guint32 FlsSlots __attribute__((packed));                         /* fb4 */
} ThreadEnvironmentBlock __attribute__((packed));


#else /* not USE_GCC */


typedef struct _ListEntry { guint8 dummy[LSTE_SIZE]; } ListEntry;
typedef struct _NtThreadInformationBlock { guint8 dummy[NTTIB_SIZE]; } NtThreadInformationBlock;
typedef struct _UnicodeString { guint8 dummy[USTR_SIZE]; } UnicodeString;
typedef struct _ClientId { guint8 dummy[CID_SIZE]; } ClientId;
typedef struct _ProcessEnvironmentBlockLdrData { guint8 dummy[PEBLD_SIZE]; } ProcessEnvironmentBlockLdrData;
typedef struct _GdiThreadEnvironmentBlockBatch { guint8 dummy[GDITEBB_SIZE]; } GdiThreadEnvironmentBlockBatch;
typedef struct _ActivationContextStack { guint8 dummy[ACS_SIZE]; } ActivationContextStack;
typedef struct _ProcessEnvironmentBlock { guint8 dummy[PEB_SIZE]; } ProcessEnvironmentBlock;
typedef struct _ThreadEnvironmentBlock { guint8 dummy[TEB_SIZE]; } ThreadEnvironmentBlock;


#endif /* not USE_GCC */


/******************************************************************************
*                                                                             *
* ja:システム構造体マクロ                                                     *
*                                                                             *
******************************************************************************/
#define lste_get_flink(lste) GUINT32_FROM_LE(*(guint32 *)(lste))
#define lste_get_blink(lste) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(lste)+4))
#define lste_get_extra32(lste) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(lste)+8))
#define lste_set_flink(lste,flink) (*(guint32 *)(lste)=GUINT32_TO_LE(flink))
#define lste_set_blink(lste,blink) (*(guint32 *)((guint8 *)(lste)+4)=GUINT32_TO_LE(blink))
#define lste_set_extra32(lste,extra) (*(guint32 *)((guint8 *)(lste)+8)=GUINT32_TO_LE(extra))


#define nttib_get_exception_list(nttib) GUINT32_FROM_LE(*(guint32 *)(nttib))
#define nttib_get_stack_base(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+4))
#define nttib_get_stack_limit(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+8))
#define nttib_get_sub_system_tib(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+12))
#define nttib_get_fiber_data(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+16))
#define nttib_get_version(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+16))
#define nttib_get_arbitrary_user_pointer(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+20))
#define nttib_get_self(nttib) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(nttib)+24))
#define nttib_set_exception_list(nttib,exception_list) (*(guint32 *)(nttib)=GUINT32_TO_LE(exception_list))
#define nttib_set_stack_base(nttib,stack_base) (*(guint32 *)((guint8 *)(nttib)+4)=GUINT32_TO_LE(stack_base))
#define nttib_set_stack_limit(nttib,stack_limit) (*(guint32 *)((guint8 *)(nttib)+8)=GUINT32_TO_LE(stack_limit))
#define nttib_set_sub_system_tib(nttib,sub_system_tib) (*(guint32 *)((guint8 *)(nttib)+12)=GUINT32_TO_LE(sub_system_tib))
#define nttib_set_fiber_data(nttib,fiber_data) (*(guint32 *)((guint8 *)(nttib)+16)=GUINT32_TO_LE(fiber_data))
#define nttib_set_version(nttib,version) (*(guint32 *)((guint8 *)(nttib)+16)=GUINT32_TO_LE(version))
#define nttib_set_arbitrary_user_pointer(nttib,arbitrary_user_pointer) (*(guint32 *)((guint8 *)(nttib)+20)=GUINT32_TO_LE(arbitrary_user_pointer))
#define nttib_set_self(nttib,self) (*(guint32 *)((guint8 *)(nttib)+24)=GUINT32_TO_LE(self))


#define pebld_get_length(pebld) GUINT32_FROM_LE(*(guint32 *)(pebld))
#define pebld_get_initialized(pebld) (*((guint8 *)(pebld)+4))
#define pebld_get_sshandle(pebld) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(pebld)+8))
#define pebld_get_in_load_order_module_list(pebld) ((ListEntry *)((guint8 *)(pebld)+12))
#define pebld_get_in_memory_order_module_list(pebld) ((ListEntry *)((guint8 *)(pebld)+20))
#define pebld_get_in_initialization_order_module_list(pebld) ((ListEntry *)((guint8 *)(pebld)+28))
#define pebld_set_length(pebld,length) (*(guint32 *)(pebld)=GUINT32_TO_LE(length))
#define pebld_set_initialized(pebld,initialized) (*((guint8 *)(pebld)+4)=(initialized))
#define pebld_set_sshandle(pebld,sshandle) (*(guint32 *)((guint8 *)(pebld)+8)=GUINT32_TO_LE(sshandle))


#define peb_get_ldr_data(teb) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(peb)+12))
#define peb_set_ldr_data(teb,ldr_data) (*(guint32 *)((guint8 *)(peb)+12)=GUINT32_TO_LE(ldr_data))


#define teb_get_tib(teb) ((NtThreadInformationBlock *)(teb))
#define teb_get_peb(teb) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(teb)+0x30))
#define teb_set_peb(teb,peb) (*(guint32 *)((guint8 *)(teb)+0x30)=GUINT32_TO_LE(peb))


/******************************************************************************
*                                                                             *
* ja:例外構造体                                                               *
*                                                                             *
******************************************************************************/
#ifndef SIZE_OF_80387_REGISTERS
# define SIZE_OF_80387_REGISTERS 80
#endif /* not SIZE_OF_80387_REGISTERS */
#ifndef MAXIMUM_SUPPORTED_EXTENSION
# define MAXIMUM_SUPPORTED_EXTENSION 512
#endif /* not MAXIMUM_SUPPORTED_EXTENSION */
#ifndef EXCEPTION_MAXIMUM_PARAMETERS
# define EXCEPTION_MAXIMUM_PARAMETERS 15
#endif /* not not EXCEPTION_MAXIMUM_PARAMETERS */
#ifndef EXCEPTION_ACCESS_VIOLATION
# define EXCEPTION_ACCESS_VIOLATION         0xc0000005
#endif /* not EXCEPTION_ACCESS_VIOLATION */
#ifndef EXCEPTION_ARRAY_BOUNDS_EXCEEDED
# define EXCEPTION_ARRAY_BOUNDS_EXCEEDED    0xc000008c
#endif /* not EXCEPTION_ARRAY_BOUNDS_EXCEEDED */
#ifndef EXCEPTION_BREAKPOINT
# define EXCEPTION_BREAKPOINT               0x80000003
#endif /* not EXCEPTION_BREAKPOINT */
#ifndef EXCEPTION_DATATYPE_MISALIGNMENT
# define EXCEPTION_DATATYPE_MISALIGNMENT    0x80000002
#endif /* not EXCEPTION_DATATYPE_MISALIGNMENT */
#ifndef EXCEPTION_FLT_DENORMAL_OPERAND
# define EXCEPTION_FLT_DENORMAL_OPERAND     0xc000008d
#endif /* not EXCEPTION_FLT_DENORMAL_OPERAND */
#ifndef EXCEPTION_FLT_DIVIDE_BY_ZERO
# define EXCEPTION_FLT_DIVIDE_BY_ZERO       0xc000008e
#endif /* not EXCEPTION_FLT_DIVIDE_BY_ZERO */
#ifndef EXCEPTION_FLT_INEXACT_RESULT
# define EXCEPTION_FLT_INEXACT_RESULT       0xc000008f
#endif /* not EXCEPTION_FLT_INEXACT_RESULT */
#ifndef EXCEPTION_FLT_INVALID_OPERATION
# define EXCEPTION_FLT_INVALID_OPERATION    0xc0000090
#endif /* not EXCEPTION_FLT_INVALID_OPERATION */
#ifndef EXCEPTION_FLT_OVERFLOW
# define EXCEPTION_FLT_OVERFLOW             0xc0000091
#endif /* not EXCEPTION_FLT_OVERFLOW */
#ifndef EXCEPTION_FLT_STACK_CHECK
# define EXCEPTION_FLT_STACK_CHECK          0xc0000092
#endif /* not EXCEPTION_FLT_STACK_CHECK */
#ifndef EXCEPTION_FLT_UNDERFLOW
# define EXCEPTION_FLT_UNDERFLOW            0xc0000093
#endif /* not EXCEPTION_FLT_UNDERFLOW */
#ifndef EXCEPTION_GUARD_PAGE
# define EXCEPTION_GUARD_PAGE               0x80000001
#endif /* not EXCEPTION_GUARD_PAGE */
#ifndef EXCEPTION_ILLEGAL_INSTRUCTION
# define EXCEPTION_ILLEGAL_INSTRUCTION      0xc000001d
#endif /* not EXCEPTION_ILLEGAL_INSTRUCTION */
#ifndef EXCEPTION_IN_PAGE_ERROR
# define EXCEPTION_IN_PAGE_ERROR            0xc0000006
#endif /* not EXCEPTION_IN_PAGE_ERROR */
#ifndef EXCEPTION_INT_DIVIDE_BY_ZERO
# define EXCEPTION_INT_DIVIDE_BY_ZERO       0xc0000094
#endif /* not EXCEPTION_INT_DIVIDE_BY_ZERO */
#ifndef EXCEPTION_INT_OVERFLOW
# define EXCEPTION_INT_OVERFLOW             0xc0000095
#endif /* not EXCEPTION_INT_OVERFLOW */
#ifndef EXCEPTION_INVALID_DISPOSITION
# define EXCEPTION_INVALID_DISPOSITION      0xc0000026
#endif /* not EXCEPTION_INVALID_DISPOSITION */
#ifndef EXCEPTION_INVALID_HANDLE
# define EXCEPTION_INVALID_HANDLE           0xc0000008
#endif /* not EXCEPTION_INVALID_HANDLE */
#ifndef EXCEPTION_NONCONTINUABLE_EXCEPTION
# define EXCEPTION_NONCONTINUABLE_EXCEPTION 0xc0000025
#endif /* not EXCEPTION_NONCONTINUABLE_EXCEPTION */
#ifndef EXCEPTION_PRIV_INSTRUCTION
# define EXCEPTION_PRIV_INSTRUCTION         0xc0000096
#endif /* not EXCEPTION_PRIV_INSTRUCTION */
#ifndef EXCEPTION_SINGLE_STEP
# define EXCEPTION_SINGLE_STEP              0x80000004
#endif /* not EXCEPTION_SINGLE_STEP */
#ifndef EXCEPTION_STACK_OVERFLOW
# define EXCEPTION_STACK_OVERFLOW           0xc00000fd
#endif /* not EXCEPTION_STACK_OVERFLOW */
#ifndef EXCEPTION_CONTINUE_EXECUTION
# define EXCEPTION_CONTINUE_EXECUTION 0
#endif /* not EXCEPTION_CONTINUE_EXECUTION */
#ifndef EXCEPTION_CONTINUE_SEARCH
# define EXCEPTION_CONTINUE_SEARCH 1
#endif /* not EXCEPTION_CONTINUE_SEARCH */
#ifndef EXCEPTION_NESTED_EXCEPTION
# define EXCEPTION_NESTED_EXCEPTION 2
#endif /* not EXCEPTION_NESTED_EXCEPTION */
#ifndef EXCEPTION_COLLIDED_UNWIND
# define EXCEPTION_COLLIDED_UNWIND 3
#endif /* not EXCEPTION_COLLIDED_UNWIND */


#define FSA_SIZE (32+SIZE_OF_80387_REGISTERS)
#define CTXT_SIZE (92+FSA_SIZE+MAXIMUM_SUPPORTED_EXTENSION)
#define EXREC_SIZE (20+EXCEPTION_MAXIMUM_PARAMETERS*4)
#define EXREG_SIZE 8


#ifdef USE_GCC


typedef struct _FloatingSaveArea
{
  guint32 ControlWord __attribute__((packed));
  guint32 StatusWord __attribute__((packed));
  guint32 TagWord __attribute__((packed));
  guint32 ErrorOffset __attribute__((packed));
  guint32 ErrorSelector __attribute__((packed));
  guint32 DataOffset __attribute__((packed));
  guint32 DataSelector __attribute__((packed));
  guint8 RegisterArea[SIZE_OF_80387_REGISTERS] __attribute__((packed));
  guint32 Cr0NpxState __attribute__((packed));
} FloatingSaveArea;
typedef struct _Context
{
  guint32 ContextFlags __attribute__((packed));                     /* 000 */
  guint32 Dr0 __attribute__((packed));                              /* 004 */
  guint32 Dr1 __attribute__((packed));                              /* 008 */
  guint32 Dr2 __attribute__((packed));                              /* 00c */
  guint32 Dr3 __attribute__((packed));                              /* 010 */
  guint32 Dr6 __attribute__((packed));                              /* 014 */
  guint32 Dr7 __attribute__((packed));                              /* 018 */
  FloatingSaveArea FloatSave __attribute__((packed));               /* 01c */
  guint32 SegGs __attribute__((packed));                            /* 08c */
  guint32 SegFs __attribute__((packed));                            /* 090 */
  guint32 SegEs __attribute__((packed));                            /* 094 */
  guint32 SegDs __attribute__((packed));                            /* 098 */
  guint32 Edi __attribute__((packed));                              /* 09c */
  guint32 Esi __attribute__((packed));                              /* 0a0 */
  guint32 Ebx __attribute__((packed));                              /* 0a4 */
  guint32 Edx __attribute__((packed));                              /* 0a8 */
  guint32 Ecx __attribute__((packed));                              /* 0ac */
  guint32 Eax __attribute__((packed));                              /* 0b0 */
  guint32 Ebp __attribute__((packed));                              /* 0b4 */
  guint32 Eip __attribute__((packed));                              /* 0b8 */
  guint32 SegCs __attribute__((packed));                            /* 0bc */
  guint32 EFlags __attribute__((packed));                           /* 0c0 */
  guint32 Esp __attribute__((packed));                              /* 0c4 */
  guint32 SegSs __attribute__((packed));                            /* 0c8 */
  guint8 ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION] __attribute__((packed));
} Context;
typedef struct _ExceptionRecord
{
  guint32 ExceptionCode __attribute__((packed));
  guint32 ExceptionFlags __attribute__((packed));
  guint32 ExceptionRecord __attribute__((packed));
  guint32 ExceptionAddress __attribute__((packed));
  guint32 NumberParameters __attribute__((packed));
  guint32 ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS] __attribute__((packed));
} ExceptionRecord;
typedef struct _ExceptionRegistrationRecord
{
  guint32 Next __attribute__((packed));
  guint32 Handler __attribute__((packed));
} ExceptionRegistrationRecord;


#else /* not USE_GCC */


typedef struct _FloatingSaveArea { guint8 dummy[FSA_SIZE]; } FloatingSaveArea;
typedef struct _Context { guint8 dummy[CTXT_SIZE]; } Context;
typedef struct _ExceptionRecord { guint8 dummy[EXREC_SIZE]; } ExceptionRecord;
typedef struct _ExceptionRegistrationRecord { guint8 dummy[EXREG_SIZE]; } ExceptionRegistrationRecord;


#endif /* not USE_GCC */


/******************************************************************************
*                                                                             *
* ja:例外構造体マクロ                                                         *
*                                                                             *
******************************************************************************/
#define ctxt_get_gs(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0x8c))
#define ctxt_get_fs(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0x90))
#define ctxt_get_es(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0x94))
#define ctxt_get_ds(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0x98))
#define ctxt_get_edi(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0x9c))
#define ctxt_get_esi(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xa0))
#define ctxt_get_ebx(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xa4))
#define ctxt_get_edx(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xa8))
#define ctxt_get_ecx(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xac))
#define ctxt_get_eax(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xb0))
#define ctxt_get_ebp(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xb4))
#define ctxt_get_eip(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xb8))
#define ctxt_get_cs(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xbc))
#define ctxt_get_eflags(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xc0))
#define ctxt_get_esp(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xc4))
#define ctxt_get_ss(ctxt) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ctxt)+0xc8))
#define ctxt_set_gs(ctxt,gs) (*(guint32 *)((guint8 *)(ctxt)+0x8c)=GUINT32_TO_LE(gs))
#define ctxt_set_fs(ctxt,fs) (*(guint32 *)((guint8 *)(ctxt)+0x90)=GUINT32_TO_LE(fs))
#define ctxt_set_es(ctxt,es) (*(guint32 *)((guint8 *)(ctxt)+0x94)=GUINT32_TO_LE(es))
#define ctxt_set_ds(ctxt,ds) (*(guint32 *)((guint8 *)(ctxt)+0x98)=GUINT32_TO_LE(ds))
#define ctxt_set_edi(ctxt,edi) (*(guint32 *)((guint8 *)(ctxt)+0x9c)=GUINT32_TO_LE(edi))
#define ctxt_set_esi(ctxt,esi) (*(guint32 *)((guint8 *)(ctxt)+0xa0)=GUINT32_TO_LE(esi))
#define ctxt_set_ebx(ctxt,ebx) (*(guint32 *)((guint8 *)(ctxt)+0xa4)=GUINT32_TO_LE(ebx))
#define ctxt_set_edx(ctxt,edx) (*(guint32 *)((guint8 *)(ctxt)+0xa8)=GUINT32_TO_LE(edx))
#define ctxt_set_ecx(ctxt,ecx) (*(guint32 *)((guint8 *)(ctxt)+0xac)=GUINT32_TO_LE(ecx))
#define ctxt_set_eax(ctxt,eax) (*(guint32 *)((guint8 *)(ctxt)+0xb0)=GUINT32_TO_LE(eax))
#define ctxt_set_ebp(ctxt,ebp) (*(guint32 *)((guint8 *)(ctxt)+0xb4)=GUINT32_TO_LE(ebp))
#define ctxt_set_eip(ctxt,eip) (*(guint32 *)((guint8 *)(ctxt)+0xb8)=GUINT32_TO_LE(eip))
#define ctxt_set_cs(ctxt,cs) (*(guint32 *)((guint8 *)(ctxt)+0xbc)=GUINT32_TO_LE(cs))
#define ctxt_set_eflags(ctxt,eflags) (*(guint32 *)((guint8 *)(ctxt)+0xc0)=GUINT32_TO_LE(eflags))
#define ctxt_set_esp(ctxt,esp) (*(guint32 *)((guint8 *)(ctxt)+0xc4)=GUINT32_TO_LE(esp))
#define ctxt_set_ss(ctxt,ss) (*(guint32 *)((guint8 *)(ctxt)+0xc8)=GUINT32_TO_LE(ss))


#define exrec_get_exception_code(exrec) GUINT32_FROM_LE(*(guint32 *)(exrec))
#define exrec_get_exception_flag(exrec) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(exrec)+4))
#define exrec_get_exception_record(exrec) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(exrec)+8))
#define exrec_get_exception_address(exrec) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(exrec)+12))
#define exrec_get_number_parameters(exrec) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(exrec)+16))
#define exrec_set_exception_code(exrec,exception_code) (*(guint32 *)(exrec)=GUINT32_TO_LE(exception_code))
#define exrec_set_exception_flag(exrec,exception_flag) (*(guint32 *)((guint8 *)(exrec)+4)=GUINT32_TO_LE(exception_flag))
#define exrec_set_exception_record(exrec,exception_record) (*(guint32 *)((guint8 *)(exrec)+8)=GUINT32_TO_LE(exception_record))
#define exrec_set_exception_address(exrec,exception_address) (*(guint32 *)((guint8 *)(exrec)+12)=GUINT32_TO_LE(exception_address))
#define exrec_set_number_parameters(exrec,number_parameters) (*(guint32 *)((guint8 *)(exrec)+16)=GUINT32_TO_LE(number_parameters))


#define exreg_get_next(exreg) GUINT32_FROM_LE(*(guint32 *)(exreg))
#define exreg_get_handler(exreg) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(exreg)+4))
#define exreg_set_next(exreg,next) (*(guint32 *)(exreg)=GUINT32_TO_LE(next))
#define exreg_set_handler(exreg,handler) (*(guint32 *)((guint8 *)(exreg)+4)=GUINT32_TO_LE(handler))


/******************************************************************************
*                                                                             *
* ja:システム関数群                                                           *
*                                                                             *
******************************************************************************/
extern Ia32Export ia32_system_exports[];


G_END_DECLS


#endif /* __SYSTEM_H__ */
