/*
copyright (c) 2008-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int
compare (const void *arg1,
         const void *arg2)
{
  return strcmp (*(char **)arg1, *( char **)arg2);
}


int
main (int   argc,
      char *argv[])
{
  char buf[BUFSIZ], *str, **funcs = NULL;
  int i, count = 0;

  str = calloc (1, sizeof (char));
  while (fgets (buf, sizeof (str) / sizeof (char), stdin))
    {
      size_t len;

      len = strlen (str) + strlen (buf);
      str = realloc (str, (len + 1) * sizeof (char));
      strcat (str, buf);
      if (str[len - 1] == '\n')
        {
          int i;
          char *p;

          for (p = str; *p != '\0'; p++)
            if (p[0] == 'g' && (p[1] == 't' || p[1] == 'd')
                            && p[2] == 'k' && p[3] == '_' && isalnum (p[4]))
              {
                char *q;

                q = strstr (p + 5, "_get_type");
                if (q && (q[9] == '\0' || isspace (q[9])))
                  {
                    char *r;

                    for (r = p + 5; r <= q - 2; r++)
                      if (*r != '_' && !isalnum (*r))
                        break;
                    if (r > q - 2)
                      {
                        funcs = realloc (funcs, (count + 1) * sizeof (char *));
                        len = q + 9 - p;
                        funcs[count] = malloc ((len + 1) * sizeof (char));
                        memcpy (funcs[count], p, len);
                        (funcs[count])[len] = '\0';
                        count++;
                        p = q + 8;
                      }
                    break;
                  }
              }
          str[0] = '\0';
        }
    }
  free (str);
  qsort (funcs, count, sizeof (char *), compare);
  for (i = 0; i < count; i++)
    {
      if (i == 0 || strcmp (funcs[i - 1], funcs[i]) != 0)
        printf ("*tp++ = %s ();\n", funcs[i]);
      free (funcs[i]);
    }
  free (funcs);
  return 0;
}
