/*
    disw32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __INFO_H__
#define __INFO_H__


#include "disw32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:情報関数                                                                 *
*                                                                             *
******************************************************************************/
/*  ja:イメージ情報構造体を作成する
    image,PEイメージ
      RET,イメージ情報構造体                                                */
Dw32Info *
dw32_info_create (const guint8 *image);


/*  ja:イメージ情報構造体の整理
        info,イメージ情報構造体
      export,エクスポート(TRUE:存続,FALSE:削除)
      import,インポート(TRUE:存続,FALSE:削除)
    resource,リソース(TRUE:存続,FALSE:削除)
       reloc,再配置(TRUE:存続,FALSE:削除)                                   */
void
dw32_info_organize (Dw32Info       *info,
                    const gboolean  export,
                    const gboolean  import,
                    const gboolean  resource,
                    const gboolean  reloc);


/*  ja:イメージ情報構造体を表示する
      fp,ファイルポインタ
    info,イメージ情報構造体                                                 */
void
dw32_info_disp (FILE           *fp,
                const Dw32Info *info);


/*  ja:イメージ情報構造体を解放する
    info,イメージ情報構造体                                                 */
void
dw32_info_free (Dw32Info *info);


G_END_DECLS


#endif /* __INFO_H__ */
