/*
    cws2fws
    copyright (c) 2008-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#include <zlib.h>

#define INBUFSIZ  BUFSIZ
#define OUTBUFSIZ BUFSIZ

int
main (int   argc,
      char *argv[])
{
  char inbuf[INBUFSIZ];
  char outbuf[OUTBUFSIZ];
  int status = Z_OK, ret = -1;
  size_t len;
  FILE *fp_in, *fp_out = NULL;
  z_stream z;

  if (argc != 3)
    {
      fprintf (stderr,
"cws2fws "VERSION" ("BUILD_ENVIRONMENT")\n"
"copyright (c) 2008-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org\n"
"\n"
"Usage: %s infile outfile\n"
"\n", argv[0]);
      return -1;
    }

  fp_in = fopen (argv[1], "rb");
  if (!fp_in)
    {
      fprintf (stderr, "Error fopen(\"%s\")\n", argv[1]);
      return -1;
    }
  if (fread (inbuf, sizeof (char), 8, fp_in) != 8)
    {
      fprintf (stderr, "Error : fread\n");
      fclose (fp_in);
      return -1;
    }
  if (inbuf[0] != 'C' || inbuf[1] != 'W' || inbuf[2] != 'S')
    {
      fprintf (stderr, "Error : Header\n");
      fclose (fp_in);
      return -1;
    }
  fp_out = fopen (argv[2], "wb");
  if (!fp_out)
    {
      fprintf (stderr, "Error fopen(\"%s\")\n", argv[2]);
      fclose (fp_in);
      return -1;
    }
  inbuf[0] = 'F';
  if (fwrite (inbuf, sizeof (char), 8, fp_out) != 8)
    {
      fprintf (stderr, "Error : fwrite\n");
      fclose (fp_in);
      fclose (fp_out);
      return -1;
    }

  z.zalloc = Z_NULL;
  z.zfree = Z_NULL;
  z.opaque = Z_NULL;
  if (inflateInit (&z) != Z_OK)
    {
      fprintf (stderr, "Error : %s\n", z.msg ? z.msg : "inflateInit");
      fclose (fp_in);
      fclose (fp_out);
      return -1;
    }

  z.next_in = Z_NULL;
  z.avail_in = 0;
  z.next_out = (Bytef *)outbuf;
  z.avail_out = OUTBUFSIZ;

  while (status != Z_STREAM_END)
    {
      if (z.avail_in == 0)
        {
          z.next_in = (Bytef *)inbuf;
          z.avail_in = fread (inbuf, 1, INBUFSIZ, fp_in);
        }
      status = inflate (&z, Z_NO_FLUSH);
      if (status == Z_STREAM_END)
        break;
      if (status != Z_OK)
        {
          fprintf (stderr, "Error : %s\n", z.msg ? z.msg : "inflate");
          goto final;
        }
      if (z.avail_out == 0)
        {
          if (fwrite (outbuf, 1, OUTBUFSIZ, fp_out) != OUTBUFSIZ)
            {
              fprintf (stderr, "Error : fwrite\n");
              goto final;
            }
          z.next_out = (Bytef *)outbuf;
          z.avail_out = OUTBUFSIZ;
        }
    }

  len = OUTBUFSIZ - z.avail_out;
  if (len > 0 && fwrite (outbuf, 1, len, fp_out) != len)
    fprintf (stderr, "Error : fwrite\n");
  else
    ret = 0;

  final:
  if (inflateEnd (&z) != Z_OK)
    {
      fprintf (stderr, "Error : %s\n", z.msg ? z.msg : "inflateEnd");
      ret = -1;
    }
  if ((fclose (fp_in) != 0) | (fclose (fp_out) != 0))
    {
      fprintf (stderr, "Error : fclose\n");
      ret = -1;
    }
  return ret;
}
