/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBDATETIME_H__
#define __GLIBDATETIME_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* GDateTime                                                                   *
******************************************************************************/
#ifndef G_TIME_SPAN_DAY
# define G_TIME_SPAN_DAY         (G_GINT64_CONSTANT (86400000000))
#endif /* not G_TIME_SPAN_DAY */
#ifndef G_TIME_SPAN_HOUR
# define G_TIME_SPAN_HOUR        (G_GINT64_CONSTANT (3600000000))
#endif /* not G_TIME_SPAN_HOUR */
#ifndef G_TIME_SPAN_MINUTE
# define G_TIME_SPAN_MINUTE      (G_GINT64_CONSTANT (60000000))
#endif /* not G_TIME_SPAN_MINUTE */
#ifndef G_TIME_SPAN_SECOND
# define G_TIME_SPAN_SECOND      (G_GINT64_CONSTANT (1000000))
#endif /* not G_TIME_SPAN_SECOND */
#ifndef G_TIME_SPAN_MILLISECOND
# define G_TIME_SPAN_MILLISECOND (G_GINT64_CONSTANT (1000))
#endif /* not G_TIME_SPAN_MILLISECOND */
#if ! GLIB_CHECK_VERSION(2,26,0)
typedef gint64 GTimeSpan;
typedef struct _GDateTime GDateTime;


void g_date_time_unref (GDateTime *datetime);
GDateTime *g_date_time_ref (GDateTime *datetime);
GDateTime *g_date_time_new_now_utc (void);
GDateTime *g_date_time_new_from_unix_utc (gint64 t);
GDateTime *g_date_time_new_from_timeval_utc (const GTimeVal *tv);
GDateTime *g_date_time_new_utc (gint year, gint month, gint day, gint hour, gint minute, gdouble seconds);
GDateTime *g_date_time_add (GDateTime *datetime, GTimeSpan timespan);
GDateTime *g_date_time_add_years (GDateTime *datetime, gint years);
GDateTime *g_date_time_add_months (GDateTime *datetime, gint months);
GDateTime *g_date_time_add_weeks (GDateTime *datetime, gint weeks);
GDateTime *g_date_time_add_days (GDateTime *datetime, gint days);
GDateTime *g_date_time_add_hours (GDateTime *datetime, gint hours);
GDateTime *g_date_time_add_minutes (GDateTime *datetime, gint minutes);
GDateTime *g_date_time_add_seconds (GDateTime *datetime, gdouble seconds);
GDateTime *g_date_time_add_full (GDateTime *datetime, gint years, gint months, gint days, gint hours, gint minutes, gdouble seconds);
gint g_date_time_compare (gconstpointer dt1, gconstpointer dt2);
GTimeSpan g_date_time_difference (GDateTime *end, GDateTime *begin);
guint g_date_time_hash (gconstpointer datetime);
gboolean g_date_time_equal (gconstpointer dt1, gconstpointer dt2);
void g_date_time_get_ymd (GDateTime *datetime, gint *year, gint *month, gint *day);
gint g_date_time_get_year (GDateTime *datetime);
gint g_date_time_get_month (GDateTime *datetime);
gint g_date_time_get_day_of_month (GDateTime *datetime);
gint g_date_time_get_hour (GDateTime *datetime);
gint g_date_time_get_minute (GDateTime *datetime);
gint g_date_time_get_second (GDateTime *datetime);
gint g_date_time_get_microsecond (GDateTime *datetime);
gdouble g_date_time_get_seconds (GDateTime *datetime);
gint64 g_date_time_to_unix (GDateTime *datetime);
gboolean g_date_time_to_timeval (GDateTime *datetime, GTimeVal *tv);
#endif /* not GLIB_CHECK_VERSION(2,26,0) */


G_END_DECLS


#endif /* __GLIBDATETIME_H__ */
