/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "gcommon.h"


/******************************************************************************
* Unicode Manipulation                                                        *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *
g_utf8_next_char (const gchar *p)
{
  const static gchar skip[256] = {
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                            3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
                            4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 1, 1};
  return p ? (gchar *)p + skip[*(guchar *)p] : NULL;
}

gunichar
g_utf8_get_char_validated (const gchar *p,
                           gssize       max_len)
{
  return max_len != 0 && p ? (guchar)*p : (gunichar)-2;
}


gchar *
g_utf8_strup (const gchar *str,
              gssize       len)
{
  return g_ascii_strup (str, len);
}


gchar *
g_utf8_strdown (const gchar *str,
                gssize       len)
{
  return g_ascii_strdown (str, len);
}


gunichar2 *
g_utf8_to_utf16 (const gchar  *str,
                 glong         len,
                 glong        *items_read,
                 glong        *items_written,
                 GError      **error)
{
  gunichar2 *utf16str = NULL;

  if (str)
    {
      gint i;

      if (len < 0)
        len = g_strlen (str);
      utf16str = g_malloc ((len + 1) * sizeof (gunichar2));
      for (i = 0; i < len; i++)
        utf16str[i] = (guchar)str[i];
      utf16str[i] = 0;
      if (items_read)
        *items_read = len;
      if (items_written)
        *items_written = len;
    }
  return utf16str;
}


gchar *
g_utf16_to_utf8 (const gunichar2  *str,
                 glong             len,
                 glong            *items_read,
                 glong            *items_written,
                 GError          **error)
{
  gchar *utf8str = NULL;

  if (str)
    {
      gint i;

      if (len < 0)
        for (len = 0; str[len] != 0; len++);
      utf8str = g_malloc ((len + 1) * sizeof (gchar));
      for (i = 0; i < len; i++)
        utf8str[i] = str[i];
      utf8str[i] = '\0';
      if (items_read)
        *items_read = len;
      if (items_written)
        *items_written = len;
    }
  return utf8str;
}


gint
g_unichar_to_utf8 (gunichar  c,
                   gchar    *outbuf)
{
  if (outbuf)
    {
      *outbuf = c;
      return 1;
    }
  return 0;
}
#endif /* USE_GTK_EMULATE */
