/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GTK2ADJUSTMENT_H__
#define __GTK2ADJUSTMENT_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* GtkAdjustment                                                               *
******************************************************************************/
#if ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0)
gdouble gtk_adjustment_get_lower (GtkAdjustment *adjustment);
void gtk_adjustment_set_lower (GtkAdjustment *adjustment, gdouble lower);
gdouble gtk_adjustment_get_upper (GtkAdjustment *adjustment);
void gtk_adjustment_set_upper (GtkAdjustment *adjustment, gdouble upper);
gdouble gtk_adjustment_get_step_increment (GtkAdjustment *adjustment);
void gtk_adjustment_set_step_increment (GtkAdjustment *adjustment, gdouble step_increment);
gdouble gtk_adjustment_get_page_increment (GtkAdjustment *adjustment);
void gtk_adjustment_set_page_increment (GtkAdjustment *adjustment, gdouble page_increment);
gdouble gtk_adjustment_get_page_size (GtkAdjustment *adjustment);
void gtk_adjustment_set_page_size (GtkAdjustment *adjustment, gdouble page_size);
#endif /* ! defined (USE_GTK_EMULATE) && ! GTK_CHECK_VERSION(2,14,0) */


G_END_DECLS


#endif /* __GTK2ADJUSTMENT_H__ */
