/*
copyright (c) 2012 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifdef WINMAIN
# pragma comment (lib, "kernel32.lib")
#endif /* WINMAIN */
#include <windows.h>
#include <tchar.h>
#include <float.h>
#include "iwmcrt.h"


#ifndef _CONSOLE_APP
# define _CONSOLE_APP 1
#endif /* not _CONSOLE_APP */
#ifndef _GUI_APP
# define _GUI_APP 2
#endif /* not _GUI_APP */


typedef struct __startupinfo
{
  int newmode;
} _startupinfo;


extern char ***_imp____initenv;
extern wchar_t ***_imp____winitenv;
extern char **_imp___acmdln;
extern wchar_t **_imp___wcmdln;


void __cdecl __getmainargs (int *, char ***, char ***, int, _startupinfo *);
void __cdecl __wgetmainargs (int *, wchar_t ***, wchar_t ***, int, _startupinfo *);


#ifdef WINMAIN
# ifdef UNICODE
INT WINAPI wWinMain (HINSTANCE, HINSTANCE, LPWSTR, INT);
VOID CDECL wWinMainCRTStartup (VOID)
# else /* not UNICODE */
INT WINAPI WinMain (HINSTANCE, HINSTANCE, LPSTR, INT);
VOID CDECL WinMainCRTStartup (VOID)
# endif /* not UNICODE */
#else /* not WINMAIN */
# ifdef UNICODE
int __cdecl wmain ();
VOID CDECL wmainCRTStartup (VOID)
# else /* not UNICODE */
int __cdecl main ();
VOID CDECL mainCRTStartup (VOID)
# endif /* not UNICODE */
#endif /* not WINMAIN */
{
  int argc;
  TCHAR **argv;
  TCHAR **envp;
#ifdef WINMAIN
  LPTSTR lpszCommandLine;
  STARTUPINFO StartupInfo;
#endif /* WINMAIN */
  _startupinfo startinfo;

  __onexitbegin = __onexitend = (_PVFV *)-1;
#ifdef WINMAIN
  __set_app_type (_GUI_APP);
#else /* not WINMAIN */
  __set_app_type (_CONSOLE_APP);
#endif /* not WINMAIN */
  _controlfp (PC_53, MCW_PC);
  _initterm (__xi_a, __xi_z);
  startinfo.newmode = 0;
#ifdef UNICODE
  __wgetmainargs (&argc, &argv, &envp, 0, &startinfo);
#else /* not UNICODE */
  __getmainargs (&argc, &argv, &envp, 0, &startinfo);
#endif /* not UNICODE */
  _initterm (__xc_a, __xc_z);
#ifdef WINMAIN
# ifdef UNICODE
  lpszCommandLine = *_imp___wcmdln;
# else /* not UNICODE */
  lpszCommandLine = *_imp___acmdln;
# endif /* not UNICODE */
  while (*lpszCommandLine == ' ')
    lpszCommandLine++;
  if (*lpszCommandLine == '\"')
    {
      do
        lpszCommandLine++;
      while (*lpszCommandLine != '\0' && *lpszCommandLine != '\"');
      if (*lpszCommandLine == '\"')
        lpszCommandLine++;
    }
  else
    {
      while (*lpszCommandLine != '\0' && *lpszCommandLine != ' ')
        lpszCommandLine++;
    }
  while (*lpszCommandLine == ' ')
    lpszCommandLine++;
  StartupInfo.dwFlags = 0;
  GetStartupInfo (&StartupInfo);
# ifdef UNICODE
  exit (wWinMain (
# else /* not UNICODE */
  exit (WinMain (
# endif /* not UNICODE */
        GetModuleHandle (NULL),
        NULL,
        lpszCommandLine,
        StartupInfo.dwFlags & STARTF_USESHOWWINDOW ? StartupInfo.wShowWindow
                                                   : SW_SHOWDEFAULT));
#else /* not WINMAIN */
# ifdef UNICODE
  *_imp____winitenv = envp;
  exit (wmain (argc, argv, envp));
# else /* not UNICODE */
  *_imp____initenv = envp;
  exit (main (argc, argv, envp));
# endif /* not UNICODE */
#endif /* not WINMAIN */
}
