/*
    opcode
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __OPCODE_H__
#define __OPCODE_H__


#include "gcommon/gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:オペコード関数                                                           *
*                                                                             *
******************************************************************************/
#define OPCODE_MNEMONIC_LENGTH 44
#define OPCODE_TYPE_CALL       0x00000001
#define OPCODE_TYPE_JMP        0x00000002
#define OPCODE_TYPE_EXIT       0x00000004


typedef struct _Opcode
{
  gchar mnemonic[OPCODE_MNEMONIC_LENGTH];
  gint index;        /* ja:添字(イメージベース相対アドレス) */
  gint bit;          /* ja:オペランドのビット数 */
  guint type;        /* ja:命令のタイプ */
  guint32 relative;  /* ja:相対アドレス(論理アドレス) */
  guint32 immediate; /* ja:即値(論理アドレス) */
  guint32 offset;    /* ja:オフセット値(論理アドレス) */
  guint32 array;     /* ja:配列アドレス(論理アドレス) */
} Opcode;


extern const gchar *regname[8][8];


/*  ja:命令解析
    image,PEイメージ
     size,サイズ(サイズが0ならば自動計算)
     base,ベースアドレス(サイズが0ならば自動計算)
       op,オペコード構造体
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
opcode_parse (const guint8  *image,
              const gsize    size,
              const guint32  base,
              Opcode        *op);


G_END_DECLS


#endif /* __OPCODE_H__ */
