/*
    peimage
    copyright (c) 1998-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __PEIMAGE_H__
#define __PEIMAGE_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ヘッダをチェックする
    lpcvHeader,ヘッダ
        dwFile,ファイルサイズ
       dwImage,イメージサイズ
          RET,TRUE:正常終了,NULL:エラー                                     */
BOOL WINAPI
PeCheck32 (LPCVOID lpcvHeader,
           DWORD   dwFile,
           DWORD   dwMemory);


/*  ヘッダをチェックする
    lpcvHeader,ヘッダ
           RET,TRUE:正常終了,NULL:エラー                                    */
PeCheckHeader32 (LPCVOID lpcvHeader);


/*  ヘッダをチェックする
    lpcvFile,ファイル
      dwSize,ファイルサイズ
         RET,TRUE:正常終了,NULL:エラー                                      */
PeCheckFile32 (LPCVOID lpcvImage,
               DWORD   dwSize);


/*  ヘッダをチェックする
    lpcvImage,イメージ
       dwSize,イメージサイズ
          RET,TRUE:正常終了,NULL:エラー                                     */
PeCheckImage32 (LPCVOID lpcvImage,
                DWORD   dwSize);


/*  ファイルをイメージに変換する
    lpcvFile,ファイル
    lpdwSize,イメージサイズ
         RET,イメージ,NULL:エラー                                           */
LPVOID WINAPI
PeFileToImage32 (LPCVOID lpcvFile,
                 LPDWORD lpdwSize);


/*  ファイルを読み込んでイメージを取得する
    lpszFile,ファイル名
    lpdwSize,イメージサイズ
         RET,イメージ,NULL:エラー                                           */
LPVOID WINAPI
PeLoad32A (LPCSTR  lpszFile,
           LPDWORD lpdwSize);


/*  ファイルを読み込んでイメージを取得する
    lpszFile,ファイル名
    lpdwSize,イメージサイズ
         RET,イメージ,NULL:エラー                                           */
LPVOID WINAPI
PeLoad32W (LPCWSTR lpszFile,
           LPDWORD lpdwSize);



/*  イメージの再配置
    lpvImage,イメージ
      dwBase,ベースアドレス
         RET,TRUE:正常終了,NULL:エラー                                      */
VOID WINAPI
PeRelocateBase32 (LPVOID lpvImage,
                  DWORD  dwBase);


/*  イメージの再配置
    lpvImage,イメージ
         RET,TRUE:正常終了,NULL:エラー                                      */
VOID WINAPI
PeRelocate32 (LPVOID lpvImage);


#ifdef UNICODE
# define PeLoad32 PeLoad32W
#else /* not UNICODE */
# define PeLoad32 PeLoad32A
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __PEIMAGE_H__ */
