/*
    tlhlp
    copyright (c) 2000-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <windows.h>
#include <shlwapi.h>
#include <tchar.h>
#include <tlhelp32.h>
#include "common.h"
#include "snap.h"


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int i = 1;
  DWORD dwBytes = 0, dwProcessId = (DWORD)-1;
  LPCTSTR lpszProcess = NULL, lpszFile = NULL;
  LPCVOID lpBaseAddress = NULL;
  HANDLE hSnap;

  while (i < argc)
    if (i + 1 < argc && (lstrcmpi (argv[i], _T("/o")) == 0
                      || lstrcmpi (argv[i], _T("-o")) == 0))
      {
        lpszFile = argv[i + 1];
        i += 2;
      }
    else if (!lpszProcess)
      {
        lpszProcess = argv[i];
        dwProcessId = Dec (argv[i]);
        i++;
      }
    else if (i + 1 < argc && dwBytes <= 0)
      {
        lpBaseAddress = (LPCVOID)Hex (argv[i]);
        dwBytes = Hex (argv[i + 1]);
        i += 2;
      }
    else
      {
        break;
      }
  if (i < argc || !lpszProcess)
    {
      PrintConsole (STD_ERROR_HANDLE,
_T("tlhlp "VERSION" ("BUILD_ENVIRONMENT")\n")
_T("copyright (c) 2000-2017 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org\n")
_T("\n")
_T("Usage: %s pid | name [address] [length] [/o outfile]\n")
_T("\n"), argv[0]);
      return -1;
    }
  hSnap = CreateToolhelp32Snapshot (TH32CS_SNAPPROCESS, 0);
  if (hSnap != INVALID_HANDLE_VALUE)
    {
      BOOL fResult;
      PROCESSENTRY32 pe;
      TCHAR szDir[MAX_PATH];

      GetModuleFileName (NULL, szDir, MAX_PATH);
      PathRemoveFileSpec (szDir);
      pe.dwSize = sizeof (PROCESSENTRY32);
      for (fResult = Process32First (hSnap, &pe); fResult;
                                        fResult = Process32Next (hSnap, &pe))
        {
          if (lstrcmpi (pe.szExeFile, lpszProcess) == 0
                                            || pe.th32ProcessID == dwProcessId)
            {
              TCHAR szFile[MAX_PATH];

              PrintConsole (STD_OUTPUT_HANDLE,
                                    _T("%d %s\n"), dwProcessId, pe.szExeFile);
              lstrcpy (szFile, szDir);
              PathAppend (szFile, pe.szExeFile);
              SnapShot (pe.th32ProcessID, lpszFile ? lpszFile : szFile,
                                        pe.szExeFile, lpBaseAddress, dwBytes);
            }
        }
      CloseHandle (hSnap);
    }
  else
    {
      PrintConsole (STD_ERROR_HANDLE,
                                    _T("Error : CreateToolhelp32Snapshot\n"));
    }
  return 0;
}
