/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __STACK_H__
#define __STACK_H__


#include "memory.h"


G_BEGIN_DECLS


#define IA32_STACK_SIZE 0x00010000


/******************************************************************************
*                                                                             *
* ja:スタック関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:スタック格納(32ビット)
    thread,スレッド構造体
     value,値
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
ia32_stack_push32 (Ia32Thread    *thread,
                   const guint32  value);


/*  ja:スタック搬出(32ビット)
    thread,スレッド構造体
     value,値
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
ia32_stack_pop32 (Ia32Thread *thread,
                  guint32    *value);


/*  ja:スタック格納(16ビット)
    thread,スレッド構造体
     value,値
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
ia32_stack_push16 (Ia32Thread    *thread,
                   const guint16  value);


/*  ja:スタック搬出(16ビット)
    thread,スレッド構造体
     value,値
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
ia32_stack_pop16 (Ia32Thread *thread,
                  guint16    *value);


/******************************************************************************
*                                                                             *
* ja:引数関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:スタックから引数の値を取得する
    thread,スレッド構造体
      argv,引数の位置(0:戻りアドレス,1:最左引数,...)
       RET,値                                                               */
guint32
ia32_stack_value (Ia32Thread *thread,
                  const gint  argv);


/*  ja:スタックから引数のポインタを取得する
    thread,スレッド構造体
      argv,引数の位置(0:戻りアドレス,1:最左引数,...)
       RET,実アドレス(NULL:エラー)                                          */
gpointer
ia32_stack_pointer (Ia32Thread *thread,
                    const gint  argv);


/*  ja:スタックから引数の文字列を取得する
    thread,スレッド構造体
      argv,引数の位置(0:戻りアドレス,1:最左引数,...)
       RET,実アドレス(NULL:エラー)                                          */
gpointer
ia32_stack_string (Ia32Thread *thread,
                   const gint  argv);


/*  ja:スタックから引数のワイド文字列を取得する
    thread,スレッド構造体
      argv,引数の位置(0:戻りアドレス,1:最左引数,...)
       RET,実アドレス(NULL:エラー)                                          */
gpointer
ia32_stack_stringw (Ia32Thread *thread,
                    const gint  argv);


G_END_DECLS


#endif /* __STACK_H__ */
