/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCLIST_H__
#define __WCLIST_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
typedef struct _LIST *LPLIST;
typedef int (WINAPI *ListCompare_t)(LPVOID lpValue1, LPVOID lpValue2,
                                                                LPVOID lpData);
typedef VOID (WINAPI *ListFree_t)(LPVOID lpValue, LPVOID lpData);
typedef BOOL (CALLBACK *ListEnumProc_t)(LPVOID lpValue, LPVOID lpData);


/*  値を直接比較する
    lpValue1,値1
    lpValue2,値2
      lpData,ユーザデータ
         RET,負:値1が小さい,0:等しい,正:値1が大きい                         */
int WINAPI
ListCompareDirect (LPVOID lpValue1,
                   LPVOID lpValue2,
                   LPVOID lpData);


/*  値を文字列として比較する
    lpValue1,値1
    lpValue2,値2
      lpData,ユーザデータ
         RET,負:値1が小さい,0:等しい,正:値1が大きい                         */
int WINAPI
ListCompareStringW (LPVOID lpValue1,
                    LPVOID lpValue2,
                    LPVOID lpData);


/*  値を文字列として比較する
    lpValue1,値1
    lpValue2,値2
      lpData,ユーザデータ
         RET,負:値1が小さい,0:等しい,正:値1が大きい                         */
int WINAPI
ListCompareStringA (LPVOID lpValue1,
                    LPVOID lpValue2,
                    LPVOID lpData);


/*  リストの値を解放する
    lpValue,値
     lpData,ユーザデータ                                                    */
VOID WINAPI
ListFree (LPVOID lpValue,
          LPVOID lpData);


/*  線形リストの末尾に追加する
    lpStart,線形リスト(NULL:新規作成)
    lpValue,値
        RET,線形リスト                                                      */
LPLIST WINAPI
ListAppend (LPLIST lpStart,
            LPVOID lpValue);


/*  線形リストの先頭に追加する
    lpStart,線形リスト(NULL:新規作成)
    lpValue,値
        RET,線形リスト                                                      */
LPLIST WINAPI
ListPrepend (LPLIST lpStart,
             LPVOID lpValue);


/*  線形リストに追加する
      lpStart,線形リスト(NULL:新規作成)
      lpValue,値
    lpCompare,比較関数
       lpData,ユーザデータ
          RET,線形リスト                                                    */
LPLIST WINAPI
ListInsert (LPLIST        lpStart,
            LPVOID        lpValue,
            ListCompare_t lpCompare,
            LPVOID        lpData);


/*  線形リストをソートする
      lpStart,線形リスト
    lpCompare,比較関数
       lpData,ユーザデータ
          RET,線形リスト                                                    */
LPLIST WINAPI
ListSort (LPLIST        lpStart,
          ListCompare_t lpCompare,
          LPVOID        lpData);


/*  線形リストの先頭を求める
    lpStart,線形リスト
        RET,値(NULL:要素なし)                                               */
LPVOID WINAPI
ListFirst (LPLIST lpStart);


/*  線形リストの末尾を求める
    lpStart,線形リスト
        RET,値(NULL:要素なし)                                               */
LPVOID WINAPI
ListLast (LPLIST lpStart);


/*  線形リストのn番目を求める
    lpStart,線形リスト
     nIndex,n番(負:後方から,正or0:前方から)
        RET,値(NULL:要素なし)                                               */
LPVOID WINAPI
ListIndex (LPLIST lpStart,
           int    nIndex);


/*  線形リストの要素数を求める
    lpStart,線形リスト
        RET,要素数                                                          */
int WINAPI
ListLength (LPLIST lpStart);


/*  線形リストの一致する要素の数を求める
      lpStart,線形リスト
      lpValue,値
    lpCompare,比較関数
       lpData,ユーザデータ
          RET,一致数                                                        */
int WINAPI
ListHasValue (LPLIST        lpStart,
              LPVOID        lpValue,
              ListCompare_t lpCompare,
              LPVOID        lpData);


/*  線形リストの一致する要素を削除する
      lpStart,線形リスト
      lpValue,値
         fAll,TRUE:すべて削除,FALSE:最初の要素のみ削除
    lpCompare,比較関数
       lpFree,解放関数
       lpData,ユーザデータ
          RET,線形リスト(NULL:すべて削除)                                   */
LPLIST WINAPI
ListRemove (LPLIST        lpStart,
            LPVOID        lpValue,
            BOOL          fAll,
            ListCompare_t lpCompare,
            ListFree_t    lpFree,
            LPVOID        lpData);


/*  線形リストを解放する
    lpStart,線形リスト
     lpFree,解放関数
     lpData,ユーザデータ                                                    */
VOID WINAPI
ListRelease (LPLIST     lpStart,
             ListFree_t lpFree,
             LPVOID     lpData);


/*  線形リストの要素を列挙する
    lpStart,線形リスト
    lpFree,列挙関数
    lpData,ユーザデータ
       RET,TRUE:すべて列挙,FALSE:中断                                       */
BOOL WINAPI
ListEnum (LPLIST         lpStart,
          ListEnumProc_t lpProc,
          LPVOID         lpData);


#ifdef UNICODE
# define ListCompareString ListCompareStringW
#else /* not UNICODE */
# define ListCompareString ListCompareStringA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCLIST_H__ */
