/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCMEMORY_H__
#define __WCMEMORY_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  メモリの内容を埋める
    lpvDest,メモリ
      bByte,内容
     uBytes,バイト数                                                        */
VOID WINAPI
MemorySet (LPVOID lpvDest,
           BYTE   bByte,
           SIZE_T uBytes);


/*  メモリの内容をコピーする
    lpvDest,コピー先
     lpvSrc,コピー元
     uBytes,バイト数                                                        */
VOID WINAPI
MemoryCopy (LPVOID  lpvDest,
            LPCVOID lpvSrc,
            SIZE_T  uBytes);


/*  メモリの内容を比較する
    lpvBuf1,バッファ1
    lpvBuf1,バッファ2
     uBytes,バイト数
        RET,0:等しい,負:バッファ1は小さい,正:バッファ1は大きい              */
int WINAPI
MemoryCompare (LPCVOID lpvBuf1,
               LPCVOID lpvBuf2,
               SIZE_T  uBytes);


/*  メモリを確保する
    uBytes,サイズ
       RET,確保したメモリ,NULL:エラー                                       */
LPVOID WINAPI
MemoryAlloc (SIZE_T uBytes);


/*  メモリを解放する
    lpMemory,確保したメモリ
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
MemoryFree (LPVOID lpMemory);


/*  メモリのサイズを変更する
    lpMemory,確保したメモリ
      uBytes,サイズ
         RET,確保したメモリ,NULL:エラー                                     */
LPVOID WINAPI
MemoryReAlloc (LPVOID lpMemory,
               SIZE_T uBytes);


/*  メモリを複製する
    lpMemory,複製するメモリ
      uBytes,サイズ
         RET,確保したメモリ,NULL:エラー                                     */
LPVOID WINAPI
MemoryDuplicate (LPCVOID lpMemory,
                 SIZE_T  uBytes);


#ifdef COMMON_NO_DEPRECATE
# pragma deprecated(MemoryString, MemoryStringW, MemoryStringA)
# define MemoryStringW StringDuplicateW
# define MemoryStringA StringDuplicateA
# ifdef UNICODE
#  define MemoryString StringDuplicateW
# else /* not UNICODE */
#  define MemoryString StringDuplicateA
# endif /* not UNICODE */
#endif /* COMMON_NO_DEPRECATE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCMEMORY_H__ */
