/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCPRINT_H__
#define __WCPRINT_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  文字列をデバイスに出力する
    nStdHandle,デバイス
    lpszFormat,書式文字列                                                   */
VOID WINAPI
PrintConsoleW (DWORD   nStdHandle,
               LPCWSTR lpszFormat, ...);


/*  文字列をデバイスに出力する
    nStdHandle,デバイス
    lpszFormat,書式文字列                                                   */
VOID WINAPI
PrintConsoleA (DWORD  nStdHandle,
               LPCSTR lpszFormat, ...);


#ifdef UNICODE
# define PrintConsole PrintConsoleW
#else /* not UNICODE */
# define PrintConsole PrintConsoleA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCPRINT_H__ */
