/*
    mki
    copyright (c) 2000-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <windows.h>
#include <shlwapi.h>
#include <tchar.h>
#include "wcommon/wcommon.h"
#include "peimage.h"
#include "snap.h"


/*  ヘルプ表示
    nStdHandle,デバイス
      lpszFile,ファイル名                                                   */
static VOID WINAPI
PrintHelp (DWORD   nStdHandle,
           LPCTSTR lpszFile)
{
  LPTSTR lpszInternalName = NULL;
  LPTSTR lpszProductVersion = NULL;
  LPTSTR lpszLegalCopyright = NULL;
  TCHAR szFile[MAX_PATH];

  if (GetModuleFileName (NULL, szFile, MAX_PATH) > 0)
    {
      DWORD dwData, dwHandle;

      dwData = GetFileVersionInfoSize (szFile, &dwHandle);
      if(dwData > 0)
        {
          LPVOID lpData;

          lpData = MemoryAlloc (dwData);
          if (GetFileVersionInfo (szFile, dwHandle, dwData, lpData))
            {
              LPVOID lpVer;
              UINT uVer;

              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\InternalName"),
                                                                &lpVer, &uVer))
                lpszInternalName = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\ProductVersion"),
                                                                &lpVer, &uVer))
                lpszProductVersion = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\LegalCopyright"),
                                                                &lpVer, &uVer))
                lpszLegalCopyright = StringDuplicateEx (lpVer, uVer);
            }
          MemoryFree (lpData);
        }
    }
  PrintConsole (nStdHandle,
_T("%s %s ("BUILD_ENVIRONMENT")\n")
_T("%s\n")
_T("\n")
_T("Usage: %s dmpfile impfile zzzfile\n")
_T("\n"), lpszInternalName, lpszProductVersion, lpszLegalCopyright, lpszFile);
  MemoryFree (lpszInternalName);
  MemoryFree (lpszProductVersion);
  MemoryFree (lpszLegalCopyright);
}


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int i, j = 0, nDll = 0;
  BOOL fResult;
  LPBYTE lpbImage;
  LPSTR lpszList, *lpszLine;
  DWORD dwSize, dwCode, dwPrev = -sizeof (DWORD);
  DWORD dwImport = 0, dwMax = 0, dwMin = UINT_MAX;
  LPDWORD lpdwTable;
  LPSTR lpszName;
  HANDLE hFile;
  PIMAGE_NT_HEADERS pinth;
  PIMAGE_SECTION_HEADER pish;
  PIMAGE_IMPORT_DESCRIPTOR piid;
  PDLL_LIST dl = NULL;

  for (i = 1; i < argc; i++)
    if (StrCmpI (argv[i], _T("/?")) == 0 || StrCmpI (argv[i], _T("-?")) == 0
     || StrCmpI (argv[i], _T("/h")) == 0 || StrCmpI (argv[i], _T("-h")) == 0
     || StrCmpI (argv[i], _T("--help")) == 0)
      {
        PrintHelp (STD_OUTPUT_HANDLE, argv[0]);
        return 0;
      }
  if (argc != 4)
    {
      PrintHelp (STD_ERROR_HANDLE, argv[0]);
      return -1;
    }

  lpbImage = LoadFile (argv[1], &dwSize);
  if (!lpbImage)
    {
      PrintConsole (STD_ERROR_HANDLE,
                                _T("Error : LoadFile (\"%s\")\n"), argv[1]);
      return -1;
    }
  if (!PeCheckImage32 (lpbImage, dwSize))
    {
      MemoryFree (lpbImage);
      PrintConsole (STD_ERROR_HANDLE,
                            _T("Error : PeCheckImage32 (\"%s\")\n"), argv[1]);
      return -1;
    }

  pinth = (PIMAGE_NT_HEADERS)(lpbImage
                                    + ((PIMAGE_DOS_HEADER)lpbImage)->e_lfanew);
  dwSize = ((dwSize + pinth->OptionalHeader.FileAlignment - 1)
                                        / pinth->OptionalHeader.FileAlignment)
                                        * pinth->OptionalHeader.FileAlignment;
  lpbImage = MemoryReAlloc (lpbImage, dwSize);
  pinth = (PIMAGE_NT_HEADERS)(lpbImage
                                    + ((PIMAGE_DOS_HEADER)lpbImage)->e_lfanew);
  dwCode = dwSize;

  lpszList = LoadFile (argv[2], &dwSize);
  if (!lpszList)
    {
      MemoryFree (lpbImage);
      PrintConsole (STD_ERROR_HANDLE,
                                _T("Error : LoadFile (\"%s\")\n"), argv[2]);
      return -1;
    }
  for (i = 0; lpszList[i] != '\0'; i++)
    if (lpszList[i] != '\r')
      lpszList[j++] = lpszList[i];
    else if (lpszList[i + 1] != '\n')
      lpszList[j++] = '\n';
  lpszList[j] = '\0';
  lpszLine = StringSplitDelimiterA (lpszList, "\n");
  MemoryFree (lpszList);
  for (i = 0; lpszLine[i]; i++)
    {
      LPSTR *lpszText;

      lpszText = StringSplitDelimiterA (lpszLine[i], ",");
      if (lpszText)
        {
          if (lpszText[0] && lpszText[1] && lpszText[2]
                                                && lpszText[3] && !lpszText[4])
            {
              DWORD dwAddress;

              dwAddress = HexA (lpszText[0]);
              if (nDll <= 0 || dwPrev + sizeof (DWORD) != dwAddress
                    || lstrcmpiA (dl[nDll - 1].lpszModule, lpszText[2]) != 0)
                {
                  nDll++;
                  dl = MemoryReAlloc (dl, nDll * sizeof (DLL_LIST));
                  dl[nDll - 1].lpszModule = StringDuplicateA (lpszText[2]);
                }
              dl[nDll - 1].al = MemoryReAlloc (dl[nDll - 1].al,
                                (dl[nDll - 1].nApi + 1) * sizeof (API_LIST));
              dl[nDll - 1].al[dl[nDll - 1].nApi].dwAddress = dwAddress;
              dl[nDll - 1].al[dl[nDll - 1].nApi].lpszName
                                            = StringDuplicateA (lpszText[3]);
              dl[nDll - 1].nApi++;
              dwPrev = dwAddress;
            }
          MemoryFree (lpszText);
        }
    }
  MemoryFree (lpszLine);

  for (i = 0; i < nDll; i++)
    {
      dwImport += (dl[i].nApi + 1) * sizeof (DWORD)
                                    + (lstrlenA (dl[i].lpszModule) + 2 & ~1);
      for (j = 0; j < dl[i].nApi; j++)
        dwImport += 2 + (lstrlenA (dl[i].al[j].lpszName) + 2 & ~1);
    }
  dwSize = ((dwCode + dwImport + (nDll + 1) * sizeof (IMAGE_IMPORT_DESCRIPTOR))
                                    / pinth->OptionalHeader.FileAlignment + 1)
                                        * pinth->OptionalHeader.FileAlignment;
  lpbImage = MemoryReAlloc (lpbImage, dwSize);
  pinth = (PIMAGE_NT_HEADERS)(lpbImage
                                    + ((PIMAGE_DOS_HEADER)lpbImage)->e_lfanew);
  pish = (PIMAGE_SECTION_HEADER)(pinth + 1);
  piid = (PIMAGE_IMPORT_DESCRIPTOR)(lpbImage + dwCode);
  lpszName = lpbImage + dwCode + (nDll + 1) * sizeof (IMAGE_IMPORT_DESCRIPTOR);
  lpdwTable = (LPDWORD)lpszName;
  for (i = 0; i < nDll; i++)
    lpszName += (dl[i].nApi + 1) * sizeof (DWORD);
  for (i = 0; i < nDll; i++)
    {
      piid[i].Name = lpszName - lpbImage;
      lstrcpyA (lpszName, dl[i].lpszModule);
      lpszName += lstrlenA (dl[i].lpszModule) + 2 & ~1;
      piid[i].OriginalFirstThunk = (LPBYTE)lpdwTable - lpbImage;
      piid[i].FirstThunk = dl[i].al[0].dwAddress;
      for (j = 0; j < dl[i].nApi; j++)
        {
          lpdwTable[j] = lpszName - lpbImage;
          ((LPDWORD)(lpbImage + dl[i].al[0].dwAddress))[j]
                                                        = lpszName - lpbImage;
          lpszName += 2;
          lstrcpyA (lpszName, dl[i].al[j].lpszName);
          lpszName += lstrlenA (dl[i].al[j].lpszName) + 2 & ~1;
        }
      lpdwTable += dl[i].nApi + 1;
    }

  pinth->OptionalHeader.SizeOfImage
                        = (dwSize / pinth->OptionalHeader.SectionAlignment + 1)
                                    * pinth->OptionalHeader.SectionAlignment;
  pish += pinth->FileHeader.NumberOfSections;
  lstrcpyA (pish->Name, "KRNLHKEX");
  pish->Misc.VirtualSize
            = ((dwSize - dwCode) / pinth->OptionalHeader.SectionAlignment + 1)
                                    * pinth->OptionalHeader.SectionAlignment;
  pish->VirtualAddress = dwCode;
  pish->SizeOfRawData
                    = dwImport + (nDll + 1) * sizeof (IMAGE_IMPORT_DESCRIPTOR);
  pish->PointerToRawData = dwCode;
  pish->Characteristics = IMAGE_SCN_MEM_READ | IMAGE_SCN_CNT_INITIALIZED_DATA;
  pinth->FileHeader.NumberOfSections++;

  pinth->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT]
                                                    .VirtualAddress = dwCode;
  pinth->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].Size
                            = (nDll + 1) * sizeof (IMAGE_IMPORT_DESCRIPTOR);
  for (i = 0; i < nDll; i++)
    {
      for (j = 0; j < dl[i].nApi; j++)
        {
          if (dl[i].al[j].dwAddress < dwMin)
            dwMin = dl[i].al[j].dwAddress;
          if (dl[i].al[j].dwAddress > dwMax)
            dwMax = dl[i].al[j].dwAddress;
          MemoryFree (dl[i].al[j].lpszName);
        }
      MemoryFree (dl[i].lpszModule);
      MemoryFree (dl[i].al);
    }
  MemoryFree (dl);
  pinth->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IAT].VirtualAddress
                                                                    = dwMin;
  pinth->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IAT].Size
                                                        = dwMax - dwMin + 8;

  fResult = SaveFile (argv[3], lpbImage, dwSize);
  MemoryFree (lpbImage);
  if (!fResult)
    {
      PrintConsole (STD_ERROR_HANDLE,
                                _T("Error : SaveFile (\"%s\")\n"), argv[3]);
      return -1;
    }
  return 0;
}
